/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.LongArray;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LongMap<V>
implements Iterable<Entry<V>> {
    private static final int EMPTY = 0;
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    boolean hasZeroValue;
    private int hashShift;
    long[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    V[] valueTable;
    private Values values1;
    private Values values2;
    V zeroValue;

    public LongMap() {
        this(51, 0.8f);
    }

    public LongMap(int n) {
        this(n, 0.8f);
    }

    public LongMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 63 - Long.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new long[this.capacity + this.stashCapacity];
                    this.valueTable = new Object[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public LongMap(LongMap<? extends V> longMap) {
        this((int)Math.floor((float)longMap.capacity * longMap.loadFactor), longMap.loadFactor);
        this.stashSize = longMap.stashSize;
        Object[] objectArray = longMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = longMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = longMap.size;
        this.zeroValue = longMap.zeroValue;
        this.hasZeroValue = longMap.hasZeroValue;
    }

    private boolean containsKeyStash(long l) {
        long[] lArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (lArray[i] != l) continue;
            return true;
        }
        return false;
    }

    private V getStash(long l, V v) {
        long[] lArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (lArray[i] != l) continue;
            return this.valueTable[i];
        }
        return v;
    }

    private int hash2(long l) {
        return (int)(((l *= -1262997959L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    private int hash3(long l) {
        return (int)(((l *= -825114047L) ^ l >>> this.hashShift) & (long)this.mask);
    }

    private void push(long l, V v, int n, long l2, int n2, long l3, int n3, long l4) {
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.mask;
        int n5 = this.pushIterations;
        long l5 = l;
        int n6 = n;
        l = l2;
        l2 = l4;
        n = 0;
        int n7 = n2;
        n2 = n6;
        while (true) {
            V v2;
            if ((n6 = MathUtils.random(2)) != 0) {
                if (n6 != 1) {
                    v2 = VArray[n3];
                    lArray[n3] = l5;
                    VArray[n3] = v;
                    l = l2;
                    v = v2;
                } else {
                    v2 = VArray[n7];
                    lArray[n7] = l5;
                    VArray[n7] = v;
                    v = v2;
                    l = l3;
                }
            } else {
                v2 = VArray[n2];
                lArray[n2] = l5;
                VArray[n2] = v;
                v = v2;
            }
            n2 = (int)((long)n4 & l);
            l4 = lArray[n2];
            if (l4 == 0L) {
                lArray[n2] = l;
                VArray[n2] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash2(l);
            l3 = lArray[n7];
            if (l3 == 0L) {
                lArray[n7] = l;
                VArray[n7] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash3(l);
            l2 = lArray[n3];
            if (l2 == 0L) {
                lArray[n3] = l;
                VArray[n3] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n == n5) {
                this.putStash(l, v);
                return;
            }
            l5 = l;
            l = l4;
        }
    }

    private void putResize(long l, V v) {
        if (l == 0L) {
            this.zeroValue = v;
            this.hasZeroValue = true;
            return;
        }
        long[] lArray = this.keyTable;
        int n = (int)(l & (long)this.mask);
        long l2 = lArray[n];
        if (l2 == 0L) {
            lArray[n] = l;
            this.valueTable[n] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        lArray = this.keyTable;
        int n2 = this.hash2(l);
        long l3 = lArray[n2];
        if (l3 == 0L) {
            lArray[n2] = l;
            this.valueTable[n2] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        lArray = this.keyTable;
        int n3 = this.hash3(l);
        long l4 = lArray[n3];
        if (l4 == 0L) {
            lArray[n3] = l;
            this.valueTable[n3] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(l, v, n, l2, n2, l3, n3, l4);
    }

    private void putStash(long l, V v) {
        int n = this.stashSize;
        if (n == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(l, v);
            return;
        }
        int n2 = this.capacity + n;
        this.keyTable[n2] = l;
        this.valueTable[n2] = v;
        this.stashSize = n + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 63 - Long.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new long[n + n4];
        this.valueTable = new Object[n + n4];
        n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                long l = lArray[n];
                if (l == 0L) continue;
                this.putResize(l, VArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            lArray[n2] = 0L;
            VArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.zeroValue = null;
        this.hasZeroValue = false;
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(long l) {
        if (l == 0L) {
            return this.hasZeroValue;
        }
        int n = (int)((long)this.mask & l);
        if (this.keyTable[n] != l && this.keyTable[n = this.hash2(l)] != l && this.keyTable[n = this.hash3(l)] != l) {
            return this.containsKeyStash(l);
        }
        return true;
    }

    public boolean containsValue(Object object, boolean bl) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return true;
            }
            object = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (object[n2] != 0L && VArray[n2] == null) {
                        return true;
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == object) {
                        return true;
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return true;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (object.equals(VArray[n4])) {
                    return true;
                }
                n = n4;
            }
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        V v;
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        object = (LongMap)object;
        if (((LongMap)object).size != this.size) {
            return false;
        }
        boolean bl = ((LongMap)object).hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && ((v = ((LongMap)object).zeroValue) == null ? this.zeroValue != null : !v.equals(this.zeroValue))) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            long l = lArray[i];
            if (l == 0L || !((v = VArray[i]) == null ? ((LongMap)object).get(l, ObjectMap.dummy) != null : !v.equals(((LongMap)object).get(l)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LongMap)) {
            return false;
        }
        object = (LongMap)object;
        if (((LongMap)object).size != this.size) {
            return false;
        }
        boolean bl = ((LongMap)object).hasZeroValue;
        boolean bl2 = this.hasZeroValue;
        if (bl != bl2) {
            return false;
        }
        if (bl2 && this.zeroValue != ((LongMap)object).zeroValue) {
            return false;
        }
        long[] lArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            long l = lArray[i];
            if (l == 0L || VArray[i] == ((LongMap)object).get(l, ObjectMap.dummy)) continue;
            return false;
        }
        return true;
    }

    public long findKey(Object object, boolean bl, long l) {
        V[] VArray = this.valueTable;
        if (object == null) {
            if (this.hasZeroValue && this.zeroValue == null) {
                return 0L;
            }
            object = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (object[n2] != 0L && VArray[n2] == null) {
                        return (long)object[n2];
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            if (object == this.zeroValue) {
                return 0L;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == object) {
                        return this.keyTable[n3];
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            if (this.hasZeroValue && object.equals(this.zeroValue)) {
                return 0L;
            }
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (object.equals(VArray[n4])) {
                    return this.keyTable[n4];
                }
                n = n4;
            }
        }
        return l;
    }

    public V get(long l) {
        int n;
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n2 = n = (int)((long)this.mask & l);
        if (this.keyTable[n] != l) {
            n2 = n = this.hash2(l);
            if (this.keyTable[n] != l) {
                n2 = n = this.hash3(l);
                if (this.keyTable[n] != l) {
                    return this.getStash(l, null);
                }
            }
        }
        return this.valueTable[n2];
    }

    public V get(long l, V v) {
        int n;
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return v;
            }
            return this.zeroValue;
        }
        int n2 = n = (int)((long)this.mask & l);
        if (this.keyTable[n] != l) {
            n2 = n = this.hash2(l);
            if (this.keyTable[n] != l) {
                n2 = n = this.hash3(l);
                if (this.keyTable[n] != l) {
                    return this.getStash(l, v);
                }
            }
        }
        return this.valueTable[n2];
    }

    public int hashCode() {
        Object object;
        boolean bl = this.hasZeroValue;
        int n = bl && (object = this.zeroValue) != null ? object.hashCode() + 0 : 0;
        long[] lArray = this.keyTable;
        object = this.valueTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        int n4 = n;
        for (int i = 0; i < n2 + n3; ++i) {
            long l = lArray[i];
            n = n4;
            if (l != 0L) {
                V v = object[i];
                n = n4 += (int)(l ^ l >>> 32) * 31;
                if (v != null) {
                    n = n4 + v.hashCode();
                }
            }
            n4 = n;
        }
        return n4;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Iterator<Entry<V>> iterator() {
        return this.entries();
    }

    public Keys keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public V put(long l, V v) {
        int n;
        if (l == 0L) {
            V v2 = this.zeroValue;
            this.zeroValue = v;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v2;
        }
        Object object = this.keyTable;
        int n2 = (int)(l & (long)this.mask);
        long l2 = object[n2];
        if (l2 == l) {
            object = this.valueTable;
            long l3 = object[n2];
            object[n2] = (long)v;
            return l3;
        }
        int n3 = this.hash2(l);
        long l4 = object[n3];
        if (l4 == l) {
            object = this.valueTable;
            long l5 = object[n3];
            object[n3] = (long)v;
            return l5;
        }
        int n4 = this.hash3(l);
        long l6 = object[n4];
        if (l6 == l) {
            object = this.valueTable;
            long l7 = object[n4];
            object[n4] = (long)v;
            return l7;
        }
        int n5 = this.capacity;
        int n6 = this.stashSize;
        for (n = n5; n < n6 + n5; ++n) {
            if (object[n] != l) continue;
            V[] VArray = this.valueTable;
            object = VArray[n];
            VArray[n] = v;
            return (V)object;
        }
        if (l2 == 0L) {
            object[n2] = l;
            this.valueTable[n2] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l4 == 0L) {
            object[n3] = l;
            this.valueTable[n3] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (l6 == 0L) {
            object[n4] = l;
            this.valueTable[n4] = v;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(l, v, n2, l2, n3, l4, n4, l6);
        return null;
    }

    public void putAll(LongMap<? extends V> object) {
        for (Entry<V> entry : ((LongMap)((Object)object)).entries()) {
            this.put(entry.key, entry.value);
        }
    }

    public V remove(long l) {
        if (l == 0L) {
            if (!this.hasZeroValue) {
                return null;
            }
            V v = this.zeroValue;
            this.zeroValue = null;
            this.hasZeroValue = false;
            --this.size;
            return v;
        }
        Object object = this.keyTable;
        int n = (int)((long)this.mask & l);
        if (object[n] == l) {
            object[n] = 0L;
            object = this.valueTable;
            long l2 = object[n];
            object[n] = (long)null;
            --this.size;
            return l2;
        }
        object = this.keyTable;
        n = this.hash2(l);
        if (object[n] == l) {
            object[n] = 0L;
            V[] VArray = this.valueTable;
            object = VArray[n];
            VArray[n] = null;
            --this.size;
            return (V)object;
        }
        object = this.keyTable;
        n = this.hash3(l);
        if (object[n] == l) {
            object[n] = 0L;
            V[] VArray = this.valueTable;
            object = VArray[n];
            VArray[n] = null;
            --this.size;
            return (V)object;
        }
        return this.removeStash(l);
    }

    V removeStash(long l) {
        Object object = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (object[i] != l) continue;
            object = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return (V)object;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            Object[] objectArray = this.keyTable;
            objectArray[n] = objectArray[n2];
            objectArray = this.valueTable;
            objectArray[n] = objectArray[n2];
            objectArray[n2] = (long)null;
        } else {
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        long l;
        int n;
        int n2;
        V[] VArray;
        long[] lArray;
        StringBuilder stringBuilder;
        block4: {
            if (this.size == 0) {
                return "[]";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('[');
            lArray = this.keyTable;
            VArray = this.valueTable;
            int n3 = lArray.length;
            while (true) {
                n = n2 = n3 - 1;
                if (n3 <= 0) break block4;
                l = lArray[n2];
                if (l != 0L) break;
                n3 = n2;
            }
            stringBuilder.append(l);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n2]);
            n = n2;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            l = lArray[n2];
            if (l != 0L) {
                stringBuilder.append(", ");
                stringBuilder.append(l);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n2]);
            }
            n = n2;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<V>
    extends MapIterator<V>
    implements Iterable<Entry<V>>,
    Iterator<Entry<V>> {
        private Entry<V> entry = new Entry();

        public Entries(LongMap longMap) {
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return this;
        }

        @Override
        public Entry<V> next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object object = this.map.keyTable;
                    if (this.nextIndex == -1) {
                        object = this.entry;
                        object.key = 0L;
                        object.value = this.map.zeroValue;
                    } else {
                        this.entry.key = object[this.nextIndex];
                        this.entry.value = this.map.valueTable[this.nextIndex];
                    }
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<V> {
        public long key;
        public V value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys
    extends MapIterator {
        public Keys(LongMap longMap) {
            super(longMap);
        }

        public long next() {
            if (this.hasNext) {
                if (this.valid) {
                    long l = this.nextIndex == -1 ? 0L : this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return l;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public LongArray toArray() {
            LongArray longArray = new LongArray(true, this.map.size);
            while (this.hasNext) {
                longArray.add(this.next());
            }
            return longArray;
        }
    }

    private static class MapIterator<V> {
        static final int INDEX_ILLEGAL = -2;
        static final int INDEX_ZERO = -1;
        int currentIndex;
        public boolean hasNext;
        final LongMap<V> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(LongMap<V> longMap) {
            this.map = longMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                long[] lArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (lArray[this.nextIndex] == 0L);
                this.hasNext = true;
            }
        }

        public void remove() {
            block7: {
                LongMap<V> longMap;
                block6: {
                    block5: {
                        if (this.currentIndex != -1 || !this.map.hasZeroValue) break block5;
                        longMap = this.map;
                        longMap.zeroValue = null;
                        longMap.hasZeroValue = false;
                        break block6;
                    }
                    int n = this.currentIndex;
                    if (n < 0) break block7;
                    if (n >= this.map.capacity) {
                        this.map.removeStashIndex(this.currentIndex);
                        this.nextIndex = this.currentIndex - 1;
                        this.findNextIndex();
                    } else {
                        this.map.keyTable[this.currentIndex] = 0L;
                        this.map.valueTable[this.currentIndex] = null;
                    }
                }
                this.currentIndex = -2;
                longMap = this.map;
                --longMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -2;
            this.nextIndex = -1;
            if (this.map.hasZeroValue) {
                this.hasNext = true;
            } else {
                this.findNextIndex();
            }
        }
    }

    public static class Values<V>
    extends MapIterator<V>
    implements Iterable<V>,
    Iterator<V> {
        public Values(LongMap<V> longMap) {
            super(longMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Iterator<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object v = this.nextIndex == -1 ? this.map.zeroValue : this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return v;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }

        public Array<V> toArray() {
            Array<V> array = new Array<V>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }
}

