/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Vector2
implements Serializable,
Vector<Vector2> {
    public static final Vector2 X = new Vector2(1.0f, 0.0f);
    public static final Vector2 Y = new Vector2(0.0f, 1.0f);
    public static final Vector2 Zero = new Vector2(0.0f, 0.0f);
    private static final long serialVersionUID = 913902788239530931L;
    public float x;
    public float y;

    public Vector2() {
    }

    public Vector2(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vector2(Vector2 vector2) {
        this.set(vector2);
    }

    public static float dot(float f, float f2, float f3, float f4) {
        return f * f3 + f2 * f4;
    }

    public static float dst(float f, float f2, float f3, float f4) {
        f = f3 - f;
        f2 = f4 - f2;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static float dst2(float f, float f2, float f3, float f4) {
        f = f3 - f;
        f2 = f4 - f2;
        return f * f + f2 * f2;
    }

    public static float len(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static float len2(float f, float f2) {
        return f * f + f2 * f2;
    }

    public Vector2 add(float f, float f2) {
        this.x += f;
        this.y += f2;
        return this;
    }

    @Override
    public Vector2 add(Vector2 vector2) {
        this.x += vector2.x;
        this.y += vector2.y;
        return this;
    }

    public float angle() {
        float f;
        float f2 = f = (float)Math.atan2(this.y, this.x) * 57.295776f;
        if (f < 0.0f) {
            f2 = f + 360.0f;
        }
        return f2;
    }

    public float angle(Vector2 vector2) {
        return (float)Math.atan2(this.crs(vector2), this.dot(vector2)) * 57.295776f;
    }

    public float angleRad() {
        return (float)Math.atan2(this.y, this.x);
    }

    public float angleRad(Vector2 vector2) {
        return (float)Math.atan2(this.crs(vector2), this.dot(vector2));
    }

    @Override
    public Vector2 clamp(float f, float f2) {
        float f3 = this.len2();
        if (f3 == 0.0f) {
            return this;
        }
        if (f3 > (f2 *= f2)) {
            return this.scl((float)Math.sqrt(f2 / f3));
        }
        if (f3 < (f *= f)) {
            return this.scl((float)Math.sqrt(f / f3));
        }
        return this;
    }

    @Override
    public Vector2 cpy() {
        return new Vector2(this);
    }

    public float crs(float f, float f2) {
        return this.x * f2 - this.y * f;
    }

    public float crs(Vector2 vector2) {
        return this.x * vector2.y - this.y * vector2.x;
    }

    public float dot(float f, float f2) {
        return this.x * f + this.y * f2;
    }

    @Override
    public float dot(Vector2 vector2) {
        return this.x * vector2.x + this.y * vector2.y;
    }

    public float dst(float f, float f2) {
        return (float)Math.sqrt((f -= this.x) * f + (f2 -= this.y) * f2);
    }

    @Override
    public float dst(Vector2 vector2) {
        float f = vector2.x - this.x;
        float f2 = vector2.y - this.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public float dst2(float f, float f2) {
        return (f -= this.x) * f + (f2 -= this.y) * f2;
    }

    @Override
    public float dst2(Vector2 vector2) {
        float f = vector2.x - this.x;
        float f2 = vector2.y - this.y;
        return f * f + f2 * f2;
    }

    @Override
    public boolean epsilonEquals(float f, float f2) {
        return this.epsilonEquals(f, f2, 1.0E-6f);
    }

    public boolean epsilonEquals(float f, float f2, float f3) {
        if (Math.abs(f - this.x) > f3) {
            return false;
        }
        return !(Math.abs(f2 - this.y) > f3);
    }

    public boolean epsilonEquals(Vector2 vector2) {
        return this.epsilonEquals(vector2, 1.0E-6f);
    }

    @Override
    public boolean epsilonEquals(Vector2 vector2, float f) {
        if (vector2 == null) {
            return false;
        }
        if (Math.abs(vector2.x - this.x) > f) {
            return false;
        }
        return !(Math.abs(vector2.y - this.y) > f);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector2)object;
        if (NumberUtils.floatToIntBits(this.x) != NumberUtils.floatToIntBits(((Vector2)object).x)) {
            return false;
        }
        return NumberUtils.floatToIntBits(this.y) == NumberUtils.floatToIntBits(((Vector2)object).y);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector2 fromString(String string2) {
        int n = string2.indexOf(44, 1);
        if (n != -1 && string2.charAt(0) == '(' && string2.charAt(string2.length() - 1) == ')') {
            try {
                return this.set(Float.parseFloat(string2.substring(1, n)), Float.parseFloat(string2.substring(n + 1, string2.length() - 1)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Malformed Vector2: ");
        stringBuilder.append(string2);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    @Override
    public boolean hasOppositeDirection(Vector2 vector2) {
        boolean bl = this.dot(vector2) < 0.0f;
        return bl;
    }

    @Override
    public boolean hasSameDirection(Vector2 vector2) {
        boolean bl = this.dot(vector2) > 0.0f;
        return bl;
    }

    public int hashCode() {
        return (NumberUtils.floatToIntBits(this.x) + 31) * 31 + NumberUtils.floatToIntBits(this.y);
    }

    @Override
    public Vector2 interpolate(Vector2 vector2, float f, Interpolation interpolation) {
        return this.lerp(vector2, interpolation.apply(f));
    }

    @Override
    public boolean isCollinear(Vector2 vector2) {
        boolean bl = this.isOnLine(vector2) && this.dot(vector2) > 0.0f;
        return bl;
    }

    @Override
    public boolean isCollinear(Vector2 vector2, float f) {
        boolean bl = this.isOnLine(vector2, f) && this.dot(vector2) > 0.0f;
        return bl;
    }

    @Override
    public boolean isCollinearOpposite(Vector2 vector2) {
        boolean bl = this.isOnLine(vector2) && this.dot(vector2) < 0.0f;
        return bl;
    }

    @Override
    public boolean isCollinearOpposite(Vector2 vector2, float f) {
        boolean bl = this.isOnLine(vector2, f) && this.dot(vector2) < 0.0f;
        return bl;
    }

    @Override
    public boolean isOnLine(Vector2 vector2) {
        return MathUtils.isZero(this.x * vector2.y - this.y * vector2.x);
    }

    @Override
    public boolean isOnLine(Vector2 vector2, float f) {
        return MathUtils.isZero(this.x * vector2.y - this.y * vector2.x, f);
    }

    @Override
    public boolean isPerpendicular(Vector2 vector2) {
        return MathUtils.isZero(this.dot(vector2));
    }

    @Override
    public boolean isPerpendicular(Vector2 vector2, float f) {
        return MathUtils.isZero(this.dot(vector2), f);
    }

    @Override
    public boolean isUnit() {
        return this.isUnit(1.0E-9f);
    }

    @Override
    public boolean isUnit(float f) {
        boolean bl = Math.abs(this.len2() - 1.0f) < f;
        return bl;
    }

    @Override
    public boolean isZero() {
        boolean bl = this.x == 0.0f && this.y == 0.0f;
        return bl;
    }

    @Override
    public boolean isZero(float f) {
        boolean bl = this.len2() < f;
        return bl;
    }

    @Override
    public float len() {
        float f = this.x;
        float f2 = this.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    @Override
    public float len2() {
        float f = this.x;
        float f2 = this.y;
        return f * f + f2 * f2;
    }

    @Override
    public Vector2 lerp(Vector2 vector2, float f) {
        float f2 = 1.0f - f;
        this.x = this.x * f2 + vector2.x * f;
        this.y = this.y * f2 + vector2.y * f;
        return this;
    }

    @Override
    public Vector2 limit(float f) {
        return this.limit2(f * f);
    }

    @Override
    public Vector2 limit2(float f) {
        float f2 = this.len2();
        if (f2 > f) {
            return this.scl((float)Math.sqrt(f / f2));
        }
        return this;
    }

    public Vector2 mul(Matrix3 matrix3) {
        float f = this.x;
        float f2 = matrix3.val[0];
        float f3 = this.y;
        float f4 = matrix3.val[3];
        float f5 = matrix3.val[6];
        float f6 = this.x;
        float f7 = matrix3.val[1];
        float f8 = this.y;
        float f9 = matrix3.val[4];
        float f10 = matrix3.val[7];
        this.x = f * f2 + f3 * f4 + f5;
        this.y = f6 * f7 + f8 * f9 + f10;
        return this;
    }

    @Override
    public Vector2 mulAdd(Vector2 vector2, float f) {
        this.x += vector2.x * f;
        this.y += vector2.y * f;
        return this;
    }

    @Override
    public Vector2 mulAdd(Vector2 vector2, Vector2 vector22) {
        this.x += vector2.x * vector22.x;
        this.y += vector2.y * vector22.y;
        return this;
    }

    @Override
    public Vector2 nor() {
        float f = this.len();
        if (f != 0.0f) {
            this.x /= f;
            this.y /= f;
        }
        return this;
    }

    public Vector2 rotate(float f) {
        return this.rotateRad(f * ((float)Math.PI / 180));
    }

    public Vector2 rotate90(int n) {
        float f = this.x;
        if (n >= 0) {
            this.x = -this.y;
            this.y = f;
        } else {
            this.x = this.y;
            this.y = -f;
        }
        return this;
    }

    public Vector2 rotateAround(Vector2 vector2, float f) {
        return this.sub(vector2).rotate(f).add(vector2);
    }

    public Vector2 rotateAroundRad(Vector2 vector2, float f) {
        return this.sub(vector2).rotateRad(f).add(vector2);
    }

    public Vector2 rotateRad(float f) {
        double d = f;
        float f2 = (float)Math.cos(d);
        float f3 = (float)Math.sin(d);
        f = this.x;
        float f4 = this.y;
        this.x = f * f2 - f4 * f3;
        this.y = f * f3 + f4 * f2;
        return this;
    }

    @Override
    public Vector2 scl(float f) {
        this.x *= f;
        this.y *= f;
        return this;
    }

    public Vector2 scl(float f, float f2) {
        this.x *= f;
        this.y *= f2;
        return this;
    }

    @Override
    public Vector2 scl(Vector2 vector2) {
        this.x *= vector2.x;
        this.y *= vector2.y;
        return this;
    }

    public Vector2 set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    @Override
    public Vector2 set(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
        return this;
    }

    public Vector2 setAngle(float f) {
        return this.setAngleRad(f * ((float)Math.PI / 180));
    }

    public Vector2 setAngleRad(float f) {
        this.set(this.len(), 0.0f);
        this.rotateRad(f);
        return this;
    }

    @Override
    public Vector2 setLength(float f) {
        return this.setLength2(f * f);
    }

    @Override
    public Vector2 setLength2(float f) {
        float f2 = this.len2();
        Vector2 vector2 = f2 != 0.0f && f2 != f ? this.scl((float)Math.sqrt(f / f2)) : this;
        return vector2;
    }

    @Override
    public Vector2 setToRandomDirection() {
        float f = MathUtils.random(0.0f, (float)Math.PI * 2);
        return this.set(MathUtils.cos(f), MathUtils.sin(f));
    }

    @Override
    public Vector2 setZero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    public Vector2 sub(float f, float f2) {
        this.x -= f;
        this.y -= f2;
        return this;
    }

    @Override
    public Vector2 sub(Vector2 vector2) {
        this.x -= vector2.x;
        this.y -= vector2.y;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x);
        stringBuilder.append(",");
        stringBuilder.append(this.y);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

