/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Plane;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;

public class Frustum {
    protected static final Vector3[] clipSpacePlanePoints;
    protected static final float[] clipSpacePlanePointsArray;
    private static final Vector3 tmpV;
    public final Vector3[] planePoints;
    protected final float[] planePointsArray;
    public final Plane[] planes = new Plane[6];

    static {
        Vector3 vector3 = new Vector3(-1.0f, -1.0f, -1.0f);
        int n = 0;
        clipSpacePlanePoints = new Vector3[]{vector3, new Vector3(1.0f, -1.0f, -1.0f), new Vector3(1.0f, 1.0f, -1.0f), new Vector3(-1.0f, 1.0f, -1.0f), new Vector3(-1.0f, -1.0f, 1.0f), new Vector3(1.0f, -1.0f, 1.0f), new Vector3(1.0f, 1.0f, 1.0f), new Vector3(-1.0f, 1.0f, 1.0f)};
        clipSpacePlanePointsArray = new float[24];
        Vector3[] vector3Array = clipSpacePlanePoints;
        int n2 = vector3Array.length;
        int n3 = 0;
        while (n < n2) {
            vector3 = vector3Array[n];
            float[] fArray = clipSpacePlanePointsArray;
            int n4 = n3 + 1;
            fArray[n3] = vector3.x;
            fArray = clipSpacePlanePointsArray;
            n3 = n4 + 1;
            fArray[n4] = vector3.y;
            Frustum.clipSpacePlanePointsArray[n3] = vector3.z;
            ++n;
            ++n3;
        }
        tmpV = new Vector3();
    }

    public Frustum() {
        Vector3 vector3 = new Vector3();
        this.planePoints = new Vector3[]{vector3, new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3(), new Vector3()};
        this.planePointsArray = new float[24];
        for (int i = 0; i < 6; ++i) {
            this.planes[i] = new Plane(new Vector3(), 0.0f);
        }
    }

    public boolean boundsInFrustum(float f, float f2, float f3, float f4, float f5, float f6) {
        int n = this.planes.length;
        for (int i = 0; i < n; ++i) {
            float f7;
            float f8;
            Plane plane = this.planes[i];
            float f9 = f + f4;
            float f10 = f2 + f5;
            float f11 = f3 + f6;
            if (plane.testPoint(f9, f10, f11) != Plane.PlaneSide.Back || (plane = this.planes[i]).testPoint(f9, f10, f8 = f3 - f6) != Plane.PlaneSide.Back || (plane = this.planes[i]).testPoint(f9, f7 = f2 - f5, f11) != Plane.PlaneSide.Back || this.planes[i].testPoint(f9, f7, f8) != Plane.PlaneSide.Back || (plane = this.planes[i]).testPoint(f9 = f - f4, f10, f11) != Plane.PlaneSide.Back || this.planes[i].testPoint(f9, f10, f8) != Plane.PlaneSide.Back || this.planes[i].testPoint(f9, f7, f11) != Plane.PlaneSide.Back || this.planes[i].testPoint(f9, f7, f8) != Plane.PlaneSide.Back) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean boundsInFrustum(Vector3 vector3, Vector3 vector32) {
        return this.boundsInFrustum(vector3.x, vector3.y, vector3.z, vector32.x / 2.0f, vector32.y / 2.0f, vector32.z / 2.0f);
    }

    public boolean boundsInFrustum(BoundingBox boundingBox) {
        int n = this.planes.length;
        for (int i = 0; i < n; ++i) {
            if (this.planes[i].testPoint(boundingBox.getCorner000(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner001(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner010(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner011(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner100(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner101(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner110(tmpV)) != Plane.PlaneSide.Back || this.planes[i].testPoint(boundingBox.getCorner111(tmpV)) != Plane.PlaneSide.Back) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean pointInFrustum(float f, float f2, float f3) {
        Plane[] planeArray;
        for (int i = 0; i < (planeArray = this.planes).length; ++i) {
            if (planeArray[i].testPoint(f, f2, f3) != Plane.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    public boolean pointInFrustum(Vector3 vector3) {
        Plane[] planeArray;
        for (int i = 0; i < (planeArray = this.planes).length; ++i) {
            if (planeArray[i].testPoint(vector3) != Plane.PlaneSide.Back) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustum(float f, float f2, float f3, float f4) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * f + this.planes[i].normal.y * f2 + this.planes[i].normal.z * f3 < -f4 - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustum(Vector3 vector3, float f) {
        for (int i = 0; i < 6; ++i) {
            if (!(this.planes[i].normal.x * vector3.x + this.planes[i].normal.y * vector3.y + this.planes[i].normal.z * vector3.z < -f - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar(float f, float f2, float f3, float f4) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * f + this.planes[i].normal.y * f2 + this.planes[i].normal.z * f3 < -f4 - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public boolean sphereInFrustumWithoutNearFar(Vector3 vector3, float f) {
        for (int i = 2; i < 6; ++i) {
            if (!(this.planes[i].normal.x * vector3.x + this.planes[i].normal.y * vector3.y + this.planes[i].normal.z * vector3.z < -f - this.planes[i].d)) continue;
            return false;
        }
        return true;
    }

    public void update(Matrix4 object) {
        Object object2 = clipSpacePlanePointsArray;
        System.arraycopy(object2, 0, this.planePointsArray, 0, ((float[])object2).length);
        Matrix4.prj(((Matrix4)object).val, this.planePointsArray, 0, 8, 3);
        int n = 0;
        int n2 = 0;
        while (n < 8) {
            object = this.planePoints[n];
            object2 = this.planePointsArray;
            int n3 = n2 + 1;
            ((Vector3)object).x = object2[n2];
            n2 = n3 + 1;
            ((Vector3)object).y = (float)object2[n3];
            ((Vector3)object).z = (float)object2[n2];
            ++n;
            ++n2;
        }
        object2 = this.planes[0];
        object = this.planePoints;
        ((Plane)object2).set(object[1], object[0], object[2]);
        object2 = this.planes[1];
        object = this.planePoints;
        ((Plane)object2).set(object[4], object[5], object[7]);
        object2 = this.planes[2];
        object = this.planePoints;
        ((Plane)object2).set(object[0], object[4], object[3]);
        object = this.planes[3];
        object2 = this.planePoints;
        ((Plane)object).set((Vector3)object2[5], (Vector3)object2[1], (Vector3)object2[6]);
        object = this.planes[4];
        object2 = this.planePoints;
        ((Plane)object).set((Vector3)object2[2], (Vector3)object2[3], (Vector3)object2[6]);
        object = this.planes[5];
        object2 = this.planePoints;
        ((Plane)object).set((Vector3)object2[4], (Vector3)object2[0], (Vector3)object2[1]);
    }
}

