/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Circle
implements Shape2D,
Serializable {
    public float radius;
    public float x;
    public float y;

    public Circle() {
    }

    public Circle(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.radius = f3;
    }

    public Circle(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public Circle(Vector2 vector2, float f) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = f;
    }

    public Circle(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = Vector2.len(vector2.x - vector22.x, vector2.y - vector22.y);
    }

    public float area() {
        float f = this.radius;
        return f * f * (float)Math.PI;
    }

    public float circumference() {
        return this.radius * ((float)Math.PI * 2);
    }

    @Override
    public boolean contains(float f, float f2) {
        float f3 = this.y - f2;
        boolean bl = (f = this.x - f) * f + f3 * f3 <= (f2 = this.radius) * f2;
        return bl;
    }

    public boolean contains(Circle circle) {
        float f = this.radius;
        float f2 = circle.radius;
        float f3 = f - f2;
        boolean bl = false;
        if (f3 < 0.0f) {
            return false;
        }
        float f4 = this.x - circle.x;
        float f5 = this.y - circle.y;
        f5 = f4 * f4 + f5 * f5;
        f += f2;
        boolean bl2 = bl;
        if (!(f3 * f3 < f5)) {
            bl2 = bl;
            if (f5 < f * f) {
                bl2 = true;
            }
        }
        return bl2;
    }

    @Override
    public boolean contains(Vector2 vector2) {
        float f = this.x - vector2.x;
        float f2 = this.y - vector2.y;
        float f3 = this.radius;
        boolean bl = f * f + f2 * f2 <= f3 * f3;
        return bl;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (Circle)object;
            if (this.x != ((Circle)object).x || this.y != ((Circle)object).y || this.radius != ((Circle)object).radius) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return ((NumberUtils.floatToRawIntBits(this.radius) + 41) * 41 + NumberUtils.floatToRawIntBits(this.x)) * 41 + NumberUtils.floatToRawIntBits(this.y);
    }

    public boolean overlaps(Circle circle) {
        float f = this.x - circle.x;
        float f2 = this.y - circle.y;
        float f3 = this.radius + circle.radius;
        boolean bl = f * f + f2 * f2 < f3 * f3;
        return bl;
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.radius = f3;
    }

    public void set(Circle circle) {
        this.x = circle.x;
        this.y = circle.y;
        this.radius = circle.radius;
    }

    public void set(Vector2 vector2, float f) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = f;
    }

    public void set(Vector2 vector2, Vector2 vector22) {
        this.x = vector2.x;
        this.y = vector2.y;
        this.radius = Vector2.len(vector2.x - vector22.x, vector2.y - vector22.y);
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void setPosition(Vector2 vector2) {
        this.x = vector2.x;
        this.y = vector2.y;
    }

    public void setRadius(float f) {
        this.radius = f;
    }

    public void setX(float f) {
        this.x = f;
    }

    public void setY(float f) {
        this.y = f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.x);
        stringBuilder.append(",");
        stringBuilder.append(this.y);
        stringBuilder.append(",");
        stringBuilder.append(this.radius);
        return stringBuilder.toString();
    }
}

