/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;

public class CatmullRomSpline<T extends Vector<T>>
implements Path<T> {
    public boolean continuous;
    public T[] controlPoints;
    public int spanCount;
    private T tmp;
    private T tmp2;
    private T tmp3;

    public CatmullRomSpline() {
    }

    public CatmullRomSpline(T[] TArray, boolean bl) {
        this.set((Vector[])TArray, bl);
    }

    public static <T extends Vector<T>> T calculate(T t, float f, T[] TArray, boolean bl, T t2) {
        int n = bl ? TArray.length : TArray.length - 3;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return (T)CatmullRomSpline.calculate(t, (int)n, (float)(f2 - (float)n), TArray, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T calculate(T object, int n, float f, T[] TArray, boolean bl, T object2) {
        int n2 = TArray.length;
        float f2 = f * f;
        float f3 = f2 * f;
        object.set(TArray[n]).scl((float)(1.5f * f3 - 2.5f * f2 + 1.0f));
        if (bl || n > 0) {
            object.add(object2.set(TArray[(n2 + n - 1) % n2]).scl((float)(-0.5f * f3 + f2 - f * 0.5f)));
        }
        if (bl || n < n2 - 1) {
            object.add(object2.set(TArray[(n + 1) % n2]).scl((float)(-1.5f * f3 + 2.0f * f2 + f * 0.5f)));
        }
        if (bl || n < n2 - 2) {
            object.add(object2.set(TArray[(n + 2) % n2]).scl((float)(f3 * 0.5f - f2 * 0.5f)));
        }
        return (T)object;
    }

    public static <T extends Vector<T>> T derivative(T t, float f, T[] TArray, boolean bl, T t2) {
        int n = bl ? TArray.length : TArray.length - 3;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return (T)CatmullRomSpline.derivative(t, (int)n, (float)(f2 - (float)n), TArray, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T derivative(T object, int n, float f, T[] TArray, boolean bl, T object2) {
        int n2 = TArray.length;
        float f2 = f * f;
        float f3 = object.set(TArray[n]);
        float f4 = -f;
        float f5 = 4.5f * f2;
        f3.scl((float)(5.0f * f4 + f5));
        if (bl || n > 0) {
            object.add(object2.set(TArray[(n2 + n - 1) % n2]).scl((float)(2.0f * f - 0.5f - f2 * 1.5f)));
        }
        if (bl || n < n2 - 1) {
            object.add(object2.set(TArray[(n + 1) % n2]).scl((float)(f * 4.0f + 0.5f - f5)));
        }
        if (bl || n < n2 - 2) {
            object.add(object2.set(TArray[(n + 2) % n2]).scl((float)(f4 + f2 * 1.5f)));
        }
        return (T)object;
    }

    @Override
    public float approxLength(int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.tmp2.set(this.tmp3);
            this.valueAt(this.tmp3, (float)i / ((float)n - 1.0f));
            float f2 = f;
            if (i > 0) {
                f2 = f + this.tmp2.dst(this.tmp3);
            }
            f = f2;
        }
        return f;
    }

    @Override
    public float approximate(T t) {
        return this.approximate(t, this.nearest(t));
    }

    public float approximate(T TArray, int n) {
        Object object = this.controlPoints;
        Object object2 = object[n];
        int n2 = n > 0 ? n - 1 : this.spanCount - 1;
        T t = object[n2];
        object = this.controlPoints[(n + 1) % this.spanCount];
        float f = TArray.dst2(t);
        if (TArray.dst2(object) < f) {
            t = object2;
            object2 = object;
        } else {
            if (n <= 0) {
                n = this.spanCount;
            }
            --n;
        }
        float f2 = t.dst2(object2);
        float f3 = TArray.dst2(object2);
        float f4 = TArray.dst2(t);
        f = (float)Math.sqrt(f2);
        f = MathUtils.clamp((f - (f3 + f2 - f4) / (2.0f * f)) / f, 0.0f, 1.0f);
        return ((float)n + f) / (float)this.spanCount;
    }

    public float approximate(T t, int n, int n2) {
        return this.approximate(t, this.nearest(t, n, n2));
    }

    @Override
    public T derivativeAt(T t, float f) {
        int n = this.spanCount;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return this.derivativeAt(t, n, f2 - (float)n);
    }

    public T derivativeAt(T t, int n, float f) {
        if (!this.continuous) {
            ++n;
        }
        return (T)CatmullRomSpline.derivative(t, (int)n, (float)f, this.controlPoints, (boolean)this.continuous, this.tmp);
    }

    @Override
    public float locate(T t) {
        return this.approximate(t);
    }

    public int nearest(T t) {
        return this.nearest(t, 0, this.spanCount);
    }

    public int nearest(T t, int n, int n2) {
        while (n < 0) {
            n += this.spanCount;
        }
        int n3 = n % this.spanCount;
        float f = t.dst2(this.controlPoints[n3]);
        for (int i = 1; i < n2; ++i) {
            int n4 = (n + i) % this.spanCount;
            float f2 = t.dst2(this.controlPoints[n4]);
            float f3 = f;
            if (f2 < f) {
                n3 = n4;
                f3 = f2;
            }
            f = f3;
        }
        return n3;
    }

    public CatmullRomSpline set(T[] TArray, boolean bl) {
        if (this.tmp == null) {
            this.tmp = TArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = TArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = TArray[0].cpy();
        }
        this.controlPoints = TArray;
        this.continuous = bl;
        int n = bl ? TArray.length : TArray.length - 3;
        this.spanCount = n;
        return this;
    }

    @Override
    public T valueAt(T t, float f) {
        int n = this.spanCount;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return this.valueAt(t, n, f2 - (float)n);
    }

    public T valueAt(T t, int n, float f) {
        if (!this.continuous) {
            ++n;
        }
        return (T)CatmullRomSpline.calculate(t, (int)n, (float)f, this.controlPoints, (boolean)this.continuous, this.tmp);
    }
}

