/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IndexBufferObject
implements IndexData {
    final ShortBuffer buffer;
    int bufferHandle;
    final ByteBuffer byteBuffer;
    private final boolean empty;
    boolean isBound;
    final boolean isDirect;
    boolean isDirty = true;
    final boolean ownsBuffer;
    final int usage;

    public IndexBufferObject(int n) {
        this(true, n);
    }

    public IndexBufferObject(boolean bl, int n) {
        boolean bl2 = false;
        this.isBound = false;
        if (n == 0) {
            bl2 = true;
        }
        this.empty = bl2;
        if (this.empty) {
            n = 1;
        }
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(n * 2);
        this.isDirect = true;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.ownsBuffer = true;
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        n = bl ? 35044 : 35048;
        this.usage = n;
    }

    public IndexBufferObject(boolean bl, ByteBuffer byteBuffer) {
        this.isBound = false;
        boolean bl2 = byteBuffer.limit() == 0;
        this.empty = bl2;
        this.byteBuffer = byteBuffer;
        this.isDirect = true;
        this.buffer = this.byteBuffer.asShortBuffer();
        this.ownsBuffer = false;
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        int n = bl ? 35044 : 35048;
        this.usage = n;
    }

    @Override
    public void bind() {
        if (this.bufferHandle != 0) {
            Gdx.gl20.glBindBuffer(34963, this.bufferHandle);
            if (this.isDirty) {
                this.byteBuffer.limit(this.buffer.limit() * 2);
                Gdx.gl20.glBufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
                this.isDirty = false;
            }
            this.isBound = true;
            return;
        }
        throw new GdxRuntimeException("No buffer allocated!");
    }

    @Override
    public void dispose() {
        Gdx.gl20.glBindBuffer(34963, 0);
        Gdx.gl20.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        if (this.ownsBuffer) {
            BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
        }
    }

    @Override
    public ShortBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    @Override
    public int getNumIndices() {
        int n = this.empty ? 0 : this.buffer.limit();
        return n;
    }

    @Override
    public int getNumMaxIndices() {
        int n = this.empty ? 0 : this.buffer.capacity();
        return n;
    }

    @Override
    public void invalidate() {
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.isDirty = true;
    }

    @Override
    public void setIndices(ShortBuffer shortBuffer) {
        this.isDirty = true;
        int n = shortBuffer.position();
        this.buffer.clear();
        this.buffer.put(shortBuffer);
        this.buffer.flip();
        shortBuffer.position(n);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 1);
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }

    @Override
    public void setIndices(short[] sArray, int n, int n2) {
        this.isDirty = true;
        this.buffer.clear();
        this.buffer.put(sArray, n, n2);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(n2 << 1);
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }

    @Override
    public void unbind() {
        Gdx.gl20.glBindBuffer(34963, 0);
        this.isBound = false;
    }

    @Override
    public void updateIndices(int n, short[] sArray, int n2, int n3) {
        this.isDirty = true;
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 2);
        BufferUtils.copy(sArray, n2, (Buffer)this.byteBuffer, n3);
        this.byteBuffer.position(n4);
        this.buffer.position(0);
        if (this.isBound) {
            Gdx.gl20.glBufferData(34963, this.byteBuffer.limit(), this.byteBuffer, this.usage);
            this.isDirty = false;
        }
    }
}

