/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.utils.MeshBuilder;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.Iterator;

public class ModelBuilder {
    private Array<MeshBuilder> builders = new Array();
    private Model model;
    private Node node;
    private Matrix4 tmpTransform = new Matrix4();

    private void endnode() {
        if (this.node != null) {
            this.node = null;
        }
    }

    private MeshBuilder getBuilder(VertexAttributes vertexAttributes) {
        MeshBuilder meshBuilder2;
        for (MeshBuilder meshBuilder2 : this.builders) {
            if (!meshBuilder2.getAttributes().equals(vertexAttributes) || meshBuilder2.lastIndex() >= 16383) continue;
            return meshBuilder2;
        }
        meshBuilder2 = new MeshBuilder();
        meshBuilder2.begin(vertexAttributes);
        this.builders.add(meshBuilder2);
        return meshBuilder2;
    }

    public static void rebuildReferences(Model model) {
        model.materials.clear();
        model.meshes.clear();
        model.meshParts.clear();
        Iterator<Node> iterator = model.nodes.iterator();
        while (iterator.hasNext()) {
            ModelBuilder.rebuildReferences(model, iterator.next());
        }
    }

    private static void rebuildReferences(Model model, Node object) {
        for (NodePart nodePart : ((Node)object).parts) {
            if (!model.materials.contains(nodePart.material, true)) {
                model.materials.add(nodePart.material);
            }
            if (model.meshParts.contains(nodePart.meshPart, true)) continue;
            model.meshParts.add(nodePart.meshPart);
            if (!model.meshes.contains(nodePart.meshPart.mesh, true)) {
                model.meshes.add(nodePart.meshPart.mesh);
            }
            model.manageDisposable(nodePart.meshPart.mesh);
        }
        object = ((Node)object).getChildren().iterator();
        while (object.hasNext()) {
            ModelBuilder.rebuildReferences(model, (Node)object.next());
        }
    }

    public void begin() {
        if (this.model == null) {
            this.node = null;
            this.model = new Model();
            this.builders.clear();
            return;
        }
        throw new GdxRuntimeException("Call end() first");
    }

    public Model createArrow(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n, int n2, Material material, long l) {
        this.begin();
        this.part("arrow", n2, l, material).arrow(f, f2, f3, f4, f5, f6, f7, f8, n);
        return this.end();
    }

    public Model createArrow(Vector3 vector3, Vector3 vector32, Material material, long l) {
        return this.createArrow(vector3.x, vector3.y, vector3.z, vector32.x, vector32.y, vector32.z, 0.1f, 0.1f, 5, 4, material, l);
    }

    public Model createBox(float f, float f2, float f3, int n, Material material, long l) {
        this.begin();
        this.part("box", n, l, material).box(f, f2, f3);
        return this.end();
    }

    public Model createBox(float f, float f2, float f3, Material material, long l) {
        return this.createBox(f, f2, f3, 4, material, l);
    }

    public Model createCapsule(float f, float f2, int n, int n2, Material material, long l) {
        this.begin();
        this.part("capsule", n2, l, material).capsule(f, f2, n);
        return this.end();
    }

    public Model createCapsule(float f, float f2, int n, Material material, long l) {
        return this.createCapsule(f, f2, n, 4, material, l);
    }

    public Model createCone(float f, float f2, float f3, int n, int n2, Material material, long l) {
        return this.createCone(f, f2, f3, n, n2, material, l, 0.0f, 360.0f);
    }

    public Model createCone(float f, float f2, float f3, int n, int n2, Material material, long l, float f4, float f5) {
        this.begin();
        this.part("cone", n2, l, material).cone(f, f2, f3, n, f4, f5);
        return this.end();
    }

    public Model createCone(float f, float f2, float f3, int n, Material material, long l) {
        return this.createCone(f, f2, f3, n, 4, material, l);
    }

    public Model createCone(float f, float f2, float f3, int n, Material material, long l, float f4, float f5) {
        return this.createCone(f, f2, f3, n, 4, material, l, f4, f5);
    }

    public Model createCylinder(float f, float f2, float f3, int n, int n2, Material material, long l) {
        return this.createCylinder(f, f2, f3, n, n2, material, l, 0.0f, 360.0f);
    }

    public Model createCylinder(float f, float f2, float f3, int n, int n2, Material material, long l, float f4, float f5) {
        this.begin();
        this.part("cylinder", n2, l, material).cylinder(f, f2, f3, n, f4, f5);
        return this.end();
    }

    public Model createCylinder(float f, float f2, float f3, int n, Material material, long l) {
        return this.createCylinder(f, f2, f3, n, 4, material, l);
    }

    public Model createCylinder(float f, float f2, float f3, int n, Material material, long l, float f4, float f5) {
        return this.createCylinder(f, f2, f3, n, 4, material, l, f4, f5);
    }

    public Model createLineGrid(int n, int n2, float f, float f2, Material object, long l) {
        this.begin();
        object = this.part("lines", 1, l, (Material)object);
        float f3 = n;
        float f4 = n2;
        float f5 = f3 * f / 2.0f;
        float f6 = f4 * f2 / 2.0f;
        float f7 = -f5;
        f3 = -f6;
        int n3 = 0;
        float f8 = f4 = f7;
        for (int i = 0; i <= n; ++i) {
            object.line(f4, 0.0f, f6, f8, 0.0f, f3);
            f4 += f;
            f8 += f;
        }
        f = f3;
        for (n = n3; n <= n2; ++n) {
            object.line(f7, 0.0f, f3, f5, 0.0f, f);
            f3 += f2;
            f += f2;
        }
        return this.end();
    }

    public Model createRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, Material material, long l) {
        this.begin();
        this.part("rect", n, l, material).rect(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15);
        return this.end();
    }

    public Model createRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, Material material, long l) {
        return this.createRect(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, 4, material, l);
    }

    public Model createSphere(float f, float f2, float f3, int n, int n2, int n3, Material material, long l) {
        return this.createSphere(f, f2, f3, n, n2, n3, material, l, 0.0f, 360.0f, 0.0f, 180.0f);
    }

    public Model createSphere(float f, float f2, float f3, int n, int n2, int n3, Material material, long l, float f4, float f5, float f6, float f7) {
        this.begin();
        this.part("cylinder", n3, l, material).sphere(f, f2, f3, n, n2, f4, f5, f6, f7);
        return this.end();
    }

    public Model createSphere(float f, float f2, float f3, int n, int n2, Material material, long l) {
        return this.createSphere(f, f2, f3, n, n2, 4, material, l);
    }

    public Model createSphere(float f, float f2, float f3, int n, int n2, Material material, long l, float f4, float f5, float f6, float f7) {
        return this.createSphere(f, f2, f3, n, n2, 4, material, l, f4, f5, f6, f7);
    }

    public Model createXYZCoordinates(float f, float f2, float f3, int n, int n2, Material object, long l) {
        this.begin();
        this.node();
        object = this.part("xyz", n2, l, (Material)object);
        object.setColor(Color.RED);
        object.arrow(0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, f2, f3, n);
        object.setColor(Color.GREEN);
        object.arrow(0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, f2, f3, n);
        object.setColor(Color.BLUE);
        object.arrow(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f, f2, f3, n);
        return this.end();
    }

    public Model createXYZCoordinates(float f, Material material, long l) {
        return this.createXYZCoordinates(f, 0.1f, 0.1f, 5, 4, material, l);
    }

    public Model end() {
        Model model = this.model;
        if (model != null) {
            this.endnode();
            this.model = null;
            Iterator<MeshBuilder> iterator = this.builders.iterator();
            while (iterator.hasNext()) {
                iterator.next().end();
            }
            this.builders.clear();
            ModelBuilder.rebuildReferences(model);
            return model;
        }
        GdxRuntimeException gdxRuntimeException = new GdxRuntimeException("Call begin() first");
        throw gdxRuntimeException;
    }

    public void manage(Disposable disposable) {
        Model model = this.model;
        if (model != null) {
            model.manageDisposable(disposable);
            return;
        }
        throw new GdxRuntimeException("Call begin() first");
    }

    public Node node() {
        Node node = new Node();
        this.node(node);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("node");
        stringBuilder.append(this.model.nodes.size);
        node.id = stringBuilder.toString();
        return node;
    }

    protected Node node(Node node) {
        if (this.model != null) {
            this.endnode();
            this.model.nodes.add(node);
            this.node = node;
            return node;
        }
        throw new GdxRuntimeException("Call begin() first");
    }

    public Node node(String object, Model model) {
        Node node = new Node();
        node.id = object;
        node.addChildren(model.nodes);
        this.node(node);
        object = model.getManagedDisposables().iterator();
        while (object.hasNext()) {
            this.manage((Disposable)object.next());
        }
        return node;
    }

    public MeshPart part(String string2, Mesh mesh, int n, int n2, int n3, Material material) {
        MeshPart meshPart = new MeshPart();
        meshPart.id = string2;
        meshPart.primitiveType = n;
        meshPart.mesh = mesh;
        meshPart.offset = n2;
        meshPart.size = n3;
        this.part(meshPart, material);
        return meshPart;
    }

    public MeshPart part(String string2, Mesh mesh, int n, Material material) {
        return this.part(string2, mesh, n, 0, mesh.getNumIndices(), material);
    }

    public MeshPartBuilder part(String string2, int n, long l, Material material) {
        return this.part(string2, n, MeshBuilder.createAttributes(l), material);
    }

    public MeshPartBuilder part(String string2, int n, VertexAttributes object, Material material) {
        object = this.getBuilder((VertexAttributes)object);
        this.part(((MeshBuilder)object).part(string2, n), material);
        return object;
    }

    public void part(MeshPart meshPart, Material material) {
        if (this.node == null) {
            this.node();
        }
        this.node.parts.add(new NodePart(meshPart, material));
    }
}

