/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.influencers.DynamicsModifier;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import java.util.Arrays;

public class DynamicsInfluencer
extends Influencer {
    private ParallelArray.FloatChannel accellerationChannel;
    private ParallelArray.FloatChannel angularVelocityChannel;
    boolean has2dAngularVelocity;
    boolean has3dAngularVelocity;
    boolean hasAcceleration;
    private ParallelArray.FloatChannel positionChannel;
    private ParallelArray.FloatChannel previousPositionChannel;
    private ParallelArray.FloatChannel rotationChannel;
    public Array<DynamicsModifier> velocities;

    public DynamicsInfluencer() {
        this.velocities = new Array(true, 3, DynamicsModifier.class);
    }

    public DynamicsInfluencer(DynamicsInfluencer dynamicsInfluencer) {
        this(dynamicsInfluencer.velocities.toArray(DynamicsModifier.class));
    }

    public DynamicsInfluencer(DynamicsModifier ... dynamicsModifierArray) {
        this.velocities = new Array(true, dynamicsModifierArray.length, DynamicsModifier.class);
        for (DynamicsModifier dynamicsModifier : dynamicsModifierArray) {
            this.velocities.add((DynamicsModifier)dynamicsModifier.copy());
        }
    }

    @Override
    public void activateParticles(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.hasAcceleration) {
            n5 = this.positionChannel.strideSize * n;
            n4 = this.positionChannel.strideSize;
            for (n3 = n5; n3 < n4 * n2 + n5; n3 += this.positionChannel.strideSize) {
                float[] fArray = this.previousPositionChannel.data;
                int n6 = n3 + 0;
                fArray[n6] = this.positionChannel.data[n6];
                fArray = this.previousPositionChannel.data;
                n6 = n3 + 1;
                fArray[n6] = this.positionChannel.data[n6];
                fArray = this.previousPositionChannel.data;
                n6 = n3 + 2;
                fArray[n6] = this.positionChannel.data[n6];
            }
        }
        if (this.has2dAngularVelocity) {
            n5 = this.rotationChannel.strideSize * n;
            n4 = this.rotationChannel.strideSize;
            for (n3 = n5; n3 < n4 * n2 + n5; n3 += this.rotationChannel.strideSize) {
                this.rotationChannel.data[n3 + 0] = 1.0f;
                this.rotationChannel.data[n3 + 1] = 0.0f;
            }
        } else if (this.has3dAngularVelocity) {
            n5 = this.rotationChannel.strideSize * n;
            n4 = this.rotationChannel.strideSize;
            for (n3 = n5; n3 < n4 * n2 + n5; n3 += this.rotationChannel.strideSize) {
                this.rotationChannel.data[n3 + 0] = 0.0f;
                this.rotationChannel.data[n3 + 1] = 0.0f;
                this.rotationChannel.data[n3 + 2] = 0.0f;
                this.rotationChannel.data[n3 + 3] = 1.0f;
            }
        }
        for (n3 = 0; n3 < this.velocities.size; ++n3) {
            ((DynamicsModifier[])this.velocities.items)[n3].activateParticles(n, n2);
        }
    }

    @Override
    public void allocateChannels() {
        boolean bl = false;
        for (int i = 0; i < this.velocities.size; ++i) {
            ((DynamicsModifier[])this.velocities.items)[i].allocateChannels();
        }
        this.accellerationChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.Acceleration);
        boolean bl2 = this.accellerationChannel != null;
        this.hasAcceleration = bl2;
        if (this.hasAcceleration) {
            this.positionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Position);
            this.previousPositionChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.PreviousPosition);
        }
        this.angularVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.AngularVelocity2D);
        bl2 = this.angularVelocityChannel != null;
        this.has2dAngularVelocity = bl2;
        if (this.has2dAngularVelocity) {
            this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation2D);
            this.has3dAngularVelocity = false;
        } else {
            this.angularVelocityChannel = (ParallelArray.FloatChannel)this.controller.particles.getChannel(ParticleChannels.AngularVelocity3D);
            bl2 = bl;
            if (this.angularVelocityChannel != null) {
                bl2 = true;
            }
            this.has3dAngularVelocity = bl2;
            if (this.has3dAngularVelocity) {
                this.rotationChannel = (ParallelArray.FloatChannel)this.controller.particles.addChannel(ParticleChannels.Rotation3D);
            }
        }
    }

    @Override
    public DynamicsInfluencer copy() {
        return new DynamicsInfluencer(this);
    }

    @Override
    public void init() {
        for (int i = 0; i < this.velocities.size; ++i) {
            ((DynamicsModifier[])this.velocities.items)[i].init();
        }
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.velocities.addAll((Array)((Object)json.readValue("velocities", Array.class, DynamicsModifier.class, jsonValue)));
    }

    @Override
    public void set(ParticleController particleController) {
        super.set(particleController);
        for (int i = 0; i < this.velocities.size; ++i) {
            ((DynamicsModifier[])this.velocities.items)[i].set(particleController);
        }
    }

    @Override
    public void update() {
        block9: {
            float f;
            int n;
            float f2;
            int n2;
            float f3;
            int n3;
            float[] fArray;
            int n4;
            int n5;
            int n6;
            int n7;
            block8: {
                boolean bl = this.hasAcceleration;
                n7 = 0;
                n6 = 0;
                if (bl) {
                    Arrays.fill(this.accellerationChannel.data, 0, this.controller.particles.size * this.accellerationChannel.strideSize, 0.0f);
                }
                if (this.has2dAngularVelocity || this.has3dAngularVelocity) {
                    Arrays.fill(this.angularVelocityChannel.data, 0, this.controller.particles.size * this.angularVelocityChannel.strideSize, 0.0f);
                }
                for (n5 = 0; n5 < this.velocities.size; ++n5) {
                    ((DynamicsModifier[])this.velocities.items)[n5].update();
                }
                if (this.hasAcceleration) {
                    n4 = 0;
                    n5 = 0;
                    while (n4 < this.controller.particles.size) {
                        fArray = this.positionChannel.data;
                        n3 = n5 + 0;
                        f3 = fArray[n3];
                        fArray = this.positionChannel.data;
                        n2 = n5 + 1;
                        f2 = fArray[n2];
                        fArray = this.positionChannel.data;
                        n = n5 + 2;
                        f = fArray[n];
                        this.positionChannel.data[n3] = f3 * 2.0f - this.previousPositionChannel.data[n3] + this.accellerationChannel.data[n3] * this.controller.deltaTimeSqr;
                        this.positionChannel.data[n2] = f2 * 2.0f - this.previousPositionChannel.data[n2] + this.accellerationChannel.data[n2] * this.controller.deltaTimeSqr;
                        this.positionChannel.data[n] = 2.0f * f - this.previousPositionChannel.data[n] + this.accellerationChannel.data[n] * this.controller.deltaTimeSqr;
                        this.previousPositionChannel.data[n3] = f3;
                        this.previousPositionChannel.data[n2] = f2;
                        this.previousPositionChannel.data[n] = f;
                        ++n4;
                        n5 += this.positionChannel.strideSize;
                    }
                }
                if (!this.has2dAngularVelocity) break block8;
                n4 = 0;
                n5 = n6;
                while (n5 < this.controller.particles.size) {
                    f2 = this.angularVelocityChannel.data[n5] * this.controller.deltaTime;
                    if (f2 != 0.0f) {
                        f = MathUtils.cosDeg(f2);
                        f2 = MathUtils.sinDeg(f2);
                        fArray = this.rotationChannel.data;
                        n7 = n4 + 0;
                        float f4 = fArray[n7];
                        fArray = this.rotationChannel.data;
                        n6 = n4 + 1;
                        f3 = fArray[n6];
                        this.rotationChannel.data[n7] = f4 * f - f3 * f2;
                        this.rotationChannel.data[n6] = f3 * f + f4 * f2;
                    }
                    ++n5;
                    n4 += this.rotationChannel.strideSize;
                }
                break block9;
            }
            if (!this.has3dAngularVelocity) break block9;
            n6 = 0;
            n5 = 0;
            n4 = n7;
            n7 = n6;
            while (n4 < this.controller.particles.size) {
                f = this.angularVelocityChannel.data[n7 + 0];
                float f5 = this.angularVelocityChannel.data[n7 + 1];
                float f6 = this.angularVelocityChannel.data[n7 + 2];
                fArray = this.rotationChannel.data;
                n3 = n5 + 0;
                f2 = fArray[n3];
                fArray = this.rotationChannel.data;
                n = n5 + 1;
                f3 = fArray[n];
                fArray = this.rotationChannel.data;
                n2 = n5 + 2;
                float f7 = fArray[n2];
                fArray = this.rotationChannel.data;
                n6 = n5 + 3;
                float f8 = fArray[n6];
                TMP_Q.set(f, f5, f6, 0.0f).mul(f2, f3, f7, f8).mul(this.controller.deltaTime * 0.5f).add(f2, f3, f7, f8).nor();
                this.rotationChannel.data[n3] = DynamicsInfluencer.TMP_Q.x;
                this.rotationChannel.data[n] = DynamicsInfluencer.TMP_Q.y;
                this.rotationChannel.data[n2] = DynamicsInfluencer.TMP_Q.z;
                this.rotationChannel.data[n6] = DynamicsInfluencer.TMP_Q.w;
                ++n4;
                n5 += this.rotationChannel.strideSize;
                n7 += this.angularVelocityChannel.strideSize;
            }
        }
    }

    @Override
    public void write(Json json) {
        json.writeValue("velocities", this.velocities, Array.class, DynamicsModifier.class);
    }
}

