/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.decals;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.decals.Decal;
import com.badlogic.gdx.graphics.g3d.decals.DecalMaterial;
import com.badlogic.gdx.graphics.g3d.decals.GroupStrategy;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.SortedIntList;
import java.util.Iterator;

public class DecalBatch
implements Disposable {
    private static final int DEFAULT_SIZE = 1000;
    private final SortedIntList<Array<Decal>> groupList = new SortedIntList();
    private final Pool<Array<Decal>> groupPool = new Pool<Array<Decal>>(16){

        @Override
        protected Array<Decal> newObject() {
            return new Array<Decal>(false, 100);
        }
    };
    private GroupStrategy groupStrategy;
    private Mesh mesh;
    private final Array<Array<Decal>> usedGroups = new Array(16);
    private float[] vertices;

    public DecalBatch(int n, GroupStrategy groupStrategy) {
        this.initialize(n);
        this.setGroupStrategy(groupStrategy);
    }

    public DecalBatch(GroupStrategy groupStrategy) {
        this(1000, groupStrategy);
    }

    private void render(ShaderProgram shaderProgram, Array<Decal> object) {
        int n;
        Iterator<Decal> iterator = ((Array)object).iterator();
        object = null;
        block0: while (true) {
            n = 0;
            Object object2 = object;
            while (iterator.hasNext()) {
                int n2;
                Decal decal;
                block8: {
                    block7: {
                        decal = iterator.next();
                        if (object2 == null) break block7;
                        n2 = n;
                        object = object2;
                        if (((DecalMaterial)object2).equals(decal.getMaterial())) break block8;
                    }
                    n2 = n;
                    if (n > 0) {
                        this.flush(shaderProgram, n);
                        n2 = 0;
                    }
                    decal.material.set();
                    object = decal.material;
                }
                decal.update();
                System.arraycopy(decal.vertices, 0, this.vertices, n2, decal.vertices.length);
                n = n2 += decal.vertices.length;
                object2 = object;
                if (n2 != this.vertices.length) continue;
                this.flush(shaderProgram, n2);
                continue block0;
            }
            break;
        }
        if (n > 0) {
            this.flush(shaderProgram, n);
        }
    }

    public void add(Decal decal) {
        Array<Decal> array;
        int n = this.groupStrategy.decideGroup(decal);
        Array<Decal> array2 = array = this.groupList.get(n);
        if (array == null) {
            array2 = this.groupPool.obtain();
            array2.clear();
            this.usedGroups.add(array2);
            this.groupList.insert(n, array2);
        }
        array2.add(decal);
    }

    protected void clear() {
        this.groupList.clear();
        this.groupPool.freeAll(this.usedGroups);
        this.usedGroups.clear();
    }

    @Override
    public void dispose() {
        this.clear();
        this.vertices = null;
        this.mesh.dispose();
    }

    public void flush() {
        this.render();
        this.clear();
    }

    protected void flush(ShaderProgram shaderProgram, int n) {
        this.mesh.setVertices(this.vertices, 0, n);
        this.mesh.render(shaderProgram, 4, 0, n / 4);
    }

    public int getSize() {
        return this.vertices.length / 24;
    }

    public void initialize(int n) {
        this.vertices = new float[n * 24];
        Object object = Mesh.VertexDataType.VertexArray;
        if (Gdx.gl30 != null) {
            object = Mesh.VertexDataType.VertexBufferObjectWithVAO;
        }
        int n2 = n * 6;
        VertexAttribute vertexAttribute = new VertexAttribute(1, 3, "a_position");
        int n3 = 0;
        this.mesh = new Mesh((Mesh.VertexDataType)((Object)object), false, n * 4, n2, new VertexAttribute[]{vertexAttribute, new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0")});
        object = new short[n2];
        n2 = 0;
        n = n3;
        n3 = n2;
        while (n < ((Mesh.VertexDataType)object).length) {
            object[n] = (Mesh.VertexDataType)((short)((short)n3));
            n2 = (short)(n3 + 2);
            object[n + 1] = (Mesh.VertexDataType)((short)n2);
            short s = (short)(n3 + 1);
            object[n + 2] = (Mesh.VertexDataType)((short)s);
            object[n + 3] = (Mesh.VertexDataType)((short)s);
            object[n + 4] = (Mesh.VertexDataType)((short)n2);
            object[n + 5] = (Mesh.VertexDataType)((short)((short)(n3 + 3)));
            n += 6;
            n3 += 4;
        }
        this.mesh.setIndices((short[])object);
    }

    protected void render() {
        this.groupStrategy.beforeGroups();
        for (SortedIntList.Node<Array<Decal>> node : this.groupList) {
            this.groupStrategy.beforeGroup(node.index, (Array)node.value);
            this.render(this.groupStrategy.getGroupShader(node.index), (Array)node.value);
            this.groupStrategy.afterGroup(node.index);
        }
        this.groupStrategy.afterGroups();
    }

    public void setGroupStrategy(GroupStrategy groupStrategy) {
        this.groupStrategy = groupStrategy;
    }
}

