/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNode;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import java.io.Serializable;
import java.util.Iterator;

public class Model
implements Disposable {
    public final Array<Animation> animations;
    protected final Array<Disposable> disposables;
    public final Array<Material> materials = new Array();
    public final Array<MeshPart> meshParts;
    public final Array<Mesh> meshes;
    private ObjectMap<NodePart, ArrayMap<String, Matrix4>> nodePartBones;
    public final Array<Node> nodes = new Array();

    public Model() {
        this.animations = new Array();
        this.meshes = new Array();
        this.meshParts = new Array();
        this.disposables = new Array();
        this.nodePartBones = new ObjectMap();
    }

    public Model(ModelData modelData) {
        this(modelData, new TextureProvider.FileTextureProvider());
    }

    public Model(ModelData modelData, TextureProvider textureProvider) {
        this.animations = new Array();
        this.meshes = new Array();
        this.meshParts = new Array();
        this.disposables = new Array();
        this.nodePartBones = new ObjectMap();
        this.load(modelData, textureProvider);
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public void calculateTransforms() {
        int n = this.nodes.size;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 >= n) break;
            this.nodes.get(n3).calculateTransforms(true);
            ++n3;
        }
        for (int i = n2; i < n; ++i) {
            this.nodes.get(i).calculateBoneTransforms(true);
        }
    }

    protected Material convertMaterial(ModelMaterial object, TextureProvider textureProvider) {
        Material material = new Material();
        material.id = ((ModelMaterial)object).id;
        if (((ModelMaterial)object).ambient != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Ambient, ((ModelMaterial)object).ambient));
        }
        if (((ModelMaterial)object).diffuse != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, ((ModelMaterial)object).diffuse));
        }
        if (((ModelMaterial)object).specular != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, ((ModelMaterial)object).specular));
        }
        if (((ModelMaterial)object).emissive != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, ((ModelMaterial)object).emissive));
        }
        if (((ModelMaterial)object).reflection != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Reflection, ((ModelMaterial)object).reflection));
        }
        if (((ModelMaterial)object).shininess > 0.0f) {
            material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, ((ModelMaterial)object).shininess));
        }
        if (((ModelMaterial)object).opacity != 1.0f) {
            material.set((Attribute)new BlendingAttribute(770, 771, ((ModelMaterial)object).opacity));
        }
        ObjectMap<String, Object> objectMap = new ObjectMap<String, Object>();
        if (((ModelMaterial)object).textures != null) {
            for (ModelTexture modelTexture : ((ModelMaterial)object).textures) {
                if (objectMap.containsKey(modelTexture.fileName)) {
                    object = (Texture)objectMap.get(modelTexture.fileName);
                } else {
                    object = textureProvider.load(modelTexture.fileName);
                    objectMap.put(modelTexture.fileName, object);
                    this.disposables.add((Disposable)object);
                }
                TextureDescriptor<Object> textureDescriptor = new TextureDescriptor<Object>(object);
                textureDescriptor.minFilter = ((GLTexture)object).getMinFilter();
                textureDescriptor.magFilter = ((GLTexture)object).getMagFilter();
                textureDescriptor.uWrap = ((GLTexture)object).getUWrap();
                textureDescriptor.vWrap = ((GLTexture)object).getVWrap();
                float f = modelTexture.uvTranslation == null ? 0.0f : modelTexture.uvTranslation.x;
                float f2 = modelTexture.uvTranslation == null ? 0.0f : modelTexture.uvTranslation.y;
                float f3 = modelTexture.uvScaling == null ? 1.0f : modelTexture.uvScaling.x;
                float f4 = modelTexture.uvScaling == null ? 1.0f : modelTexture.uvScaling.y;
                int n = modelTexture.usage;
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                if (n != 7) {
                                    if (n != 8) {
                                        if (n != 10) continue;
                                        material.set((Attribute)new TextureAttribute(TextureAttribute.Reflection, textureDescriptor, f, f2, f3, f4));
                                        continue;
                                    }
                                    material.set((Attribute)new TextureAttribute(TextureAttribute.Bump, textureDescriptor, f, f2, f3, f4));
                                    continue;
                                }
                                material.set((Attribute)new TextureAttribute(TextureAttribute.Normal, textureDescriptor, f, f2, f3, f4));
                                continue;
                            }
                            material.set((Attribute)new TextureAttribute(TextureAttribute.Specular, textureDescriptor, f, f2, f3, f4));
                            continue;
                        }
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Ambient, textureDescriptor, f, f2, f3, f4));
                        continue;
                    }
                    material.set((Attribute)new TextureAttribute(TextureAttribute.Emissive, textureDescriptor, f, f2, f3, f4));
                    continue;
                }
                material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, textureDescriptor, f, f2, f3, f4));
            }
        }
        return material;
    }

    protected void convertMesh(ModelMesh iterator) {
        int n;
        Object object = ((ModelMesh)((Object)iterator)).parts;
        int n2 = ((ModelMeshPart[])object).length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += object[n].indices.length;
        }
        n = n3 > 0 ? 1 : 0;
        object = new VertexAttributes(((ModelMesh)((Object)iterator)).attributes);
        int n4 = ((ModelMesh)((Object)iterator)).vertices.length / (((VertexAttributes)object).vertexSize / 4);
        object = new Mesh(true, n4, n3, (VertexAttributes)object);
        this.meshes.add((Mesh)object);
        this.disposables.add((Disposable)object);
        BufferUtils.copy(((ModelMesh)((Object)iterator)).vertices, ((Mesh)object).getVerticesBuffer(), ((ModelMesh)((Object)iterator)).vertices.length, 0);
        ((Mesh)object).getIndicesBuffer().clear();
        ModelMeshPart[] modelMeshPartArray = ((ModelMesh)((Object)iterator)).parts;
        int n5 = modelMeshPartArray.length;
        n2 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            ModelMeshPart modelMeshPart = modelMeshPartArray[n3];
            iterator = new MeshPart();
            ((MeshPart)((Object)iterator)).id = modelMeshPart.id;
            ((MeshPart)((Object)iterator)).primitiveType = modelMeshPart.primitiveType;
            ((MeshPart)((Object)iterator)).offset = n2;
            int n6 = n != 0 ? modelMeshPart.indices.length : n4;
            ((MeshPart)((Object)iterator)).size = n6;
            ((MeshPart)((Object)iterator)).mesh = object;
            if (n != 0) {
                ((Mesh)object).getIndicesBuffer().put(modelMeshPart.indices);
            }
            n2 += ((MeshPart)((Object)iterator)).size;
            this.meshParts.add((MeshPart)((Object)iterator));
        }
        ((Mesh)object).getIndicesBuffer().position(0);
        iterator = this.meshParts.iterator();
        while (iterator.hasNext()) {
            iterator.next().update();
        }
    }

    @Override
    public void dispose() {
        Iterator<Disposable> iterator = this.disposables.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        int n = this.nodes.size;
        for (int i = 0; i < n; ++i) {
            this.nodes.get(i).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public Animation getAnimation(String string2) {
        return this.getAnimation(string2, true);
    }

    public Animation getAnimation(String string2, boolean bl) {
        int n;
        int n2 = this.animations.size;
        int n3 = 0;
        if (bl) {
            for (n = n3; n < n2; ++n) {
                Animation animation = this.animations.get(n);
                if (!animation.id.equalsIgnoreCase(string2)) continue;
                return animation;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Animation animation = this.animations.get(n);
                if (!animation.id.equals(string2)) continue;
                return animation;
            }
        }
        return null;
    }

    public Iterable<Disposable> getManagedDisposables() {
        return this.disposables;
    }

    public Material getMaterial(String string2) {
        return this.getMaterial(string2, true);
    }

    public Material getMaterial(String string2, boolean bl) {
        int n;
        int n2 = this.materials.size;
        int n3 = 0;
        if (bl) {
            for (n = n3; n < n2; ++n) {
                Material material = this.materials.get(n);
                if (!material.id.equalsIgnoreCase(string2)) continue;
                return material;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                Material material = this.materials.get(n);
                if (!material.id.equals(string2)) continue;
                return material;
            }
        }
        return null;
    }

    public Node getNode(String string2) {
        return this.getNode(string2, true);
    }

    public Node getNode(String string2, boolean bl) {
        return this.getNode(string2, bl, false);
    }

    public Node getNode(String string2, boolean bl, boolean bl2) {
        return Node.getNode(this.nodes, string2, bl, bl2);
    }

    protected void load(ModelData modelData, TextureProvider textureProvider) {
        this.loadMeshes(modelData.meshes);
        this.loadMaterials(modelData.materials, textureProvider);
        this.loadNodes(modelData.nodes);
        this.loadAnimations(modelData.animations);
        this.calculateTransforms();
    }

    /*
     * WARNING - void declaration
     */
    protected void loadAnimations(Iterable<ModelAnimation> object3) {
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            ModelAnimation modelAnimation = (ModelAnimation)iterator.next();
            Animation animation = new Animation();
            animation.id = modelAnimation.id;
            for (ModelNodeAnimation modelNodeAnimation : modelAnimation.nodeAnimations) {
                float f;
                Array<NodeKeyframe<Quaternion>> array;
                Node node = this.getNode(modelNodeAnimation.nodeId);
                if (node == null) continue;
                NodeAnimation nodeAnimation = new NodeAnimation();
                nodeAnimation.node = node;
                if (modelNodeAnimation.translation != null) {
                    nodeAnimation.translation = new Array();
                    nodeAnimation.translation.ensureCapacity(modelNodeAnimation.translation.size);
                    for (ModelNodeKeyframe<Serializable> modelNodeKeyframe : modelNodeAnimation.translation) {
                        void var1_8;
                        if (modelNodeKeyframe.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        array = nodeAnimation.translation;
                        f = modelNodeKeyframe.keytime;
                        if (modelNodeKeyframe.value == null) {
                            Vector3 vector3 = node.translation;
                        } else {
                            Vector3 vector3 = (Vector3)modelNodeKeyframe.value;
                        }
                        array.add(new NodeKeyframe<Vector3>(f, new Vector3((Vector3)var1_8)));
                    }
                }
                if (modelNodeAnimation.rotation != null) {
                    nodeAnimation.rotation = new Array();
                    nodeAnimation.rotation.ensureCapacity(modelNodeAnimation.rotation.size);
                    for (ModelNodeKeyframe<Serializable> modelNodeKeyframe : modelNodeAnimation.rotation) {
                        void var1_12;
                        if (modelNodeKeyframe.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        array = nodeAnimation.rotation;
                        f = modelNodeKeyframe.keytime;
                        if (modelNodeKeyframe.value == null) {
                            Quaternion quaternion = node.rotation;
                        } else {
                            Quaternion quaternion = (Quaternion)modelNodeKeyframe.value;
                        }
                        array.add(new NodeKeyframe<Quaternion>(f, new Quaternion((Quaternion)var1_12)));
                    }
                }
                if (modelNodeAnimation.scaling != null) {
                    nodeAnimation.scaling = new Array();
                    nodeAnimation.scaling.ensureCapacity(modelNodeAnimation.scaling.size);
                    for (ModelNodeKeyframe<Vector3> modelNodeKeyframe : modelNodeAnimation.scaling) {
                        void var1_16;
                        if (modelNodeKeyframe.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        Array<NodeKeyframe<Vector3>> array2 = nodeAnimation.scaling;
                        f = modelNodeKeyframe.keytime;
                        if (modelNodeKeyframe.value == null) {
                            Vector3 vector3 = node.scale;
                        } else {
                            Vector3 vector3 = (Vector3)modelNodeKeyframe.value;
                        }
                        array2.add(new NodeKeyframe<Vector3>(f, new Vector3((Vector3)var1_16)));
                    }
                }
                if (!(nodeAnimation.translation != null && nodeAnimation.translation.size > 0 || nodeAnimation.rotation != null && nodeAnimation.rotation.size > 0) && (nodeAnimation.scaling == null || nodeAnimation.scaling.size <= 0)) continue;
                animation.nodeAnimations.add(nodeAnimation);
            }
            if (animation.nodeAnimations.size <= 0) continue;
            this.animations.add(animation);
        }
    }

    protected void loadMaterials(Iterable<ModelMaterial> object, TextureProvider textureProvider) {
        object = object.iterator();
        while (object.hasNext()) {
            ModelMaterial modelMaterial = (ModelMaterial)object.next();
            this.materials.add(this.convertMaterial(modelMaterial, textureProvider));
        }
    }

    protected void loadMeshes(Iterable<ModelMesh> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.convertMesh((ModelMesh)object.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Node loadNode(ModelNode object) {
        Node node = new Node();
        node.id = ((ModelNode)object).id;
        if (((ModelNode)object).translation != null) {
            node.translation.set(((ModelNode)object).translation);
        }
        if (((ModelNode)object).rotation != null) {
            node.rotation.set(((ModelNode)object).rotation);
        }
        if (((ModelNode)object).scale != null) {
            node.scale.set(((ModelNode)object).scale);
        }
        ModelNodePart[] object22 = ((ModelNode)object).parts;
        int n = 0;
        if (object22 != null) {
            for (ModelNodePart modelNodePart : ((ModelNode)object).parts) {
                void var3_9;
                String string2 = modelNodePart.meshPartId;
                NodePart nodePart = null;
                if (string2 != null) {
                    for (MeshPart meshPart : this.meshParts) {
                        if (!modelNodePart.meshPartId.equals(meshPart.id)) continue;
                        break;
                    }
                } else {
                    Object var3_8 = null;
                }
                Object object2 = nodePart;
                if (modelNodePart.materialId != null) {
                    Iterator<Material> iterator = this.materials.iterator();
                    do {
                        object2 = nodePart;
                        if (!iterator.hasNext()) break;
                        object2 = iterator.next();
                    } while (!modelNodePart.materialId.equals(((Material)object2).id));
                }
                if (var3_9 != null && object2 != null) {
                    if (var3_9 == null || object2 == null) continue;
                    nodePart = new NodePart();
                    nodePart.meshPart = var3_9;
                    nodePart.material = object2;
                    node.parts.add(nodePart);
                    if (modelNodePart.bones == null) continue;
                    this.nodePartBones.put(nodePart, modelNodePart.bones);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Invalid node: ");
                ((StringBuilder)object).append(node.id);
                throw new GdxRuntimeException(((StringBuilder)object).toString());
            }
        }
        if (((ModelNode)object).children != null) {
            object = ((ModelNode)object).children;
            int n2 = ((Object)object).length;
            for (int i = n; i < n2; ++i) {
                node.addChild(this.loadNode((ModelNode)object[i]));
            }
        }
        return node;
    }

    protected void loadNodes(Iterable<ModelNode> iterator) {
        this.nodePartBones.clear();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ModelNode modelNode = (ModelNode)((Object)iterator.next());
            this.nodes.add(this.loadNode(modelNode));
        }
        for (ObjectMap.Entry entry : this.nodePartBones.entries()) {
            if (((NodePart)entry.key).invBoneBindTransforms == null) {
                ((NodePart)entry.key).invBoneBindTransforms = new ArrayMap(Node.class, Matrix4.class);
            }
            ((NodePart)entry.key).invBoneBindTransforms.clear();
            for (ObjectMap.Entry entry2 : ((ArrayMap)entry.value).entries()) {
                ((NodePart)entry.key).invBoneBindTransforms.put(this.getNode((String)entry2.key), new Matrix4((Matrix4)entry2.value).inv());
            }
        }
    }

    public void manageDisposable(Disposable disposable) {
        if (!this.disposables.contains(disposable, true)) {
            this.disposables.add(disposable);
        }
    }
}

