/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d.freetype;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeType;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class FreeTypeFontGenerator
implements Disposable {
    public static final String DEFAULT_CHARS = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
    public static final int NO_MAXIMUM = -1;
    private static int maxTextureSize = 1024;
    boolean bitmapped = false;
    final FreeType.Face face;
    final FreeType.Library library;
    final String name;
    private int pixelHeight;
    private int pixelWidth;

    public FreeTypeFontGenerator(FileHandle fileHandle) {
        this(fileHandle, 0);
    }

    public FreeTypeFontGenerator(FileHandle fileHandle, int n) {
        this.name = fileHandle.nameWithoutExtension();
        this.library = FreeType.initFreeType();
        this.face = this.library.newFace(fileHandle, n);
        if (this.checkForBitmapFont()) {
            return;
        }
        this.setPixelSizes(0, 15);
    }

    private boolean checkForBitmapFont() {
        int n = this.face.getFaceFlags();
        if ((FreeType.FT_FACE_FLAG_FIXED_SIZES & n) == FreeType.FT_FACE_FLAG_FIXED_SIZES && (n & FreeType.FT_FACE_FLAG_HORIZONTAL) == FreeType.FT_FACE_FLAG_HORIZONTAL && this.loadChar(32) && this.face.getGlyph().getFormat() == 1651078259) {
            this.bitmapped = true;
        }
        return this.bitmapped;
    }

    /*
     * Unable to fully structure code
     */
    private int getLoadingFlags(FreeTypeFontParameter var1_1) {
        block9: {
            block10: {
                var2_2 = FreeType.FT_LOAD_DEFAULT;
                switch (1.$SwitchMap$com$badlogic$gdx$graphics$g2d$freetype$FreeTypeFontGenerator$Hinting[var1_1.hinting.ordinal()]) {
                    default: {
                        var3_3 = var2_2;
                        break block9;
                    }
                    case 7: {
                        var4_4 = FreeType.FT_LOAD_FORCE_AUTOHINT;
                        var3_3 = FreeType.FT_LOAD_TARGET_MONO;
                        ** GOTO lbl17
                    }
                    case 6: {
                        var4_4 = FreeType.FT_LOAD_FORCE_AUTOHINT;
                        var3_3 = FreeType.FT_LOAD_TARGET_NORMAL;
                        ** GOTO lbl17
                    }
                    case 5: {
                        var4_4 = FreeType.FT_LOAD_FORCE_AUTOHINT;
                        var3_3 = FreeType.FT_LOAD_TARGET_LIGHT;
lbl17:
                        // 3 sources

                        var3_3 = var4_4 | var3_3;
                        break block10;
                    }
                    case 4: {
                        var3_3 = FreeType.FT_LOAD_TARGET_MONO;
                        break block10;
                    }
                    case 3: {
                        var3_3 = FreeType.FT_LOAD_TARGET_NORMAL;
                        break block10;
                    }
                    case 2: {
                        var3_3 = FreeType.FT_LOAD_TARGET_LIGHT;
                        break block10;
                    }
                    case 1: 
                }
                var3_3 = FreeType.FT_LOAD_NO_HINTING;
            }
            var3_3 = var2_2 | var3_3;
        }
        return var3_3;
    }

    public static int getMaxTextureSize() {
        return maxTextureSize;
    }

    private boolean loadChar(int n) {
        return this.loadChar(n, FreeType.FT_LOAD_DEFAULT | FreeType.FT_LOAD_FORCE_AUTOHINT);
    }

    private boolean loadChar(int n, int n2) {
        return this.face.loadChar(n, n2);
    }

    public static void setMaxTextureSize(int n) {
        maxTextureSize = n;
    }

    BitmapFont.Glyph createGlyph(char c, FreeTypeBitmapFontData freeTypeBitmapFontData, FreeTypeFontParameter object, FreeType.Stroker object2, float f, PixmapPacker pixmapPacker) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object3;
        Object object4;
        int n6 = this.face.getCharIndex(c) == 0 && c != '\u0000' ? 1 : 0;
        if (n6 != 0) {
            return null;
        }
        if (!this.loadChar(c, this.getLoadingFlags((FreeTypeFontParameter)object))) {
            return null;
        }
        FreeType.GlyphSlot glyphSlot = this.face.getGlyph();
        Object object5 = glyphSlot.getGlyph();
        try {
            n6 = ((FreeTypeFontParameter)object).mono ? FreeType.FT_RENDER_MODE_MONO : FreeType.FT_RENDER_MODE_NORMAL;
            ((FreeType.Glyph)object5).toBitmap(n6);
        }
        catch (GdxRuntimeException gdxRuntimeException) {
            ((FreeType.Glyph)object5).dispose();
            object = Gdx.app;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Couldn't render char: ");
            stringBuilder.append(c);
            object.log("FreeTypeFontGenerator", stringBuilder.toString());
            return null;
        }
        FreeType.Bitmap bitmap = ((FreeType.Glyph)object5).getBitmap();
        Object object6 = bitmap.getPixmap(Pixmap.Format.RGBA8888, ((FreeTypeFontParameter)object).color, ((FreeTypeFontParameter)object).gamma);
        if (bitmap.getWidth() != 0 && bitmap.getRows() != 0) {
            object4 = object5;
            object3 = object6;
            if (((FreeTypeFontParameter)object).borderWidth > 0.0f) {
                n5 = ((FreeType.Glyph)object5).getTop();
                n4 = ((FreeType.Glyph)object5).getLeft();
                object4 = glyphSlot.getGlyph();
                ((FreeType.Glyph)object4).strokeBorder((FreeType.Stroker)object2, false);
                n6 = ((FreeTypeFontParameter)object).mono ? FreeType.FT_RENDER_MODE_MONO : FreeType.FT_RENDER_MODE_NORMAL;
                ((FreeType.Glyph)object4).toBitmap(n6);
                n3 = ((FreeType.Glyph)object4).getLeft();
                n2 = -(n5 - ((FreeType.Glyph)object4).getTop());
                object3 = ((FreeType.Glyph)object4).getBitmap().getPixmap(Pixmap.Format.RGBA8888, ((FreeTypeFontParameter)object).borderColor, ((FreeTypeFontParameter)object).borderGamma);
                n5 = ((FreeTypeFontParameter)object).renderCount;
                for (n6 = 0; n6 < n5; ++n6) {
                    ((Pixmap)object3).drawPixmap((Pixmap)object6, n4 - n3, n2);
                }
                ((Pixmap)object6).dispose();
                ((FreeType.Glyph)object5).dispose();
            }
            if (((FreeTypeFontParameter)object).shadowOffsetX == 0 && ((FreeTypeFontParameter)object).shadowOffsetY == 0) {
                if (((FreeTypeFontParameter)object).borderWidth == 0.0f) {
                    n4 = ((FreeTypeFontParameter)object).renderCount;
                    for (n6 = 0; n6 < n4 - 1; ++n6) {
                        ((Pixmap)object3).drawPixmap((Pixmap)object3, 0, 0);
                    }
                }
            } else {
                n3 = ((Pixmap)object3).getWidth();
                n6 = ((Pixmap)object3).getHeight();
                int n7 = Math.max(((FreeTypeFontParameter)object).shadowOffsetX, 0);
                n = Math.max(((FreeTypeFontParameter)object).shadowOffsetY, 0);
                int n8 = Math.abs(((FreeTypeFontParameter)object).shadowOffsetX) + n3;
                object5 = new Pixmap(n8, Math.abs(((FreeTypeFontParameter)object).shadowOffsetY) + n6, ((Pixmap)object3).getFormat());
                object2 = ((FreeTypeFontParameter)object).shadowColor;
                float f2 = ((Color)object2).a;
                if (f2 != 0.0f) {
                    n2 = (byte)(((Color)object2).r * 255.0f);
                    byte by = (byte)(((Color)object2).g * 255.0f);
                    byte by2 = (byte)(((Color)object2).b * 255.0f);
                    object2 = ((Pixmap)object3).getPixels();
                    object6 = ((Pixmap)object5).getPixels();
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n9 = n2;
                        for (n5 = 0; n5 < n3; ++n5) {
                            byte by3 = ((ByteBuffer)object2).get((n3 * n4 + n5) * 4 + 3);
                            if (by3 != 0) {
                                n2 = ((n4 + n) * n8 + n7 + n5) * 4;
                                ((ByteBuffer)object6).put(n2, (byte)n9);
                                ((ByteBuffer)object6).put(n2 + 1, by);
                                ((ByteBuffer)object6).put(n2 + 2, by2);
                                ((ByteBuffer)object6).put(n2 + 3, (byte)((float)(by3 & 0xFF) * f2));
                            }
                            n9 = n2 = n9;
                        }
                        n2 = n9;
                    }
                }
                n4 = ((FreeTypeFontParameter)object).renderCount;
                for (n6 = 0; n6 < n4; ++n6) {
                    ((Pixmap)object5).drawPixmap((Pixmap)object3, Math.max(-((FreeTypeFontParameter)object).shadowOffsetX, 0), Math.max(-((FreeTypeFontParameter)object).shadowOffsetY, 0));
                }
                ((Pixmap)object3).dispose();
                object3 = object5;
            }
            if (((FreeTypeFontParameter)object).padTop <= 0 && ((FreeTypeFontParameter)object).padLeft <= 0 && ((FreeTypeFontParameter)object).padBottom <= 0 && ((FreeTypeFontParameter)object).padRight <= 0) {
                object2 = object4;
                object4 = object3;
            } else {
                object5 = new Pixmap(((Pixmap)object3).getWidth() + ((FreeTypeFontParameter)object).padLeft + ((FreeTypeFontParameter)object).padRight, ((Pixmap)object3).getHeight() + ((FreeTypeFontParameter)object).padTop + ((FreeTypeFontParameter)object).padBottom, ((Pixmap)object3).getFormat());
                ((Pixmap)object5).setBlending(Pixmap.Blending.None);
                ((Pixmap)object5).drawPixmap((Pixmap)object3, ((FreeTypeFontParameter)object).padLeft, ((FreeTypeFontParameter)object).padTop);
                ((Pixmap)object3).dispose();
                object2 = object4;
                object4 = object5;
            }
        } else {
            object4 = object6;
            object2 = object5;
        }
        object5 = glyphSlot.getMetrics();
        object3 = new BitmapFont.Glyph();
        ((BitmapFont.Glyph)object3).id = c;
        ((BitmapFont.Glyph)object3).width = ((Pixmap)object4).getWidth();
        ((BitmapFont.Glyph)object3).height = ((Pixmap)object4).getHeight();
        ((BitmapFont.Glyph)object3).xoffset = ((FreeType.Glyph)object2).getLeft();
        ((BitmapFont.Glyph)object3).yoffset = ((FreeTypeFontParameter)object).flip ? -((FreeType.Glyph)object2).getTop() + (int)f : -(((BitmapFont.Glyph)object3).height - ((FreeType.Glyph)object2).getTop()) - (int)f;
        ((BitmapFont.Glyph)object3).xadvance = FreeType.toInt(((FreeType.GlyphMetrics)object5).getHoriAdvance()) + (int)((FreeTypeFontParameter)object).borderWidth + ((FreeTypeFontParameter)object).spaceX;
        if (this.bitmapped) {
            ((Pixmap)object4).setColor(Color.CLEAR);
            ((Pixmap)object4).fill();
            object5 = bitmap.getBuffer();
            n5 = Color.WHITE.toIntBits();
            n2 = Color.CLEAR.toIntBits();
            for (n6 = 0; n6 < ((BitmapFont.Glyph)object3).height; ++n6) {
                n = bitmap.getPitch();
                for (n4 = 0; n4 < ((BitmapFont.Glyph)object3).width + ((BitmapFont.Glyph)object3).xoffset; ++n4) {
                    n3 = (((ByteBuffer)object5).get(n4 / 8 + n * n6) >>> 7 - n4 % 8 & 1) == 1 ? n5 : n2;
                    ((Pixmap)object4).drawPixel(n4, n6, n3);
                }
            }
        }
        object5 = pixmapPacker.pack((Pixmap)object4);
        ((BitmapFont.Glyph)object3).page = pixmapPacker.getPages().size - 1;
        ((BitmapFont.Glyph)object3).srcX = (int)((Rectangle)object5).x;
        ((BitmapFont.Glyph)object3).srcY = (int)((Rectangle)object5).y;
        if (((FreeTypeFontParameter)object).incremental && freeTypeBitmapFontData.regions != null && freeTypeBitmapFontData.regions.size <= ((BitmapFont.Glyph)object3).page) {
            pixmapPacker.updateTextureRegions(freeTypeBitmapFontData.regions, ((FreeTypeFontParameter)object).minFilter, ((FreeTypeFontParameter)object).magFilter, ((FreeTypeFontParameter)object).genMipMaps);
        }
        ((Pixmap)object4).dispose();
        ((FreeType.Glyph)object2).dispose();
        return object3;
    }

    @Override
    public void dispose() {
        this.face.dispose();
        this.library.dispose();
    }

    public FreeTypeBitmapFontData generateData(int n) {
        FreeTypeFontParameter freeTypeFontParameter = new FreeTypeFontParameter();
        freeTypeFontParameter.size = n;
        return this.generateData(freeTypeFontParameter);
    }

    public FreeTypeBitmapFontData generateData(FreeTypeFontParameter freeTypeFontParameter) {
        return this.generateData(freeTypeFontParameter, new FreeTypeBitmapFontData());
    }

    public FreeTypeBitmapFontData generateData(FreeTypeFontParameter object, FreeTypeBitmapFontData freeTypeBitmapFontData) {
        int n;
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append(this.name);
        ((StringBuilder)object2).append("-");
        ((StringBuilder)object2).append(((FreeTypeFontParameter)object).size);
        freeTypeBitmapFontData.name = ((StringBuilder)object2).toString();
        FreeTypeFontParameter freeTypeFontParameter = object;
        if (object == null) {
            freeTypeFontParameter = new FreeTypeFontParameter();
        }
        char[] cArray = freeTypeFontParameter.characters.toCharArray();
        int n2 = cArray.length;
        boolean bl = freeTypeFontParameter.incremental;
        int n3 = this.getLoadingFlags(freeTypeFontParameter);
        this.setPixelSizes(0, freeTypeFontParameter.size);
        object = this.face.getSize().getMetrics();
        freeTypeBitmapFontData.flipped = freeTypeFontParameter.flip;
        freeTypeBitmapFontData.ascent = FreeType.toInt(((FreeType.SizeMetrics)object).getAscender());
        freeTypeBitmapFontData.descent = FreeType.toInt(((FreeType.SizeMetrics)object).getDescender());
        freeTypeBitmapFontData.lineHeight = FreeType.toInt(((FreeType.SizeMetrics)object).getHeight());
        float f = freeTypeBitmapFontData.ascent;
        if (this.bitmapped && freeTypeBitmapFontData.lineHeight == 0.0f) {
            for (n = 32; n < this.face.getNumGlyphs() + 32; ++n) {
                if (!this.loadChar(n, n3)) continue;
                float f2 = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
                if (!(f2 > freeTypeBitmapFontData.lineHeight)) {
                    f2 = freeTypeBitmapFontData.lineHeight;
                }
                freeTypeBitmapFontData.lineHeight = f2;
            }
        }
        freeTypeBitmapFontData.lineHeight += (float)freeTypeFontParameter.spaceY;
        freeTypeBitmapFontData.spaceXadvance = !this.loadChar(32, n3) && !this.loadChar(108, n3) ? (float)this.face.getMaxAdvanceWidth() : (float)FreeType.toInt(this.face.getGlyph().getMetrics().getHoriAdvance());
        object = freeTypeBitmapFontData.xChars;
        int n4 = ((Object)object).length;
        for (n = 0; n < n4; ++n) {
            if (!this.loadChar((int)object[n], n3)) {
                continue;
            }
            freeTypeBitmapFontData.xHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight());
            break;
        }
        if (freeTypeBitmapFontData.xHeight != 0.0f) {
            char c;
            Object object3;
            Object object4;
            int n5;
            object = freeTypeBitmapFontData.capChars;
            n4 = ((Object)object).length;
            for (n = 0; n < n4; ++n) {
                if (!this.loadChar((int)object[n], n3)) {
                    continue;
                }
                freeTypeBitmapFontData.capHeight = FreeType.toInt(this.face.getGlyph().getMetrics().getHeight()) + Math.abs(freeTypeFontParameter.shadowOffsetY);
                break;
            }
            if (!this.bitmapped && freeTypeBitmapFontData.capHeight == 1.0f) {
                throw new GdxRuntimeException("No cap character found in font");
            }
            freeTypeBitmapFontData.ascent -= freeTypeBitmapFontData.capHeight;
            freeTypeBitmapFontData.down = -freeTypeBitmapFontData.lineHeight;
            if (freeTypeFontParameter.flip) {
                freeTypeBitmapFontData.ascent = -freeTypeBitmapFontData.ascent;
                freeTypeBitmapFontData.down = -freeTypeBitmapFontData.down;
            }
            if ((object = freeTypeFontParameter.packer) == null) {
                if (bl) {
                    n = maxTextureSize;
                    object = new PixmapPacker.GuillotineStrategy();
                } else {
                    n = (int)Math.ceil(freeTypeBitmapFontData.lineHeight);
                    n4 = MathUtils.nextPowerOfTwo((int)Math.sqrt(n * n * n2));
                    n5 = maxTextureSize;
                    n = n4;
                    if (n5 > 0) {
                        n = Math.min(n4, n5);
                    }
                    object = new PixmapPacker.SkylineStrategy();
                }
                object = new PixmapPacker(n, n, Pixmap.Format.RGBA8888, 1, false, (PixmapPacker.PackStrategy)object);
                ((PixmapPacker)object).setTransparentColor(freeTypeFontParameter.color);
                ((PixmapPacker)object).getTransparentColor().a = 0.0f;
                if (freeTypeFontParameter.borderWidth > 0.0f) {
                    ((PixmapPacker)object).setTransparentColor(freeTypeFontParameter.borderColor);
                    ((PixmapPacker)object).getTransparentColor().a = 0.0f;
                }
                n4 = 1;
            } else {
                n4 = 0;
            }
            if (bl) {
                freeTypeBitmapFontData.glyphs = new Array(n2 + 32);
            }
            object2 = null;
            if (freeTypeFontParameter.borderWidth > 0.0f) {
                object2 = this.library.createStroker();
                object4 = (int)(freeTypeFontParameter.borderWidth * 64.0f);
                n = freeTypeFontParameter.borderStraight ? FreeType.FT_STROKER_LINECAP_BUTT : FreeType.FT_STROKER_LINECAP_ROUND;
                n5 = freeTypeFontParameter.borderStraight ? FreeType.FT_STROKER_LINEJOIN_MITER_FIXED : FreeType.FT_STROKER_LINEJOIN_ROUND;
                ((FreeType.Stroker)object2).set((int)object4, n, n5, 0);
            }
            Object object5 = object2;
            Object object6 = new int[n2];
            object2 = object;
            object = object6;
            for (n = 0; n < n2; ++n) {
                object4 = cArray[n];
                n5 = this.loadChar((int)object4, n3) ? FreeType.toInt(this.face.getGlyph().getMetrics().getHeight()) : 0;
                object[n] = n5;
                if (object4 != 0 || (object6 = (Object)this.createGlyph('\u0000', freeTypeBitmapFontData, freeTypeFontParameter, (FreeType.Stroker)object5, f, (PixmapPacker)object2)) == null || object6.width == 0 || object6.height == 0) continue;
                freeTypeBitmapFontData.setGlyph(0, (BitmapFont.Glyph)object6);
                freeTypeBitmapFontData.missingGlyph = object6;
                if (!bl) continue;
                freeTypeBitmapFontData.glyphs.add((BitmapFont.Glyph)object6);
            }
            n5 = ((Object)object).length;
            while (n5 > 0) {
                object3 = object[0];
                n3 = 0;
                for (n = 1; n < n5; ++n) {
                    Object object7 = object[n];
                    object4 = object3;
                    if (object7 > object3) {
                        n3 = n;
                        object4 = object7;
                    }
                    object3 = object4;
                }
                c = cArray[n3];
                if (freeTypeBitmapFontData.getGlyph(c) == null && (object6 = (Object)this.createGlyph(c, freeTypeBitmapFontData, freeTypeFontParameter, (FreeType.Stroker)object5, f, (PixmapPacker)object2)) != null) {
                    freeTypeBitmapFontData.setGlyph(c, (BitmapFont.Glyph)object6);
                    if (bl) {
                        freeTypeBitmapFontData.glyphs.add((BitmapFont.Glyph)object6);
                    }
                }
                object[n3] = object[--n5];
                n = cArray[n3];
                cArray[n3] = cArray[n5];
                cArray[n5] = (char)n;
            }
            if (object5 != null && !bl) {
                ((FreeType.Stroker)object5).dispose();
            }
            if (bl) {
                freeTypeBitmapFontData.generator = this;
                freeTypeBitmapFontData.parameter = freeTypeFontParameter;
                freeTypeBitmapFontData.stroker = object5;
                freeTypeBitmapFontData.packer = object2;
            }
            freeTypeFontParameter.kerning &= this.face.hasKerning();
            if (freeTypeFontParameter.kerning) {
                for (n = 0; n < n2; ++n) {
                    char c2 = cArray[n];
                    object5 = freeTypeBitmapFontData.getGlyph(c2);
                    if (object5 == null) continue;
                    n3 = this.face.getCharIndex(c2);
                    for (n5 = n; n5 < n2; ++n5) {
                        c = cArray[n5];
                        object = freeTypeBitmapFontData.getGlyph(c);
                        if (object == null) continue;
                        object4 = this.face.getCharIndex(c);
                        object3 = this.face.getKerning(n3, (int)object4, 0);
                        if (object3 != false) {
                            ((BitmapFont.Glyph)object5).setKerning(c, FreeType.toInt((int)object3));
                        }
                        if ((object4 = this.face.getKerning((int)object4, n3, 0)) == 0) continue;
                        ((BitmapFont.Glyph)object).setKerning(c2, FreeType.toInt(object4));
                    }
                }
            }
            if (n4 != 0) {
                freeTypeBitmapFontData.regions = new Array();
                ((PixmapPacker)object2).updateTextureRegions(freeTypeBitmapFontData.regions, freeTypeFontParameter.minFilter, freeTypeFontParameter.magFilter, freeTypeFontParameter.genMipMaps);
            }
            object = object2 = freeTypeBitmapFontData.getGlyph(' ');
            if (object2 == null) {
                object = new BitmapFont.Glyph();
                ((BitmapFont.Glyph)object).xadvance = (int)freeTypeBitmapFontData.spaceXadvance + freeTypeFontParameter.spaceX;
                ((BitmapFont.Glyph)object).id = 32;
                freeTypeBitmapFontData.setGlyph(32, (BitmapFont.Glyph)object);
            }
            if (((BitmapFont.Glyph)object).width == 0) {
                ((BitmapFont.Glyph)object).width = (int)((float)((BitmapFont.Glyph)object).xadvance + freeTypeBitmapFontData.padRight);
            }
            return freeTypeBitmapFontData;
        }
        object = new GdxRuntimeException("No x-height character found in font");
        throw object;
    }

    public BitmapFont generateFont(FreeTypeFontParameter freeTypeFontParameter) {
        return this.generateFont(freeTypeFontParameter, new FreeTypeBitmapFontData());
    }

    public BitmapFont generateFont(FreeTypeFontParameter freeTypeFontParameter, FreeTypeBitmapFontData disposable) {
        Array<TextureRegion> array = ((FreeTypeBitmapFontData)disposable).regions;
        boolean bl = false;
        boolean bl2 = array == null && freeTypeFontParameter.packer != null;
        if (bl2) {
            ((FreeTypeBitmapFontData)disposable).regions = new Array();
        }
        this.generateData(freeTypeFontParameter, (FreeTypeBitmapFontData)disposable);
        if (bl2) {
            freeTypeFontParameter.packer.updateTextureRegions(((FreeTypeBitmapFontData)disposable).regions, freeTypeFontParameter.minFilter, freeTypeFontParameter.magFilter, freeTypeFontParameter.genMipMaps);
        }
        if (!((FreeTypeBitmapFontData)disposable).regions.isEmpty()) {
            disposable = new BitmapFont((BitmapFont.BitmapFontData)((Object)disposable), ((FreeTypeBitmapFontData)disposable).regions, true);
            if (freeTypeFontParameter.packer == null) {
                bl = true;
            }
            ((BitmapFont)disposable).setOwnsTexture(bl);
            return disposable;
        }
        throw new GdxRuntimeException("Unable to create a font with no texture regions.");
    }

    public GlyphAndBitmap generateGlyphAndBitmap(int n, int n2, boolean bl) {
        this.setPixelSizes(0, n2);
        int n3 = FreeType.toInt(this.face.getSize().getMetrics().getAscender());
        n2 = this.face.getCharIndex(n);
        FreeType.Bitmap bitmap = null;
        if (n2 == 0) {
            return null;
        }
        if (this.loadChar(n)) {
            Object object = this.face.getGlyph();
            if (this.bitmapped) {
                bitmap = ((FreeType.GlyphSlot)object).getBitmap();
            } else if (((FreeType.GlyphSlot)object).renderGlyph(FreeType.FT_RENDER_MODE_NORMAL)) {
                bitmap = ((FreeType.GlyphSlot)object).getBitmap();
            }
            FreeType.GlyphMetrics glyphMetrics = ((FreeType.GlyphSlot)object).getMetrics();
            BitmapFont.Glyph glyph = new BitmapFont.Glyph();
            if (bitmap != null) {
                glyph.width = bitmap.getWidth();
                glyph.height = bitmap.getRows();
            } else {
                glyph.width = 0;
                glyph.height = 0;
            }
            glyph.xoffset = ((FreeType.GlyphSlot)object).getBitmapLeft();
            n2 = bl ? -((FreeType.GlyphSlot)object).getBitmapTop() + n3 : -(glyph.height - ((FreeType.GlyphSlot)object).getBitmapTop()) - n3;
            glyph.yoffset = n2;
            glyph.xadvance = FreeType.toInt(glyphMetrics.getHoriAdvance());
            glyph.srcX = 0;
            glyph.srcY = 0;
            glyph.id = n;
            object = new GlyphAndBitmap();
            ((GlyphAndBitmap)object).glyph = glyph;
            ((GlyphAndBitmap)object).bitmap = bitmap;
            return object;
        }
        throw new GdxRuntimeException("Unable to load character!");
    }

    public int scaleForPixelHeight(int n) {
        this.setPixelSizes(0, n);
        FreeType.SizeMetrics sizeMetrics = this.face.getSize().getMetrics();
        return n * n / (FreeType.toInt(sizeMetrics.getAscender()) - FreeType.toInt(sizeMetrics.getDescender()));
    }

    public int scaleForPixelWidth(int n, int n2) {
        FreeType.SizeMetrics sizeMetrics = this.face.getSize().getMetrics();
        int n3 = FreeType.toInt(sizeMetrics.getMaxAdvance());
        n = (FreeType.toInt(sizeMetrics.getAscender()) - FreeType.toInt(sizeMetrics.getDescender())) * n / (n3 * n2);
        this.setPixelSizes(0, n);
        return n;
    }

    public int scaleToFitSquare(int n, int n2, int n3) {
        return Math.min(this.scaleForPixelHeight(n2), this.scaleForPixelWidth(n, n3));
    }

    void setPixelSizes(int n, int n2) {
        this.pixelWidth = n;
        this.pixelHeight = n2;
        if (!this.bitmapped && !this.face.setPixelSizes(n, n2)) {
            throw new GdxRuntimeException("Couldn't set size for font");
        }
    }

    public String toString() {
        return this.name;
    }

    public static class FreeTypeBitmapFontData
    extends BitmapFont.BitmapFontData
    implements Disposable {
        private boolean dirty;
        FreeTypeFontGenerator generator;
        Array<BitmapFont.Glyph> glyphs;
        PixmapPacker packer;
        FreeTypeFontParameter parameter;
        public Array<TextureRegion> regions;
        FreeType.Stroker stroker;

        @Override
        public void dispose() {
            Disposable disposable = this.stroker;
            if (disposable != null) {
                ((FreeType.Stroker)disposable).dispose();
            }
            if ((disposable = this.packer) != null) {
                ((PixmapPacker)disposable).dispose();
            }
        }

        @Override
        public BitmapFont.Glyph getGlyph(char c) {
            BitmapFont.Glyph glyph;
            BitmapFont.Glyph glyph2 = glyph = super.getGlyph(c);
            if (glyph == null) {
                Disposable disposable = this.generator;
                glyph2 = glyph;
                if (disposable != null) {
                    ((FreeTypeFontGenerator)disposable).setPixelSizes(0, this.parameter.size);
                    float f = this.flipped ? -this.ascent : this.ascent;
                    f = (f + this.capHeight) / this.scaleY;
                    glyph = this.generator.createGlyph(c, this, this.parameter, this.stroker, f, this.packer);
                    if (glyph == null) {
                        return this.missingGlyph;
                    }
                    this.setGlyphRegion(glyph, this.regions.get(glyph.page));
                    this.setGlyph(c, glyph);
                    this.glyphs.add(glyph);
                    this.dirty = true;
                    disposable = this.generator.face;
                    glyph2 = glyph;
                    if (this.parameter.kerning) {
                        int n = ((FreeType.Face)disposable).getCharIndex(c);
                        int n2 = this.glyphs.size;
                        int n3 = 0;
                        while (true) {
                            glyph2 = glyph;
                            if (n3 >= n2) break;
                            glyph2 = this.glyphs.get(n3);
                            int n4 = ((FreeType.Face)disposable).getCharIndex(glyph2.id);
                            int n5 = ((FreeType.Face)disposable).getKerning(n, n4, 0);
                            if (n5 != 0) {
                                glyph.setKerning(glyph2.id, FreeType.toInt(n5));
                            }
                            if ((n4 = ((FreeType.Face)disposable).getKerning(n4, n, 0)) != 0) {
                                glyph2.setKerning(c, FreeType.toInt(n4));
                            }
                            ++n3;
                        }
                    }
                }
            }
            return glyph2;
        }

        @Override
        public void getGlyphs(GlyphLayout.GlyphRun glyphRun, CharSequence charSequence, int n, int n2, BitmapFont.Glyph glyph) {
            PixmapPacker pixmapPacker = this.packer;
            if (pixmapPacker != null) {
                pixmapPacker.setPackToTexture(true);
            }
            super.getGlyphs(glyphRun, charSequence, n, n2, glyph);
            if (this.dirty) {
                this.dirty = false;
                this.packer.updateTextureRegions(this.regions, this.parameter.minFilter, this.parameter.magFilter, this.parameter.genMipMaps);
            }
        }
    }

    public static class FreeTypeFontParameter {
        public Color borderColor;
        public float borderGamma = 1.8f;
        public boolean borderStraight = false;
        public float borderWidth = 0.0f;
        public String characters = "\u0000ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890\"!`?'.,;:()[]{}<>|/@\\^$\u20ac-%+=#_&~*\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009d\u009e\u009f\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff";
        public Color color;
        public boolean flip = false;
        public float gamma = 1.8f;
        public boolean genMipMaps = false;
        public Hinting hinting = Hinting.AutoMedium;
        public boolean incremental;
        public boolean kerning = true;
        public Texture.TextureFilter magFilter;
        public Texture.TextureFilter minFilter;
        public boolean mono;
        public PixmapPacker packer = null;
        public int padBottom;
        public int padLeft;
        public int padRight;
        public int padTop;
        public int renderCount = 2;
        public Color shadowColor;
        public int shadowOffsetX = 0;
        public int shadowOffsetY = 0;
        public int size = 16;
        public int spaceX;
        public int spaceY;

        public FreeTypeFontParameter() {
            this.color = Color.WHITE;
            this.borderColor = Color.BLACK;
            this.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.75f);
            this.minFilter = Texture.TextureFilter.Nearest;
            this.magFilter = Texture.TextureFilter.Nearest;
        }
    }

    public class GlyphAndBitmap {
        public FreeType.Bitmap bitmap;
        public BitmapFont.Glyph glyph;
    }

    public static enum Hinting {
        None,
        Slight,
        Medium,
        Full,
        AutoSlight,
        AutoMedium,
        AutoFull;

    }
}

