/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;

public class SpriteBatch
implements Batch {
    @Deprecated
    public static Mesh.VertexDataType defaultVertexDataType = Mesh.VertexDataType.VertexArray;
    private int blendDstFunc = 771;
    private int blendDstFuncAlpha = 771;
    private int blendSrcFunc = 770;
    private int blendSrcFuncAlpha = 770;
    private boolean blendingDisabled = false;
    private final Color color;
    float colorPacked;
    private final Matrix4 combinedMatrix;
    private ShaderProgram customShader = null;
    boolean drawing = false;
    int idx = 0;
    float invTexHeight = 0.0f;
    float invTexWidth = 0.0f;
    Texture lastTexture = null;
    public int maxSpritesInBatch = 0;
    private Mesh mesh;
    private boolean ownsShader;
    private final Matrix4 projectionMatrix;
    public int renderCalls = 0;
    private final ShaderProgram shader;
    public int totalRenderCalls = 0;
    private final Matrix4 transformMatrix = new Matrix4();
    final float[] vertices;

    public SpriteBatch() {
        this(1000, null);
    }

    public SpriteBatch(int n) {
        this(n, null);
    }

    public SpriteBatch(int n, ShaderProgram object) {
        this.projectionMatrix = new Matrix4();
        this.combinedMatrix = new Matrix4();
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.colorPacked = Color.WHITE_FLOAT_BITS;
        if (n <= 8191) {
            Object object2 = Gdx.gl30 != null ? Mesh.VertexDataType.VertexBufferObjectWithVAO : defaultVertexDataType;
            int n2 = n * 6;
            this.mesh = new Mesh((Mesh.VertexDataType)((Object)object2), false, n * 4, n2, new VertexAttribute[]{new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0")});
            this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            this.vertices = new float[n * 20];
            object2 = new short[n2];
            int n3 = 0;
            n = 0;
            while (n3 < n2) {
                object2[n3] = (Mesh.VertexDataType)((short)n);
                object2[n3 + 1] = (Mesh.VertexDataType)((short)((short)(n + 1)));
                short s = (short)(n + 2);
                object2[n3 + 2] = (Mesh.VertexDataType)((short)s);
                object2[n3 + 3] = (Mesh.VertexDataType)((short)s);
                object2[n3 + 4] = (Mesh.VertexDataType)((short)((short)(n + 3)));
                object2[n3 + 5] = (Mesh.VertexDataType)((short)n);
                n3 += 6;
                n = (short)(n + 4);
            }
            this.mesh.setIndices((short[])object2);
            if (object == null) {
                this.shader = SpriteBatch.createDefaultShader();
                this.ownsShader = true;
            } else {
                this.shader = object;
            }
            return;
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Can't have more than 8191 sprites per batch: ");
        ((StringBuilder)object).append(n);
        object = new IllegalArgumentException(((StringBuilder)object).toString());
        throw object;
    }

    public static ShaderProgram createDefaultShader() {
        ShaderProgram shaderProgram = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n", "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}");
        if (shaderProgram.isCompiled()) {
            return shaderProgram;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error compiling shader: ");
        stringBuilder.append(shaderProgram.getLog());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        ShaderProgram shaderProgram = this.customShader;
        if (shaderProgram != null) {
            shaderProgram.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.customShader.setUniformi("u_texture", 0);
        } else {
            this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.shader.setUniformi("u_texture", 0);
        }
    }

    @Override
    public void begin() {
        if (!this.drawing) {
            this.renderCalls = 0;
            Gdx.gl.glDepthMask(false);
            ShaderProgram shaderProgram = this.customShader;
            if (shaderProgram != null) {
                shaderProgram.begin();
            } else {
                this.shader.begin();
            }
            this.setupMatrices();
            this.drawing = true;
            return;
        }
        throw new IllegalStateException("SpriteBatch.end must be called before begin.");
    }

    @Override
    public void disableBlending() {
        if (this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = true;
    }

    @Override
    public void dispose() {
        ShaderProgram shaderProgram;
        this.mesh.dispose();
        if (this.ownsShader && (shaderProgram = this.shader) != null) {
            shaderProgram.dispose();
        }
    }

    @Override
    public void draw(Texture texture, float f, float f2) {
        this.draw(texture, f, f2, (float)texture.getWidth(), (float)texture.getHeight());
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            f3 += f;
            f4 += f2;
            float f5 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f5;
            fArray[n + 3] = 0.0f;
            fArray[n + 4] = 1.0f;
            fArray[n + 5] = f;
            fArray[n + 6] = f4;
            fArray[n + 7] = f5;
            fArray[n + 8] = 0.0f;
            fArray[n + 9] = 0.0f;
            fArray[n + 10] = f3;
            fArray[n + 11] = f4;
            fArray[n + 12] = f5;
            fArray[n + 13] = 1.0f;
            fArray[n + 14] = 0.0f;
            fArray[n + 15] = f3;
            fArray[n + 16] = f2;
            fArray[n + 17] = f5;
            fArray[n + 18] = 1.0f;
            fArray[n + 19] = 1.0f;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            f3 += f;
            float f9 = f4 + f2;
            f4 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f4;
            fArray[n + 3] = f5;
            fArray[n + 4] = f6;
            fArray[n + 5] = f;
            fArray[n + 6] = f9;
            fArray[n + 7] = f4;
            fArray[n + 8] = f5;
            fArray[n + 9] = f8;
            fArray[n + 10] = f3;
            fArray[n + 11] = f9;
            fArray[n + 12] = f4;
            fArray[n + 13] = f7;
            fArray[n + 14] = f8;
            fArray[n + 15] = f3;
            fArray[n + 16] = f2;
            fArray[n + 17] = f4;
            fArray[n + 18] = f7;
            fArray[n + 19] = f6;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        block10: {
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            block12: {
                block11: {
                    if (!this.drawing) break block10;
                    float[] fArray = this.vertices;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.idx == fArray.length) {
                        this.flush();
                    }
                    f14 = f + f3;
                    f13 = f2 + f4;
                    f12 = -f3;
                    f11 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block11;
                    f = f5;
                    f2 = f6;
                    f4 = f12;
                    f3 = f11;
                    if (f8 == 1.0f) break block12;
                }
                f4 = f12 * f7;
                f3 = f11 * f8;
                f = f5 * f7;
                f2 = f6 * f8;
            }
            if (f9 != 0.0f) {
                f8 = MathUtils.cosDeg(f9);
                f7 = MathUtils.sinDeg(f9);
                f5 = f8 * f4;
                f6 = f5 - f7 * f3;
                f9 = f4 * f7;
                f3 = f3 * f8 + f9;
                f4 = f7 * f2;
                f11 = f2 * f8;
                f9 += f11;
                f2 = f8 * f - f4;
                f11 += f7 * f;
                f7 = f2 - (f5 -= f4) + f6;
                f = f2;
                f8 = f11;
                f2 = f9;
                f4 = f6;
                f9 = f11 - (f9 - f3);
                f6 = f7;
                f7 = f9;
            } else {
                f6 = f;
                f8 = f2;
                f5 = f4;
                f7 = f3;
            }
            f9 = n;
            f12 = this.invTexWidth;
            f11 = f9 * f12;
            f9 = n2 + n4;
            float f15 = this.invTexHeight;
            f9 *= f15;
            f12 = (float)(n + n3) * f12;
            f15 = (float)n2 * f15;
            if (!bl) {
                f10 = f12;
                f12 = f11;
                f11 = f10;
            }
            if (!bl2) {
                f10 = f9;
                f9 = f15;
                f15 = f10;
            }
            f10 = this.colorPacked;
            n = this.idx;
            fArray[n] = f4 + f14;
            fArray[n + 1] = f3 + f13;
            fArray[n + 2] = f10;
            fArray[n + 3] = f12;
            fArray[n + 4] = f15;
            fArray[n + 5] = f5 + f14;
            fArray[n + 6] = f2 + f13;
            fArray[n + 7] = f10;
            fArray[n + 8] = f12;
            fArray[n + 9] = f9;
            fArray[n + 10] = f + f14;
            fArray[n + 11] = f8 + f13;
            fArray[n + 12] = f10;
            fArray[n + 13] = f11;
            fArray[n + 14] = f9;
            fArray[n + 15] = f6 + f14;
            fArray[n + 16] = f7 + f13;
            fArray[n + 17] = f10;
            fArray[n + 18] = f11;
            fArray[n + 19] = f15;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            float f5 = n;
            float f6 = this.invTexWidth;
            float f7 = f5 * f6;
            f5 = n4 + n2;
            float f8 = this.invTexHeight;
            f5 *= f8;
            f6 = (float)(n + n3) * f6;
            f8 = (float)n2 * f8;
            float f9 = f3 + f;
            float f10 = f4 + f2;
            f4 = f7;
            f3 = f6;
            if (bl) {
                f3 = f7;
                f4 = f6;
            }
            if (!bl2) {
                f7 = f8;
                f8 = f5;
                f5 = f7;
            }
            f7 = this.colorPacked;
            n = this.idx;
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f7;
            fArray[n + 3] = f4;
            fArray[n + 4] = f8;
            fArray[n + 5] = f;
            fArray[n + 6] = f10;
            fArray[n + 7] = f7;
            fArray[n + 8] = f4;
            fArray[n + 9] = f5;
            fArray[n + 10] = f9;
            fArray[n + 11] = f10;
            fArray[n + 12] = f7;
            fArray[n + 13] = f3;
            fArray[n + 14] = f5;
            fArray[n + 15] = f9;
            fArray[n + 16] = f2;
            fArray[n + 17] = f7;
            fArray[n + 18] = f3;
            fArray[n + 19] = f8;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture texture, float f, float f2, int n, int n2, int n3, int n4) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            float f3 = n;
            float f4 = this.invTexWidth;
            f3 *= f4;
            float f5 = n2 + n4;
            float f6 = this.invTexHeight;
            f5 *= f6;
            f4 = (float)(n + n3) * f4;
            float f7 = (float)n2 * f6;
            f6 = (float)n3 + f;
            float f8 = (float)n4 + f2;
            float f9 = this.colorPacked;
            n = this.idx;
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f9;
            fArray[n + 3] = f3;
            fArray[n + 4] = f5;
            fArray[n + 5] = f;
            fArray[n + 6] = f8;
            fArray[n + 7] = f9;
            fArray[n + 8] = f3;
            fArray[n + 9] = f7;
            fArray[n + 10] = f6;
            fArray[n + 11] = f8;
            fArray[n + 12] = f9;
            fArray[n + 13] = f4;
            fArray[n + 14] = f7;
            fArray[n + 15] = f6;
            fArray[n + 16] = f2;
            fArray[n + 17] = f9;
            fArray[n + 18] = f4;
            fArray[n + 19] = f5;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(Texture object, float[] fArray, int n, int n2) {
        block3: {
            int n3;
            int n4;
            int n5;
            block6: {
                block5: {
                    block4: {
                        if (!this.drawing) break block3;
                        n5 = this.vertices.length;
                        if (object == this.lastTexture) break block4;
                        this.switchTexture((Texture)object);
                        break block5;
                    }
                    n3 = n4 = n5 - this.idx;
                    if (n4 != 0) break block6;
                    this.flush();
                }
                n3 = n5;
            }
            n4 = Math.min(n3, n2);
            System.arraycopy(fArray, n, this.vertices, this.idx, n4);
            this.idx += n4;
            n3 = n;
            n = n4;
            while ((n2 -= n) > 0) {
                this.flush();
                n = Math.min(n5, n2);
                System.arraycopy(fArray, n3 += n, this.vertices, 0, n);
                this.idx += n;
            }
            return;
        }
        object = new IllegalStateException("SpriteBatch.begin must be called before draw.");
        throw object;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2) {
        this.draw(textureRegion, f, f2, (float)textureRegion.getRegionWidth(), (float)textureRegion.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            Texture texture = textureRegion.texture;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            f3 += f;
            float f5 = f4 + f2;
            float f6 = textureRegion.u;
            f4 = textureRegion.v2;
            float f7 = textureRegion.u2;
            float f8 = textureRegion.v;
            float f9 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f;
            fArray[n + 1] = f2;
            fArray[n + 2] = f9;
            fArray[n + 3] = f6;
            fArray[n + 4] = f4;
            fArray[n + 5] = f;
            fArray[n + 6] = f5;
            fArray[n + 7] = f9;
            fArray[n + 8] = f6;
            fArray[n + 9] = f8;
            fArray[n + 10] = f3;
            fArray[n + 11] = f5;
            fArray[n + 12] = f9;
            fArray[n + 13] = f7;
            fArray[n + 14] = f8;
            fArray[n + 15] = f3;
            fArray[n + 16] = f2;
            fArray[n + 17] = f9;
            fArray[n + 18] = f7;
            fArray[n + 19] = f4;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        block8: {
            float f10;
            float f11;
            float f12;
            float f13;
            block10: {
                block9: {
                    if (!this.drawing) break block8;
                    float[] fArray = this.vertices;
                    Texture texture = textureRegion.texture;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.idx == fArray.length) {
                        this.flush();
                    }
                    f13 = f + f3;
                    f12 = f2 + f4;
                    f11 = -f3;
                    f10 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block9;
                    f4 = f11;
                    f3 = f10;
                    f = f5;
                    f2 = f6;
                    if (f8 == 1.0f) break block10;
                }
                f4 = f11 * f7;
                f3 = f10 * f8;
                f = f5 * f7;
                f2 = f6 * f8;
            }
            if (f9 != 0.0f) {
                f5 = MathUtils.cosDeg(f9);
                f6 = MathUtils.sinDeg(f9);
                f10 = f5 * f4;
                f7 = f10 - f6 * f3;
                f8 = f4 * f6;
                f3 = f3 * f5 + f8;
                f9 = f6 * f2;
                f4 = f10 - f9;
                f10 = f2 * f5;
                f2 = f8 + f10;
                f5 = f5 * f - f9;
                f = f10 + f6 * f;
                f8 = f7 + (f5 - f4);
                f6 = f - (f2 - f3);
            } else {
                f5 = f;
                f9 = f2;
                f7 = f4;
                f6 = f3;
                f8 = f;
                f = f9;
            }
            float f14 = textureRegion.u;
            f10 = textureRegion.v2;
            f11 = textureRegion.u2;
            float f15 = textureRegion.v;
            f9 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f7 + f13;
            fArray[n + 1] = f3 + f12;
            fArray[n + 2] = f9;
            fArray[n + 3] = f14;
            fArray[n + 4] = f10;
            fArray[n + 5] = f4 + f13;
            fArray[n + 6] = f2 + f12;
            fArray[n + 7] = f9;
            fArray[n + 8] = f14;
            fArray[n + 9] = f15;
            fArray[n + 10] = f5 + f13;
            fArray[n + 11] = f + f12;
            fArray[n + 12] = f9;
            fArray[n + 13] = f11;
            fArray[n + 14] = f15;
            fArray[n + 15] = f8 + f13;
            fArray[n + 16] = f6 + f12;
            fArray[n + 17] = f9;
            fArray[n + 18] = f11;
            fArray[n + 19] = f10;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
        block10: {
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            float f15;
            float f16;
            float f17;
            float f18;
            block12: {
                block11: {
                    if (!this.drawing) break block10;
                    float[] fArray = this.vertices;
                    Texture texture = textureRegion.texture;
                    if (texture != this.lastTexture) {
                        this.switchTexture(texture);
                    } else if (this.idx == fArray.length) {
                        this.flush();
                    }
                    f18 = f + f3;
                    f17 = f2 + f4;
                    f16 = -f3;
                    f15 = -f4;
                    f5 -= f3;
                    f6 -= f4;
                    if (f7 != 1.0f) break block11;
                    f4 = f5;
                    f = f6;
                    f3 = f16;
                    f2 = f15;
                    if (f8 == 1.0f) break block12;
                }
                f3 = f16 * f7;
                f2 = f15 * f8;
                f4 = f5 * f7;
                f = f6 * f8;
            }
            if (f9 != 0.0f) {
                f7 = MathUtils.cosDeg(f9);
                f9 = MathUtils.sinDeg(f9);
                f6 = f7 * f3;
                f5 = f6 - f9 * f2;
                f8 = f2 * f7 + (f3 *= f9);
                f2 = f9 * f;
                f15 = f3 + (f *= f7);
                f7 = f7 * f4 - f2;
                f4 = f + f9 * f4;
                f9 = f7 - (f6 -= f2) + f5;
                f = f4;
                f2 = f15;
                f3 = f5;
                f5 = f4 - (f15 - f8);
                f4 = f7;
                f7 = f9;
            } else {
                f7 = f4;
                f9 = f;
                f6 = f3;
                f5 = f2;
                f8 = f2;
                f2 = f;
                f = f9;
            }
            if (bl) {
                f16 = textureRegion.u2;
                f14 = textureRegion.v2;
                f13 = textureRegion.u;
                f9 = textureRegion.v2;
                f12 = textureRegion.u;
                f11 = textureRegion.v;
                f10 = textureRegion.u2;
                f15 = textureRegion.v;
            } else {
                f16 = textureRegion.u;
                f14 = textureRegion.v;
                f13 = textureRegion.u2;
                f9 = textureRegion.v;
                f12 = textureRegion.u2;
                f11 = textureRegion.v2;
                f10 = textureRegion.u;
                f15 = textureRegion.v2;
            }
            float f19 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f3 + f18;
            fArray[n + 1] = f8 + f17;
            fArray[n + 2] = f19;
            fArray[n + 3] = f16;
            fArray[n + 4] = f14;
            fArray[n + 5] = f6 + f18;
            fArray[n + 6] = f2 + f17;
            fArray[n + 7] = f19;
            fArray[n + 8] = f13;
            fArray[n + 9] = f9;
            fArray[n + 10] = f4 + f18;
            fArray[n + 11] = f + f17;
            fArray[n + 12] = f19;
            fArray[n + 13] = f12;
            fArray[n + 14] = f11;
            fArray[n + 15] = f7 + f18;
            fArray[n + 16] = f5 + f17;
            fArray[n + 17] = f19;
            fArray[n + 18] = f10;
            fArray[n + 19] = f15;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void draw(TextureRegion textureRegion, float f, float f2, Affine2 affine2) {
        if (this.drawing) {
            float[] fArray = this.vertices;
            Texture texture = textureRegion.texture;
            if (texture != this.lastTexture) {
                this.switchTexture(texture);
            } else if (this.idx == fArray.length) {
                this.flush();
            }
            float f3 = affine2.m02;
            float f4 = affine2.m12;
            float f5 = affine2.m01;
            float f6 = affine2.m02;
            float f7 = affine2.m11;
            float f8 = affine2.m12;
            float f9 = affine2.m00;
            float f10 = affine2.m01;
            float f11 = affine2.m02;
            float f12 = affine2.m10;
            float f13 = affine2.m11;
            float f14 = affine2.m12;
            float f15 = affine2.m00;
            float f16 = affine2.m02;
            float f17 = affine2.m10;
            float f18 = affine2.m12;
            float f19 = textureRegion.u;
            float f20 = textureRegion.v2;
            float f21 = textureRegion.u2;
            float f22 = textureRegion.v;
            float f23 = this.colorPacked;
            int n = this.idx;
            fArray[n] = f3;
            fArray[n + 1] = f4;
            fArray[n + 2] = f23;
            fArray[n + 3] = f19;
            fArray[n + 4] = f20;
            fArray[n + 5] = f5 * f2 + f6;
            fArray[n + 6] = f7 * f2 + f8;
            fArray[n + 7] = f23;
            fArray[n + 8] = f19;
            fArray[n + 9] = f22;
            fArray[n + 10] = f9 * f + f10 * f2 + f11;
            fArray[n + 11] = f12 * f + f13 * f2 + f14;
            fArray[n + 12] = f23;
            fArray[n + 13] = f21;
            fArray[n + 14] = f22;
            fArray[n + 15] = f15 * f + f16;
            fArray[n + 16] = f17 * f + f18;
            fArray[n + 17] = f23;
            fArray[n + 18] = f21;
            fArray[n + 19] = f20;
            this.idx = n + 20;
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
    }

    @Override
    public void enableBlending() {
        if (!this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = false;
    }

    @Override
    public void end() {
        if (this.drawing) {
            if (this.idx > 0) {
                this.flush();
            }
            this.lastTexture = null;
            this.drawing = false;
            Object object = Gdx.gl;
            object.glDepthMask(true);
            if (this.isBlendingEnabled()) {
                object.glDisable(3042);
            }
            if ((object = this.customShader) != null) {
                ((ShaderProgram)object).end();
            } else {
                this.shader.end();
            }
            return;
        }
        throw new IllegalStateException("SpriteBatch.begin must be called before end.");
    }

    @Override
    public void flush() {
        int n = this.idx;
        if (n == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        if ((n /= 20) > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = n;
        }
        n *= 6;
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        mesh.getIndicesBuffer().position(0);
        mesh.getIndicesBuffer().limit(n);
        if (this.blendingDisabled) {
            Gdx.gl.glDisable(3042);
        } else {
            Gdx.gl.glEnable(3042);
            if (this.blendSrcFunc != -1) {
                Gdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
            }
        }
        ShaderProgram shaderProgram = this.customShader;
        if (shaderProgram == null) {
            shaderProgram = this.shader;
        }
        mesh.render(shaderProgram, 4, 0, n);
        this.idx = 0;
    }

    @Override
    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public int getBlendDstFuncAlpha() {
        return this.blendDstFuncAlpha;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    @Override
    public int getBlendSrcFuncAlpha() {
        return this.blendSrcFuncAlpha;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public float getPackedColor() {
        return this.colorPacked;
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public ShaderProgram getShader() {
        ShaderProgram shaderProgram;
        ShaderProgram shaderProgram2 = shaderProgram = this.customShader;
        if (shaderProgram == null) {
            shaderProgram2 = this.shader;
        }
        return shaderProgram2;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public boolean isBlendingEnabled() {
        return this.blendingDisabled ^ true;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }

    @Override
    public void setBlendFunction(int n, int n2) {
        this.setBlendFunctionSeparate(n, n2, n, n2);
    }

    @Override
    public void setBlendFunctionSeparate(int n, int n2, int n3, int n4) {
        if (this.blendSrcFunc == n && this.blendDstFunc == n2 && this.blendSrcFuncAlpha == n3 && this.blendDstFuncAlpha == n4) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n;
        this.blendDstFunc = n2;
        this.blendSrcFuncAlpha = n3;
        this.blendDstFuncAlpha = n4;
    }

    @Override
    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        this.colorPacked = this.color.toFloatBits();
    }

    @Override
    public void setColor(Color color2) {
        this.color.set(color2);
        this.colorPacked = color2.toFloatBits();
    }

    @Override
    public void setPackedColor(float f) {
        Color.abgr8888ToColor(this.color, f);
        this.colorPacked = f;
    }

    @Override
    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    @Override
    public void setShader(ShaderProgram shaderProgram) {
        if (this.drawing) {
            this.flush();
            ShaderProgram shaderProgram2 = this.customShader;
            if (shaderProgram2 != null) {
                shaderProgram2.end();
            } else {
                this.shader.end();
            }
        }
        this.customShader = shaderProgram;
        if (this.drawing) {
            shaderProgram = this.customShader;
            if (shaderProgram != null) {
                shaderProgram.begin();
            } else {
                this.shader.begin();
            }
            this.setupMatrices();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)texture.getWidth();
        this.invTexHeight = 1.0f / (float)texture.getHeight();
    }
}

