/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Matcher;

public class PixmapPackerIO {
    public void save(FileHandle fileHandle, PixmapPacker pixmapPacker) throws IOException {
        this.save(fileHandle, pixmapPacker, new SaveParameters());
    }

    public void save(FileHandle fileHandle, PixmapPacker pixmapPacker, SaveParameters saveParameters) throws IOException {
        Writer writer = fileHandle.writer(false);
        Iterator<PixmapPacker.Page> iterator = pixmapPacker.pages.iterator();
        int n = 0;
        block0: while (iterator.hasNext()) {
            PixmapPacker.Page page = iterator.next();
            if (page.rects.size <= 0) continue;
            Object object = new StringBuilder();
            ((StringBuilder)object).append(fileHandle.nameWithoutExtension());
            ((StringBuilder)object).append("_");
            int n2 = n + 1;
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append(saveParameters.format.getExtension());
            Object object2 = fileHandle.sibling(((StringBuilder)object).toString());
            n = 1.$SwitchMap$com$badlogic$gdx$graphics$g2d$PixmapPackerIO$ImageFormat[saveParameters.format.ordinal()];
            if (n != 1) {
                if (n == 2) {
                    PixmapIO.writePNG((FileHandle)object2, page.image);
                }
            } else {
                PixmapIO.writeCIM((FileHandle)object2, page.image);
            }
            writer.write("\n");
            object = new StringBuilder();
            ((StringBuilder)object).append(((FileHandle)object2).name());
            ((StringBuilder)object).append("\n");
            writer.write(((StringBuilder)object).toString());
            object = new StringBuilder();
            ((StringBuilder)object).append("size: ");
            ((StringBuilder)object).append(page.image.getWidth());
            ((StringBuilder)object).append(",");
            ((StringBuilder)object).append(page.image.getHeight());
            ((StringBuilder)object).append("\n");
            writer.write(((StringBuilder)object).toString());
            object = new StringBuilder();
            ((StringBuilder)object).append("format: ");
            ((StringBuilder)object).append(pixmapPacker.pageFormat.name());
            ((StringBuilder)object).append("\n");
            writer.write(((StringBuilder)object).toString());
            object = new StringBuilder();
            ((StringBuilder)object).append("filter: ");
            ((StringBuilder)object).append(saveParameters.minFilter.name());
            ((StringBuilder)object).append(",");
            ((StringBuilder)object).append(saveParameters.magFilter.name());
            ((StringBuilder)object).append("\n");
            writer.write(((StringBuilder)object).toString());
            writer.write("repeat: none\n");
            Iterator iterator2 = page.rects.keys().iterator();
            while (true) {
                Object object3;
                n = n2;
                if (!iterator2.hasNext()) continue block0;
                object2 = (String)iterator2.next();
                if (saveParameters.useIndexes && ((Matcher)(object3 = PixmapPacker.indexPattern.matcher((CharSequence)object2))).matches()) {
                    object = ((Matcher)object3).group(1);
                    n = Integer.parseInt(((Matcher)object3).group(2));
                } else {
                    object = object2;
                    n = -1;
                }
                object3 = new StringBuilder();
                ((StringBuilder)object3).append((String)object);
                ((StringBuilder)object3).append("\n");
                writer.write(((StringBuilder)object3).toString());
                object = (PixmapPacker.PixmapPackerRectangle)page.rects.get((String)object2);
                writer.write("  rotate: false\n");
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("  xy: ");
                ((StringBuilder)object2).append((int)((PixmapPacker.PixmapPackerRectangle)object).x);
                ((StringBuilder)object2).append(",");
                ((StringBuilder)object2).append((int)((PixmapPacker.PixmapPackerRectangle)object).y);
                ((StringBuilder)object2).append("\n");
                writer.write(((StringBuilder)object2).toString());
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("  size: ");
                ((StringBuilder)object2).append((int)((PixmapPacker.PixmapPackerRectangle)object).width);
                ((StringBuilder)object2).append(",");
                ((StringBuilder)object2).append((int)((PixmapPacker.PixmapPackerRectangle)object).height);
                ((StringBuilder)object2).append("\n");
                writer.write(((StringBuilder)object2).toString());
                if (((PixmapPacker.PixmapPackerRectangle)object).splits != null) {
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("  split: ");
                    ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).splits[0]);
                    ((StringBuilder)object2).append(", ");
                    ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).splits[1]);
                    ((StringBuilder)object2).append(", ");
                    ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).splits[2]);
                    ((StringBuilder)object2).append(", ");
                    ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).splits[3]);
                    ((StringBuilder)object2).append("\n");
                    writer.write(((StringBuilder)object2).toString());
                    if (((PixmapPacker.PixmapPackerRectangle)object).pads != null) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("  pad: ");
                        ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).pads[0]);
                        ((StringBuilder)object2).append(", ");
                        ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).pads[1]);
                        ((StringBuilder)object2).append(", ");
                        ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).pads[2]);
                        ((StringBuilder)object2).append(", ");
                        ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).pads[3]);
                        ((StringBuilder)object2).append("\n");
                        writer.write(((StringBuilder)object2).toString());
                    }
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("  orig: ");
                ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).originalWidth);
                ((StringBuilder)object2).append(", ");
                ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).originalHeight);
                ((StringBuilder)object2).append("\n");
                writer.write(((StringBuilder)object2).toString());
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("  offset: ");
                ((StringBuilder)object2).append(((PixmapPacker.PixmapPackerRectangle)object).offsetX);
                ((StringBuilder)object2).append(", ");
                ((StringBuilder)object2).append((int)((float)((PixmapPacker.PixmapPackerRectangle)object).originalHeight - ((PixmapPacker.PixmapPackerRectangle)object).height - (float)((PixmapPacker.PixmapPackerRectangle)object).offsetY));
                ((StringBuilder)object2).append("\n");
                writer.write(((StringBuilder)object2).toString());
                object = new StringBuilder();
                ((StringBuilder)object).append("  index: ");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("\n");
                writer.write(((StringBuilder)object).toString());
            }
        }
        writer.close();
    }

    public static enum ImageFormat {
        CIM(".cim"),
        PNG(".png");

        private final String extension;

        private ImageFormat(String string3) {
            this.extension = string3;
        }

        public String getExtension() {
            return this.extension;
        }
    }

    public static class SaveParameters {
        public ImageFormat format = ImageFormat.PNG;
        public Texture.TextureFilter magFilter;
        public Texture.TextureFilter minFilter = Texture.TextureFilter.Nearest;
        public boolean useIndexes;

        public SaveParameters() {
            this.magFilter = Texture.TextureFilter.Nearest;
        }
    }
}

