/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class GlyphLayout
implements Pool.Poolable {
    private final Array<Color> colorStack;
    public float height;
    public final Array<GlyphRun> runs = new Array();
    public float width;

    public GlyphLayout() {
        this.colorStack = new Array(4);
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence) {
        this.colorStack = new Array(4);
        this.setText(bitmapFont, charSequence);
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence, int n, int n2, Color color2, float f, int n3, boolean bl, String string2) {
        this.colorStack = new Array(4);
        this.setText(bitmapFont, charSequence, n, n2, color2, f, n3, bl, string2);
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence, Color color2, float f, int n, boolean bl) {
        this.colorStack = new Array(4);
        this.setText(bitmapFont, charSequence, color2, f, n, bl);
    }

    private void adjustLastGlyph(BitmapFont.BitmapFontData bitmapFontData, GlyphRun glyphRun) {
        BitmapFont.Glyph glyph = glyphRun.glyphs.peek();
        if (glyph.fixedWidth) {
            return;
        }
        float f = (float)(glyph.width + glyph.xoffset) * bitmapFontData.scaleX - bitmapFontData.padRight;
        glyphRun.width += f - glyphRun.xAdvances.peek();
        glyphRun.xAdvances.set(glyphRun.xAdvances.size - 1, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int parseColorMarkup(CharSequence object, int n, int n2, Pool<Color> object2) {
        if (n == n2) {
            return -1;
        }
        int n3 = object.charAt(n);
        int n4 = 0;
        if (n3 != 35) {
            block15: {
                if (n3 == 91) return -2;
                if (n3 == 93) {
                    if (this.colorStack.size <= 1) return 0;
                    ((Pool)object2).free(this.colorStack.pop());
                    return 0;
                }
                n3 = n + 1;
                while (n3 < n2) {
                    if (object.charAt(n3) != ']') {
                        ++n3;
                        continue;
                    }
                    break block15;
                }
                return -1;
            }
            if ((object = Colors.get(object.subSequence(n, n3).toString())) == null) {
                return -1;
            }
            object2 = (Color)((Pool)object2).obtain();
            this.colorStack.add((Color)object2);
            ((Color)object2).set((Color)object);
            return n3 - n;
        }
        int n5 = n + 1;
        n3 = 0;
        while (n5 < n2) {
            int n6 = object.charAt(n5);
            if (n6 == 93) {
                if (n5 < n + 2) return -1;
                if (n5 > n + 9) {
                    return -1;
                }
                n2 = n5 - n;
                n = n3;
                if (n2 <= 7) {
                    for (n = n4; n < 9 - n2; n3 <<= 4, ++n) {
                    }
                    n = n3 | 0xFF;
                }
                object = (Color)((Pool)object2).obtain();
                this.colorStack.add((Color)object);
                Color.rgba8888ToColor((Color)object, n);
                return n2;
            }
            if (n6 >= 48 && n6 <= 57) {
                n3 *= 16;
                n6 -= 48;
            } else if (n6 >= 97 && n6 <= 102) {
                n3 *= 16;
                n6 -= 87;
            } else {
                if (n6 < 65) return -1;
                if (n6 > 70) return -1;
                n3 *= 16;
                n6 -= 55;
            }
            n3 += n6;
            ++n5;
        }
        return -1;
    }

    private void truncate(BitmapFont.BitmapFontData bitmapFontData, GlyphRun glyphRun, float f, String string2, int n, Pool<GlyphRun> pool) {
        GlyphRun glyphRun2 = pool.obtain();
        bitmapFontData.getGlyphs(glyphRun2, string2, 0, string2.length(), null);
        n = glyphRun2.xAdvances.size;
        float f2 = 0.0f;
        if (n > 0) {
            this.adjustLastGlyph(bitmapFontData, glyphRun2);
            int n2 = glyphRun2.xAdvances.size;
            f2 = 0.0f;
            for (n = 1; n < n2; ++n) {
                f2 += glyphRun2.xAdvances.get(n);
            }
        }
        float f3 = glyphRun.x;
        for (n = 0; n < glyphRun.xAdvances.size; ++n) {
            float f4 = glyphRun.xAdvances.get(n);
            if (!((f3 += f4) > f - f2)) continue;
            glyphRun.width = f3 - glyphRun.x - f4;
            break;
        }
        if (n > 1) {
            glyphRun.glyphs.truncate(n - 1);
            glyphRun.xAdvances.truncate(n);
            this.adjustLastGlyph(bitmapFontData, glyphRun);
            if (glyphRun2.xAdvances.size > 0) {
                glyphRun.xAdvances.addAll(glyphRun2.xAdvances, 1, glyphRun2.xAdvances.size - 1);
            }
        } else {
            glyphRun.glyphs.clear();
            glyphRun.xAdvances.clear();
            glyphRun.xAdvances.addAll(glyphRun2.xAdvances);
            if (glyphRun2.xAdvances.size > 0) {
                glyphRun.width += glyphRun2.xAdvances.get(0);
            }
        }
        glyphRun.glyphs.addAll(glyphRun2.glyphs);
        glyphRun.width += f2;
        pool.free(glyphRun2);
    }

    private GlyphRun wrap(BitmapFont.BitmapFontData bitmapFontData, GlyphRun glyphRun, Pool<GlyphRun> pool, int n, int n2) {
        int n3;
        Array<BitmapFont.Glyph> array = glyphRun.glyphs;
        int n4 = glyphRun.glyphs.size;
        FloatArray floatArray = glyphRun.xAdvances;
        int n5 = n;
        while (true) {
            n3 = n;
            if (n5 <= 0) break;
            if (!bitmapFontData.isWhitespace((char)array.get((int)(n5 - 1)).id)) {
                n3 = n;
                break;
            }
            --n5;
        }
        while (true) {
            n = n2;
            if (n3 >= n4) break;
            if (!bitmapFontData.isWhitespace((char)array.get((int)n3).id)) {
                n = n2;
                break;
            }
            ++n3;
        }
        while (n < n5) {
            glyphRun.width += floatArray.get(n);
            ++n;
        }
        n2 = n5 + 1;
        while (n > n2) {
            float f = glyphRun.width;
            glyphRun.width = f - floatArray.get(--n);
        }
        GlyphRun glyphRun2 = null;
        if (n3 < n4) {
            glyphRun2 = pool.obtain();
            glyphRun2.color.set(glyphRun.color);
            Object object = glyphRun2.glyphs;
            ((Array)object).addAll(array, 0, n5);
            array.removeRange(0, n3 - 1);
            glyphRun.glyphs = object;
            glyphRun2.glyphs = array;
            object = glyphRun2.xAdvances;
            ((FloatArray)object).addAll(floatArray, 0, n2);
            floatArray.removeRange(1, n3);
            floatArray.set(0, (float)(-array.first().xoffset) * bitmapFontData.scaleX - bitmapFontData.padLeft);
            glyphRun.xAdvances = object;
            glyphRun2.xAdvances = floatArray;
        } else {
            array.truncate(n5);
            floatArray.truncate(n2);
        }
        if (n5 == 0) {
            pool.free(glyphRun);
            this.runs.pop();
        } else {
            this.adjustLastGlyph(bitmapFontData, glyphRun);
        }
        return glyphRun2;
    }

    @Override
    public void reset() {
        Pools.get(GlyphRun.class).freeAll(this.runs);
        this.runs.clear();
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public void setText(BitmapFont bitmapFont, CharSequence charSequence) {
        this.setText(bitmapFont, charSequence, 0, charSequence.length(), bitmapFont.getColor(), 0.0f, 8, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setText(BitmapFont var1_1, CharSequence var2_2, int var3_3, int var4_4, Color var5_5, float var6_6, int var7_7, boolean var8_8, String var9_9) {
        var10_10 = var1_1.data;
        if (var9_9 != null) {
            var8_8 = true;
        } else if (var6_6 <= var10_10.spaceXadvance * 3.0f) {
            var8_8 = false;
        }
        var11_11 = var10_10.markupEnabled;
        var12_12 = Pools.get(GlyphRun.class);
        var13_13 = this.runs;
        var12_12.freeAll(var13_13);
        var13_13.clear();
        var14_14 = this.colorStack;
        var14_14.add(var5_5);
        var1_1 = Pools.get(Color.class);
        var15_15 = var3_3;
        var16_16 = var5_5;
        var5_5 = var16_16;
        var17_17 = null;
        var18_18 = 0.0f;
        var19_19 /* !! */  = 0.0f;
        var20_20 = 0.0f;
        var3_3 = 0;
        var21_21 = 0;
        var22_22 = var15_15;
        var23_23 = var16_16;
        var16_16 = var17_17;
        while (true) {
            block54: {
                block45: {
                    block40: {
                        block46: {
                            block50: {
                                block49: {
                                    block48: {
                                        block47: {
                                            block43: {
                                                block44: {
                                                    block41: {
                                                        block42: {
                                                            var17_17 = var2_2;
                                                            if (var22_22 != var4_4) break block41;
                                                            if (var15_15 != var4_4) break block42;
                                                            var4_4 = var3_3;
                                                            ** GOTO lbl118
                                                        }
                                                        var24_24 = var4_4;
                                                        var25_25 = false;
                                                        break block43;
                                                    }
                                                    var24_24 = var22_22 + 1;
                                                    if ((var22_22 = (int)var17_17.charAt(var22_22)) == 10) break block44;
                                                    if (var22_22 != 91 || !var11_11) ** GOTO lbl51
                                                    var22_22 = this.parseColorMarkup((CharSequence)var17_17, var24_24, var4_4, (Pool<Color>)var1_1);
                                                    if (var22_22 >= 0) {
                                                        var5_5 = var14_14.peek();
                                                        var22_22 = var24_24 + (var22_22 + 1);
                                                        var25_25 = false;
                                                        --var24_24;
                                                    } else {
                                                        if (var22_22 == -2) {
                                                            var22_22 = var24_24 + 1;
                                                            continue;
                                                        }
lbl51:
                                                        // 3 sources

                                                        var25_25 = false;
                                                        var22_22 = var24_24;
                                                        var24_24 = -1;
                                                    }
                                                    break block43;
                                                }
                                                var25_25 = true;
                                                var22_22 = var24_24--;
                                            }
                                            var17_17 = var16_16;
                                            if (var24_24 == -1) break block45;
                                            if (var24_24 == var15_15) break block46;
                                            var26_26 = var12_12.obtain();
                                            var26_26.color.set((Color)var23_23);
                                            var16_16 = var1_1;
                                            var10_10.getGlyphs(var26_26, (CharSequence)var2_2, var15_15, var24_24, (BitmapFont.Glyph)var17_17);
                                            if (var26_26.glyphs.size != 0) break block47;
                                            var12_12.free(var26_26);
                                            break block46;
                                        }
                                        var27_27 = var19_19 /* !! */ ;
                                        if (var17_17 != null) {
                                            var27_27 = var17_17.fixedWidth != false ? (float)var17_17.xadvance * var10_10.scaleX : (float)(var17_17.width + var17_17.xoffset) * var10_10.scaleX - var10_10.padRight;
                                            var27_27 = var19_19 /* !! */  - var27_27;
                                        }
                                        var28_28 = var26_26.glyphs.peek();
                                        var26_26.x = var27_27;
                                        var26_26.y = var18_18;
                                        if (var25_25 || var24_24 == var4_4) {
                                            this.adjustLastGlyph(var10_10, var26_26);
                                        }
                                        var13_13.add(var26_26);
                                        var23_23 = var26_26.xAdvances.items;
                                        var29_29 = var26_26.xAdvances.size;
                                        if (var8_8) break block48;
                                        var19_19 /* !! */  = 0.0f;
                                        for (var30_30 = 0; var30_30 < var29_29; ++var30_30) {
                                            var19_19 /* !! */  += var23_23[var30_30];
                                        }
                                        var27_27 += var19_19 /* !! */ ;
                                        var26_26.width = var19_19 /* !! */ ;
                                        var19_19 /* !! */  = var27_27;
                                        break block49;
                                    }
                                    var19_19 /* !! */  = var27_27 + var23_23[0];
                                    var26_26.width = (float)var23_23[0];
                                    if (var29_29 >= 1) break block50;
                                }
                                var1_1 = var16_16;
                                var16_16 = var28_28;
                                break block40;
                            }
                            var19_19 /* !! */  += var23_23[1];
                            var26_26.width += var23_23[1];
                            var17_17 = var26_26;
                            var1_1 = var16_16;
                            var16_16 = var28_28;
                            for (var30_30 = 2; var30_30 < var29_29; ++var30_30) {
                                block53: {
                                    block52: {
                                        block51: {
                                            var28_28 = var17_17.glyphs;
                                            var31_31 = var30_30 - 1;
                                            var28_28 = (BitmapFont.Glyph)var28_28.get(var31_31);
                                            if ((float)(var28_28.width + var28_28.xoffset) * var10_10.scaleX - var10_10.padRight + var19_19 /* !! */  <= var6_6) {
                                                var19_19 /* !! */  += var23_23[var30_30];
                                                var17_17.width += var23_23[var30_30];
                                                continue;
                                            }
                                            if (var9_9 == null) break block51;
                                            this.truncate(var10_10, (GlyphRun)var17_17, var6_6, var9_9, var30_30, var12_12);
                                            var19_19 /* !! */  = var17_17.x + var17_17.width;
                                            var4_4 = var3_3;
lbl118:
                                            // 2 sources

                                            var32_32 = Math.max(var20_20, var19_19 /* !! */ );
                                            var22_22 = var14_14.size;
                                            for (var3_3 = 1; var3_3 < var22_22; ++var3_3) {
                                                var1_1.free(var14_14.get(var3_3));
                                            }
                                            var14_14.clear();
                                            if ((var7_7 & 8) == 0) {
                                                var7_7 = (var7_7 & 1) != 0 ? 1 : 0;
                                                var24_24 = var13_13.size;
                                                var20_20 = 0.0f;
                                                var19_19 /* !! */  = -2.1474836E9f;
                                                var3_3 = 0;
                                                for (var22_22 = 0; var22_22 < var24_24; ++var22_22) {
                                                    var1_1 = var13_13.get(var22_22);
                                                    var27_27 = var20_20;
                                                    var18_18 = var19_19 /* !! */ ;
                                                    var15_15 = var3_3;
                                                    if (var1_1.y != var19_19 /* !! */ ) {
                                                        var18_18 = var1_1.y;
                                                        var20_20 = var19_19 /* !! */  = var6_6 - var20_20;
                                                        if (var7_7 != 0) {
                                                            var20_20 = var19_19 /* !! */  / 2.0f;
                                                        }
                                                        while (var3_3 < var22_22) {
                                                            var2_2 = var13_13.get(var3_3);
                                                            var2_2.x += var20_20;
                                                            ++var3_3;
                                                        }
                                                        var27_27 = 0.0f;
                                                        var15_15 = var3_3;
                                                    }
                                                    var20_20 = Math.max(var27_27, var1_1.x + var1_1.width);
                                                    var19_19 /* !! */  = var18_18;
                                                    var3_3 = var15_15;
                                                }
                                                var6_6 = var20_20 = var6_6 - var20_20;
                                                if (var7_7 != 0) {
                                                    var6_6 = var20_20 / 2.0f;
                                                }
                                                while (var3_3 < var24_24) {
                                                    var1_1 = var13_13.get(var3_3);
                                                    var1_1.x += var6_6;
                                                    ++var3_3;
                                                }
                                            }
                                            this.width = var32_32;
                                            this.height = var10_10.flipped != false ? var10_10.capHeight + (float)var4_4 * var10_10.down + (float)var21_21 * var10_10.down * var10_10.blankLineScale : var10_10.capHeight + (float)var4_4 * -var10_10.down + (float)var21_21 * -var10_10.down * var10_10.blankLineScale;
                                            return;
                                        }
                                        var33_33 = var10_10.getWrapIndex(var17_17.glyphs, var30_30);
                                        if (var17_17.x != 0.0f) break block52;
                                        var29_29 = var31_31;
                                        if (var33_33 == 0) break block53;
                                    }
                                    var29_29 = var33_33 >= var17_17.glyphs.size ? var31_31 : var33_33;
                                }
                                if (var29_29 == 0) {
                                    var17_17.width = 0.0f;
                                    var31_31 = var17_17.glyphs.size;
                                    for (var30_30 = var29_29; var30_30 < var31_31 && var10_10.isWhitespace((char)var17_17.glyphs.get((int)var30_30).id); ++var30_30) {
                                    }
                                    if (var30_30 > 0) {
                                        var17_17.glyphs.removeRange(0, var30_30 - 1);
                                        var17_17.xAdvances.removeRange(1, var30_30);
                                    }
                                    var17_17.xAdvances.set(0, (float)(-var17_17.glyphs.first().xoffset) * var10_10.scaleX - var10_10.padLeft);
                                    if (var13_13.size > 1) {
                                        var16_16 = var13_13.get(var13_13.size - 2);
                                        for (var30_30 = var16_16.glyphs.size - 1; var30_30 > 0 && var10_10.isWhitespace((char)var16_16.glyphs.get((int)var30_30).id); --var30_30) {
                                            var16_16.width -= var16_16.xAdvances.get(var30_30 + 1);
                                        }
                                        var16_16.glyphs.truncate(var30_30 + 1);
                                        var16_16.xAdvances.truncate(var30_30 + 2);
                                        this.adjustLastGlyph(var10_10, (GlyphRun)var16_16);
                                        var20_20 = Math.max(var20_20, var16_16.x + var16_16.width);
                                    }
                                } else {
                                    var23_23 = var1_1;
                                    var16_16 = this.wrap(var10_10, (GlyphRun)var17_17, var12_12, var29_29, var30_30);
                                    var20_20 = Math.max(var20_20, var17_17.x + var17_17.width);
                                    if (var16_16 == null) {
                                        var18_18 += var10_10.down;
                                        ++var3_3;
                                        var16_16 = null;
                                        var19_19 /* !! */  = 0.0f;
                                        var1_1 = var23_23;
                                        break block40;
                                    }
                                    var13_13.add((GlyphRun)var16_16);
                                    var17_17 = var16_16;
                                }
                                var29_29 = var17_17.xAdvances.size;
                                var23_23 = var17_17.xAdvances.items;
                                var19_19 /* !! */  = var27_27 = (float)var23_23[0];
                                if (var29_29 > 1) {
                                    var19_19 /* !! */  = var27_27 + var23_23[1];
                                }
                                var17_17.width += var19_19 /* !! */ ;
                                ++var3_3;
                                var17_17.x = 0.0f;
                                var17_17.y = var18_18 += var10_10.down;
                                var16_16 = null;
                                var30_30 = 1;
                            }
                            break block40;
                        }
                        var16_16 = var17_17;
                    }
                    var34_34 = var19_19 /* !! */ ;
                    var32_32 = var20_20;
                    var27_27 = var18_18;
                    var29_29 = var3_3++;
                    var30_30 = var21_21++;
                    if (var25_25) {
                        var32_32 = Math.max(var20_20, var19_19 /* !! */ );
                        var20_20 = var10_10.down;
                        if (var24_24 == var15_15) {
                            var20_20 *= var10_10.blankLineScale;
                        }
                        var27_27 = var18_18 + var20_20;
                        var16_16 = null;
                        var34_34 = 0.0f;
                        var30_30 = var21_21;
                        var29_29 = var3_3;
                    }
                    var19_19 /* !! */  = var34_34;
                    var3_3 = var22_22;
                    var23_23 = var5_5;
                    var18_18 = var27_27;
                    var20_20 = var32_32;
                    var21_21 = var30_30;
                    break block54;
                }
                var16_16 = var17_17;
                var29_29 = var3_3;
                var3_3 = var15_15;
            }
            var15_15 = var3_3;
            var3_3 = var29_29;
        }
    }

    public void setText(BitmapFont bitmapFont, CharSequence charSequence, Color color2, float f, int n, boolean bl) {
        this.setText(bitmapFont, charSequence, 0, charSequence.length(), color2, f, n, bl, null);
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.width);
        stringBuilder.append('x');
        stringBuilder.append(this.height);
        stringBuilder.append('\n');
        int n = this.runs.size;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.runs.get(i).toString());
            stringBuilder.append('\n');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public static class GlyphRun
    implements Pool.Poolable {
        public final Color color;
        public Array<BitmapFont.Glyph> glyphs = new Array();
        public float width;
        public float x;
        public FloatArray xAdvances = new FloatArray();
        public float y;

        public GlyphRun() {
            this.color = new Color();
        }

        @Override
        public void reset() {
            this.glyphs.clear();
            this.xAdvances.clear();
            this.width = 0.0f;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.glyphs.size);
            Array<BitmapFont.Glyph> array = this.glyphs;
            int n = array.size;
            for (int i = 0; i < n; ++i) {
                stringBuilder.append((char)array.get((int)i).id);
            }
            stringBuilder.append(", #");
            stringBuilder.append(this.color);
            stringBuilder.append(", ");
            stringBuilder.append(this.x);
            stringBuilder.append(", ");
            stringBuilder.append(this.y);
            stringBuilder.append(", ");
            stringBuilder.append(this.width);
            return stringBuilder.toString();
        }
    }
}

