/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.Pools;

public class BitmapFontCache {
    private static final Color tempColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private final Color color;
    private float currentTint;
    private final BitmapFont font;
    private int glyphCount;
    private int[] idx;
    private boolean integer;
    private final Array<GlyphLayout> layouts = new Array();
    private IntArray[] pageGlyphIndices;
    private float[][] pageVertices;
    private final Array<GlyphLayout> pooledLayouts = new Array();
    private int[] tempGlyphCount;
    private float x;
    private float y;

    public BitmapFontCache(BitmapFont bitmapFont) {
        this(bitmapFont, bitmapFont.usesIntegerPositions());
    }

    public BitmapFontCache(BitmapFont object, boolean bl) {
        this.color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.font = object;
        this.integer = bl;
        int n = ((BitmapFont)object).regions.size;
        if (n != 0) {
            this.pageVertices = new float[n][];
            this.idx = new int[n];
            if (n > 1) {
                this.pageGlyphIndices = new IntArray[n];
                int n2 = this.pageGlyphIndices.length;
                for (int i = 0; i < n2; ++i) {
                    this.pageGlyphIndices[i] = new IntArray();
                }
            }
            this.tempGlyphCount = new int[n];
            return;
        }
        object = new IllegalArgumentException("The specified font must contain at least one texture page.");
        throw object;
    }

    private void addGlyph(BitmapFont.Glyph object, float f, float f2, float f3) {
        Object object2;
        float f4 = this.font.data.scaleX;
        float f5 = this.font.data.scaleY;
        float f6 = f + (float)((BitmapFont.Glyph)object).xoffset * f4;
        float f7 = f2 + (float)((BitmapFont.Glyph)object).yoffset * f5;
        float f8 = (float)((BitmapFont.Glyph)object).width * f4;
        float f9 = (float)((BitmapFont.Glyph)object).height * f5;
        float f10 = ((BitmapFont.Glyph)object).u;
        float f11 = ((BitmapFont.Glyph)object).u2;
        float f12 = ((BitmapFont.Glyph)object).v;
        float f13 = ((BitmapFont.Glyph)object).v2;
        f4 = f9;
        f5 = f8;
        f2 = f6;
        f = f7;
        if (this.integer) {
            f2 = Math.round(f6);
            f = Math.round(f7);
            f5 = Math.round(f8);
            f4 = Math.round(f9);
        }
        f5 += f2;
        f4 += f;
        int n = ((BitmapFont.Glyph)object).page;
        object = this.idx;
        Object object3 = object[n];
        object[n] = object[n] + 20;
        object = this.pageGlyphIndices;
        if (object != null) {
            object = object[n];
            object2 = this.glyphCount;
            this.glyphCount = object2 + 1;
            ((IntArray)object).add((int)object2);
        }
        object = this.pageVertices[n];
        object2 = object3 + true;
        object[object3] = (IntArray)f2;
        object3 = object2 + 1;
        object[object2] = f;
        object2 = object3 + true;
        object[object3] = f3;
        object3 = object2 + 1;
        object[object2] = f10;
        object2 = object3 + true;
        object[object3] = f12;
        n = object2 + 1;
        object[object2] = f2;
        object3 = n + 1;
        object[n] = f4;
        object2 = object3 + true;
        object[object3] = f3;
        object3 = object2 + 1;
        object[object2] = f10;
        object2 = object3 + true;
        object[object3] = f13;
        object3 = object2 + 1;
        object[object2] = f5;
        object2 = object3 + true;
        object[object3] = f4;
        object3 = object2 + 1;
        object[object2] = f3;
        object2 = object3 + true;
        object[object3] = f11;
        object3 = object2 + 1;
        object[object2] = f13;
        object2 = object3 + true;
        object[object3] = f5;
        object3 = object2 + 1;
        object[object2] = f;
        object2 = object3 + true;
        object[object3] = f3;
        object[object2] = f11;
        object[object2 + 1] = f12;
    }

    private void addToCache(GlyphLayout glyphLayout, float f, float f2) {
        int n;
        Object object;
        Object object2 = this.pageVertices;
        int n2 = this.font.regions.size;
        if (((float[][])object2).length < n2) {
            object = new float[n2][];
            System.arraycopy(object2, 0, object, 0, ((float[][])object2).length);
            this.pageVertices = (float[][])object;
            object = new int[n2];
            object2 = this.idx;
            System.arraycopy(object2, 0, object, 0, ((float[][])object2).length);
            this.idx = (int[])object;
            object = new IntArray[n2];
            object2 = this.pageGlyphIndices;
            if (object2 != null) {
                n = ((float[][])object2).length;
                System.arraycopy(object2, 0, object, 0, ((float[][])object2).length);
            } else {
                n = 0;
            }
            while (n < n2) {
                object[n] = (float[])new IntArray();
                ++n;
            }
            this.pageGlyphIndices = (IntArray[])object;
            this.tempGlyphCount = new int[n2];
        }
        this.layouts.add(glyphLayout);
        this.requireGlyphs(glyphLayout);
        int n3 = glyphLayout.runs.size;
        for (n = 0; n < n3; ++n) {
            Object object3 = glyphLayout.runs.get(n);
            object = ((GlyphLayout.GlyphRun)object3).glyphs;
            object2 = ((GlyphLayout.GlyphRun)object3).xAdvances;
            float f3 = ((GlyphLayout.GlyphRun)object3).color.toFloatBits();
            float f4 = ((GlyphLayout.GlyphRun)object3).x;
            float f5 = ((GlyphLayout.GlyphRun)object3).y;
            int n4 = ((Array)object).size;
            f4 += f;
            for (n2 = 0; n2 < n4; ++n2) {
                object3 = (BitmapFont.Glyph)((Array)object).get(n2);
                this.addGlyph((BitmapFont.Glyph)object3, f4 += object2.get(n2), f5 + f2, f3);
            }
        }
        this.currentTint = Color.WHITE_FLOAT_BITS;
    }

    private void requireGlyphs(GlyphLayout glyphLayout) {
        int n = this.pageVertices.length;
        int n2 = 0;
        if (n == 1) {
            n2 = glyphLayout.runs.size;
            n = 0;
            for (int i = 0; i < n2; ++i) {
                n += glyphLayout.runs.get((int)i).glyphs.size;
            }
            this.requirePageGlyphs(0, n);
        } else {
            int[] nArray = this.tempGlyphCount;
            int n3 = nArray.length;
            for (n = 0; n < n3; ++n) {
                nArray[n] = 0;
            }
            int n4 = glyphLayout.runs.size;
            for (n = 0; n < n4; ++n) {
                Array<BitmapFont.Glyph> array = glyphLayout.runs.get((int)n).glyphs;
                int n5 = array.size;
                for (n3 = 0; n3 < n5; ++n3) {
                    int n6 = array.get((int)n3).page;
                    nArray[n6] = nArray[n6] + 1;
                }
            }
            n3 = nArray.length;
            for (n = n2; n < n3; ++n) {
                this.requirePageGlyphs(n, nArray[n]);
            }
        }
    }

    private void requirePageGlyphs(int n, int n2) {
        Object[] objectArray = this.pageGlyphIndices;
        if (objectArray != null && n2 > objectArray[n].items.length) {
            objectArray = this.pageGlyphIndices;
            objectArray[n].ensureCapacity(n2 - objectArray[n].items.length);
        }
        int[] nArray = this.idx;
        n2 = nArray[n] + n2 * 20;
        Object object = this.pageVertices;
        objectArray = object[n];
        if (objectArray == null) {
            object[n] = new float[n2];
        } else if (objectArray.length < n2) {
            object = new float[n2];
            System.arraycopy(objectArray, 0, object, 0, nArray[n]);
            this.pageVertices[n] = (float[])object;
        }
    }

    public GlyphLayout addText(CharSequence charSequence, float f, float f2) {
        return this.addText(charSequence, f, f2, 0, charSequence.length(), 0.0f, 8, false, null);
    }

    public GlyphLayout addText(CharSequence charSequence, float f, float f2, float f3, int n, boolean bl) {
        return this.addText(charSequence, f, f2, 0, charSequence.length(), f3, n, bl, null);
    }

    public GlyphLayout addText(CharSequence charSequence, float f, float f2, int n, int n2, float f3, int n3, boolean bl) {
        return this.addText(charSequence, f, f2, n, n2, f3, n3, bl, null);
    }

    public GlyphLayout addText(CharSequence charSequence, float f, float f2, int n, int n2, float f3, int n3, boolean bl, String string2) {
        GlyphLayout glyphLayout = Pools.obtain(GlyphLayout.class);
        this.pooledLayouts.add(glyphLayout);
        glyphLayout.setText(this.font, charSequence, n, n2, this.color, f3, n3, bl, string2);
        this.addText(glyphLayout, f, f2);
        return glyphLayout;
    }

    public void addText(GlyphLayout glyphLayout, float f, float f2) {
        this.addToCache(glyphLayout, f, f2 + this.font.data.ascent);
    }

    public void clear() {
        this.x = 0.0f;
        this.y = 0.0f;
        Pools.freeAll(this.pooledLayouts, true);
        this.pooledLayouts.clear();
        this.layouts.clear();
        int n = this.idx.length;
        for (int i = 0; i < n; ++i) {
            IntArray[] intArrayArray = this.pageGlyphIndices;
            if (intArrayArray != null) {
                intArrayArray[i].clear();
            }
            this.idx[i] = 0;
        }
    }

    public void draw(Batch batch) {
        Array<TextureRegion> array = this.font.getRegions();
        int n = this.pageVertices.length;
        for (int i = 0; i < n; ++i) {
            if (this.idx[i] <= 0) continue;
            float[] fArray = this.pageVertices[i];
            batch.draw(array.get(i).getTexture(), fArray, 0, this.idx[i]);
        }
    }

    public void draw(Batch batch, float f) {
        if (f == 1.0f) {
            this.draw(batch);
            return;
        }
        Color color2 = this.getColor();
        float f2 = color2.a;
        color2.a *= f;
        this.setColors(color2);
        this.draw(batch);
        color2.a = f2;
        this.setColors(color2);
    }

    public void draw(Batch batch, int n, int n2) {
        if (this.pageVertices.length == 1) {
            batch.draw(this.font.getRegion().getTexture(), this.pageVertices[0], n * 20, (n2 - n) * 20);
            return;
        }
        Array<TextureRegion> array = this.font.getRegions();
        int n3 = this.pageVertices.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            IntArray intArray = this.pageGlyphIndices[i];
            int n5 = intArray.size;
            int n6 = -1;
            int n7 = 0;
            for (int j = 0; j < n5 && (n4 = intArray.get(j)) < n2; ++j) {
                int n8 = n6;
                if (n6 == -1) {
                    n8 = n6;
                    if (n4 >= n) {
                        n8 = j;
                    }
                }
                int n9 = n7;
                if (n4 >= n) {
                    n9 = n7 + 1;
                }
                n6 = n8;
                n7 = n9;
            }
            if (n6 == -1 || n7 == 0) continue;
            batch.draw(array.get(i).getTexture(), this.pageVertices[i], n6 * 20, n7 * 20);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public Array<GlyphLayout> getLayouts() {
        return this.layouts;
    }

    public int getVertexCount(int n) {
        return this.idx[n];
    }

    public float[] getVertices() {
        return this.getVertices(0);
    }

    public float[] getVertices(int n) {
        return this.pageVertices[n];
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setAlphas(float f) {
        int n = (int)(f * 254.0f);
        int n2 = this.pageVertices.length;
        f = 0.0f;
        float f2 = 0.0f;
        for (int i = 0; i < n2; ++i) {
            float[] fArray = this.pageVertices[i];
            int n3 = this.idx[i];
            float f3 = f2;
            f2 = f;
            f = f3;
            for (int j = 2; j < n3; j += 5) {
                f3 = fArray[j];
                if (f3 == f2 && j != 2) {
                    fArray[j] = f;
                    continue;
                }
                fArray[j] = f = NumberUtils.intToFloatColor(NumberUtils.floatToIntColor(f3) & 0xFFFFFF | n << 24);
                f2 = f3;
            }
            f3 = f;
            f = f2;
            f2 = f3;
        }
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
    }

    public void setColor(Color color2) {
        this.color.set(color2);
    }

    public void setColors(float f) {
        int n = this.pageVertices.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray = this.pageVertices[i];
            int n2 = this.idx[i];
            for (int j = 2; j < n2; j += 5) {
                fArray[j] = f;
            }
        }
    }

    public void setColors(float f, float f2, float f3, float f4) {
        int n = (int)(f4 * 255.0f);
        int n2 = (int)(f3 * 255.0f);
        int n3 = (int)(f2 * 255.0f);
        this.setColors(NumberUtils.intToFloatColor((int)(f * 255.0f) | (n3 << 8 | (n2 << 16 | n << 24))));
    }

    public void setColors(float f, int n, int n2) {
        Object object = this.pageVertices;
        if (((float[][])object).length == 1) {
            object = object[0];
            for (n = n * 20 + 2; n < n2 * 20; n += 5) {
                object[n] = (float[])f;
            }
            return;
        }
        int n3 = ((float[][])object).length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            object = this.pageVertices[i];
            IntArray intArray = this.pageGlyphIndices[i];
            int n5 = intArray.size;
            for (int j = 0; j < n5 && (n4 = intArray.items[j]) < n2; ++j) {
                if (n4 < n) continue;
                for (n4 = 0; n4 < 20; n4 += 5) {
                    object[j * 20 + 2 + n4] = (float[])f;
                }
            }
        }
    }

    public void setColors(Color color2) {
        this.setColors(color2.toFloatBits());
    }

    public void setColors(Color color2, int n, int n2) {
        this.setColors(color2.toFloatBits(), n, n2);
    }

    public void setPosition(float f, float f2) {
        this.translate(f - this.x, f2 - this.y);
    }

    public GlyphLayout setText(CharSequence charSequence, float f, float f2) {
        this.clear();
        return this.addText(charSequence, f, f2, 0, charSequence.length(), 0.0f, 8, false);
    }

    public GlyphLayout setText(CharSequence charSequence, float f, float f2, float f3, int n, boolean bl) {
        this.clear();
        return this.addText(charSequence, f, f2, 0, charSequence.length(), f3, n, bl);
    }

    public GlyphLayout setText(CharSequence charSequence, float f, float f2, int n, int n2, float f3, int n3, boolean bl) {
        this.clear();
        return this.addText(charSequence, f, f2, n, n2, f3, n3, bl);
    }

    public GlyphLayout setText(CharSequence charSequence, float f, float f2, int n, int n2, float f3, int n3, boolean bl, String string2) {
        this.clear();
        return this.addText(charSequence, f, f2, n, n2, f3, n3, bl, string2);
    }

    public void setText(GlyphLayout glyphLayout, float f, float f2) {
        this.clear();
        this.addText(glyphLayout, f, f2);
    }

    public void setUseIntegerPositions(boolean bl) {
        this.integer = bl;
    }

    public void tint(Color color2) {
        int n;
        float f = color2.toFloatBits();
        if (this.currentTint == f) {
            return;
        }
        this.currentTint = f;
        int[] nArray = this.tempGlyphCount;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            nArray[n] = 0;
        }
        int n3 = this.layouts.size;
        for (n = 0; n < n3; ++n) {
            GlyphLayout glyphLayout = this.layouts.get(n);
            int n4 = glyphLayout.runs.size;
            for (n2 = 0; n2 < n4; ++n2) {
                Object object = glyphLayout.runs.get(n2);
                Array<BitmapFont.Glyph> array = ((GlyphLayout.GlyphRun)object).glyphs;
                f = tempColor.set(((GlyphLayout.GlyphRun)object).color).mul(color2).toFloatBits();
                int n5 = array.size;
                for (int i = 0; i < n5; ++i) {
                    int n6 = array.get((int)i).page;
                    int n7 = nArray[n6];
                    nArray[n6] = nArray[n6] + 1;
                    object = this.pageVertices[n6];
                    for (n6 = 0; n6 < 20; n6 += 5) {
                        object[n7 * 20 + 2 + n6] = f;
                    }
                }
            }
        }
    }

    public void translate(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            return;
        }
        float f3 = f;
        float f4 = f2;
        if (this.integer) {
            f3 = Math.round(f);
            f4 = Math.round(f2);
        }
        this.x += f3;
        this.y += f4;
        float[][] fArray = this.pageVertices;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            float[] fArray2 = fArray[i];
            int n2 = this.idx[i];
            for (int j = 0; j < n2; j += 5) {
                fArray2[j] = fArray2[j] + f3;
                int n3 = j + 1;
                fArray2[n3] = fArray2[n3] + f4;
            }
        }
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }
}

