/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.utils.Array;

public class TextureAtlasLoader
extends SynchronousAssetLoader<TextureAtlas, TextureAtlasParameter> {
    TextureAtlas.TextureAtlasData data;

    public TextureAtlasLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String iterator, FileHandle object3, TextureAtlasParameter object2) {
        Array<AssetDescriptor> array;
        iterator = ((FileHandle)object3).parent();
        this.data = array != null ? new TextureAtlas.TextureAtlasData((FileHandle)object3, (FileHandle)((Object)iterator), ((TextureAtlasParameter)((Object)array)).flip) : new TextureAtlas.TextureAtlasData((FileHandle)object3, (FileHandle)((Object)iterator), false);
        array = new Array<AssetDescriptor>();
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            TextureLoader.TextureParameter textureParameter = new TextureLoader.TextureParameter();
            textureParameter.format = page.format;
            textureParameter.genMipMaps = page.useMipMaps;
            textureParameter.minFilter = page.minFilter;
            textureParameter.magFilter = page.magFilter;
            array.add(new AssetDescriptor<Texture>(page.textureFile, Texture.class, textureParameter));
        }
        return array;
    }

    @Override
    public TextureAtlas load(AssetManager disposable, String object, FileHandle object22, TextureAtlasParameter textureAtlasParameter) {
        for (TextureAtlas.TextureAtlasData.Page page : this.data.getPages()) {
            page.texture = ((AssetManager)disposable).get(page.textureFile.path().replaceAll("\\\\", "/"), Texture.class);
        }
        disposable = new TextureAtlas(this.data);
        this.data = null;
        return disposable;
    }

    public static class TextureAtlasParameter
    extends AssetLoaderParameters<TextureAtlas> {
        public boolean flip = false;

        public TextureAtlasParameter() {
        }

        public TextureAtlasParameter(boolean bl) {
            this.flip = bl;
        }
    }
}

