/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.glutils.HdpiUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;

public abstract class Viewport {
    private Camera camera;
    private int screenHeight;
    private int screenWidth;
    private int screenX;
    private int screenY;
    private final Vector3 tmp = new Vector3();
    private float worldHeight;
    private float worldWidth;

    public void apply() {
        this.apply(false);
    }

    public void apply(boolean bl) {
        HdpiUtils.glViewport(this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        Camera camera = this.camera;
        camera.viewportWidth = this.worldWidth;
        camera.viewportHeight = this.worldHeight;
        if (bl) {
            camera.position.set(this.worldWidth / 2.0f, this.worldHeight / 2.0f, 0.0f);
        }
        this.camera.update();
    }

    public void calculateScissors(Matrix4 matrix4, Rectangle rectangle, Rectangle rectangle2) {
        ScissorStack.calculateScissors(this.camera, this.screenX, this.screenY, this.screenWidth, this.screenHeight, matrix4, rectangle, rectangle2);
    }

    public int getBottomGutterHeight() {
        return this.screenY;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public int getLeftGutterWidth() {
        return this.screenX;
    }

    public Ray getPickRay(float f, float f2) {
        return this.camera.getPickRay(f, f2, this.screenX, this.screenY, this.screenWidth, this.screenHeight);
    }

    public int getRightGutterWidth() {
        return Gdx.graphics.getWidth() - (this.screenX + this.screenWidth);
    }

    public int getRightGutterX() {
        return this.screenX + this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public int getTopGutterHeight() {
        return Gdx.graphics.getHeight() - (this.screenY + this.screenHeight);
    }

    public int getTopGutterY() {
        return this.screenY + this.screenHeight;
    }

    public float getWorldHeight() {
        return this.worldHeight;
    }

    public float getWorldWidth() {
        return this.worldWidth;
    }

    public Vector2 project(Vector2 vector2) {
        this.tmp.set(vector2.x, vector2.y, 1.0f);
        this.camera.project(this.tmp, this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        vector2.set(this.tmp.x, this.tmp.y);
        return vector2;
    }

    public Vector3 project(Vector3 vector3) {
        this.camera.project(vector3, this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        return vector3;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setScreenBounds(int n, int n2, int n3, int n4) {
        this.screenX = n;
        this.screenY = n2;
        this.screenWidth = n3;
        this.screenHeight = n4;
    }

    public void setScreenHeight(int n) {
        this.screenHeight = n;
    }

    public void setScreenPosition(int n, int n2) {
        this.screenX = n;
        this.screenY = n2;
    }

    public void setScreenSize(int n, int n2) {
        this.screenWidth = n;
        this.screenHeight = n2;
    }

    public void setScreenWidth(int n) {
        this.screenWidth = n;
    }

    public void setScreenX(int n) {
        this.screenX = n;
    }

    public void setScreenY(int n) {
        this.screenY = n;
    }

    public void setWorldHeight(float f) {
        this.worldHeight = f;
    }

    public void setWorldSize(float f, float f2) {
        this.worldWidth = f;
        this.worldHeight = f2;
    }

    public void setWorldWidth(float f) {
        this.worldWidth = f;
    }

    public Vector2 toScreenCoordinates(Vector2 vector2, Matrix4 matrix4) {
        this.tmp.set(vector2.x, vector2.y, 0.0f);
        this.tmp.mul(matrix4);
        this.camera.project(this.tmp);
        this.tmp.y = (float)Gdx.graphics.getHeight() - this.tmp.y;
        vector2.x = this.tmp.x;
        vector2.y = this.tmp.y;
        return vector2;
    }

    public Vector2 unproject(Vector2 vector2) {
        this.tmp.set(vector2.x, vector2.y, 1.0f);
        this.camera.unproject(this.tmp, this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        vector2.set(this.tmp.x, this.tmp.y);
        return vector2;
    }

    public Vector3 unproject(Vector3 vector3) {
        this.camera.unproject(vector3, this.screenX, this.screenY, this.screenWidth, this.screenHeight);
        return vector3;
    }

    public final void update(int n, int n2) {
        this.update(n, n2, false);
    }

    public void update(int n, int n2, boolean bl) {
        this.apply(bl);
    }
}

