/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ArrayReflection;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class Field {
    private final java.lang.reflect.Field field;

    Field(java.lang.reflect.Field field) {
        this.field = field;
    }

    public Object get(Object object) throws ReflectionException {
        try {
            object = this.field.get(object);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Illegal access to field: ");
            stringBuilder.append(this.getName());
            throw new ReflectionException(stringBuilder.toString(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Object is not an instance of ");
            ((StringBuilder)object).append(this.getDeclaringClass());
            throw new ReflectionException(((StringBuilder)object).toString(), illegalArgumentException);
        }
    }

    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        java.lang.annotation.Annotation[] annotationArray = this.field.getDeclaredAnnotations();
        if (annotationArray == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotationArray) {
            if (!annotation.annotationType().equals(clazz)) continue;
            return new Annotation(annotation);
        }
        return null;
    }

    public Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotationArray = this.field.getDeclaredAnnotations();
        Annotation[] annotationArray2 = new Annotation[annotationArray.length];
        for (int i = 0; i < annotationArray.length; ++i) {
            annotationArray2[i] = new Annotation(annotationArray[i]);
        }
        return annotationArray2;
    }

    public Class getDeclaringClass() {
        return this.field.getDeclaringClass();
    }

    public Class getElementType(int n) {
        Object object = this.field.getGenericType();
        if (object instanceof ParameterizedType && ((Type[])(object = ((ParameterizedType)object).getActualTypeArguments())).length - 1 >= n) {
            if ((object = object[n]) instanceof Class) {
                return (Class)object;
            }
            if (object instanceof ParameterizedType) {
                return (Class)((ParameterizedType)object).getRawType();
            }
            if (object instanceof GenericArrayType && (object = ((GenericArrayType)object).getGenericComponentType()) instanceof Class) {
                return ArrayReflection.newInstance((Class)object, 0).getClass();
            }
        }
        return null;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class getType() {
        return this.field.getType();
    }

    public boolean isAccessible() {
        return this.field.isAccessible();
    }

    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.field.isAnnotationPresent(clazz);
    }

    public boolean isDefaultAccess() {
        boolean bl = !this.isPrivate() && !this.isProtected() && !this.isPublic();
        return bl;
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.field.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.field.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }

    public boolean isSynthetic() {
        return this.field.isSynthetic();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.field.getModifiers());
    }

    public void set(Object object, Object object2) throws ReflectionException {
        try {
            this.field.set(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Illegal access to field: ");
            ((StringBuilder)object2).append(this.getName());
            throw new ReflectionException(((StringBuilder)object2).toString(), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Argument not valid for field: ");
            ((StringBuilder)object).append(this.getName());
            throw new ReflectionException(((StringBuilder)object).toString(), illegalArgumentException);
        }
    }

    public void setAccessible(boolean bl) {
        this.field.setAccessible(bl);
    }
}

