/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.Arrays;

public class StringBuilder
implements Appendable,
CharSequence {
    static final int INITIAL_CAPACITY = 16;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public char[] chars;
    public int length;

    public StringBuilder() {
        this.chars = new char[16];
    }

    public StringBuilder(int n) {
        if (n >= 0) {
            this.chars = new char[n];
            return;
        }
        throw new NegativeArraySizeException();
    }

    public StringBuilder(StringBuilder stringBuilder) {
        int n = this.length = stringBuilder.length;
        this.chars = new char[n + 16];
        System.arraycopy(stringBuilder.chars, 0, this.chars, 0, n);
    }

    public StringBuilder(CharSequence charSequence) {
        this(charSequence.toString());
    }

    public StringBuilder(String string2) {
        int n = this.length = string2.length();
        this.chars = new char[n + 16];
        string2.getChars(0, n, this.chars, 0);
    }

    private void enlargeBuffer(int n) {
        char[] cArray = this.chars;
        int n2 = (cArray.length >> 1) + cArray.length + 2;
        if (n <= n2) {
            n = n2;
        }
        cArray = new char[n];
        System.arraycopy(this.chars, 0, cArray, 0, this.length);
        this.chars = cArray;
    }

    private void move(int n, int n2) {
        char[] cArray = this.chars;
        int n3 = cArray.length;
        int n4 = this.length;
        if (n3 - n4 >= n) {
            System.arraycopy(cArray, n2, cArray, n + n2, n4 - n2);
            return;
        }
        int n5 = n4 + n;
        n4 = n3 = (cArray.length << 1) + 2;
        if (n5 > n3) {
            n4 = n5;
        }
        cArray = new char[n4];
        System.arraycopy(this.chars, 0, cArray, 0, n2);
        System.arraycopy(this.chars, n2, cArray, n + n2, this.length - n2);
        this.chars = cArray;
    }

    public static int numChars(int n, int n2) {
        int n3 = n < 0 ? 2 : 1;
        while ((n /= n2) != 0) {
            ++n3;
        }
        return n3;
    }

    public static int numChars(long l, int n) {
        int n2 = l < 0L ? 2 : 1;
        while ((l /= (long)n) != 0L) {
            ++n2;
        }
        return n2;
    }

    @Override
    public StringBuilder append(char c) {
        this.append0(c);
        return this;
    }

    public StringBuilder append(double d) {
        this.append0(Double.toString(d));
        return this;
    }

    public StringBuilder append(float f) {
        this.append0(Float.toString(f));
        return this;
    }

    public StringBuilder append(int n) {
        return this.append(n, 0);
    }

    public StringBuilder append(int n, int n2) {
        return this.append(n, n2, '0');
    }

    public StringBuilder append(int n, int n2, char c) {
        if (n == Integer.MIN_VALUE) {
            this.append0("-2147483648");
            return this;
        }
        int n3 = n;
        if (n < 0) {
            this.append0('-');
            n3 = -n;
        }
        if (n2 > 1) {
            for (n = n2 - StringBuilder.numChars(n3, 10); n > 0; --n) {
                this.append(c);
            }
        }
        if (n3 >= 10000) {
            if (n3 >= 1000000000) {
                this.append0(digits[(int)((long)n3 % 10000000000L / 1000000000L)]);
            }
            if (n3 >= 100000000) {
                this.append0(digits[n3 % 1000000000 / 100000000]);
            }
            if (n3 >= 10000000) {
                this.append0(digits[n3 % 100000000 / 10000000]);
            }
            if (n3 >= 1000000) {
                this.append0(digits[n3 % 10000000 / 1000000]);
            }
            if (n3 >= 100000) {
                this.append0(digits[n3 % 1000000 / 100000]);
            }
            this.append0(digits[n3 % 100000 / 10000]);
        }
        if (n3 >= 1000) {
            this.append0(digits[n3 % 10000 / 1000]);
        }
        if (n3 >= 100) {
            this.append0(digits[n3 % 1000 / 100]);
        }
        if (n3 >= 10) {
            this.append0(digits[n3 % 100 / 10]);
        }
        this.append0(digits[n3 % 10]);
        return this;
    }

    public StringBuilder append(long l) {
        return this.append(l, 0);
    }

    public StringBuilder append(long l, int n) {
        return this.append(l, n, '0');
    }

    public StringBuilder append(long l, int n, char c) {
        if (l == Long.MIN_VALUE) {
            this.append0("-9223372036854775808");
            return this;
        }
        long l2 = l;
        if (l < 0L) {
            this.append0('-');
            l2 = -l;
        }
        if (n > 1) {
            n -= StringBuilder.numChars(l2, 10);
            while (n > 0) {
                this.append(c);
                --n;
            }
        }
        if (l2 >= 10000L) {
            if (l2 >= 1000000000000000000L) {
                char[] cArray = digits;
                double d = l2;
                Double.isNaN(d);
                this.append0(cArray[(int)(d % 1.0E19 / 1.0E18)]);
            }
            if (l2 >= 100000000000000000L) {
                this.append0(digits[(int)(l2 % 1000000000000000000L / 100000000000000000L)]);
            }
            if (l2 >= 10000000000000000L) {
                this.append0(digits[(int)(l2 % 100000000000000000L / 10000000000000000L)]);
            }
            if (l2 >= 1000000000000000L) {
                this.append0(digits[(int)(l2 % 10000000000000000L / 1000000000000000L)]);
            }
            if (l2 >= 100000000000000L) {
                this.append0(digits[(int)(l2 % 1000000000000000L / 100000000000000L)]);
            }
            if (l2 >= 10000000000000L) {
                this.append0(digits[(int)(l2 % 100000000000000L / 10000000000000L)]);
            }
            if (l2 >= 1000000000000L) {
                this.append0(digits[(int)(l2 % 10000000000000L / 1000000000000L)]);
            }
            if (l2 >= 100000000000L) {
                this.append0(digits[(int)(l2 % 1000000000000L / 100000000000L)]);
            }
            if (l2 >= 10000000000L) {
                this.append0(digits[(int)(l2 % 100000000000L / 10000000000L)]);
            }
            if (l2 >= 1000000000L) {
                this.append0(digits[(int)(l2 % 10000000000L / 1000000000L)]);
            }
            if (l2 >= 100000000L) {
                this.append0(digits[(int)(l2 % 1000000000L / 100000000L)]);
            }
            if (l2 >= 10000000L) {
                this.append0(digits[(int)(l2 % 100000000L / 10000000L)]);
            }
            if (l2 >= 1000000L) {
                this.append0(digits[(int)(l2 % 10000000L / 1000000L)]);
            }
            if (l2 >= 100000L) {
                this.append0(digits[(int)(l2 % 1000000L / 100000L)]);
            }
            this.append0(digits[(int)(l2 % 100000L / 10000L)]);
        }
        if (l2 >= 1000L) {
            this.append0(digits[(int)(l2 % 10000L / 1000L)]);
        }
        if (l2 >= 100L) {
            this.append0(digits[(int)(l2 % 1000L / 100L)]);
        }
        if (l2 >= 10L) {
            this.append0(digits[(int)(l2 % 100L / 10L)]);
        }
        this.append0(digits[(int)(l2 % 10L)]);
        return this;
    }

    public StringBuilder append(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            this.appendNull();
        } else {
            this.append0(stringBuilder.chars, 0, stringBuilder.length);
        }
        return this;
    }

    public StringBuilder append(StringBuilder stringBuilder, int n, int n2) {
        if (stringBuilder == null) {
            this.appendNull();
        } else {
            this.append0(stringBuilder.chars, n, n2);
        }
        return this;
    }

    @Override
    public StringBuilder append(CharSequence charSequence) {
        if (charSequence == null) {
            this.appendNull();
        } else if (charSequence instanceof StringBuilder) {
            charSequence = (StringBuilder)charSequence;
            this.append0(((StringBuilder)charSequence).chars, 0, ((StringBuilder)charSequence).length);
        } else {
            this.append0(charSequence.toString());
        }
        return this;
    }

    @Override
    public StringBuilder append(CharSequence charSequence, int n, int n2) {
        this.append0(charSequence, n, n2);
        return this;
    }

    public StringBuilder append(Object object) {
        if (object == null) {
            this.appendNull();
        } else {
            this.append0(object.toString());
        }
        return this;
    }

    public StringBuilder append(String string2) {
        this.append0(string2);
        return this;
    }

    public StringBuilder append(boolean bl) {
        String string2 = bl ? "true" : "false";
        this.append0(string2);
        return this;
    }

    public StringBuilder append(char[] cArray) {
        this.append0(cArray);
        return this;
    }

    public StringBuilder append(char[] cArray, int n, int n2) {
        this.append0(cArray, n, n2);
        return this;
    }

    final void append0(char c) {
        int n = this.length;
        if (n == this.chars.length) {
            this.enlargeBuffer(n + 1);
        }
        char[] cArray = this.chars;
        n = this.length;
        this.length = n + 1;
        cArray[n] = c;
    }

    final void append0(CharSequence charSequence, int n, int n2) {
        CharSequence charSequence2 = charSequence;
        if (charSequence == null) {
            charSequence2 = "null";
        }
        if (n >= 0 && n2 >= 0 && n <= n2 && n2 <= charSequence2.length()) {
            this.append0(charSequence2.subSequence(n, n2).toString());
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    final void append0(String string2) {
        if (string2 == null) {
            this.appendNull();
            return;
        }
        int n = string2.length();
        int n2 = this.length + n;
        if (n2 > this.chars.length) {
            this.enlargeBuffer(n2);
        }
        string2.getChars(0, n, this.chars, this.length);
        this.length = n2;
    }

    final void append0(char[] cArray) {
        int n = this.length + cArray.length;
        if (n > this.chars.length) {
            this.enlargeBuffer(n);
        }
        System.arraycopy(cArray, 0, this.chars, this.length, cArray.length);
        this.length = n;
    }

    final void append0(char[] object, int n, int n2) {
        if (n <= ((char[])object).length && n >= 0) {
            if (n2 >= 0 && ((char[])object).length - n >= n2) {
                int n3 = this.length + n2;
                if (n3 > this.chars.length) {
                    this.enlargeBuffer(n3);
                }
                System.arraycopy(object, n, this.chars, this.length, n2);
                this.length = n3;
                return;
            }
            object = new java.lang.StringBuilder();
            ((java.lang.StringBuilder)object).append("Length out of bounds: ");
            ((java.lang.StringBuilder)object).append(n2);
            throw new ArrayIndexOutOfBoundsException(((java.lang.StringBuilder)object).toString());
        }
        object = new java.lang.StringBuilder();
        ((java.lang.StringBuilder)object).append("Offset out of bounds: ");
        ((java.lang.StringBuilder)object).append(n);
        throw new ArrayIndexOutOfBoundsException(((java.lang.StringBuilder)object).toString());
    }

    public StringBuilder appendCodePoint(int n) {
        this.append0(Character.toChars(n));
        return this;
    }

    public StringBuilder appendLine(String string2) {
        this.append0(string2);
        this.append0('\n');
        return this;
    }

    final void appendNull() {
        int n = this.length + 4;
        if (n > this.chars.length) {
            this.enlargeBuffer(n);
        }
        char[] cArray = this.chars;
        n = this.length;
        this.length = n + 1;
        cArray[n] = (char)110;
        n = this.length;
        this.length = n + 1;
        cArray[n] = (char)117;
        n = this.length;
        this.length = n + 1;
        cArray[n] = (char)108;
        n = this.length;
        this.length = n + 1;
        cArray[n] = (char)108;
    }

    public int capacity() {
        return this.chars.length;
    }

    @Override
    public char charAt(int n) {
        if (n >= 0 && n < this.length) {
            return this.chars[n];
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public void clear() {
        this.length = 0;
    }

    public int codePointAt(int n) {
        int n2;
        if (n >= 0 && n < (n2 = this.length)) {
            return Character.codePointAt(this.chars, n, n2);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointBefore(int n) {
        if (n >= 1 && n <= this.length) {
            return Character.codePointBefore(this.chars, n);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int codePointCount(int n, int n2) {
        if (n >= 0 && n2 <= this.length && n <= n2) {
            return Character.codePointCount(this.chars, n, n2 - n);
        }
        throw new StringIndexOutOfBoundsException();
    }

    public boolean contains(String string2) {
        boolean bl = false;
        if (this.indexOf(string2, 0) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean containsIgnoreCase(String string2) {
        boolean bl = false;
        if (this.indexOfIgnoreCase(string2, 0) != -1) {
            bl = true;
        }
        return bl;
    }

    public StringBuilder delete(int n, int n2) {
        this.delete0(n, n2);
        return this;
    }

    final void delete0(int n, int n2) {
        if (n >= 0) {
            int n3 = this.length;
            int n4 = n2;
            if (n2 > n3) {
                n4 = n3;
            }
            if (n4 == n) {
                return;
            }
            if (n4 > n) {
                n2 = this.length - n4;
                if (n2 >= 0) {
                    char[] cArray = this.chars;
                    System.arraycopy(cArray, n4, cArray, n, n2);
                }
                this.length -= n4 - n;
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder deleteCharAt(int n) {
        this.deleteCharAt0(n);
        return this;
    }

    final void deleteCharAt0(int n) {
        int n2;
        if (n >= 0 && n < (n2 = this.length)) {
            if ((n2 = n2 - n - 1) > 0) {
                char[] cArray = this.chars;
                System.arraycopy(cArray, n + 1, cArray, n, n2);
            }
            --this.length;
            return;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public void ensureCapacity(int n) {
        char[] cArray = this.chars;
        if (n > cArray.length) {
            int n2 = (cArray.length << 1) + 2;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            this.enlargeBuffer(n3);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Object object2 = (StringBuilder)object;
        int n = this.length;
        if (n != ((StringBuilder)object2).length) {
            return false;
        }
        object = this.chars;
        object2 = ((StringBuilder)object2).chars;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(StringBuilder object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        int n = this.length;
        if (n != ((StringBuilder)object).length) {
            return false;
        }
        char[] cArray = this.chars;
        object = ((StringBuilder)object).chars;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = Character.toUpperCase((char)object[i]);
            if (c == c2 || c == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string2) {
        if (string2 == null) {
            return false;
        }
        int n = this.length;
        if (n != string2.length()) {
            return false;
        }
        char[] cArray = this.chars;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            char c2 = Character.toUpperCase(string2.charAt(i));
            if (c == c2 || c == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4 = this.length;
        if (n <= n4 && n2 <= n4 && n <= n2) {
            System.arraycopy(this.chars, n, cArray, n3, n2 - n);
            return;
        }
        throw new StringIndexOutOfBoundsException();
    }

    final char[] getValue() {
        return this.chars;
    }

    public int hashCode() {
        return (this.length + 31) * 31 + Arrays.hashCode(this.chars);
    }

    public int indexOf(String string2) {
        return this.indexOf(string2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int indexOf(String string2, int n) {
        int n2;
        int n3 = n;
        if (n < 0) {
            n3 = 0;
        }
        if ((n2 = string2.length()) == 0) {
            n = this.length;
            if (n3 < n) return n3;
            if (n3 != 0) return n;
            return n3;
        }
        int n4 = this.length - n2;
        if (n3 > n4) {
            return -1;
        }
        char c = string2.charAt(0);
        while (n3 <= n4) {
            if (this.chars[n3] == c) {
                char[] cArray;
                n = 1;
                if (n == 0) {
                    return -1;
                }
                n = n3;
                int n5 = 0;
                while (++n5 < n2 && (cArray = this.chars)[++n] == string2.charAt(n5)) {
                }
                if (n5 == n2) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int indexOfIgnoreCase(String string2, int n) {
        int n2;
        int n3 = n;
        if (n < 0) {
            n3 = 0;
        }
        if ((n2 = string2.length()) == 0) {
            n = this.length;
            if (n3 < n) return n3;
            if (n3 != 0) return n;
            return n3;
        }
        int n4 = this.length - n2;
        if (n3 > n4) {
            return -1;
        }
        char c = Character.toUpperCase(string2.charAt(0));
        char c2 = Character.toLowerCase(c);
        while (n3 <= n4) {
            n = this.chars[n3];
            if (n == c || n == c2) {
                int n5;
                n = 1;
                if (n == 0) {
                    return -1;
                }
                n = n3;
                int n6 = 0;
                while ((n5 = n6 + 1) < n2) {
                    char[] cArray = this.chars;
                    int n7 = n + 1;
                    char c3 = cArray[n7];
                    char c4 = Character.toUpperCase(string2.charAt(n5));
                    n6 = n5;
                    n = n7;
                    if (c3 == c4) continue;
                    n6 = n5;
                    n = n7;
                    if (c3 == Character.toLowerCase(c4)) continue;
                }
                if (n5 == n2) {
                    return n3;
                }
            }
            ++n3;
        }
        return -1;
    }

    public StringBuilder insert(int n, char c) {
        this.insert0(n, c);
        return this;
    }

    public StringBuilder insert(int n, double d) {
        this.insert0(n, Double.toString(d));
        return this;
    }

    public StringBuilder insert(int n, float f) {
        this.insert0(n, Float.toString(f));
        return this;
    }

    public StringBuilder insert(int n, int n2) {
        this.insert0(n, Integer.toString(n2));
        return this;
    }

    public StringBuilder insert(int n, long l) {
        this.insert0(n, Long.toString(l));
        return this;
    }

    public StringBuilder insert(int n, CharSequence charSequence) {
        charSequence = charSequence == null ? "null" : charSequence.toString();
        this.insert0(n, (String)charSequence);
        return this;
    }

    public StringBuilder insert(int n, CharSequence charSequence, int n2, int n3) {
        this.insert0(n, charSequence, n2, n3);
        return this;
    }

    public StringBuilder insert(int n, Object object) {
        object = object == null ? "null" : object.toString();
        this.insert0(n, (String)object);
        return this;
    }

    public StringBuilder insert(int n, String string2) {
        this.insert0(n, string2);
        return this;
    }

    public StringBuilder insert(int n, boolean bl) {
        String string2 = bl ? "true" : "false";
        this.insert0(n, string2);
        return this;
    }

    public StringBuilder insert(int n, char[] cArray) {
        this.insert0(n, cArray);
        return this;
    }

    public StringBuilder insert(int n, char[] cArray, int n2, int n3) {
        this.insert0(n, cArray, n2, n3);
        return this;
    }

    final void insert0(int n, char c) {
        if (n >= 0 && n <= this.length) {
            this.move(1, n);
            this.chars[n] = c;
            ++this.length;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(n);
    }

    final void insert0(int n, CharSequence charSequence, int n2, int n3) {
        CharSequence charSequence2 = charSequence;
        if (charSequence == null) {
            charSequence2 = "null";
        }
        if (n >= 0 && n <= this.length && n2 >= 0 && n3 >= 0 && n2 <= n3 && n3 <= charSequence2.length()) {
            this.insert0(n, charSequence2.subSequence(n2, n3).toString());
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    final void insert0(int n, String string2) {
        if (n >= 0 && n <= this.length) {
            int n2;
            String string3 = string2;
            if (string2 == null) {
                string3 = "null";
            }
            if ((n2 = string3.length()) != 0) {
                this.move(n2, n);
                string3.getChars(0, n2, this.chars, n);
                this.length += n2;
            }
            return;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    final void insert0(int n, char[] cArray) {
        if (n >= 0 && n <= this.length) {
            if (cArray.length != 0) {
                this.move(cArray.length, n);
                System.arraycopy(cArray, 0, cArray, n, cArray.length);
                this.length += cArray.length;
            }
            return;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    final void insert0(int n, char[] cArray, int n2, int n3) {
        if (n >= 0 && n <= n3) {
            if (n2 >= 0 && n3 >= 0 && n3 <= cArray.length - n2) {
                if (n3 != 0) {
                    this.move(n3, n);
                    System.arraycopy(cArray, n2, this.chars, n, n3);
                    this.length += n3;
                }
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("offset ");
            stringBuilder.append(n2);
            stringBuilder.append(", length ");
            stringBuilder.append(n3);
            stringBuilder.append(", char[].length ");
            stringBuilder.append(cArray.length);
            throw new StringIndexOutOfBoundsException(stringBuilder.toString());
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public int lastIndexOf(String string2) {
        return this.lastIndexOf(string2, this.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int lastIndexOf(String string2, int n) {
        int n2;
        int n3 = string2.length();
        if (n3 > (n2 = this.length)) return -1;
        if (n < 0) return -1;
        if (n3 > 0) {
            int n4 = n;
            if (n > n2 - n3) {
                n4 = n2 - n3;
            }
            char c = string2.charAt(0);
            n = n4;
            while (n >= 0) {
                char[] cArray;
                if (this.chars[n] != c) {
                    --n;
                    continue;
                }
                n4 = 1;
                if (n4 == 0) {
                    return -1;
                }
                n4 = n;
                n2 = 0;
                while (++n2 < n3 && (cArray = this.chars)[++n4] == string2.charAt(n2)) {
                }
                if (n2 == n3) {
                    return n;
                }
                --n;
            }
            return -1;
        }
        if (n >= n2) return n2;
        return n;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int offsetByCodePoints(int n, int n2) {
        return Character.offsetByCodePoints(this.chars, 0, this.length, n, n2);
    }

    public StringBuilder replace(char c, String string2) {
        int n = string2.length();
        int n2 = 0;
        while (n2 != this.length) {
            if (this.chars[n2] == c) {
                this.replace0(n2, n2 + 1, string2);
                n2 += n;
                continue;
            }
            ++n2;
        }
        return this;
    }

    public StringBuilder replace(int n, int n2, String string2) {
        this.replace0(n, n2, string2);
        return this;
    }

    public StringBuilder replace(String string2, String string3) {
        int n = string2.length();
        int n2 = string3.length();
        int n3 = 0;
        while ((n3 = this.indexOf(string2, n3)) != -1) {
            this.replace0(n3, n3 + n, string3);
            n3 += n2;
        }
        return this;
    }

    final void replace0(int n, int n2, String string2) {
        if (n >= 0) {
            int n3 = this.length;
            int n4 = n2;
            if (n2 > n3) {
                n4 = n3;
            }
            if (n4 > n) {
                n2 = string2.length();
                n3 = n4 - n - n2;
                if (n3 > 0) {
                    char[] cArray = this.chars;
                    System.arraycopy(cArray, n4, cArray, n + n2, this.length - n4);
                } else if (n3 < 0) {
                    this.move(-n3, n4);
                }
                string2.getChars(0, n2, this.chars, n);
                this.length -= n3;
                return;
            }
            if (n == n4) {
                if (string2 != null) {
                    this.insert0(n, string2);
                    return;
                }
                throw new NullPointerException();
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    public StringBuilder reverse() {
        this.reverse0();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    final void reverse0() {
        var1_1 = this.length;
        if (var1_1 < 2) {
            return;
        }
        var2_2 = var1_1 - 1;
        var3_3 = this.chars;
        var4_4 = var3_3[0];
        var5_5 = var3_3[var2_2];
        var6_6 = var1_1 / 2;
        var7_7 = '\u0001';
        var8_8 = true;
        var1_1 = 0;
        while (var1_1 < var6_6) {
            block9: {
                var3_3 = this.chars;
                var9_9 = var1_1 + 1;
                var10_10 = var3_3[var9_9];
                var11_11 = var2_2 - 1;
                var12_12 = var3_3[var11_11];
                if ((var7_7 = var7_7 != '\u0000' && var10_10 >= '\udc00' && var10_10 <= '\udfff' && var4_4 >= '\ud800' && var4_4 <= '\udbff' ? '\u0001' : '\u0000') != '\u0000' && this.length < 3) {
                    return;
                }
                if (var7_7 != (var8_8 = var8_8 != false && var12_12 >= '\ud800' && var12_12 <= '\udbff' && var5_5 >= '\udc00' && var5_5 <= '\udfff')) break block9;
                if (var7_7 != '\u0000') {
                    var3_3 = this.chars;
                    var3_3[var2_2] = var10_10;
                    var3_3[var11_11] = var4_4;
                    var3_3[var1_1] = var12_12;
                    var3_3[var9_9] = var5_5;
                    var4_4 = var3_3[var1_1 + 2];
                    var5_5 = var3_3[var2_2 - 2];
                    --var2_2;
                    var1_1 = var9_9;
                } else {
                    var3_3 = this.chars;
                    var3_3[var2_2] = var4_4;
                    var3_3[var1_1] = var5_5;
                    var5_5 = var12_12;
                    var4_4 = var10_10;
                }
                var10_10 = '\u0001';
                ** GOTO lbl46
            }
            if (var7_7 != '\u0000') {
                var3_3 = this.chars;
                var3_3[var2_2] = var10_10;
                var3_3[var1_1] = var5_5;
                var5_5 = var12_12;
                var10_10 = '\u0000';
lbl46:
                // 2 sources

                var8_8 = true;
            } else {
                var3_3 = this.chars;
                var3_3[var2_2] = var4_4;
                var3_3[var1_1] = var12_12;
                var4_4 = var10_10;
                var10_10 = '\u0001';
                var8_8 = false;
            }
            ++var1_1;
            --var2_2;
            var7_7 = var10_10;
        }
        if (!((this.length & 1) != 1 || var7_7 != '\u0000' && var8_8)) {
            var3_3 = this.chars;
            if (var7_7 != '\u0000') {
                var4_4 = var5_5;
            }
            var3_3[var2_2] = var4_4;
        }
    }

    public void setCharAt(int n, char c) {
        if (n >= 0 && n < this.length) {
            this.chars[n] = c;
            return;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public void setLength(int n) {
        if (n >= 0) {
            char[] cArray = this.chars;
            if (n > cArray.length) {
                this.enlargeBuffer(n);
            } else {
                int n2 = this.length;
                if (n2 < n) {
                    Arrays.fill(cArray, n2, n, '\u0000');
                }
            }
            this.length = n;
            return;
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String substring(int n) {
        int n2;
        if (n >= 0 && n <= (n2 = this.length)) {
            if (n == n2) {
                return "";
            }
            return new String(this.chars, n, n2 - n);
        }
        throw new StringIndexOutOfBoundsException(n);
    }

    public String substring(int n, int n2) {
        if (n >= 0 && n <= n2 && n2 <= this.length) {
            if (n == n2) {
                return "";
            }
            return new String(this.chars, n, n2 - n);
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public String toString() {
        int n = this.length;
        if (n == 0) {
            return "";
        }
        return new String(this.chars, 0, n);
    }

    public void trimToSize() {
        int n = this.length;
        char[] cArray = this.chars;
        if (n < cArray.length) {
            char[] cArray2 = new char[n];
            System.arraycopy(cArray, 0, cArray2, 0, n);
            this.chars = cArray2;
        }
    }
}

