/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.ByteBuffer;

public final class ScreenUtils {
    public static byte[] getFrameBufferPixels(int n, int n2, int n3, int n4, boolean bl) {
        Gdx.gl.glPixelStorei(3333, 1);
        int n5 = n3 * n4 * 4;
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer(n5);
        Gdx.gl.glReadPixels(n, n2, n3, n4, 6408, 5121, byteBuffer);
        byte[] byArray = new byte[n5];
        if (bl) {
            n2 = n3 * 4;
            for (n = 0; n < n4; ++n) {
                byteBuffer.position((n4 - n - 1) * n2);
                byteBuffer.get(byArray, n * n2, n2);
            }
        } else {
            byteBuffer.clear();
            byteBuffer.get(byArray);
        }
        return byArray;
    }

    public static byte[] getFrameBufferPixels(boolean bl) {
        return ScreenUtils.getFrameBufferPixels(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight(), bl);
    }

    public static Pixmap getFrameBufferPixmap(int n, int n2, int n3, int n4) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(n3, n4, Pixmap.Format.RGBA8888);
        ByteBuffer byteBuffer = pixmap.getPixels();
        Gdx.gl.glReadPixels(n, n2, n3, n4, 6408, 5121, byteBuffer);
        return pixmap;
    }

    public static TextureRegion getFrameBufferTexture() {
        return ScreenUtils.getFrameBufferTexture(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
    }

    public static TextureRegion getFrameBufferTexture(int n, int n2, int n3, int n4) {
        int n5 = MathUtils.nextPowerOfTwo(n3);
        int n6 = MathUtils.nextPowerOfTwo(n4);
        Pixmap pixmap = ScreenUtils.getFrameBufferPixmap(n, n2, n3, n4);
        Pixmap pixmap2 = new Pixmap(n5, n6, Pixmap.Format.RGBA8888);
        pixmap2.setBlending(Pixmap.Blending.None);
        pixmap2.drawPixmap(pixmap, 0, 0);
        TextureRegion textureRegion = new TextureRegion(new Texture(pixmap2), 0, n4, n3, -n4);
        pixmap2.dispose();
        pixmap.dispose();
        return textureRegion;
    }
}

