/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IdentityMap;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectMap<K, V>
implements Iterable<Entry<K, V>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    static final Object dummy = new Object();
    int capacity;
    Entries entries1;
    Entries entries2;
    private int hashShift;
    K[] keyTable;
    Keys keys1;
    Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    V[] valueTable;
    Values values1;
    Values values2;

    public ObjectMap() {
        this(51, 0.8f);
    }

    public ObjectMap(int n) {
        this(n, 0.8f);
    }

    public ObjectMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new Object[this.capacity + this.stashCapacity];
                    this.valueTable = new Object[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public ObjectMap(ObjectMap<? extends K, ? extends V> objectMap) {
        this((int)Math.floor((float)objectMap.capacity * objectMap.loadFactor), objectMap.loadFactor);
        this.stashSize = objectMap.stashSize;
        Object[] objectArray = objectMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = objectMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = objectMap.size;
    }

    private boolean containsKeyStash(K k) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            return true;
        }
        return false;
    }

    private V getStash(K k, V v) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            return this.valueTable[i];
        }
        return v;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(K k, V v, int n, K k2, int n2, K k3, int n3, K k4) {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.mask;
        int n5 = this.pushIterations;
        int n6 = n;
        int n7 = n3;
        n = 0;
        n3 = n6;
        V v2 = v;
        K k5 = k;
        n6 = n7;
        do {
            if ((n7 = MathUtils.random(2)) != 0) {
                if (n7 != 1) {
                    v = VArray[n6];
                    KArray[n6] = k5;
                    VArray[n6] = v2;
                    k = k4;
                } else {
                    v = VArray[n2];
                    KArray[n2] = k5;
                    VArray[n2] = v2;
                    k = k3;
                }
            } else {
                v = VArray[n3];
                KArray[n3] = k5;
                VArray[n3] = v2;
                k = k2;
            }
            n6 = k.hashCode();
            n3 = n6 & n4;
            k2 = KArray[n3];
            if (k2 == null) {
                KArray[n3] = k;
                VArray[n3] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n2 = this.hash2(n6);
            k3 = KArray[n2];
            if (k3 == null) {
                KArray[n2] = k;
                VArray[n2] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            k4 = KArray[n6 = this.hash3(n6)];
            if (k4 == null) {
                KArray[n6] = k;
                VArray[n6] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = n + 1;
            k5 = k;
            v2 = v;
            n = n7;
        } while (n7 != n5);
        this.putStash(k, v);
    }

    private void putResize(K k, V v) {
        Object object = this.keyTable;
        int n = k.hashCode();
        int n2 = n & this.mask;
        K k2 = object[n2];
        if (k2 == null) {
            object[n2] = k;
            this.valueTable[n2] = v;
            int n3 = this.size;
            this.size = n3 + 1;
            if (n3 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        K[] KArray = this.keyTable;
        int n4 = this.hash2(n);
        object = KArray[n4];
        if (object == null) {
            KArray[n4] = k;
            this.valueTable[n4] = v;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        KArray = this.keyTable;
        K k3 = KArray[n = this.hash3(n)];
        if (k3 == null) {
            KArray[n] = k;
            this.valueTable[n] = v;
            n4 = this.size;
            this.size = n4 + 1;
            if (n4 >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, v, n2, k2, n4, object, n, k3);
    }

    private void putStash(K k, V v) {
        int n = this.stashSize;
        if (n == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(k, v);
            return;
        }
        int n2 = this.capacity + n;
        this.keyTable[n2] = k;
        this.valueTable[n2] = v;
        this.stashSize = n + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new Object[n + n4];
        this.valueTable = new Object[n + n4];
        n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                K k = KArray[n];
                if (k == null) continue;
                this.putResize(k, VArray[n]);
            }
        }
    }

    private String toString(String string2, boolean bl) {
        K k;
        int n;
        int n2;
        V[] VArray;
        K[] KArray;
        StringBuilder stringBuilder;
        block6: {
            int n3;
            if (this.size == 0) {
                string2 = bl ? "{}" : "";
                return string2;
            }
            stringBuilder = new StringBuilder(32);
            if (bl) {
                stringBuilder.append('{');
            }
            KArray = this.keyTable;
            VArray = this.valueTable;
            n2 = KArray.length;
            while (true) {
                n = n3 = n2 - 1;
                if (n2 <= 0) break block6;
                k = KArray[n3];
                if (k != null) break;
                n2 = n3;
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n3]);
            n = n3;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            k = KArray[n2];
            if (k != null) {
                stringBuilder.append(string2);
                stringBuilder.append(k);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n2]);
            }
            n = n2;
        }
        if (bl) {
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            KArray[n2] = null;
            VArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(K k) {
        int n = this.mask;
        int n2 = k.hashCode();
        if (!(k.equals(this.keyTable[n & n2]) || k.equals(this.keyTable[n = this.hash2(n2)]) || k.equals(this.keyTable[n2 = this.hash3(n2)]))) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    public boolean containsValue(Object KArray, boolean bl) {
        V[] VArray = this.valueTable;
        if (KArray == null) {
            KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (KArray[n2] != null && VArray[n2] == null) {
                        return true;
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == KArray) {
                        return true;
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (KArray.equals(VArray[n4])) {
                    return true;
                }
                n = n4;
            }
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<K, V> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectMap)) {
            return false;
        }
        ObjectMap objectMap = (ObjectMap)object;
        if (objectMap.size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            if (k == null || !((object = VArray[i]) == null ? objectMap.get(k, dummy) != null : !object.equals(objectMap.get(k)))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIdentity(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IdentityMap)) {
            return false;
        }
        object = (IdentityMap)object;
        if (((IdentityMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            if (k == null || VArray[i] == ((IdentityMap)object).get(k, dummy)) continue;
            return false;
        }
        return true;
    }

    public K findKey(Object KArray, boolean bl) {
        V[] VArray = this.valueTable;
        if (KArray == null) {
            KArray = this.keyTable;
            int n = this.capacity + this.stashSize;
            while (true) {
                int n2 = n - 1;
                if (n > 0) {
                    if (KArray[n2] != null && VArray[n2] == null) {
                        return KArray[n2];
                    }
                    n = n2;
                    continue;
                }
                break;
            }
        } else if (bl) {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n3 = n - 1;
                if (n > 0) {
                    if (VArray[n3] == KArray) {
                        return this.keyTable[n3];
                    }
                    n = n3;
                    continue;
                }
                break;
            }
        } else {
            int n = this.capacity + this.stashSize;
            while (true) {
                int n4 = n - 1;
                if (n <= 0) break;
                if (KArray.equals(VArray[n4])) {
                    return this.keyTable[n4];
                }
                n = n4;
            }
        }
        return null;
    }

    public V get(K k) {
        int n;
        int n2 = k.hashCode();
        int n3 = n = this.mask & n2;
        if (!k.equals(this.keyTable[n])) {
            n3 = n = this.hash2(n2);
            if (!k.equals(this.keyTable[n])) {
                n3 = n = this.hash3(n2);
                if (!k.equals(this.keyTable[n])) {
                    return this.getStash(k, null);
                }
            }
        }
        return this.valueTable[n3];
    }

    public V get(K k, V v) {
        int n;
        int n2 = k.hashCode();
        int n3 = n = this.mask & n2;
        if (!k.equals(this.keyTable[n])) {
            n3 = n = this.hash2(n2);
            if (!k.equals(this.keyTable[n])) {
                n3 = n = this.hash3(n2);
                if (!k.equals(this.keyTable[n])) {
                    return this.getStash(k, v);
                }
            }
        }
        return this.valueTable[n3];
    }

    public int hashCode() {
        K[] KArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            Object object = KArray[i];
            int n4 = n3;
            if (object != null) {
                n3 += object.hashCode() * 31;
                object = VArray[i];
                n4 = n3;
                if (object != null) {
                    n4 = n3 + object.hashCode();
                }
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public Entries<K, V> iterator() {
        return this.entries();
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public V put(K object, V v) {
        if (object != null) {
            K[] KArray = this.keyTable;
            int n = object.hashCode();
            int n2 = n & this.mask;
            K k = KArray[n2];
            if (object.equals(k)) {
                object = this.valueTable;
                Object object2 = object[n2];
                object[n2] = v;
                return (V)object2;
            }
            int n3 = this.hash2(n);
            K k2 = KArray[n3];
            if (object.equals(k2)) {
                object = this.valueTable;
                Object object3 = object[n3];
                object[n3] = v;
                return (V)object3;
            }
            int n4 = this.hash3(n);
            Object object4 = KArray[n4];
            if (object.equals(object4)) {
                object = this.valueTable;
                object4 = object[n4];
                object[n4] = v;
                return (V)object4;
            }
            int n5 = this.capacity;
            int n6 = this.stashSize;
            for (n = n5; n < n6 + n5; ++n) {
                if (!object.equals(KArray[n])) continue;
                object4 = this.valueTable;
                object = object4[n];
                object4[n] = v;
                return (V)object;
            }
            if (k == null) {
                KArray[n2] = object;
                this.valueTable[n2] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            if (k2 == null) {
                KArray[n3] = object;
                this.valueTable[n3] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            if (object4 == null) {
                KArray[n4] = object;
                this.valueTable[n4] = v;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return null;
            }
            this.push(object, v, n2, k, n3, k2, n4, object4);
            return null;
        }
        object = new IllegalArgumentException("key cannot be null.");
        throw object;
    }

    public void putAll(ObjectMap<? extends K, ? extends V> object) {
        this.ensureCapacity(((ObjectMap)object).size);
        Iterator iterator = ((ObjectMap)object).iterator();
        while (iterator.hasNext()) {
            object = (Entry)iterator.next();
            this.put(((Entry)object).key, ((Entry)object).value);
        }
    }

    public V remove(K object) {
        int n = object.hashCode();
        int n2 = this.mask & n;
        if (object.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            object = this.valueTable;
            K k = object[n2];
            object[n2] = null;
            --this.size;
            return (V)k;
        }
        n2 = this.hash2(n);
        if (object.equals(this.keyTable[n2])) {
            this.keyTable[n2] = null;
            V[] VArray = this.valueTable;
            object = VArray[n2];
            VArray[n2] = null;
            --this.size;
            return (V)object;
        }
        if (object.equals(this.keyTable[n = this.hash3(n)])) {
            this.keyTable[n] = null;
            object = this.valueTable;
            K k = object[n];
            object[n] = null;
            --this.size;
            return (V)k;
        }
        return this.removeStash(object);
    }

    V removeStash(K object) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!object.equals(KArray[i])) continue;
            object = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return (V)object;
        }
        return null;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            K[] KArray = this.keyTable;
            KArray[n] = KArray[n2];
            V[] VArray = this.valueTable;
            VArray[n] = VArray[n2];
            KArray[n2] = null;
            VArray[n2] = null;
        } else {
            this.keyTable[n] = null;
            this.valueTable[n] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        return this.toString(", ", true);
    }

    public String toString(String string2) {
        return this.toString(string2, false);
    }

    public Values<V> values() {
        if (Collections.allocateIterators) {
            return new Values(this);
        }
        if (this.values1 == null) {
            this.values1 = new Values(this);
            this.values2 = new Values(this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<K, V>
    extends MapIterator<K, V, Entry<K, V>> {
        Entry<K, V> entry = new Entry();

        public Entries(ObjectMap<K, V> objectMap) {
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public Entries<K, V> iterator() {
            return this;
        }

        @Override
        public Entry<K, V> next() {
            if (this.hasNext) {
                if (this.valid) {
                    K[] KArray = this.map.keyTable;
                    this.entry.key = KArray[this.nextIndex];
                    this.entry.value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }
    }

    public static class Entry<K, V> {
        public K key;
        public V value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys<K>
    extends MapIterator<K, Object, K> {
        public Keys(ObjectMap<K, ?> objectMap) {
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object k = this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return k;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.map.size));
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    private static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I> {
        int currentIndex;
        public boolean hasNext;
        final ObjectMap<K, V> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(ObjectMap<K, V> objectMap) {
            this.map = objectMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                K[] KArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
            }
        }

        @Override
        public void remove() {
            int n = this.currentIndex;
            if (n >= 0) {
                if (n >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = null;
                    this.map.valueTable[this.currentIndex] = null;
                }
                this.currentIndex = -1;
                ObjectMap<K, V> objectMap = this.map;
                --objectMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }
    }

    public static class Values<V>
    extends MapIterator<Object, V, V> {
        public Values(ObjectMap<?, V> objectMap) {
            super(objectMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Values<V> iterator() {
            return this;
        }

        @Override
        public V next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object v = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return v;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public Array<V> toArray() {
            return this.toArray(new Array(true, this.map.size));
        }

        public Array<V> toArray(Array<V> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }
}

