/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Collections;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ObjectIntMap<K>
implements Iterable<Entry<K>> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    int capacity;
    private Entries entries1;
    private Entries entries2;
    private int hashShift;
    K[] keyTable;
    private Keys keys1;
    private Keys keys2;
    private float loadFactor;
    private int mask;
    private int pushIterations;
    public int size;
    private int stashCapacity;
    int stashSize;
    private int threshold;
    int[] valueTable;
    private Values values1;
    private Values values2;

    public ObjectIntMap() {
        this(51, 0.8f);
    }

    public ObjectIntMap(int n) {
        this(n, 0.8f);
    }

    public ObjectIntMap(int n, float f) {
        if (n >= 0) {
            if ((n = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / f))) <= 0x40000000) {
                this.capacity = n;
                if (!(f <= 0.0f)) {
                    this.loadFactor = f;
                    n = this.capacity;
                    this.threshold = (int)((float)n * f);
                    this.mask = n - 1;
                    this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
                    this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
                    this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
                    this.keyTable = new Object[this.capacity + this.stashCapacity];
                    this.valueTable = new int[this.keyTable.length];
                    return;
                }
                java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
                stringBuilder.append("loadFactor must be > 0: ");
                stringBuilder.append(f);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("initialCapacity is too large: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("initialCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public ObjectIntMap(ObjectIntMap<? extends K> objectIntMap) {
        this((int)Math.floor((float)objectIntMap.capacity * objectIntMap.loadFactor), objectIntMap.loadFactor);
        this.stashSize = objectIntMap.stashSize;
        Object[] objectArray = objectIntMap.keyTable;
        System.arraycopy(objectArray, 0, this.keyTable, 0, objectArray.length);
        objectArray = objectIntMap.valueTable;
        System.arraycopy(objectArray, 0, this.valueTable, 0, objectArray.length);
        this.size = objectIntMap.size;
    }

    private boolean containsKeyStash(K k) {
        K[] KArray = this.keyTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = n; i < n2 + n; ++i) {
            if (!k.equals(KArray[i])) continue;
            return true;
        }
        return false;
    }

    private int getAndIncrementStash(K object, int object2, int n) {
        K[] KArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (!object.equals(KArray[i])) continue;
            object = this.valueTable;
            object2 = object[i];
            object[i] = n + object2;
            return object2;
        }
        this.put(object, n + object2);
        return object2;
    }

    private int getStash(K k, int n) {
        K[] KArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (!k.equals(KArray[i])) continue;
            return this.valueTable[i];
        }
        return n;
    }

    private int hash2(int n) {
        return ((n *= -1262997959) ^ n >>> this.hashShift) & this.mask;
    }

    private int hash3(int n) {
        return ((n *= -825114047) ^ n >>> this.hashShift) & this.mask;
    }

    private void push(K k, int n, int n2, K k2, int n3, K k3, int n4, K k4) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n5 = this.mask;
        int n6 = this.pushIterations;
        int n7 = n2;
        int n8 = n4;
        n2 = 0;
        int n9 = n3;
        n4 = n7;
        n3 = n;
        K k5 = k;
        do {
            if ((n = MathUtils.random(2)) != 0) {
                if (n != 1) {
                    n = nArray[n8];
                    KArray[n8] = k5;
                    nArray[n8] = n3;
                    k = k4;
                } else {
                    n = nArray[n9];
                    KArray[n9] = k5;
                    nArray[n9] = n3;
                    k = k3;
                }
            } else {
                n = nArray[n4];
                KArray[n4] = k5;
                nArray[n4] = n3;
                k = k2;
            }
            n3 = k.hashCode();
            n4 = n3 & n5;
            k2 = KArray[n4];
            if (k2 == null) {
                KArray[n4] = k;
                nArray[n4] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n9 = this.hash2(n3);
            k3 = KArray[n9];
            if (k3 == null) {
                KArray[n9] = k;
                nArray[n9] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n8 = this.hash3(n3);
            k4 = KArray[n8];
            if (k4 == null) {
                KArray[n8] = k;
                nArray[n8] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = n2 + 1;
            k5 = k;
            n3 = n;
            n2 = n7;
        } while (n7 != n6);
        this.putStash(k, n);
    }

    private void putResize(K k, int n) {
        Object object = this.keyTable;
        int n2 = k.hashCode();
        int n3 = n2 & this.mask;
        K k2 = object[n3];
        if (k2 == null) {
            object[n3] = k;
            this.valueTable[n3] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        K[] KArray = this.keyTable;
        int n4 = this.hash2(n2);
        object = KArray[n4];
        if (object == null) {
            KArray[n4] = k;
            this.valueTable[n4] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        KArray = this.keyTable;
        K k3 = KArray[n2 = this.hash3(n2)];
        if (k3 == null) {
            KArray[n2] = k;
            this.valueTable[n2] = n;
            n = this.size;
            this.size = n + 1;
            if (n >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(k, n, n3, k2, n4, object, n2, k3);
    }

    private void putStash(K k, int n) {
        int n2 = this.stashSize;
        if (n2 == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.putResize(k, n);
            return;
        }
        int n3 = this.capacity + n2;
        this.keyTable[n3] = k;
        this.valueTable[n3] = n;
        this.stashSize = n2 + 1;
        ++this.size;
    }

    private void resize(int n) {
        int n2 = this.capacity;
        int n3 = this.stashSize;
        this.capacity = n;
        this.threshold = (int)((float)n * this.loadFactor);
        this.mask = n - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n);
        double d = n;
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(d)) * 2);
        this.pushIterations = Math.max(Math.min(n, 8), (int)Math.sqrt(d) / 8);
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n4 = this.stashCapacity;
        this.keyTable = new Object[n + n4];
        this.valueTable = new int[n + n4];
        n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (n = 0; n < n2 + n3; ++n) {
                K k = KArray[n];
                if (k == null) continue;
                this.putResize(k, nArray[n]);
            }
        }
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        K[] KArray = this.keyTable;
        int n = this.capacity + this.stashSize;
        while (true) {
            int n2 = n - 1;
            if (n <= 0) break;
            KArray[n2] = null;
            n = n2;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public void clear(int n) {
        if (this.capacity <= n) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n);
    }

    public boolean containsKey(K k) {
        int n = this.mask;
        int n2 = k.hashCode();
        if (!(k.equals(this.keyTable[n & n2]) || k.equals(this.keyTable[n = this.hash2(n2)]) || k.equals(this.keyTable[n2 = this.hash3(n2)]))) {
            return this.containsKeyStash(k);
        }
        return true;
    }

    public boolean containsValue(int n) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (true) {
            int n3 = n2 - 1;
            if (n2 <= 0) break;
            if (KArray[n3] != null && nArray[n3] == n) {
                return true;
            }
            n2 = n3;
        }
        return false;
    }

    public void ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) >= this.threshold) {
                this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n / this.loadFactor)));
            }
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public Entries<K> entries() {
        if (Collections.allocateIterators) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        if (!this.entries1.valid) {
            this.entries1.reset();
            Entries entries = this.entries1;
            entries.valid = true;
            this.entries2.valid = false;
            return entries;
        }
        this.entries2.reset();
        Entries entries = this.entries2;
        entries.valid = true;
        this.entries1.valid = false;
        return entries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ObjectIntMap)) {
            return false;
        }
        object = (ObjectIntMap)object;
        if (((ObjectIntMap)object).size != this.size) {
            return false;
        }
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            if (k == null) continue;
            int n3 = ((ObjectIntMap)object).get(k, 0);
            if (n3 == 0 && !((ObjectIntMap)object).containsKey(k)) {
                return false;
            }
            if (n3 == nArray[i]) continue;
            return false;
        }
        return true;
    }

    public K findKey(int n) {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (true) {
            int n3 = n2 - 1;
            if (n2 <= 0) break;
            if (KArray[n3] != null && nArray[n3] == n) {
                return KArray[n3];
            }
            n2 = n3;
        }
        return null;
    }

    public int get(K k, int n) {
        int n2;
        int n3 = k.hashCode();
        int n4 = n2 = this.mask & n3;
        if (!k.equals(this.keyTable[n2])) {
            n4 = n2 = this.hash2(n3);
            if (!k.equals(this.keyTable[n2])) {
                n4 = n2 = this.hash3(n3);
                if (!k.equals(this.keyTable[n2])) {
                    return this.getStash(k, n);
                }
            }
        }
        return this.valueTable[n4];
    }

    public int getAndIncrement(K object, int object2, int n) {
        int n2;
        int n3 = object.hashCode();
        int n4 = n2 = this.mask & n3;
        if (!object.equals(this.keyTable[n2])) {
            n4 = n2 = this.hash2(n3);
            if (!object.equals(this.keyTable[n2])) {
                n4 = n2 = this.hash3(n3);
                if (!object.equals(this.keyTable[n2])) {
                    return this.getAndIncrementStash((K)object, (int)object2, n);
                }
            }
        }
        object = this.valueTable;
        object2 = object[n4];
        object[n4] = n + object2;
        return object2;
    }

    public int hashCode() {
        K[] KArray = this.keyTable;
        int[] nArray = this.valueTable;
        int n = this.capacity;
        int n2 = this.stashSize;
        int n3 = 0;
        for (int i = 0; i < n + n2; ++i) {
            K k = KArray[i];
            int n4 = n3;
            if (k != null) {
                n4 = n3 + k.hashCode() * 31 + nArray[i];
            }
            n3 = n4;
        }
        return n3;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    @Override
    public Entries<K> iterator() {
        return this.entries();
    }

    public Keys<K> keys() {
        if (Collections.allocateIterators) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        if (!this.keys1.valid) {
            this.keys1.reset();
            Keys keys = this.keys1;
            keys.valid = true;
            this.keys2.valid = false;
            return keys;
        }
        this.keys2.reset();
        Keys keys = this.keys2;
        keys.valid = true;
        this.keys1.valid = false;
        return keys;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public void put(K object, int n) {
        if (object != null) {
            K[] KArray = this.keyTable;
            int n2 = object.hashCode();
            int n3 = n2 & this.mask;
            K k = KArray[n3];
            if (object.equals(k)) {
                this.valueTable[n3] = n;
                return;
            }
            int n4 = this.hash2(n2);
            K k2 = KArray[n4];
            if (object.equals(k2)) {
                this.valueTable[n4] = n;
                return;
            }
            int n5 = this.hash3(n2);
            K k3 = KArray[n5];
            if (object.equals(k3)) {
                this.valueTable[n5] = n;
                return;
            }
            int n6 = this.capacity;
            int n7 = this.stashSize;
            for (n2 = n6; n2 < n7 + n6; ++n2) {
                if (!object.equals(KArray[n2])) continue;
                this.valueTable[n2] = n;
                return;
            }
            if (k == null) {
                KArray[n3] = object;
                this.valueTable[n3] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (k2 == null) {
                KArray[n4] = object;
                this.valueTable[n4] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (k3 == null) {
                KArray[n5] = object;
                this.valueTable[n5] = n;
                n = this.size;
                this.size = n + 1;
                if (n >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            this.push(object, n, n3, k, n4, k2, n5, k3);
            return;
        }
        object = new IllegalArgumentException("key cannot be null.");
        throw object;
    }

    public void putAll(ObjectIntMap<? extends K> object) {
        for (Entry entry : ((ObjectIntMap)object).entries()) {
            this.put(entry.key, entry.value);
        }
    }

    public int remove(K k, int n) {
        int n2 = k.hashCode();
        int n3 = this.mask & n2;
        if (k.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            n = this.valueTable[n3];
            --this.size;
            return n;
        }
        n3 = this.hash2(n2);
        if (k.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            n = this.valueTable[n3];
            --this.size;
            return n;
        }
        if (k.equals(this.keyTable[n2 = this.hash3(n2)])) {
            this.keyTable[n2] = null;
            n = this.valueTable[n2];
            --this.size;
            return n;
        }
        return this.removeStash(k, n);
    }

    int removeStash(K k, int n) {
        K[] KArray = this.keyTable;
        int n2 = this.capacity;
        int n3 = this.stashSize;
        for (int i = n2; i < n3 + n2; ++i) {
            if (!k.equals(KArray[i])) continue;
            n = this.valueTable[i];
            this.removeStashIndex(i);
            --this.size;
            return n;
        }
        return n;
    }

    void removeStashIndex(int n) {
        --this.stashSize;
        int n2 = this.capacity + this.stashSize;
        if (n < n2) {
            K[] KArray = this.keyTable;
            KArray[n] = KArray[n2];
            int[] nArray = this.valueTable;
            nArray[n] = nArray[n2];
            KArray[n2] = null;
        }
    }

    public void shrink(int n) {
        if (n >= 0) {
            int n2 = this.size;
            int n3 = n;
            if (n2 > n) {
                n3 = n2;
            }
            if (this.capacity <= n3) {
                return;
            }
            this.resize(MathUtils.nextPowerOfTwo(n3));
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("maximumCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public String toString() {
        K k;
        int n;
        int n2;
        int[] nArray;
        K[] KArray;
        StringBuilder stringBuilder;
        block4: {
            if (this.size == 0) {
                return "{}";
            }
            stringBuilder = new StringBuilder(32);
            stringBuilder.append('{');
            KArray = this.keyTable;
            nArray = this.valueTable;
            int n3 = KArray.length;
            while (true) {
                n = n2 = n3 - 1;
                if (n3 <= 0) break block4;
                k = KArray[n2];
                if (k != null) break;
                n3 = n2;
            }
            stringBuilder.append(k);
            stringBuilder.append('=');
            stringBuilder.append(nArray[n2]);
            n = n2;
        }
        while (true) {
            n2 = n - 1;
            if (n <= 0) break;
            k = KArray[n2];
            if (k != null) {
                stringBuilder.append(", ");
                stringBuilder.append(k);
                stringBuilder.append('=');
                stringBuilder.append(nArray[n2]);
            }
            n = n2;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Values values() {
        if (Collections.allocateIterators) {
            return new Values((ObjectIntMap<?>)this);
        }
        if (this.values1 == null) {
            this.values1 = new Values((ObjectIntMap<?>)this);
            this.values2 = new Values((ObjectIntMap<?>)this);
        }
        if (!this.values1.valid) {
            this.values1.reset();
            Values values = this.values1;
            values.valid = true;
            this.values2.valid = false;
            return values;
        }
        this.values2.reset();
        Values values = this.values2;
        values.valid = true;
        this.values1.valid = false;
        return values;
    }

    public static class Entries<K>
    extends MapIterator<K>
    implements Iterable<Entry<K>>,
    Iterator<Entry<K>> {
        private Entry<K> entry = new Entry();

        public Entries(ObjectIntMap<K> objectIntMap) {
            super(objectIntMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public Entry<K> next() {
            if (this.hasNext) {
                if (this.valid) {
                    K[] KArray = this.map.keyTable;
                    this.entry.key = KArray[this.nextIndex];
                    this.entry.value = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return this.entry;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }
    }

    public static class Entry<K> {
        public K key;
        public int value;

        public String toString() {
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append(this.key);
            stringBuilder.append("=");
            stringBuilder.append(this.value);
            return stringBuilder.toString();
        }
    }

    public static class Keys<K>
    extends MapIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public Keys(ObjectIntMap<K> objectIntMap) {
            super(objectIntMap);
        }

        @Override
        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        @Override
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public K next() {
            if (this.hasNext) {
                if (this.valid) {
                    Object k = this.map.keyTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return k;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            super.remove();
        }

        public Array<K> toArray() {
            Array<K> array = new Array<K>(true, this.map.size);
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }
    }

    private static class MapIterator<K> {
        int currentIndex;
        public boolean hasNext;
        final ObjectIntMap<K> map;
        int nextIndex;
        boolean valid = true;

        public MapIterator(ObjectIntMap<K> objectIntMap) {
            this.map = objectIntMap;
            this.reset();
        }

        void findNextIndex() {
            block1: {
                this.hasNext = false;
                K[] KArray = this.map.keyTable;
                int n = this.map.capacity;
                int n2 = this.map.stashSize;
                do {
                    int n3;
                    this.nextIndex = n3 = this.nextIndex + 1;
                    if (n3 >= n + n2) break block1;
                } while (KArray[this.nextIndex] == null);
                this.hasNext = true;
            }
        }

        public void remove() {
            int n = this.currentIndex;
            if (n >= 0) {
                if (n >= this.map.capacity) {
                    this.map.removeStashIndex(this.currentIndex);
                    this.nextIndex = this.currentIndex - 1;
                    this.findNextIndex();
                } else {
                    this.map.keyTable[this.currentIndex] = null;
                }
                this.currentIndex = -1;
                ObjectIntMap<K> objectIntMap = this.map;
                --objectIntMap.size;
                return;
            }
            throw new IllegalStateException("next must be called before remove.");
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }
    }

    public static class Values
    extends MapIterator<Object> {
        public Values(ObjectIntMap<?> objectIntMap) {
            super(objectIntMap);
        }

        public boolean hasNext() {
            if (this.valid) {
                return this.hasNext;
            }
            throw new GdxRuntimeException("#iterator() cannot be used nested.");
        }

        public int next() {
            if (this.hasNext) {
                if (this.valid) {
                    int n = this.map.valueTable[this.nextIndex];
                    this.currentIndex = this.nextIndex;
                    this.findNextIndex();
                    return n;
                }
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            throw new NoSuchElementException();
        }

        public IntArray toArray() {
            IntArray intArray = new IntArray(true, this.map.size);
            while (this.hasNext) {
                intArray.add(this.next());
            }
            return intArray;
        }
    }
}

