/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class CharArray {
    public char[] items;
    public boolean ordered;
    public int size;

    public CharArray() {
        this(true, 16);
    }

    public CharArray(int n) {
        this(true, n);
    }

    public CharArray(CharArray charArray) {
        this.ordered = charArray.ordered;
        int n = this.size = charArray.size;
        this.items = new char[n];
        System.arraycopy(charArray.items, 0, this.items, 0, n);
    }

    public CharArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new char[n];
    }

    public CharArray(boolean bl, char[] cArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(cArray, n, this.items, 0, n2);
    }

    public CharArray(char[] cArray) {
        this(true, cArray, 0, cArray.length);
    }

    public static CharArray with(char ... cArray) {
        return new CharArray(cArray);
    }

    public void add(char c) {
        char[] cArray = this.items;
        int n = this.size;
        char[] cArray2 = cArray;
        if (n == cArray.length) {
            cArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        this.size = n + 1;
        cArray2[n] = c;
    }

    public void add(char c, char c2) {
        char[] cArray = this.items;
        int n = this.size;
        char[] cArray2 = cArray;
        if (n + 1 >= cArray.length) {
            cArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        cArray2[n] = c;
        cArray2[n + 1] = c2;
        this.size = n + 2;
    }

    public void add(char c, char c2, char c3) {
        char[] cArray = this.items;
        int n = this.size;
        char[] cArray2 = cArray;
        if (n + 2 >= cArray.length) {
            cArray2 = this.resize(Math.max(8, (int)((float)n * 1.75f)));
        }
        n = this.size;
        cArray2[n] = c;
        cArray2[n + 1] = c2;
        cArray2[n + 2] = c3;
        this.size = n + 3;
    }

    public void add(char c, char c2, char c3, char c4) {
        char[] cArray = this.items;
        int n = this.size;
        char[] cArray2 = cArray;
        if (n + 3 >= cArray.length) {
            cArray2 = this.resize(Math.max(8, (int)((float)n * 1.8f)));
        }
        n = this.size;
        cArray2[n] = c;
        cArray2[n + 1] = c2;
        cArray2[n + 2] = c3;
        cArray2[n + 3] = c4;
        this.size = n + 4;
    }

    public void addAll(CharArray charArray) {
        this.addAll(charArray.items, 0, charArray.size);
    }

    public void addAll(CharArray charArray, int n, int n2) {
        if (n + n2 <= charArray.size) {
            this.addAll(charArray.items, n, n2);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("offset + length must be <= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" + ");
        stringBuilder.append(n2);
        stringBuilder.append(" <= ");
        stringBuilder.append(charArray.size);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public void addAll(char ... cArray) {
        this.addAll(cArray, 0, cArray.length);
    }

    public void addAll(char[] cArray, int n, int n2) {
        char[] cArray2 = this.items;
        int n3 = this.size + n2;
        char[] cArray3 = cArray2;
        if (n3 > cArray2.length) {
            cArray3 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(cArray, n, cArray3, this.size, n2);
        this.size += n2;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(char c) {
        char[] cArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public char[] ensureCapacity(int n) {
        if (n >= 0) {
            if ((n = this.size + n) > this.items.length) {
                this.resize(Math.max(8, n));
            }
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("additionalCapacity must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof CharArray)) {
            return false;
        }
        Object object2 = (CharArray)object;
        if (!((CharArray)object2).ordered) {
            return false;
        }
        int n = this.size;
        if (n != ((CharArray)object2).size) {
            return false;
        }
        object = this.items;
        object2 = ((CharArray)object2).items;
        for (int i = 0; i < n; ++i) {
            if (object[i] == object2[i]) continue;
            return false;
        }
        return true;
    }

    public char first() {
        if (this.size != 0) {
            return this.items[0];
        }
        throw new IllegalStateException("Array is empty.");
    }

    public char get(int n) {
        if (n < this.size) {
            return this.items[n];
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        char[] cArray = this.items;
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + cArray[i];
        }
        return n2;
    }

    public void incr(int n, char c) {
        if (n < this.size) {
            char[] cArray = this.items;
            cArray[n] = (char)(cArray[n] + c);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public int indexOf(char c) {
        char[] cArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void insert(int n, char c) {
        int n2 = this.size;
        if (n <= n2) {
            char[] cArray;
            char[] cArray2 = cArray = this.items;
            if (n2 == cArray.length) {
                cArray2 = this.resize(Math.max(8, (int)((float)n2 * 1.75f)));
            }
            if (this.ordered) {
                System.arraycopy(cArray2, n, cArray2, n + 1, this.size - n);
            } else {
                cArray2[this.size] = cArray2[n];
            }
            ++this.size;
            cArray2[n] = c;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be > size: ");
        stringBuilder.append(n);
        stringBuilder.append(" > ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public int lastIndexOf(char c) {
        char[] cArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (cArray[i] != c) continue;
            return i;
        }
        return -1;
    }

    public void mul(int n, char c) {
        if (n < this.size) {
            char[] cArray = this.items;
            cArray[n] = (char)(cArray[n] * c);
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public char peek() {
        return this.items[this.size - 1];
    }

    public char pop() {
        int n;
        char[] cArray = this.items;
        this.size = n = this.size - 1;
        return cArray[n];
    }

    public char random() {
        int n = this.size;
        if (n == 0) {
            return '\u0000';
        }
        return this.items[MathUtils.random(0, n - 1)];
    }

    public boolean removeAll(CharArray charArray) {
        int n = this.size;
        char[] cArray = this.items;
        int n2 = charArray.size;
        boolean bl = false;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            char c = charArray.get(i);
            int n5 = 0;
            while (true) {
                n4 = n3;
                if (n5 >= n3) break;
                if (c == cArray[n5]) {
                    this.removeIndex(n5);
                    n4 = n3 - 1;
                    break;
                }
                ++n5;
            }
            n3 = n4;
        }
        if (n3 != n) {
            bl = true;
        }
        return bl;
    }

    public char removeIndex(int n) {
        int n2 = this.size;
        if (n < n2) {
            char[] cArray = this.items;
            char c = cArray[n];
            this.size = n2 - 1;
            if (this.ordered) {
                System.arraycopy(cArray, n + 1, cArray, n, this.size - n);
            } else {
                cArray[n] = cArray[this.size];
            }
            return c;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public void removeRange(int n, int n2) {
        int n3 = this.size;
        if (n2 < n3) {
            if (n <= n2) {
                int n4 = n2 - n + 1;
                int n5 = n3 - n4;
                if (this.ordered) {
                    char[] cArray = this.items;
                    n2 = n4 + n;
                    System.arraycopy(cArray, n2, cArray, n, n3 - n2);
                } else {
                    n2 = Math.max(n5, n2 + 1);
                    char[] cArray = this.items;
                    System.arraycopy(cArray, n2, cArray, n, n3 - n2);
                }
                this.size = n5;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("start can't be > end: ");
            stringBuilder.append(n);
            stringBuilder.append(" > ");
            stringBuilder.append(n2);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("end can't be >= size: ");
        stringBuilder.append(n2);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public boolean removeValue(char c) {
        char[] cArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (cArray[i] != c) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    protected char[] resize(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.items, 0, cArray, 0, Math.min(this.size, cArray.length));
        this.items = cArray;
        return cArray;
    }

    public void reverse() {
        char[] cArray = this.items;
        int n = this.size;
        int n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - 1 - i;
            char c = cArray[i];
            cArray[i] = cArray[n3];
            cArray[n3] = c;
        }
    }

    public void set(int n, char c) {
        if (n < this.size) {
            this.items[n] = c;
            return;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("index can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public char[] setSize(int n) {
        if (n >= 0) {
            if (n > this.items.length) {
                this.resize(Math.max(8, n));
            }
            this.size = n;
            return this.items;
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("newSize must be >= 0: ");
        stringBuilder.append(n);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public char[] shrink() {
        int n = this.items.length;
        int n2 = this.size;
        if (n != n2) {
            this.resize(n2);
        }
        return this.items;
    }

    public void shuffle() {
        char[] cArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            char c = cArray[i];
            cArray[i] = cArray[n];
            cArray[n] = c;
        }
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void swap(int n, int n2) {
        int n3 = this.size;
        if (n < n3) {
            if (n2 < n3) {
                char[] cArray = this.items;
                n3 = cArray[n];
                cArray[n] = cArray[n2];
                cArray[n2] = (char)n3;
                return;
            }
            java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
            stringBuilder.append("second can't be >= size: ");
            stringBuilder.append(n2);
            stringBuilder.append(" >= ");
            stringBuilder.append(this.size);
            throw new IndexOutOfBoundsException(stringBuilder.toString());
        }
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder();
        stringBuilder.append("first can't be >= size: ");
        stringBuilder.append(n);
        stringBuilder.append(" >= ");
        stringBuilder.append(this.size);
        throw new IndexOutOfBoundsException(stringBuilder.toString());
    }

    public char[] toArray() {
        int n = this.size;
        char[] cArray = new char[n];
        System.arraycopy(this.items, 0, cArray, 0, n);
        return cArray;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(cArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string2) {
        if (this.size == 0) {
            return "";
        }
        char[] cArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(cArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string2);
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }
}

