/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.StringBuilder;

public class BinaryHeap<T extends Node> {
    private final boolean isMaxHeap;
    private Node[] nodes;
    public int size;

    public BinaryHeap() {
        this(16, false);
    }

    public BinaryHeap(int n, boolean bl) {
        this.isMaxHeap = bl;
        this.nodes = new Node[n];
    }

    private void down(int n) {
        Node[] nodeArray = this.nodes;
        int n2 = this.size;
        Node node = nodeArray[n];
        float f = node.value;
        while (true) {
            float f2;
            Node node2;
            boolean bl = true;
            boolean bl2 = true;
            int n3 = (n << 1) + 1;
            if (n3 >= n2) break;
            int n4 = n3 + 1;
            Node node3 = nodeArray[n3];
            float f3 = node3.value;
            if (n4 >= n2) {
                node2 = null;
                f2 = this.isMaxHeap ? -3.4028235E38f : Float.MAX_VALUE;
            } else {
                node2 = nodeArray[n4];
                f2 = node2.value;
            }
            boolean bl3 = f3 < f2;
            if (bl3 ^ this.isMaxHeap) {
                if (f3 == f || (bl3 = f3 > f ? bl2 : false) ^ this.isMaxHeap) break;
                nodeArray[n] = node3;
                node3.index = n;
                n = n3;
                continue;
            }
            if (f2 == f || this.isMaxHeap ^ (bl3 = f2 > f ? bl : false)) break;
            nodeArray[n] = node2;
            node2.index = n;
            n = n4;
        }
        nodeArray[n] = node;
        node.index = n;
    }

    private T remove(int n) {
        int n2;
        Node[] nodeArray = this.nodes;
        Node node = nodeArray[n];
        this.size = n2 = this.size - 1;
        nodeArray[n] = nodeArray[n2];
        n2 = this.size;
        nodeArray[n2] = null;
        if (n2 > 0 && n < n2) {
            this.down(n);
        }
        return (T)node;
    }

    private void up(int n) {
        Node[] nodeArray = this.nodes;
        Node node = nodeArray[n];
        float f = node.value;
        while (n > 0) {
            boolean bl = true;
            int n2 = n - 1 >> 1;
            Node node2 = nodeArray[n2];
            if (!(f < node2.value)) {
                bl = false;
            }
            if (!(bl ^ this.isMaxHeap)) break;
            nodeArray[n] = node2;
            node2.index = n;
            n = n2;
        }
        nodeArray[n] = node;
        node.index = n;
    }

    public T add(T t) {
        int n = this.size;
        Node[] nodeArray = this.nodes;
        if (n == nodeArray.length) {
            Node[] nodeArray2 = new Node[n << 1];
            System.arraycopy(nodeArray, 0, nodeArray2, 0, n);
            this.nodes = nodeArray2;
        }
        ((Node)t).index = n = this.size;
        this.nodes[n] = t;
        this.size = n + 1;
        this.up(n);
        return t;
    }

    public T add(T t, float f) {
        ((Node)t).value = f;
        return this.add(t);
    }

    public void clear() {
        Node[] nodeArray = this.nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = null;
        }
        this.size = 0;
    }

    public boolean contains(T object, boolean bl) {
        if (object != null) {
            if (bl) {
                Node[] nodeArray = this.nodes;
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    if (nodeArray[i] != object) continue;
                    return true;
                }
            } else {
                Node[] nodeArray = this.nodes;
                int n = nodeArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!nodeArray[i].equals(object)) continue;
                    return true;
                }
            }
            return false;
        }
        object = new IllegalArgumentException("node cannot be null.");
        throw object;
    }

    public boolean equals(Object nodeArray) {
        if (!(nodeArray instanceof BinaryHeap)) {
            return false;
        }
        Node[] nodeArray2 = nodeArray;
        int n = nodeArray2.size;
        int n2 = this.size;
        if (n != n2) {
            return false;
        }
        nodeArray = this.nodes;
        nodeArray2 = nodeArray2.nodes;
        for (n = 0; n < n2; ++n) {
            if (nodeArray[n].value == nodeArray2[n].value) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.size;
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + Float.floatToIntBits(this.nodes[i].value);
        }
        return n2;
    }

    public boolean isEmpty() {
        boolean bl = this.size == 0;
        return bl;
    }

    public boolean notEmpty() {
        boolean bl = this.size > 0;
        return bl;
    }

    public T peek() {
        if (this.size != 0) {
            return (T)this.nodes[0];
        }
        throw new IllegalStateException("The heap is empty.");
    }

    public T pop() {
        return this.remove(false);
    }

    public T remove(T t) {
        return this.remove((T)((Node)t).index);
    }

    public void setValue(T t, float f) {
        float f2 = ((Node)t).value;
        ((Node)t).value = f;
        boolean bl = f < f2;
        if (bl ^ this.isMaxHeap) {
            this.up(((Node)t).index);
        } else {
            this.down(((Node)t).index);
        }
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodeArray = this.nodes;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(nodeArray[0].value);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(nodeArray[i].value);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static class Node {
        int index;
        float value;

        public Node(float f) {
            this.value = f;
        }

        public float getValue() {
            return this.value;
        }

        public String toString() {
            return Float.toString(this.value);
        }
    }
}

