/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Event;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;

public class Tooltip<T extends Actor>
extends InputListener {
    static Vector2 tmp = new Vector2();
    boolean always;
    final Container<T> container;
    boolean instant;
    private final TooltipManager manager;
    Actor targetActor;

    public Tooltip(T t) {
        this(t, TooltipManager.getInstance());
    }

    public Tooltip(T t, TooltipManager tooltipManager) {
        this.manager = tooltipManager;
        this.container = new Container((Actor)t){

            @Override
            public void act(float f) {
                super.act(f);
                if (Tooltip.this.targetActor != null && Tooltip.this.targetActor.getStage() == null) {
                    this.remove();
                }
            }
        };
        this.container.setTouchable(Touchable.disabled);
    }

    private void setContainerPosition(Actor object, float f, float f2) {
        Vector2 vector2;
        this.targetActor = object;
        Stage stage = ((Actor)object).getStage();
        if (stage == null) {
            return;
        }
        this.container.pack();
        float f3 = this.manager.offsetX;
        float f4 = this.manager.offsetY;
        float f5 = this.manager.edgeDistance;
        Vector2 vector22 = tmp;
        vector22 = vector2 = ((Actor)object).localToStageCoordinates(vector22.set(f += f3, f2 - f4 - this.container.getHeight()));
        if (vector2.y < f5) {
            vector22 = ((Actor)object).localToStageCoordinates(tmp.set(f, f2 + f4));
        }
        if (vector22.x < f5) {
            vector22.x = f5;
        }
        if (vector22.x + this.container.getWidth() > stage.getWidth() - f5) {
            vector22.x = stage.getWidth() - f5 - this.container.getWidth();
        }
        if (vector22.y + this.container.getHeight() > stage.getHeight() - f5) {
            vector22.y = stage.getHeight() - f5 - this.container.getHeight();
        }
        this.container.setPosition(vector22.x, vector22.y);
        object = ((Actor)object).localToStageCoordinates(tmp.set(((Actor)object).getWidth() / 2.0f, ((Actor)object).getHeight() / 2.0f));
        ((Vector2)object).sub(this.container.getX(), this.container.getY());
        this.container.setOrigin(((Vector2)object).x, ((Vector2)object).y);
    }

    @Override
    public void enter(InputEvent object, float f, float f2, int n, Actor actor) {
        if (n != -1) {
            return;
        }
        if (Gdx.input.isTouched()) {
            return;
        }
        object = ((Event)object).getListenerActor();
        if (actor != null && actor.isDescendantOf((Actor)object)) {
            return;
        }
        this.setContainerPosition((Actor)object, f, f2);
        this.manager.enter(this);
    }

    @Override
    public void exit(InputEvent inputEvent, float f, float f2, int n, Actor actor) {
        if (actor != null && actor.isDescendantOf(inputEvent.getListenerActor())) {
            return;
        }
        this.hide();
    }

    public T getActor() {
        return this.container.getActor();
    }

    public Container<T> getContainer() {
        return this.container;
    }

    public TooltipManager getManager() {
        return this.manager;
    }

    public void hide() {
        this.manager.hide(this);
    }

    @Override
    public boolean mouseMoved(InputEvent inputEvent, float f, float f2) {
        if (this.container.hasParent()) {
            return false;
        }
        this.setContainerPosition(inputEvent.getListenerActor(), f, f2);
        return true;
    }

    public void setActor(T t) {
        this.container.setActor(t);
    }

    public void setAlways(boolean bl) {
        this.always = bl;
    }

    public void setInstant(boolean bl) {
        this.instant = bl;
    }

    @Override
    public boolean touchDown(InputEvent inputEvent, float f, float f2, int n, int n2) {
        if (this.instant) {
            this.container.toFront();
            return false;
        }
        this.manager.touchDown(this);
        return false;
    }
}

