/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Value;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Cullable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public class Container<T extends Actor>
extends WidgetGroup {
    private T actor;
    private int align;
    private Drawable background;
    private boolean clip;
    private float fillX;
    private float fillY;
    private Value maxHeight;
    private Value maxWidth;
    private Value minHeight;
    private Value minWidth = Value.minWidth;
    private Value padBottom;
    private Value padLeft;
    private Value padRight;
    private Value padTop;
    private Value prefHeight;
    private Value prefWidth;
    private boolean round = true;

    public Container() {
        this.minHeight = Value.minHeight;
        this.prefWidth = Value.prefWidth;
        this.prefHeight = Value.prefHeight;
        this.maxWidth = Value.zero;
        this.maxHeight = Value.zero;
        this.padTop = Value.zero;
        this.padLeft = Value.zero;
        this.padBottom = Value.zero;
        this.padRight = Value.zero;
        this.setTouchable(Touchable.childrenOnly);
        this.setTransform(false);
    }

    public Container(T t) {
        this();
        this.setActor(t);
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorAfter(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorAt(int n, Actor actor) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    @Override
    public void addActorBefore(Actor actor, Actor actor2) {
        throw new UnsupportedOperationException("Use Container#setActor.");
    }

    public Container<T> align(int n) {
        this.align = n;
        return this;
    }

    public Container<T> background(Drawable drawable2) {
        this.setBackground(drawable2);
        return this;
    }

    public Container<T> bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Container<T> center() {
        this.align = 1;
        return this;
    }

    @Override
    public void draw(Batch batch, float f) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, f, 0.0f, 0.0f);
            if (this.clip) {
                batch.flush();
                float f2 = this.padLeft.get(this);
                float f3 = this.padBottom.get(this);
                if (this.clipBegin(f2, f3, this.getWidth() - f2 - this.padRight.get(this), this.getHeight() - f3 - this.padTop.get(this))) {
                    this.drawChildren(batch, f);
                    batch.flush();
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, f);
            }
            this.resetTransform(batch);
        } else {
            this.drawBackground(batch, f, this.getX(), this.getY());
            super.draw(batch, f);
        }
    }

    protected void drawBackground(Batch batch, float f, float f2, float f3) {
        if (this.background == null) {
            return;
        }
        Color color2 = this.getColor();
        batch.setColor(color2.r, color2.g, color2.b, color2.a * f);
        this.background.draw(batch, f2, f3, this.getWidth(), this.getHeight());
    }

    @Override
    public void drawDebug(ShapeRenderer shapeRenderer) {
        this.validate();
        if (this.isTransform()) {
            this.applyTransform(shapeRenderer, this.computeTransform());
            if (this.clip) {
                shapeRenderer.flush();
                float f = this.padLeft.get(this);
                float f2 = this.padBottom.get(this);
                boolean bl = this.background == null ? this.clipBegin(0.0f, 0.0f, this.getWidth(), this.getHeight()) : this.clipBegin(f, f2, this.getWidth() - f - this.padRight.get(this), this.getHeight() - f2 - this.padTop.get(this));
                if (bl) {
                    this.drawDebugChildren(shapeRenderer);
                    this.clipEnd();
                }
            } else {
                this.drawDebugChildren(shapeRenderer);
            }
            this.resetTransform(shapeRenderer);
        } else {
            super.drawDebug(shapeRenderer);
        }
    }

    public Container<T> fill() {
        this.fillX = 1.0f;
        this.fillY = 1.0f;
        return this;
    }

    public Container<T> fill(float f, float f2) {
        this.fillX = f;
        this.fillY = f2;
        return this;
    }

    public Container<T> fill(boolean bl) {
        float f = 1.0f;
        float f2 = bl ? 1.0f : 0.0f;
        this.fillX = f2;
        f2 = bl ? f : 0.0f;
        this.fillY = f2;
        return this;
    }

    public Container<T> fill(boolean bl, boolean bl2) {
        float f = 1.0f;
        float f2 = bl ? 1.0f : 0.0f;
        this.fillX = f2;
        f2 = bl2 ? f : 0.0f;
        this.fillY = f2;
        return this;
    }

    public Container<T> fillX() {
        this.fillX = 1.0f;
        return this;
    }

    public Container<T> fillY() {
        this.fillY = 1.0f;
        return this;
    }

    public T getActor() {
        return this.actor;
    }

    public int getAlign() {
        return this.align;
    }

    public Drawable getBackground() {
        return this.background;
    }

    public boolean getClip() {
        return this.clip;
    }

    public float getFillX() {
        return this.fillX;
    }

    public float getFillY() {
        return this.fillY;
    }

    @Override
    public float getMaxHeight() {
        float f;
        float f2 = f = this.maxHeight.get((Actor)this.actor);
        if (f > 0.0f) {
            f2 = f + (this.padTop.get(this) + this.padBottom.get(this));
        }
        return f2;
    }

    public Value getMaxHeightValue() {
        return this.maxHeight;
    }

    @Override
    public float getMaxWidth() {
        float f;
        float f2 = f = this.maxWidth.get((Actor)this.actor);
        if (f > 0.0f) {
            f2 = f + (this.padLeft.get(this) + this.padRight.get(this));
        }
        return f2;
    }

    public Value getMaxWidthValue() {
        return this.maxWidth;
    }

    @Override
    public float getMinHeight() {
        return this.minHeight.get((Actor)this.actor) + this.padTop.get(this) + this.padBottom.get(this);
    }

    public Value getMinHeightValue() {
        return this.minHeight;
    }

    @Override
    public float getMinWidth() {
        return this.minWidth.get((Actor)this.actor) + this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadBottom() {
        return this.padBottom.get(this);
    }

    public Value getPadBottomValue() {
        return this.padBottom;
    }

    public float getPadLeft() {
        return this.padLeft.get(this);
    }

    public Value getPadLeftValue() {
        return this.padLeft;
    }

    public float getPadRight() {
        return this.padRight.get(this);
    }

    public Value getPadRightValue() {
        return this.padRight;
    }

    public float getPadTop() {
        return this.padTop.get(this);
    }

    public Value getPadTopValue() {
        return this.padTop;
    }

    public float getPadX() {
        return this.padLeft.get(this) + this.padRight.get(this);
    }

    public float getPadY() {
        return this.padTop.get(this) + this.padBottom.get(this);
    }

    @Override
    public float getPrefHeight() {
        float f = this.prefHeight.get((Actor)this.actor);
        Drawable drawable2 = this.background;
        float f2 = f;
        if (drawable2 != null) {
            f2 = Math.max(f, drawable2.getMinHeight());
        }
        return Math.max(this.getMinHeight(), f2 + this.padTop.get(this) + this.padBottom.get(this));
    }

    public Value getPrefHeightValue() {
        return this.prefHeight;
    }

    @Override
    public float getPrefWidth() {
        float f = this.prefWidth.get((Actor)this.actor);
        Drawable drawable2 = this.background;
        float f2 = f;
        if (drawable2 != null) {
            f2 = Math.max(f, drawable2.getMinWidth());
        }
        return Math.max(this.getMinWidth(), f2 + this.padLeft.get(this) + this.padRight.get(this));
    }

    public Value getPrefWidthValue() {
        return this.prefWidth;
    }

    public Container<T> height(float f) {
        this.height(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> height(Value value) {
        if (value != null) {
            this.minHeight = value;
            this.prefHeight = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("height cannot be null.");
    }

    @Override
    public Actor hit(float f, float f2, boolean bl) {
        if (this.clip) {
            if (bl && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (f < 0.0f || f >= this.getWidth() || f2 < 0.0f || f2 >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(f, f2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void layout() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        block20: {
            block19: {
                int n;
                block18: {
                    block17: {
                        block16: {
                            float f9;
                            block15: {
                                if (this.actor == null) {
                                    return;
                                }
                                f8 = this.padLeft.get(this);
                                f7 = this.padBottom.get(this);
                                f9 = this.getWidth() - f8 - this.padRight.get(this);
                                f6 = this.getHeight() - f7 - this.padTop.get(this);
                                f5 = this.minWidth.get((Actor)this.actor);
                                f4 = this.minHeight.get((Actor)this.actor);
                                float f10 = this.prefWidth.get((Actor)this.actor);
                                float f11 = this.prefHeight.get((Actor)this.actor);
                                f3 = this.maxWidth.get((Actor)this.actor);
                                f2 = this.maxHeight.get((Actor)this.actor);
                                f = this.fillX;
                                f = f > 0.0f ? (f *= f9) : Math.min(f10, f9);
                                if (!(f < f5)) {
                                    f5 = f;
                                }
                                f = f5;
                                if (f3 > 0.0f) {
                                    f = f5;
                                    if (f5 > f3) {
                                        f = f3;
                                    }
                                }
                                f5 = (f5 = this.fillY) > 0.0f ? (f5 *= f6) : Math.min(f11, f6);
                                if (!(f5 < f4)) {
                                    f4 = f5;
                                }
                                f5 = f4;
                                if (f2 > 0.0f) {
                                    f5 = f4;
                                    if (f4 > f2) {
                                        f5 = f2;
                                    }
                                }
                                if (((n = this.align) & 0x10) == 0) break block15;
                                f4 = f9 - f;
                                break block16;
                            }
                            f4 = f8;
                            if ((n & 8) != 0) break block17;
                            f4 = (f9 - f) / 2.0f;
                        }
                        f4 = f8 + f4;
                    }
                    if (((n = this.align) & 2) == 0) break block18;
                    f8 = f6 - f5;
                    break block19;
                }
                f8 = f7;
                if ((n & 4) != 0) break block20;
                f8 = (f6 - f5) / 2.0f;
            }
            f8 = f7 + f8;
        }
        f6 = f4;
        f3 = f8;
        f2 = f;
        f7 = f5;
        if (this.round) {
            f6 = Math.round(f4);
            f3 = Math.round(f8);
            f2 = Math.round(f);
            f7 = Math.round(f5);
        }
        ((Actor)this.actor).setBounds(f6, f3, f2, f7);
        T t = this.actor;
        if (t instanceof Layout) {
            ((Layout)t).validate();
        }
    }

    public Container<T> left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Container<T> maxHeight(float f) {
        this.maxHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> maxHeight(Value value) {
        if (value != null) {
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("maxHeight cannot be null.");
    }

    public Container<T> maxSize(float f) {
        this.maxSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> maxSize(float f, float f2) {
        this.maxSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Container<T> maxSize(Value value) {
        if (value != null) {
            this.maxWidth = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Container<T> maxSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.maxWidth = value;
                this.maxHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Container<T> maxWidth(float f) {
        this.maxWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> maxWidth(Value value) {
        if (value != null) {
            this.maxWidth = value;
            return this;
        }
        throw new IllegalArgumentException("maxWidth cannot be null.");
    }

    public Container<T> minHeight(float f) {
        this.minHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> minHeight(Value value) {
        if (value != null) {
            this.minHeight = value;
            return this;
        }
        throw new IllegalArgumentException("minHeight cannot be null.");
    }

    public Container<T> minSize(float f) {
        this.minSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> minSize(float f, float f2) {
        this.minSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Container<T> minSize(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.minHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Container<T> minSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.minWidth = value;
                this.minHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Container<T> minWidth(float f) {
        this.minWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> minWidth(Value value) {
        if (value != null) {
            this.minWidth = value;
            return this;
        }
        throw new IllegalArgumentException("minWidth cannot be null.");
    }

    public Container<T> pad(float f) {
        Value.Fixed fixed = Value.Fixed.valueOf(f);
        this.padTop = fixed;
        this.padLeft = fixed;
        this.padBottom = fixed;
        this.padRight = fixed;
        return this;
    }

    public Container<T> pad(float f, float f2, float f3, float f4) {
        this.padTop = Value.Fixed.valueOf(f);
        this.padLeft = Value.Fixed.valueOf(f2);
        this.padBottom = Value.Fixed.valueOf(f3);
        this.padRight = Value.Fixed.valueOf(f4);
        return this;
    }

    public Container<T> pad(Value value) {
        if (value != null) {
            this.padTop = value;
            this.padLeft = value;
            this.padBottom = value;
            this.padRight = value;
            return this;
        }
        throw new IllegalArgumentException("pad cannot be null.");
    }

    public Container<T> pad(Value value, Value value2, Value value3, Value value4) {
        if (value != null) {
            if (value2 != null) {
                if (value3 != null) {
                    if (value4 != null) {
                        this.padTop = value;
                        this.padLeft = value2;
                        this.padBottom = value3;
                        this.padRight = value4;
                        return this;
                    }
                    throw new IllegalArgumentException("right cannot be null.");
                }
                throw new IllegalArgumentException("bottom cannot be null.");
            }
            throw new IllegalArgumentException("left cannot be null.");
        }
        throw new IllegalArgumentException("top cannot be null.");
    }

    public Container<T> padBottom(float f) {
        this.padBottom = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> padBottom(Value value) {
        if (value != null) {
            this.padBottom = value;
            return this;
        }
        throw new IllegalArgumentException("padBottom cannot be null.");
    }

    public Container<T> padLeft(float f) {
        this.padLeft = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> padLeft(Value value) {
        if (value != null) {
            this.padLeft = value;
            return this;
        }
        throw new IllegalArgumentException("padLeft cannot be null.");
    }

    public Container<T> padRight(float f) {
        this.padRight = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> padRight(Value value) {
        if (value != null) {
            this.padRight = value;
            return this;
        }
        throw new IllegalArgumentException("padRight cannot be null.");
    }

    public Container<T> padTop(float f) {
        this.padTop = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> padTop(Value value) {
        if (value != null) {
            this.padTop = value;
            return this;
        }
        throw new IllegalArgumentException("padTop cannot be null.");
    }

    public Container<T> prefHeight(float f) {
        this.prefHeight = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> prefHeight(Value value) {
        if (value != null) {
            this.prefHeight = value;
            return this;
        }
        throw new IllegalArgumentException("prefHeight cannot be null.");
    }

    public Container<T> prefSize(float f) {
        this.prefSize(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> prefSize(float f, float f2) {
        this.prefSize(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Container<T> prefSize(Value value) {
        if (value != null) {
            this.prefWidth = value;
            this.prefHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Container<T> prefSize(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.prefWidth = value;
                this.prefHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Container<T> prefWidth(float f) {
        this.prefWidth = Value.Fixed.valueOf(f);
        return this;
    }

    public Container<T> prefWidth(Value value) {
        if (value != null) {
            this.prefWidth = value;
            return this;
        }
        throw new IllegalArgumentException("prefWidth cannot be null.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor != null) {
            if (actor != this.actor) {
                return false;
            }
            this.setActor(null);
            return true;
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    @Override
    public boolean removeActor(Actor actor, boolean bl) {
        if (actor != null) {
            if (actor != this.actor) {
                return false;
            }
            this.actor = null;
            return super.removeActor(actor, bl);
        }
        throw new IllegalArgumentException("actor cannot be null.");
    }

    public Container<T> right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    public void setActor(T t) {
        if (t != this) {
            T t2 = this.actor;
            if (t == t2) {
                return;
            }
            if (t2 != null) {
                super.removeActor((Actor)t2);
            }
            this.actor = t;
            if (t != null) {
                super.addActor((Actor)t);
            }
            return;
        }
        throw new IllegalArgumentException("actor cannot be the Container.");
    }

    public void setBackground(Drawable drawable2) {
        this.setBackground(drawable2, true);
    }

    public void setBackground(Drawable drawable2, boolean bl) {
        if (this.background == drawable2) {
            return;
        }
        this.background = drawable2;
        if (bl) {
            if (drawable2 == null) {
                this.pad(Value.zero);
            } else {
                this.pad(drawable2.getTopHeight(), drawable2.getLeftWidth(), drawable2.getBottomHeight(), drawable2.getRightWidth());
            }
            this.invalidate();
        }
    }

    public void setClip(boolean bl) {
        this.clip = bl;
        this.setTransform(bl);
        this.invalidate();
    }

    @Override
    public void setCullingArea(Rectangle rectangle) {
        T t;
        super.setCullingArea(rectangle);
        if (this.fillX == 1.0f && this.fillY == 1.0f && (t = this.actor) instanceof Cullable) {
            ((Cullable)t).setCullingArea(rectangle);
        }
    }

    public void setRound(boolean bl) {
        this.round = bl;
    }

    public Container<T> size(float f) {
        this.size(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> size(float f, float f2) {
        this.size(Value.Fixed.valueOf(f), Value.Fixed.valueOf(f2));
        return this;
    }

    public Container<T> size(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.minHeight = value;
            this.prefWidth = value;
            this.prefHeight = value;
            this.maxWidth = value;
            this.maxHeight = value;
            return this;
        }
        throw new IllegalArgumentException("size cannot be null.");
    }

    public Container<T> size(Value value, Value value2) {
        if (value != null) {
            if (value2 != null) {
                this.minWidth = value;
                this.minHeight = value2;
                this.prefWidth = value;
                this.prefHeight = value2;
                this.maxWidth = value;
                this.maxHeight = value2;
                return this;
            }
            throw new IllegalArgumentException("height cannot be null.");
        }
        throw new IllegalArgumentException("width cannot be null.");
    }

    public Container<T> top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Container<T> width(float f) {
        this.width(Value.Fixed.valueOf(f));
        return this;
    }

    public Container<T> width(Value value) {
        if (value != null) {
            this.minWidth = value;
            this.prefWidth = value;
            this.maxWidth = value;
            return this;
        }
        throw new IllegalArgumentException("width cannot be null.");
    }
}

