/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.NumberUtils;
import java.io.Serializable;

public class Quaternion
implements Serializable {
    private static final long serialVersionUID = -7661875440774897168L;
    private static Quaternion tmp1 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    private static Quaternion tmp2 = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
    public float w;
    public float x;
    public float y;
    public float z;

    public Quaternion() {
        this.idt();
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.set(f, f2, f3, f4);
    }

    public Quaternion(Quaternion quaternion) {
        this.set(quaternion);
    }

    public Quaternion(Vector3 vector3, float f) {
        this.set(vector3, f);
    }

    public static final float dot(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        return f * f5 + f2 * f6 + f3 * f7 + f4 * f8;
    }

    public static final float len(float f, float f2, float f3, float f4) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
    }

    public static final float len2(float f, float f2, float f3, float f4) {
        return f * f + f2 * f2 + f3 * f3 + f4 * f4;
    }

    public Quaternion add(float f, float f2, float f3, float f4) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.w += f4;
        return this;
    }

    public Quaternion add(Quaternion quaternion) {
        this.x += quaternion.x;
        this.y += quaternion.y;
        this.z += quaternion.z;
        this.w += quaternion.w;
        return this;
    }

    public Quaternion conjugate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Quaternion cpy() {
        return new Quaternion(this);
    }

    public float dot(float f, float f2, float f3, float f4) {
        return this.x * f + this.y * f2 + this.z * f3 + this.w * f4;
    }

    public float dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Quaternion)) {
            return false;
        }
        object = (Quaternion)object;
        if (NumberUtils.floatToRawIntBits(this.w) != NumberUtils.floatToRawIntBits(((Quaternion)object).w) || NumberUtils.floatToRawIntBits(this.x) != NumberUtils.floatToRawIntBits(((Quaternion)object).x) || NumberUtils.floatToRawIntBits(this.y) != NumberUtils.floatToRawIntBits(((Quaternion)object).y) || NumberUtils.floatToRawIntBits(this.z) != NumberUtils.floatToRawIntBits(((Quaternion)object).z)) {
            bl = false;
        }
        return bl;
    }

    public Quaternion exp(float f) {
        double d;
        double d2;
        float f2 = this.len();
        double d3 = f2;
        float f3 = (float)Math.pow(d3, f);
        float f4 = (float)Math.acos(this.w / f2);
        if ((double)Math.abs(f4) < 0.001) {
            f2 = f3 * f / f2;
        } else {
            double d4 = f3;
            d2 = Math.sin(f * f4);
            Double.isNaN(d4);
            d = Math.sin(f4);
            Double.isNaN(d3);
            f2 = (float)(d4 * d2 / (d3 * d));
        }
        d = f3;
        d2 = Math.cos(f * f4);
        Double.isNaN(d);
        this.w = (float)(d * d2);
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        this.nor();
        return this;
    }

    public float getAngle() {
        return this.getAngleRad() * 57.295776f;
    }

    public float getAngleAround(float f, float f2, float f3) {
        return this.getAngleAroundRad(f, f2, f3) * 57.295776f;
    }

    public float getAngleAround(Vector3 vector3) {
        return this.getAngleAround(vector3.x, vector3.y, vector3.z);
    }

    public float getAngleAroundRad(float f, float f2, float f3) {
        float f4 = Vector3.dot(this.x, this.y, this.z, f, f2, f3);
        f2 = Quaternion.len2(f * f4, f2 * f4, f3 * f4, this.w);
        boolean bl = MathUtils.isZero(f2);
        f = 0.0f;
        if (!bl) {
            f = f4 < 0.0f ? -this.w : this.w;
            double d = f;
            double d2 = Math.sqrt(f2);
            Double.isNaN(d);
            f = (float)(Math.acos(MathUtils.clamp((float)(d / d2), -1.0f, 1.0f)) * 2.0);
        }
        return f;
    }

    public float getAngleAroundRad(Vector3 vector3) {
        return this.getAngleAroundRad(vector3.x, vector3.y, vector3.z);
    }

    public float getAngleRad() {
        float f;
        float f2 = f = this.w;
        if (f > 1.0f) {
            f2 = f / this.len();
        }
        return (float)(Math.acos(f2) * 2.0);
    }

    public float getAxisAngle(Vector3 vector3) {
        return this.getAxisAngleRad(vector3) * 57.295776f;
    }

    public float getAxisAngleRad(Vector3 vector3) {
        if (this.w > 1.0f) {
            this.nor();
        }
        float f = (float)(Math.acos(this.w) * 2.0);
        float f2 = this.w;
        double d = Math.sqrt(1.0f - f2 * f2);
        if (d < (double)1.0E-6f) {
            vector3.x = this.x;
            vector3.y = this.y;
            vector3.z = this.z;
        } else {
            double d2 = this.x;
            Double.isNaN(d2);
            vector3.x = (float)(d2 / d);
            d2 = this.y;
            Double.isNaN(d2);
            vector3.y = (float)(d2 / d);
            d2 = this.z;
            Double.isNaN(d2);
            vector3.z = (float)(d2 / d);
        }
        return f;
    }

    public int getGimbalPole() {
        float f = this.y * this.x + this.z * this.w;
        int n = f > 0.499f ? 1 : (f < -0.499f ? -1 : 0);
        return n;
    }

    public float getPitch() {
        return this.getPitchRad() * 57.295776f;
    }

    public float getPitchRad() {
        int n = this.getGimbalPole();
        float f = n == 0 ? (float)Math.asin(MathUtils.clamp((this.w * this.x - this.z * this.y) * 2.0f, -1.0f, 1.0f)) : (float)n * (float)Math.PI * 0.5f;
        return f;
    }

    public float getRoll() {
        return this.getRollRad() * 57.295776f;
    }

    public float getRollRad() {
        float f;
        int n = this.getGimbalPole();
        if (n == 0) {
            f = this.w;
            float f2 = this.z;
            float f3 = this.y;
            float f4 = this.x;
            f = MathUtils.atan2((f * f2 + f3 * f4) * 2.0f, 1.0f - (f4 * f4 + f2 * f2) * 2.0f);
        } else {
            f = (float)n * 2.0f * MathUtils.atan2(this.y, this.w);
        }
        return f;
    }

    public void getSwingTwist(float f, float f2, float f3, Quaternion quaternion, Quaternion quaternion2) {
        float f4 = Vector3.dot(this.x, this.y, this.z, f, f2, f3);
        quaternion2.set(f * f4, f2 * f4, f3 * f4, this.w).nor();
        if (f4 < 0.0f) {
            quaternion2.mul(-1.0f);
        }
        quaternion.set(quaternion2).conjugate().mulLeft(this);
    }

    public void getSwingTwist(Vector3 vector3, Quaternion quaternion, Quaternion quaternion2) {
        this.getSwingTwist(vector3.x, vector3.y, vector3.z, quaternion, quaternion2);
    }

    public float getYaw() {
        return this.getYawRad() * 57.295776f;
    }

    public float getYawRad() {
        float f;
        if (this.getGimbalPole() == 0) {
            float f2 = this.y;
            f = this.w;
            float f3 = this.x;
            f = MathUtils.atan2((f * f2 + this.z * f3) * 2.0f, 1.0f - (f2 * f2 + f3 * f3) * 2.0f);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public int hashCode() {
        return (((NumberUtils.floatToRawIntBits(this.w) + 31) * 31 + NumberUtils.floatToRawIntBits(this.x)) * 31 + NumberUtils.floatToRawIntBits(this.y)) * 31 + NumberUtils.floatToRawIntBits(this.z);
    }

    public Quaternion idt() {
        return this.set(0.0f, 0.0f, 0.0f, 1.0f);
    }

    public boolean isIdentity() {
        boolean bl = MathUtils.isZero(this.x) && MathUtils.isZero(this.y) && MathUtils.isZero(this.z) && MathUtils.isEqual(this.w, 1.0f);
        return bl;
    }

    public boolean isIdentity(float f) {
        boolean bl = MathUtils.isZero(this.x, f) && MathUtils.isZero(this.y, f) && MathUtils.isZero(this.z, f) && MathUtils.isEqual(this.w, 1.0f, f);
        return bl;
    }

    public float len() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3 + f4 * f4);
    }

    public float len2() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = this.w;
        return f * f + f2 * f2 + f3 * f3 + f4 * f4;
    }

    public Quaternion mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Quaternion mul(float f, float f2, float f3, float f4) {
        float f5 = this.w;
        float f6 = this.x;
        float f7 = this.y;
        float f8 = this.z;
        this.x = f5 * f + f6 * f4 + f7 * f3 - f8 * f2;
        this.y = f5 * f2 + f7 * f4 + f8 * f - f6 * f3;
        this.z = f5 * f3 + f8 * f4 + f6 * f2 - f7 * f;
        this.w = f5 * f4 - f6 * f - f7 * f2 - f8 * f3;
        return this;
    }

    public Quaternion mul(Quaternion quaternion) {
        float f = this.w;
        float f2 = quaternion.x;
        float f3 = this.x;
        float f4 = quaternion.w;
        float f5 = this.y;
        float f6 = quaternion.z;
        float f7 = this.z;
        float f8 = quaternion.y;
        this.x = f * f2 + f3 * f4 + f5 * f6 - f7 * f8;
        this.y = f * f8 + f5 * f4 + f7 * f2 - f3 * f6;
        this.z = f * f6 + f7 * f4 + f3 * f8 - f5 * f2;
        this.w = f * f4 - f3 * f2 - f5 * f8 - f7 * f6;
        return this;
    }

    public Quaternion mulLeft(float f, float f2, float f3, float f4) {
        float f5 = this.x;
        float f6 = this.w;
        float f7 = this.z;
        float f8 = this.y;
        this.x = f4 * f5 + f * f6 + f2 * f7 - f3 * f8;
        this.y = f4 * f8 + f2 * f6 + f3 * f5 - f * f7;
        this.z = f4 * f7 + f3 * f6 + f * f8 - f2 * f5;
        this.w = f4 * f6 - f * f5 - f2 * f8 - f3 * f7;
        return this;
    }

    public Quaternion mulLeft(Quaternion quaternion) {
        float f = quaternion.w;
        float f2 = this.x;
        float f3 = quaternion.x;
        float f4 = this.w;
        float f5 = quaternion.y;
        float f6 = this.z;
        float f7 = quaternion.z;
        float f8 = this.y;
        this.x = f * f2 + f3 * f4 + f5 * f6 - f7 * f8;
        this.y = f * f8 + f5 * f4 + f7 * f2 - f3 * f6;
        this.z = f * f6 + f7 * f4 + f3 * f8 - f5 * f2;
        this.w = f * f4 - f3 * f2 - f5 * f8 - f7 * f6;
        return this;
    }

    public Quaternion nor() {
        float f = this.len2();
        if (f != 0.0f && !MathUtils.isEqual(f, 1.0f)) {
            f = (float)Math.sqrt(f);
            this.w /= f;
            this.x /= f;
            this.y /= f;
            this.z /= f;
        }
        return this;
    }

    public Quaternion set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(Vector3 vector3, float f) {
        return this.setFromAxis(vector3.x, vector3.y, vector3.z, f);
    }

    public Quaternion setEulerAngles(float f, float f2, float f3) {
        return this.setEulerAnglesRad(f * ((float)Math.PI / 180), f2 * ((float)Math.PI / 180), f3 * ((float)Math.PI / 180));
    }

    public Quaternion setEulerAnglesRad(float f, float f2, float f3) {
        double d = f3 * 0.5f;
        f3 = (float)Math.sin(d);
        float f4 = (float)Math.cos(d);
        d = f2 * 0.5f;
        float f5 = (float)Math.sin(d);
        float f6 = (float)Math.cos(d);
        d = f * 0.5f;
        float f7 = (float)Math.sin(d);
        float f8 = (float)Math.cos(d);
        f2 = f8 * f5;
        f = f7 * f6;
        f6 = f8 * f6;
        f5 = f7 * f5;
        this.x = f2 * f4 + f * f3;
        this.y = f * f4 - f2 * f3;
        this.z = f6 * f3 - f5 * f4;
        this.w = f6 * f4 + f5 * f3;
        return this;
    }

    public Quaternion setFromAxes(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return this.setFromAxes(false, f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public Quaternion setFromAxes(boolean bl, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f;
        float f11 = f2;
        float f12 = f3;
        float f13 = f4;
        float f14 = f5;
        float f15 = f6;
        float f16 = f7;
        float f17 = f8;
        float f18 = f9;
        if (bl) {
            f16 = 1.0f / Vector3.len(f, f2, f3);
            f17 = 1.0f / Vector3.len(f4, f5, f6);
            f18 = 1.0f / Vector3.len(f7, f8, f9);
            f10 = f * f16;
            f11 = f2 * f16;
            f12 = f3 * f16;
            f13 = f4 * f17;
            f14 = f5 * f17;
            f15 = f6 * f17;
            f16 = f7 * f18;
            f17 = f8 * f18;
            f18 = f9 * f18;
        }
        if ((f = f10 + f14 + f18) >= 0.0f) {
            f = (float)Math.sqrt(f + 1.0f);
            this.w = f * 0.5f;
            f = 0.5f / f;
            this.x = (f17 - f15) * f;
            this.y = (f12 - f16) * f;
            this.z = (f13 - f11) * f;
        } else if (f10 > f14 && f10 > f18) {
            double d = f10;
            Double.isNaN(d);
            double d2 = f14;
            Double.isNaN(d2);
            double d3 = f18;
            Double.isNaN(d3);
            f = (float)Math.sqrt(d + 1.0 - d2 - d3);
            this.x = f * 0.5f;
            f = 0.5f / f;
            this.y = (f13 + f11) * f;
            this.z = (f12 + f16) * f;
            this.w = (f17 - f15) * f;
        } else if (f14 > f18) {
            double d = f14;
            Double.isNaN(d);
            double d4 = f10;
            Double.isNaN(d4);
            double d5 = f18;
            Double.isNaN(d5);
            f = (float)Math.sqrt(d + 1.0 - d4 - d5);
            this.y = f * 0.5f;
            f = 0.5f / f;
            this.x = (f13 + f11) * f;
            this.z = (f17 + f15) * f;
            this.w = (f12 - f16) * f;
        } else {
            double d = f18;
            Double.isNaN(d);
            double d6 = f10;
            Double.isNaN(d6);
            double d7 = f14;
            Double.isNaN(d7);
            f = (float)Math.sqrt(d + 1.0 - d6 - d7);
            this.z = f * 0.5f;
            f = 0.5f / f;
            this.x = (f12 + f16) * f;
            this.y = (f17 + f15) * f;
            this.w = (f13 - f11) * f;
        }
        return this;
    }

    public Quaternion setFromAxis(float f, float f2, float f3, float f4) {
        return this.setFromAxisRad(f, f2, f3, f4 * ((float)Math.PI / 180));
    }

    public Quaternion setFromAxis(Vector3 vector3, float f) {
        return this.setFromAxis(vector3.x, vector3.y, vector3.z, f);
    }

    public Quaternion setFromAxisRad(float f, float f2, float f3, float f4) {
        float f5 = Vector3.len(f, f2, f3);
        if (f5 == 0.0f) {
            return this.idt();
        }
        f5 = 1.0f / f5;
        f4 = f4 < 0.0f ? (float)Math.PI * 2 - -f4 % ((float)Math.PI * 2) : (f4 %= (float)Math.PI * 2);
        double d = f4 / 2.0f;
        f4 = (float)Math.sin(d);
        return this.set(f * f5 * f4, f2 * f5 * f4, f5 * f3 * f4, (float)Math.cos(d)).nor();
    }

    public Quaternion setFromAxisRad(Vector3 vector3, float f) {
        return this.setFromAxisRad(vector3.x, vector3.y, vector3.z, f);
    }

    public Quaternion setFromCross(float f, float f2, float f3, float f4, float f5, float f6) {
        return this.setFromAxisRad(f2 * f6 - f3 * f5, f3 * f4 - f6 * f, f * f5 - f2 * f4, (float)Math.acos(MathUtils.clamp(Vector3.dot(f, f2, f3, f4, f5, f6), -1.0f, 1.0f)));
    }

    public Quaternion setFromCross(Vector3 vector3, Vector3 vector32) {
        float f = (float)Math.acos(MathUtils.clamp(vector3.dot(vector32), -1.0f, 1.0f));
        return this.setFromAxisRad(vector3.y * vector32.z - vector3.z * vector32.y, vector3.z * vector32.x - vector3.x * vector32.z, vector3.x * vector32.y - vector3.y * vector32.x, f);
    }

    public Quaternion setFromMatrix(Matrix3 matrix3) {
        return this.setFromMatrix(false, matrix3);
    }

    public Quaternion setFromMatrix(Matrix4 matrix4) {
        return this.setFromMatrix(false, matrix4);
    }

    public Quaternion setFromMatrix(boolean bl, Matrix3 matrix3) {
        return this.setFromAxes(bl, matrix3.val[0], matrix3.val[3], matrix3.val[6], matrix3.val[1], matrix3.val[4], matrix3.val[7], matrix3.val[2], matrix3.val[5], matrix3.val[8]);
    }

    public Quaternion setFromMatrix(boolean bl, Matrix4 matrix4) {
        return this.setFromAxes(bl, matrix4.val[0], matrix4.val[4], matrix4.val[8], matrix4.val[1], matrix4.val[5], matrix4.val[9], matrix4.val[2], matrix4.val[6], matrix4.val[10]);
    }

    public Quaternion slerp(Quaternion quaternion, float f) {
        float f2;
        float f3 = this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
        float f4 = f3 < 0.0f ? -f3 : f3;
        float f5 = f2 = 1.0f - f;
        float f6 = f;
        if ((double)(1.0f - f4) > 0.1) {
            f4 = (float)Math.acos(f4);
            f6 = 1.0f / (float)Math.sin(f4);
            f5 = (float)Math.sin(f2 * f4) * f6;
            f6 = (float)Math.sin(f * f4) * f6;
        }
        f = f6;
        if (f3 < 0.0f) {
            f = -f6;
        }
        this.x = this.x * f5 + quaternion.x * f;
        this.y = this.y * f5 + quaternion.y * f;
        this.z = this.z * f5 + quaternion.z * f;
        this.w = f5 * this.w + f * quaternion.w;
        return this;
    }

    public Quaternion slerp(Quaternion[] quaternionArray) {
        float f = 1.0f / (float)quaternionArray.length;
        this.set(quaternionArray[0]).exp(f);
        for (int i = 1; i < quaternionArray.length; ++i) {
            this.mul(tmp1.set(quaternionArray[i]).exp(f));
        }
        this.nor();
        return this;
    }

    public Quaternion slerp(Quaternion[] quaternionArray, float[] fArray) {
        this.set(quaternionArray[0]).exp(fArray[0]);
        for (int i = 1; i < quaternionArray.length; ++i) {
            this.mul(tmp1.set(quaternionArray[i]).exp(fArray[i]));
        }
        this.nor();
        return this;
    }

    public void toMatrix(float[] fArray) {
        float f = this.x;
        float f2 = f * f;
        float f3 = this.y;
        float f4 = f * f3;
        float f5 = this.z;
        float f6 = f * f5;
        float f7 = this.w;
        float f8 = f * f7;
        f = f3 * f3;
        float f9 = f3 * f5;
        float f10 = f3 * f7;
        f3 = f5 * f5;
        f7 = f5 * f7;
        fArray[0] = 1.0f - (f + f3) * 2.0f;
        fArray[4] = (f4 - f7) * 2.0f;
        fArray[8] = (f6 + f10) * 2.0f;
        fArray[12] = 0.0f;
        fArray[1] = (f4 + f7) * 2.0f;
        fArray[5] = 1.0f - (f3 + f2) * 2.0f;
        fArray[9] = (f9 - f8) * 2.0f;
        fArray[13] = 0.0f;
        fArray[2] = (f6 - f10) * 2.0f;
        fArray[6] = (f9 + f8) * 2.0f;
        fArray[10] = 1.0f - (f2 + f) * 2.0f;
        fArray[14] = 0.0f;
        fArray[3] = 0.0f;
        fArray[7] = 0.0f;
        fArray[11] = 0.0f;
        fArray[15] = 1.0f;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(this.x);
        stringBuilder.append("|");
        stringBuilder.append(this.y);
        stringBuilder.append("|");
        stringBuilder.append(this.z);
        stringBuilder.append("|");
        stringBuilder.append(this.w);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public Vector3 transform(Vector3 vector3) {
        tmp2.set(this);
        tmp2.conjugate();
        tmp2.mulLeft(tmp1.set(vector3.x, vector3.y, vector3.z, 0.0f)).mulLeft(this);
        Quaternion quaternion = tmp2;
        vector3.x = quaternion.x;
        vector3.y = quaternion.y;
        vector3.z = quaternion.z;
        return vector3;
    }
}

