/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.RandomXS128;
import java.util.Random;

public final class MathUtils {
    private static final double BIG_ENOUGH_CEIL = 16384.999999999996;
    private static final double BIG_ENOUGH_FLOOR = 16384.0;
    private static final int BIG_ENOUGH_INT = 16384;
    private static final double BIG_ENOUGH_ROUND = 16384.5;
    private static final double CEIL = 0.9999999;
    public static final float E = (float)Math.E;
    public static final float FLOAT_ROUNDING_ERROR = 1.0E-6f;
    public static final float PI = (float)Math.PI;
    public static final float PI2 = (float)Math.PI * 2;
    private static final int SIN_BITS = 14;
    private static final int SIN_COUNT = 16384;
    private static final int SIN_MASK = 16383;
    private static final float degFull = 360.0f;
    public static final float degRad = (float)Math.PI / 180;
    private static final float degToIndex = 45.511112f;
    public static final float degreesToRadians = (float)Math.PI / 180;
    public static final float nanoToSec = 1.0E-9f;
    public static final float radDeg = 57.295776f;
    private static final float radFull = (float)Math.PI * 2;
    private static final float radToIndex = 2607.5945f;
    public static final float radiansToDegrees = 57.295776f;
    public static Random random = new RandomXS128();

    public static float atan2(float f, float f2) {
        if (f2 == 0.0f) {
            if (f > 0.0f) {
                return 1.5707964f;
            }
            if (f == 0.0f) {
                return 0.0f;
            }
            return -1.5707964f;
        }
        float f3 = f / f2;
        float f4 = Math.abs(f3);
        float f5 = (float)Math.PI;
        if (f4 < 1.0f) {
            f3 = f4 = f3 / (0.28f * f3 * f3 + 1.0f);
            if (f2 < 0.0f) {
                f2 = f5;
                if (f < 0.0f) {
                    f2 = (float)(-Math.PI);
                }
                f3 = f4 + f2;
            }
            return f3;
        }
        f2 = f3 = 1.5707964f - f3 / (f3 * f3 + 0.28f);
        if (f < 0.0f) {
            f2 = f3 - (float)Math.PI;
        }
        return f2;
    }

    public static int ceil(float f) {
        double d = f;
        Double.isNaN(d);
        return 16384 - (int)(16384.0 - d);
    }

    public static int ceilPositive(float f) {
        double d = f;
        Double.isNaN(d);
        return (int)(d + 0.9999999);
    }

    public static double clamp(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public static long clamp(long l, long l2, long l3) {
        if (l < l2) {
            return l2;
        }
        if (l > l3) {
            return l3;
        }
        return l;
    }

    public static short clamp(short s, short s2, short s3) {
        if (s < s2) {
            return s2;
        }
        if (s > s3) {
            return s3;
        }
        return s;
    }

    public static float cos(float f) {
        return Sin.table[(int)((f + 1.5707964f) * 2607.5945f) & 0x3FFF];
    }

    public static float cosDeg(float f) {
        return Sin.table[(int)((f + 90.0f) * 45.511112f) & 0x3FFF];
    }

    public static int floor(float f) {
        double d = f;
        Double.isNaN(d);
        return (int)(d + 16384.0) - 16384;
    }

    public static int floorPositive(float f) {
        return (int)f;
    }

    public static boolean isEqual(float f, float f2) {
        boolean bl = Math.abs(f - f2) <= 1.0E-6f;
        return bl;
    }

    public static boolean isEqual(float f, float f2, float f3) {
        boolean bl = Math.abs(f - f2) <= f3;
        return bl;
    }

    public static boolean isPowerOfTwo(int n) {
        boolean bl = n != 0 && (n & n - 1) == 0;
        return bl;
    }

    public static boolean isZero(float f) {
        boolean bl = Math.abs(f) <= 1.0E-6f;
        return bl;
    }

    public static boolean isZero(float f, float f2) {
        boolean bl = Math.abs(f) <= f2;
        return bl;
    }

    public static float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static float lerpAngle(float f, float f2, float f3) {
        return (f + ((f2 - f + (float)Math.PI * 2 + (float)Math.PI) % ((float)Math.PI * 2) - (float)Math.PI) * f3 + (float)Math.PI * 2) % ((float)Math.PI * 2);
    }

    public static float lerpAngleDeg(float f, float f2, float f3) {
        return (f + ((f2 - f + 360.0f + 180.0f) % 360.0f - 180.0f) * f3 + 360.0f) % 360.0f;
    }

    public static float log(float f, float f2) {
        return (float)(Math.log(f2) / Math.log(f));
    }

    public static float log2(float f) {
        return MathUtils.log(2.0f, f);
    }

    public static float map(float f, float f2, float f3, float f4, float f5) {
        return f3 + (f5 - f) * (f4 - f3) / (f2 - f);
    }

    public static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        return (n | n >> 16) + 1;
    }

    public static float norm(float f, float f2, float f3) {
        return (f3 - f) / (f2 - f);
    }

    public static float random() {
        return random.nextFloat();
    }

    public static float random(float f) {
        return random.nextFloat() * f;
    }

    public static float random(float f, float f2) {
        return f + random.nextFloat() * (f2 - f);
    }

    public static int random(int n) {
        return random.nextInt(n + 1);
    }

    public static int random(int n, int n2) {
        return n + random.nextInt(n2 - n + 1);
    }

    public static long random(long l) {
        double d = random.nextDouble();
        double d2 = l;
        Double.isNaN(d2);
        return (long)(d * d2);
    }

    public static long random(long l, long l2) {
        double d = random.nextDouble();
        double d2 = l2 - l;
        Double.isNaN(d2);
        return l + (long)(d * d2);
    }

    public static boolean randomBoolean() {
        return random.nextBoolean();
    }

    public static boolean randomBoolean(float f) {
        boolean bl = MathUtils.random() < f;
        return bl;
    }

    public static int randomSign() {
        return random.nextInt() >> 31 | 1;
    }

    public static float randomTriangular() {
        return random.nextFloat() - random.nextFloat();
    }

    public static float randomTriangular(float f) {
        return (random.nextFloat() - random.nextFloat()) * f;
    }

    public static float randomTriangular(float f, float f2) {
        return MathUtils.randomTriangular(f, f2, (f + f2) * 0.5f);
    }

    public static float randomTriangular(float f, float f2, float f3) {
        float f4;
        float f5;
        float f6 = random.nextFloat();
        if (f6 <= (f5 = f3 - f) / (f4 = f2 - f)) {
            return f + (float)Math.sqrt(f6 * f4 * f5);
        }
        return f2 - (float)Math.sqrt((1.0f - f6) * f4 * (f2 - f3));
    }

    public static int round(float f) {
        double d = f;
        Double.isNaN(d);
        return (int)(d + 16384.5) - 16384;
    }

    public static int roundPositive(float f) {
        return (int)(f + 0.5f);
    }

    public static float sin(float f) {
        return Sin.table[(int)(f * 2607.5945f) & 0x3FFF];
    }

    public static float sinDeg(float f) {
        return Sin.table[(int)(f * 45.511112f) & 0x3FFF];
    }

    private static class Sin {
        static final float[] table = new float[16384];

        static {
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n2 >= 16384) break;
                Sin.table[n2] = (float)Math.sin(((float)n2 + 0.5f) / 16384.0f * ((float)Math.PI * 2));
                ++n2;
            }
            for (int i = n; i < 360; i += 90) {
                float[] fArray = table;
                float f = i;
                fArray[(int)(45.511112f * f) & 0x3FFF] = (float)Math.sin(f * ((float)Math.PI / 180));
            }
        }

        private Sin() {
        }
    }
}

