/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;

public abstract class Interpolation {
    public static final Bounce bounce;
    public static final BounceIn bounceIn;
    public static final BounceOut bounceOut;
    public static final Interpolation circle;
    public static final Interpolation circleIn;
    public static final Interpolation circleOut;
    public static final Elastic elastic;
    public static final ElasticIn elasticIn;
    public static final ElasticOut elasticOut;
    public static final Exp exp10;
    public static final ExpIn exp10In;
    public static final ExpOut exp10Out;
    public static final Exp exp5;
    public static final ExpIn exp5In;
    public static final ExpOut exp5Out;
    public static final Interpolation fade;
    public static final PowOut fastSlow;
    public static final Interpolation linear;
    public static final Pow pow2;
    public static final PowIn pow2In;
    public static final Interpolation pow2InInverse;
    public static final PowOut pow2Out;
    public static final Interpolation pow2OutInverse;
    public static final Pow pow3;
    public static final PowIn pow3In;
    public static final Interpolation pow3InInverse;
    public static final PowOut pow3Out;
    public static final Interpolation pow3OutInverse;
    public static final Pow pow4;
    public static final PowIn pow4In;
    public static final PowOut pow4Out;
    public static final Pow pow5;
    public static final PowIn pow5In;
    public static final PowOut pow5Out;
    public static final Interpolation sine;
    public static final Interpolation sineIn;
    public static final Interpolation sineOut;
    public static final PowIn slowFast;
    public static final Interpolation smooth;
    public static final Interpolation smooth2;
    public static final Interpolation smoother;
    public static final Swing swing;
    public static final SwingIn swingIn;
    public static final SwingOut swingOut;

    static {
        linear = new Interpolation(){

            @Override
            public float apply(float f) {
                return f;
            }
        };
        smooth = new Interpolation(){

            @Override
            public float apply(float f) {
                return f * f * (3.0f - f * 2.0f);
            }
        };
        smooth2 = new Interpolation(){

            @Override
            public float apply(float f) {
                f = f * f * (3.0f - f * 2.0f);
                return f * f * (3.0f - f * 2.0f);
            }
        };
        fade = smoother = new Interpolation(){

            @Override
            public float apply(float f) {
                return f * f * f * (f * (6.0f * f - 15.0f) + 10.0f);
            }
        };
        pow2 = new Pow(2);
        slowFast = pow2In = new PowIn(2);
        fastSlow = pow2Out = new PowOut(2);
        pow2InInverse = new Interpolation(){

            @Override
            public float apply(float f) {
                return (float)Math.sqrt(f);
            }
        };
        pow2OutInverse = new Interpolation(){

            @Override
            public float apply(float f) {
                return 1.0f - (float)Math.sqrt(-(f - 1.0f));
            }
        };
        pow3 = new Pow(3);
        pow3In = new PowIn(3);
        pow3Out = new PowOut(3);
        pow3InInverse = new Interpolation(){

            @Override
            public float apply(float f) {
                return (float)Math.cbrt(f);
            }
        };
        pow3OutInverse = new Interpolation(){

            @Override
            public float apply(float f) {
                return 1.0f - (float)Math.cbrt(-(f - 1.0f));
            }
        };
        pow4 = new Pow(4);
        pow4In = new PowIn(4);
        pow4Out = new PowOut(4);
        pow5 = new Pow(5);
        pow5In = new PowIn(5);
        pow5Out = new PowOut(5);
        sine = new Interpolation(){

            @Override
            public float apply(float f) {
                return (1.0f - MathUtils.cos(f * (float)Math.PI)) / 2.0f;
            }
        };
        sineIn = new Interpolation(){

            @Override
            public float apply(float f) {
                return 1.0f - MathUtils.cos(f * (float)Math.PI / 2.0f);
            }
        };
        sineOut = new Interpolation(){

            @Override
            public float apply(float f) {
                return MathUtils.sin(f * (float)Math.PI / 2.0f);
            }
        };
        exp10 = new Exp(2.0f, 10.0f);
        exp10In = new ExpIn(2.0f, 10.0f);
        exp10Out = new ExpOut(2.0f, 10.0f);
        exp5 = new Exp(2.0f, 5.0f);
        exp5In = new ExpIn(2.0f, 5.0f);
        exp5Out = new ExpOut(2.0f, 5.0f);
        circle = new Interpolation(){

            @Override
            public float apply(float f) {
                if (f <= 0.5f) {
                    return (1.0f - (float)Math.sqrt(1.0f - (f *= 2.0f) * f)) / 2.0f;
                }
                f = (f - 1.0f) * 2.0f;
                return ((float)Math.sqrt(1.0f - f * f) + 1.0f) / 2.0f;
            }
        };
        circleIn = new Interpolation(){

            @Override
            public float apply(float f) {
                return 1.0f - (float)Math.sqrt(1.0f - f * f);
            }
        };
        circleOut = new Interpolation(){

            @Override
            public float apply(float f) {
                return (float)Math.sqrt(1.0f - (f -= 1.0f) * f);
            }
        };
        elastic = new Elastic(2.0f, 10.0f, 7, 1.0f);
        elasticIn = new ElasticIn(2.0f, 10.0f, 6, 1.0f);
        elasticOut = new ElasticOut(2.0f, 10.0f, 7, 1.0f);
        swing = new Swing(1.5f);
        swingIn = new SwingIn(2.0f);
        swingOut = new SwingOut(2.0f);
        bounce = new Bounce(4);
        bounceIn = new BounceIn(4);
        bounceOut = new BounceOut(4);
    }

    public abstract float apply(float var1);

    public float apply(float f, float f2, float f3) {
        return f + (f2 - f) * this.apply(f3);
    }

    public static class Bounce
    extends BounceOut {
        public Bounce(int n) {
            super(n);
        }

        public Bounce(float[] fArray, float[] fArray2) {
            super(fArray, fArray2);
        }

        private float out(float f) {
            float f2 = this.widths[0] / 2.0f + f;
            if (f2 < this.widths[0]) {
                return f2 / (this.widths[0] / 2.0f) - 1.0f;
            }
            return super.apply(f);
        }

        @Override
        public float apply(float f) {
            if (f <= 0.5f) {
                return (1.0f - this.out(1.0f - f * 2.0f)) / 2.0f;
            }
            return this.out(f * 2.0f - 1.0f) / 2.0f + 0.5f;
        }
    }

    public static class BounceIn
    extends BounceOut {
        public BounceIn(int n) {
            super(n);
        }

        public BounceIn(float[] fArray, float[] fArray2) {
            super(fArray, fArray2);
        }

        @Override
        public float apply(float f) {
            return 1.0f - super.apply(1.0f - f);
        }
    }

    public static class BounceOut
    extends Interpolation {
        final float[] heights;
        final float[] widths;

        public BounceOut(int n) {
            if (n >= 2 && n <= 5) {
                this.widths = new float[n];
                float[] fArray = this.heights = new float[n];
                fArray[0] = 1.0f;
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n == 5) {
                                float[] fArray2 = this.widths;
                                fArray2[0] = 0.3f;
                                fArray2[1] = 0.3f;
                                fArray2[2] = 0.2f;
                                fArray2[3] = 0.1f;
                                fArray2[4] = 0.1f;
                                fArray[1] = 0.45f;
                                fArray[2] = 0.3f;
                                fArray[3] = 0.15f;
                                fArray[4] = 0.06f;
                            }
                        } else {
                            float[] fArray3 = this.widths;
                            fArray3[0] = 0.34f;
                            fArray3[1] = 0.34f;
                            fArray3[2] = 0.2f;
                            fArray3[3] = 0.15f;
                            fArray[1] = 0.26f;
                            fArray[2] = 0.11f;
                            fArray[3] = 0.03f;
                        }
                    } else {
                        float[] fArray4 = this.widths;
                        fArray4[0] = 0.4f;
                        fArray4[1] = 0.4f;
                        fArray4[2] = 0.2f;
                        fArray[1] = 0.33f;
                        fArray[2] = 0.1f;
                    }
                } else {
                    float[] fArray5 = this.widths;
                    fArray5[0] = 0.6f;
                    fArray5[1] = 0.4f;
                    fArray[1] = 0.33f;
                }
                fArray = this.widths;
                fArray[0] = fArray[0] * 2.0f;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("bounces cannot be < 2 or > 5: ");
            stringBuilder.append(n);
            throw new IllegalArgumentException(stringBuilder.toString());
        }

        public BounceOut(float[] fArray, float[] fArray2) {
            if (fArray.length == fArray2.length) {
                this.widths = fArray;
                this.heights = fArray2;
                return;
            }
            throw new IllegalArgumentException("Must be the same number of widths and heights.");
        }

        @Override
        public float apply(float f) {
            float f2;
            if (f == 1.0f) {
                return 1.0f;
            }
            float[] fArray = this.widths;
            int n = 0;
            float f3 = f + fArray[0] / 2.0f;
            int n2 = fArray.length;
            float f4 = 0.0f;
            f = 0.0f;
            while (true) {
                f2 = f4;
                if (n >= n2) break;
                f = this.widths[n];
                if (f3 <= f) {
                    f2 = this.heights[n];
                    break;
                }
                f3 -= f;
                ++n;
            }
            f2 = 4.0f / f * f2 * (f3 /= f);
            return 1.0f - (f2 - f3 * f2) * f;
        }
    }

    public static class Elastic
    extends Interpolation {
        final float bounces;
        final float power;
        final float scale;
        final float value;

        public Elastic(float f, float f2, int n, float f3) {
            this.value = f;
            this.power = f2;
            this.scale = f3;
            f = n;
            n = n % 2 == 0 ? 1 : -1;
            this.bounces = f * (float)Math.PI * (float)n;
        }

        @Override
        public float apply(float f) {
            if (f <= 0.5f) {
                return (float)Math.pow(this.value, this.power * ((f *= 2.0f) - 1.0f)) * MathUtils.sin(f * this.bounces) * this.scale / 2.0f;
            }
            f = (1.0f - f) * 2.0f;
            return 1.0f - (float)Math.pow(this.value, this.power * (f - 1.0f)) * MathUtils.sin(f * this.bounces) * this.scale / 2.0f;
        }
    }

    public static class ElasticIn
    extends Elastic {
        public ElasticIn(float f, float f2, int n, float f3) {
            super(f, f2, n, f3);
        }

        @Override
        public float apply(float f) {
            if ((double)f >= 0.99) {
                return 1.0f;
            }
            return (float)Math.pow(this.value, this.power * (f - 1.0f)) * MathUtils.sin(f * this.bounces) * this.scale;
        }
    }

    public static class ElasticOut
    extends Elastic {
        public ElasticOut(float f, float f2, int n, float f3) {
            super(f, f2, n, f3);
        }

        @Override
        public float apply(float f) {
            if (f == 0.0f) {
                return 0.0f;
            }
            f = 1.0f - f;
            return 1.0f - (float)Math.pow(this.value, this.power * (f - 1.0f)) * MathUtils.sin(f * this.bounces) * this.scale;
        }
    }

    public static class Exp
    extends Interpolation {
        final float min;
        final float power;
        final float scale;
        final float value;

        public Exp(float f, float f2) {
            this.value = f;
            this.power = f2;
            this.min = (float)Math.pow(f, -f2);
            this.scale = 1.0f / (1.0f - this.min);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float apply(float f) {
            if (f <= 0.5f) {
                f = ((float)Math.pow(this.value, this.power * (f * 2.0f - 1.0f)) - this.min) * this.scale;
                return f / 2.0f;
            }
            f = 2.0f - ((float)Math.pow(this.value, -this.power * (f * 2.0f - 1.0f)) - this.min) * this.scale;
            return f / 2.0f;
        }
    }

    public static class ExpIn
    extends Exp {
        public ExpIn(float f, float f2) {
            super(f, f2);
        }

        @Override
        public float apply(float f) {
            return ((float)Math.pow(this.value, this.power * (f - 1.0f)) - this.min) * this.scale;
        }
    }

    public static class ExpOut
    extends Exp {
        public ExpOut(float f, float f2) {
            super(f, f2);
        }

        @Override
        public float apply(float f) {
            return 1.0f - ((float)Math.pow(this.value, -this.power * f) - this.min) * this.scale;
        }
    }

    public static class Pow
    extends Interpolation {
        final int power;

        public Pow(int n) {
            this.power = n;
        }

        @Override
        public float apply(float f) {
            if (f <= 0.5f) {
                return (float)Math.pow(f * 2.0f, this.power) / 2.0f;
            }
            f = (float)Math.pow((f - 1.0f) * 2.0f, this.power);
            int n = this.power;
            int n2 = 2;
            if (n % 2 == 0) {
                n2 = -2;
            }
            return f / (float)n2 + 1.0f;
        }
    }

    public static class PowIn
    extends Pow {
        public PowIn(int n) {
            super(n);
        }

        @Override
        public float apply(float f) {
            return (float)Math.pow(f, this.power);
        }
    }

    public static class PowOut
    extends Pow {
        public PowOut(int n) {
            super(n);
        }

        @Override
        public float apply(float f) {
            f = (float)Math.pow(f - 1.0f, this.power);
            int n = this.power % 2 == 0 ? -1 : 1;
            return f * (float)n + 1.0f;
        }
    }

    public static class Swing
    extends Interpolation {
        private final float scale;

        public Swing(float f) {
            this.scale = f * 2.0f;
        }

        @Override
        public float apply(float f) {
            if (f <= 0.5f) {
                float f2 = this.scale;
                return (f *= 2.0f) * f * ((1.0f + f2) * f - f2) / 2.0f;
            }
            f = (f - 1.0f) * 2.0f;
            float f3 = this.scale;
            return f * f * ((f3 + 1.0f) * f + f3) / 2.0f + 1.0f;
        }
    }

    public static class SwingIn
    extends Interpolation {
        private final float scale;

        public SwingIn(float f) {
            this.scale = f;
        }

        @Override
        public float apply(float f) {
            float f2 = this.scale;
            return f * f * ((1.0f + f2) * f - f2);
        }
    }

    public static class SwingOut
    extends Interpolation {
        private final float scale;

        public SwingOut(float f) {
            this.scale = f;
        }

        @Override
        public float apply(float f) {
            float f2 = this.scale;
            return (f -= 1.0f) * f * ((f2 + 1.0f) * f + f2) + 1.0f;
        }
    }
}

