/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import java.io.Serializable;

public class GridPoint3
implements Serializable {
    private static final long serialVersionUID = 5922187982746752830L;
    public int x;
    public int y;
    public int z;

    public GridPoint3() {
    }

    public GridPoint3(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public GridPoint3(GridPoint3 gridPoint3) {
        this.x = gridPoint3.x;
        this.y = gridPoint3.y;
        this.z = gridPoint3.z;
    }

    public GridPoint3 add(int n, int n2, int n3) {
        this.x += n;
        this.y += n2;
        this.z += n3;
        return this;
    }

    public GridPoint3 add(GridPoint3 gridPoint3) {
        this.x += gridPoint3.x;
        this.y += gridPoint3.y;
        this.z += gridPoint3.z;
        return this;
    }

    public GridPoint3 cpy() {
        return new GridPoint3(this);
    }

    public float dst(int n, int n2, int n3) {
        return (float)Math.sqrt((n -= this.x) * n + (n2 -= this.y) * n2 + (n3 -= this.z) * n3);
    }

    public float dst(GridPoint3 gridPoint3) {
        int n = gridPoint3.x - this.x;
        int n2 = gridPoint3.y - this.y;
        int n3 = gridPoint3.z - this.z;
        return (float)Math.sqrt(n * n + n2 * n2 + n3 * n3);
    }

    public float dst2(int n, int n2, int n3) {
        return (n -= this.x) * n + (n2 -= this.y) * n2 + (n3 -= this.z) * n3;
    }

    public float dst2(GridPoint3 gridPoint3) {
        int n = gridPoint3.x - this.x;
        int n2 = gridPoint3.y - this.y;
        int n3 = gridPoint3.z - this.z;
        return n * n + n2 * n2 + n3 * n3;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            object = (GridPoint3)object;
            if (this.x != ((GridPoint3)object).x || this.y != ((GridPoint3)object).y || this.z != ((GridPoint3)object).z) {
                bl = false;
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        return ((this.x + 17) * 17 + this.y) * 17 + this.z;
    }

    public GridPoint3 set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        return this;
    }

    public GridPoint3 set(GridPoint3 gridPoint3) {
        this.x = gridPoint3.x;
        this.y = gridPoint3.y;
        this.z = gridPoint3.z;
        return this;
    }

    public GridPoint3 sub(int n, int n2, int n3) {
        this.x -= n;
        this.y -= n2;
        this.z -= n3;
        return this;
    }

    public GridPoint3 sub(GridPoint3 gridPoint3) {
        this.x -= gridPoint3.x;
        this.y -= gridPoint3.y;
        this.z -= gridPoint3.z;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.x);
        stringBuilder.append(", ");
        stringBuilder.append(this.y);
        stringBuilder.append(", ");
        stringBuilder.append(this.z);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

