/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;

public class CumulativeDistribution<T> {
    private Array<CumulativeValue> values = new Array(false, 10, CumulativeValue.class);

    public void add(T t) {
        this.values.add(new CumulativeValue(t, 0.0f, 0.0f));
    }

    public void add(T t, float f) {
        this.values.add(new CumulativeValue(t, 0.0f, f));
    }

    public void clear() {
        this.values.clear();
    }

    public void generate() {
        float f = 0.0f;
        for (int i = 0; i < this.values.size; ++i) {
            ((CumulativeValue[])this.values.items)[i].frequency = f += ((CumulativeValue[])this.values.items)[i].interval;
        }
    }

    public void generateNormalized() {
        int n = 0;
        float f = 0.0f;
        int n2 = 0;
        float f2 = 0.0f;
        while (true) {
            float f3 = f;
            if (n2 >= this.values.size) break;
            f2 += ((CumulativeValue[])this.values.items)[n2].interval;
            ++n2;
        }
        for (int i = n; i < this.values.size; ++i) {
            ((CumulativeValue[])this.values.items)[i].frequency = f3 += ((CumulativeValue[])this.values.items)[i].interval / f2;
        }
    }

    public void generateUniform() {
        float f = 1.0f / (float)this.values.size;
        int n = 0;
        while (n < this.values.size) {
            ((CumulativeValue[])this.values.items)[n].interval = f;
            CumulativeValue cumulativeValue = ((CumulativeValue[])this.values.items)[n];
            cumulativeValue.frequency = (float)(++n) * f;
        }
    }

    public float getInterval(int n) {
        return ((CumulativeValue[])this.values.items)[n].interval;
    }

    public T getValue(int n) {
        return ((CumulativeValue[])this.values.items)[n].value;
    }

    public void setInterval(int n, float f) {
        ((CumulativeValue[])this.values.items)[n].interval = f;
    }

    public void setInterval(T t, float f) {
        for (CumulativeValue cumulativeValue : this.values) {
            if (cumulativeValue.value != t) continue;
            cumulativeValue.interval = f;
            break;
        }
    }

    public int size() {
        return this.values.size;
    }

    public T value() {
        return this.value(MathUtils.random());
    }

    public T value(float f) {
        int n = this.values.size - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = (n - n2) / 2 + n2;
            CumulativeValue cumulativeValue = ((CumulativeValue[])this.values.items)[n3];
            if (f < cumulativeValue.frequency) {
                n = n3 - 1;
                continue;
            }
            if (!(f > cumulativeValue.frequency)) break;
            n2 = n3 + 1;
        }
        return ((CumulativeValue[])this.values.items)[n2].value;
    }

    public class CumulativeValue {
        public float frequency;
        public float interval;
        public T value;

        public CumulativeValue(T t, float f, float f2) {
            this.value = t;
            this.frequency = f;
            this.interval = f2;
        }
    }
}

