/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Path;
import com.badlogic.gdx.math.Vector;
import com.badlogic.gdx.utils.Array;

public class BSpline<T extends Vector<T>>
implements Path<T> {
    private static final float d6 = 0.16666667f;
    public boolean continuous;
    public T[] controlPoints;
    public int degree;
    public Array<T> knots;
    public int spanCount;
    private T tmp;
    private T tmp2;
    private T tmp3;

    public BSpline() {
    }

    public BSpline(T[] TArray, int n, boolean bl) {
        this.set((Vector[])TArray, n, bl);
    }

    public static <T extends Vector<T>> T calculate(T t, float f, T[] TArray, int n, boolean bl, T t2) {
        int n2 = bl ? TArray.length : TArray.length - n;
        float f2 = (float)n2 * f;
        n2 = f >= 1.0f ? --n2 : (int)f2;
        return (T)BSpline.calculate(t, (int)n2, (float)(f2 - (float)n2), TArray, (int)n, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T calculate(T t, int n, float f, T[] TArray, int n2, boolean bl, T t2) {
        if (n2 != 3) {
            return t;
        }
        return (T)BSpline.cubic(t, (int)n, (float)f, TArray, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T cubic(T t, float f, T[] TArray, boolean bl, T t2) {
        int n = bl ? TArray.length : TArray.length - 3;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return (T)BSpline.cubic(t, (int)n, (float)(f2 - (float)n), TArray, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T cubic(T object, int n, float f, T[] TArray, boolean bl, T object2) {
        int n2 = TArray.length;
        float f2 = 1.0f - f;
        float f3 = f * f;
        float f4 = f3 * f;
        object.set(TArray[n]).scl((float)((f4 * 3.0f - 6.0f * f3 + 4.0f) * 0.16666667f));
        if (bl || n > 0) {
            object.add(object2.set(TArray[(n2 + n - 1) % n2]).scl((float)(f2 * f2 * f2 * 0.16666667f)));
        }
        if (bl || n < n2 - 1) {
            object.add(object2.set(TArray[(n + 1) % n2]).scl((float)((-3.0f * f4 + f3 * 3.0f + f * 3.0f + 1.0f) * 0.16666667f)));
        }
        if (bl || n < n2 - 2) {
            object.add(object2.set(TArray[(n + 2) % n2]).scl((float)(f4 * 0.16666667f)));
        }
        return (T)object;
    }

    public static <T extends Vector<T>> T cubic_derivative(T t, float f, T[] TArray, boolean bl, T t2) {
        int n = bl ? TArray.length : TArray.length - 3;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return (T)BSpline.cubic(t, (int)n, (float)(f2 - (float)n), TArray, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T cubic_derivative(T object, int n, float f, T[] TArray, boolean bl, T object2) {
        int n2 = TArray.length;
        float f2 = 1.0f - f;
        float f3 = f * f;
        object.set(TArray[n]).scl((float)(1.5f * f3 - 2.0f * f));
        if (bl || n > 0) {
            object.add(object2.set(TArray[(n2 + n - 1) % n2]).scl((float)(-0.5f * f2 * f2)));
        }
        if (bl || n < n2 - 1) {
            object.add(object2.set(TArray[(n + 1) % n2]).scl((float)(-1.5f * f3 + f + 0.5f)));
        }
        if (bl || n < n2 - 2) {
            object.add(object2.set(TArray[(n + 2) % n2]).scl((float)(f3 * 0.5f)));
        }
        return (T)object;
    }

    public static <T extends Vector<T>> T derivative(T t, float f, T[] TArray, int n, boolean bl, T t2) {
        int n2 = bl ? TArray.length : TArray.length - n;
        float f2 = (float)n2 * f;
        n2 = f >= 1.0f ? --n2 : (int)f2;
        return (T)BSpline.derivative(t, (int)n2, (float)(f2 - (float)n2), TArray, (int)n, (boolean)bl, t2);
    }

    public static <T extends Vector<T>> T derivative(T t, int n, float f, T[] TArray, int n2, boolean bl, T t2) {
        if (n2 != 3) {
            return t;
        }
        return (T)BSpline.cubic_derivative(t, (int)n, (float)f, TArray, (boolean)bl, t2);
    }

    @Override
    public float approxLength(int n) {
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.tmp2.set(this.tmp3);
            this.valueAt(this.tmp3, (float)i / ((float)n - 1.0f));
            float f2 = f;
            if (i > 0) {
                f2 = f + this.tmp2.dst(this.tmp3);
            }
            f = f2;
        }
        return f;
    }

    @Override
    public float approximate(T t) {
        return this.approximate(t, this.nearest(t));
    }

    public float approximate(T object, int n) {
        Object object2 = (Vector)this.knots.get(n);
        Object object3 = this.knots;
        int n2 = n > 0 ? n - 1 : this.spanCount - 1;
        object3 = (Vector)((Array)object3).get(n2);
        Vector vector = (Vector)this.knots.get((n + 1) % this.spanCount);
        float f = object.dst2((Object)object3);
        if (!(object.dst2((Vector)vector) < f)) {
            if (n <= 0) {
                n = this.spanCount;
            }
            --n;
            vector = object2;
            object2 = object3;
        }
        float f2 = object2.dst2(vector);
        f = object.dst2((Vector)vector);
        float f3 = object.dst2((Object)object2);
        float f4 = (float)Math.sqrt(f2);
        f = MathUtils.clamp((f4 - (f + f2 - f3) / (2.0f * f4)) / f4, 0.0f, 1.0f);
        return ((float)n + f) / (float)this.spanCount;
    }

    public float approximate(T t, int n, int n2) {
        return this.approximate(t, this.nearest(t, n, n2));
    }

    @Override
    public T derivativeAt(T t, float f) {
        int n = this.spanCount;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return this.derivativeAt(t, n, f2 - (float)n);
    }

    public T derivativeAt(T t, int n, float f) {
        if (!this.continuous) {
            n += (int)((float)this.degree * 0.5f);
        }
        return (T)BSpline.derivative(t, (int)n, (float)f, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }

    @Override
    public float locate(T t) {
        return this.approximate(t);
    }

    public int nearest(T t) {
        return this.nearest(t, 0, this.spanCount);
    }

    public int nearest(T vector, int n, int n2) {
        while (n < 0) {
            n += this.spanCount;
        }
        int n3 = n % this.spanCount;
        float f = vector.dst2((Vector)((Vector)this.knots.get(n3)));
        for (int i = 1; i < n2; ++i) {
            int n4 = (n + i) % this.spanCount;
            float f2 = vector.dst2((Vector)((Vector)this.knots.get(n4)));
            float f3 = f;
            if (f2 < f) {
                n3 = n4;
                f3 = f2;
            }
            f = f3;
        }
        return n3;
    }

    public BSpline set(T[] TArray, int n, boolean bl) {
        if (this.tmp == null) {
            this.tmp = TArray[0].cpy();
        }
        if (this.tmp2 == null) {
            this.tmp2 = TArray[0].cpy();
        }
        if (this.tmp3 == null) {
            this.tmp3 = TArray[0].cpy();
        }
        this.controlPoints = TArray;
        this.degree = n;
        this.continuous = bl;
        int n2 = bl ? TArray.length : TArray.length - n;
        this.spanCount = n2;
        Array<Vector> array = this.knots;
        if (array == null) {
            this.knots = new Array(this.spanCount);
        } else {
            array.clear();
            this.knots.ensureCapacity(this.spanCount);
        }
        for (n2 = 0; n2 < this.spanCount; ++n2) {
            array = this.knots;
            Object t = TArray[0].cpy();
            int n3 = bl ? n2 : (int)((float)n2 + (float)n * 0.5f);
            array.add(BSpline.calculate(t, (int)n3, (float)0.0f, TArray, (int)n, (boolean)bl, this.tmp));
        }
        return this;
    }

    @Override
    public T valueAt(T t, float f) {
        int n = this.spanCount;
        float f2 = (float)n * f;
        n = f >= 1.0f ? --n : (int)f2;
        return this.valueAt(t, n, f2 - (float)n);
    }

    public T valueAt(T t, int n, float f) {
        if (!this.continuous) {
            n += (int)((float)this.degree * 0.5f);
        }
        return (T)BSpline.calculate(t, (int)n, (float)f, this.controlPoints, (int)this.degree, (boolean)this.continuous, this.tmp);
    }
}

