/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled.renderers;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.MapGroupLayer;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapRenderer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.utils.Disposable;
import java.util.Iterator;

public abstract class BatchTiledMapRenderer
implements TiledMapRenderer,
Disposable {
    protected static final int NUM_VERTICES = 20;
    protected Batch batch;
    protected Rectangle imageBounds = new Rectangle();
    protected TiledMap map;
    protected boolean ownsBatch;
    protected float unitScale;
    protected float[] vertices = new float[20];
    protected Rectangle viewBounds;

    public BatchTiledMapRenderer(TiledMap tiledMap) {
        this(tiledMap, 1.0f);
    }

    public BatchTiledMapRenderer(TiledMap tiledMap, float f) {
        this.map = tiledMap;
        this.unitScale = f;
        this.viewBounds = new Rectangle();
        this.batch = new SpriteBatch();
        this.ownsBatch = true;
    }

    public BatchTiledMapRenderer(TiledMap tiledMap, float f, Batch batch) {
        this.map = tiledMap;
        this.unitScale = f;
        this.viewBounds = new Rectangle();
        this.batch = batch;
        this.ownsBatch = false;
    }

    public BatchTiledMapRenderer(TiledMap tiledMap, Batch batch) {
        this(tiledMap, 1.0f, batch);
    }

    protected void beginRender() {
        AnimatedTiledMapTile.updateAnimationBaseTime();
        this.batch.begin();
    }

    @Override
    public void dispose() {
        if (this.ownsBatch) {
            this.batch.dispose();
        }
    }

    protected void endRender() {
        this.batch.end();
    }

    public Batch getBatch() {
        return this.batch;
    }

    public TiledMap getMap() {
        return this.map;
    }

    public float getUnitScale() {
        return this.unitScale;
    }

    public Rectangle getViewBounds() {
        return this.viewBounds;
    }

    @Override
    public void render() {
        this.beginRender();
        Iterator<MapLayer> iterator = this.map.getLayers().iterator();
        while (iterator.hasNext()) {
            this.renderMapLayer(iterator.next());
        }
        this.endRender();
    }

    @Override
    public void render(int[] nArray) {
        this.beginRender();
        for (int n : nArray) {
            this.renderMapLayer(this.map.getLayers().get(n));
        }
        this.endRender();
    }

    @Override
    public void renderImageLayer(TiledMapImageLayer tiledMapImageLayer) {
        Object object = this.batch.getColor();
        float f = Color.toFloatBits(((Color)object).r, ((Color)object).g, ((Color)object).b, ((Color)object).a * tiledMapImageLayer.getOpacity());
        float[] fArray = this.vertices;
        object = tiledMapImageLayer.getTextureRegion();
        if (object == null) {
            return;
        }
        float f2 = tiledMapImageLayer.getX();
        float f3 = tiledMapImageLayer.getY();
        float f4 = this.unitScale;
        float f5 = f3 * f4;
        float f6 = (float)((TextureRegion)object).getRegionWidth() * this.unitScale + (f2 *= f4);
        f4 = (float)((TextureRegion)object).getRegionHeight() * this.unitScale + f5;
        this.imageBounds.set(f2, f5, f6 - f2, f4 - f5);
        if (this.viewBounds.contains(this.imageBounds) || this.viewBounds.overlaps(this.imageBounds)) {
            float f7 = ((TextureRegion)object).getU();
            f3 = ((TextureRegion)object).getV2();
            float f8 = ((TextureRegion)object).getU2();
            float f9 = ((TextureRegion)object).getV();
            fArray[0] = f2;
            fArray[1] = f5;
            fArray[2] = f;
            fArray[3] = f7;
            fArray[4] = f3;
            fArray[5] = f2;
            fArray[6] = f4;
            fArray[7] = f;
            fArray[8] = f7;
            fArray[9] = f9;
            fArray[10] = f6;
            fArray[11] = f4;
            fArray[12] = f;
            fArray[13] = f8;
            fArray[14] = f9;
            fArray[15] = f6;
            fArray[16] = f5;
            fArray[17] = f;
            fArray[18] = f8;
            fArray[19] = f3;
            this.batch.draw(((TextureRegion)object).getTexture(), fArray, 0, 20);
        }
    }

    protected void renderMapLayer(MapLayer mapLayer) {
        if (!mapLayer.isVisible()) {
            return;
        }
        if (mapLayer instanceof MapGroupLayer) {
            MapLayers mapLayers = ((MapGroupLayer)mapLayer).getLayers();
            for (int i = 0; i < mapLayers.size(); ++i) {
                mapLayer = mapLayers.get(i);
                if (!mapLayer.isVisible()) continue;
                this.renderMapLayer(mapLayer);
            }
        } else if (mapLayer instanceof TiledMapTileLayer) {
            this.renderTileLayer((TiledMapTileLayer)mapLayer);
        } else if (mapLayer instanceof TiledMapImageLayer) {
            this.renderImageLayer((TiledMapImageLayer)mapLayer);
        } else {
            this.renderObjects(mapLayer);
        }
    }

    @Override
    public void renderObject(MapObject mapObject) {
    }

    @Override
    public void renderObjects(MapLayer object) {
        object = ((MapLayer)object).getObjects().iterator();
        while (object.hasNext()) {
            this.renderObject((MapObject)object.next());
        }
    }

    public void setMap(TiledMap tiledMap) {
        this.map = tiledMap;
    }

    @Override
    public void setView(OrthographicCamera orthographicCamera) {
        this.batch.setProjectionMatrix(orthographicCamera.combined);
        float f = orthographicCamera.viewportWidth * orthographicCamera.zoom;
        float f2 = orthographicCamera.viewportHeight * orthographicCamera.zoom;
        float f3 = Math.abs(orthographicCamera.up.y) * f + Math.abs(orthographicCamera.up.x) * f2;
        f2 = f2 * Math.abs(orthographicCamera.up.y) + f * Math.abs(orthographicCamera.up.x);
        this.viewBounds.set(orthographicCamera.position.x - f3 / 2.0f, orthographicCamera.position.y - f2 / 2.0f, f3, f2);
    }

    @Override
    public void setView(Matrix4 matrix4, float f, float f2, float f3, float f4) {
        this.batch.setProjectionMatrix(matrix4);
        this.viewBounds.set(f, f2, f3, f4);
    }
}

