/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.util.Iterator;

public class AtlasTmxMapLoader
extends BaseTmxMapLoader<AtlasTiledMapLoaderParameters> {
    protected AtlasResolver atlasResolver;
    protected Array<Texture> trackedTextures = new Array();

    public AtlasTmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public AtlasTmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    private FileHandle getAtlasFileHandle(FileHandle object) {
        Object object2 = this.root.getChildByName("properties");
        if (object2 != null) {
            object2 = ((XmlReader.Element)object2).getChildrenByName("property").iterator();
            while (object2.hasNext()) {
                XmlReader.Element element = (XmlReader.Element)object2.next();
                if (!element.getAttribute("name").startsWith("atlas")) continue;
                object2 = element.getAttribute("value");
                break;
            }
        } else {
            object2 = null;
        }
        if (object2 != null) {
            if (((FileHandle)(object = AtlasTmxMapLoader.getRelativeFileHandle((FileHandle)object, (String)object2))).exists()) {
                return object;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("The 'atlas' file could not be found: '");
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append("'");
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
        object = new GdxRuntimeException("The map is missing the 'atlas' property");
        throw object;
    }

    private void setTextureFilters(Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2) {
        Iterator<Texture> iterator = this.trackedTextures.iterator();
        while (iterator.hasNext()) {
            iterator.next().setFilter(textureFilter, textureFilter2);
        }
        this.trackedTextures.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addStaticTiles(FileHandle object, ImageResolver object22, TiledMapTileSet tiledMapTileSet, XmlReader.Element object32, Array<XmlReader.Element> object4, String string2, int n, int n2, int n3, int n4, int n5, String string3, int n6, int n7, String string4, int n8, int n9, FileHandle fileHandle) {
        TextureAtlas.AtlasRegion atlasRegion;
        void var14_28;
        void var13_27;
        void var7_21;
        void var10_24;
        void var11_25;
        void var9_23;
        void var8_22;
        void var17_31;
        void var16_30;
        void var15_29;
        void var3_8;
        object = this.atlasResolver.getAtlas();
        for (Texture texture : ((TextureAtlas)object).getTextures()) {
            this.trackedTextures.add(texture);
        }
        MapProperties mapProperties = var3_8.getProperties();
        mapProperties.put("imagesource", var15_29);
        mapProperties.put("imagewidth", (int)var16_30);
        mapProperties.put("imageheight", (int)var17_31);
        mapProperties.put("tilewidth", (int)var8_22);
        mapProperties.put("tileheight", (int)var9_23);
        mapProperties.put("margin", (int)var11_25);
        mapProperties.put("spacing", (int)var10_24);
        if (var15_29 != null && var15_29.length() > 0) {
            void var6_20;
            var8_22 = var16_30 / var8_22;
            var10_24 = var17_31 / var9_23;
            for (TextureAtlas.AtlasRegion atlasRegion2 : ((TextureAtlas)object).findRegions((String)var6_20)) {
                if (atlasRegion2 == null || (var9_23 = var7_21 + atlasRegion2.index) < var7_21 || var9_23 > var8_22 * var10_24 + var7_21 - true) continue;
                this.addStaticTiledMapTile((TiledMapTileSet)var3_8, atlasRegion2, (int)var9_23, (float)var13_27, (float)var14_28);
            }
        }
        Iterator iterator = ((Array)((Object)atlasRegion)).iterator();
        while (iterator.hasNext()) {
            XmlReader.Element element;
            XmlReader.Element element2 = (XmlReader.Element)iterator.next();
            var8_22 = var7_21 + element2.getIntAttribute("id", 0);
            if (var3_8.getTile((int)var8_22) != null || (element = element2.getChildByName("image")) == null) continue;
            String string6 = element.getAttribute("source");
            string6 = string6.substring(0, string6.lastIndexOf(46));
            atlasRegion = ((TextureAtlas)object).findRegion(string6);
            if (atlasRegion != null) {
                this.addStaticTiledMapTile((TiledMapTileSet)var3_8, atlasRegion, (int)var8_22, (float)var13_27, (float)var14_28);
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Tileset atlasRegion not found: ");
            ((StringBuilder)object).append(string6);
            throw new GdxRuntimeException(((StringBuilder)object).toString());
        }
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle fileHandle, TextureLoader.TextureParameter object) {
        object = new Array();
        if ((fileHandle = this.getAtlasFileHandle(fileHandle)) != null) {
            ((Array)object).add(new AssetDescriptor<TextureAtlas>(fileHandle, TextureAtlas.class));
        }
        return object;
    }

    public TiledMap load(String string2) {
        return this.load(string2, new AtlasTiledMapLoaderParameters());
    }

    public TiledMap load(String object, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        Object object2 = this.resolve((String)object);
        this.root = this.xml.parse((FileHandle)object2);
        object = new TextureAtlas(this.getAtlasFileHandle((FileHandle)object2));
        this.atlasResolver = new AtlasResolver.DirectAtlasResolver((TextureAtlas)object);
        object2 = this.loadTiledMap((FileHandle)object2, atlasTiledMapLoaderParameters, this.atlasResolver);
        ((TiledMap)object2).setOwnedResources(new Array<TextureAtlas>(new TextureAtlas[]{object}));
        this.setTextureFilters(atlasTiledMapLoaderParameters.textureMinFilter, atlasTiledMapLoaderParameters.textureMagFilter);
        return object2;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String string2, FileHandle fileHandle, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        this.atlasResolver = new AtlasResolver.AssetManagerAtlasResolver(assetManager, this.getAtlasFileHandle(fileHandle).path());
        this.map = this.loadTiledMap(fileHandle, atlasTiledMapLoaderParameters, this.atlasResolver);
    }

    @Override
    public TiledMap loadSync(AssetManager assetManager, String string2, FileHandle fileHandle, AtlasTiledMapLoaderParameters atlasTiledMapLoaderParameters) {
        if (atlasTiledMapLoaderParameters != null) {
            this.setTextureFilters(atlasTiledMapLoaderParameters.textureMinFilter, atlasTiledMapLoaderParameters.textureMagFilter);
        }
        return this.map;
    }

    private static interface AtlasResolver
    extends ImageResolver {
        public TextureAtlas getAtlas();

        public static class AssetManagerAtlasResolver
        implements AtlasResolver {
            private final AssetManager assetManager;
            private final String atlasName;

            public AssetManagerAtlasResolver(AssetManager assetManager, String string2) {
                this.assetManager = assetManager;
                this.atlasName = string2;
            }

            @Override
            public TextureAtlas getAtlas() {
                return this.assetManager.get(this.atlasName, TextureAtlas.class);
            }

            @Override
            public TextureRegion getImage(String string2) {
                return this.getAtlas().findRegion(string2);
            }
        }

        public static class DirectAtlasResolver
        implements AtlasResolver {
            private final TextureAtlas atlas;

            public DirectAtlasResolver(TextureAtlas textureAtlas) {
                this.atlas = textureAtlas;
            }

            @Override
            public TextureAtlas getAtlas() {
                return this.atlas;
            }

            @Override
            public TextureRegion getImage(String string2) {
                return this.atlas.findRegion(string2);
            }
        }
    }

    public static class AtlasTiledMapLoaderParameters
    extends BaseTmxMapLoader.Parameters {
        public boolean forceTextureFilters = false;
    }
}

