/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps;

import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.util.Iterator;

public class MapObjects
implements Iterable<MapObject> {
    private Array<MapObject> objects = new Array();

    public void add(MapObject mapObject) {
        this.objects.add(mapObject);
    }

    public MapObject get(int n) {
        return this.objects.get(n);
    }

    public MapObject get(String string2) {
        int n = this.objects.size;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = this.objects.get(i);
            if (!string2.equals(mapObject.getName())) continue;
            return mapObject;
        }
        return null;
    }

    public <T extends MapObject> Array<T> getByType(Class<T> clazz) {
        return this.getByType(clazz, new Array());
    }

    public <T extends MapObject> Array<T> getByType(Class<T> clazz, Array<T> array) {
        array.clear();
        int n = this.objects.size;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = this.objects.get(i);
            if (!ClassReflection.isInstance(clazz, mapObject)) continue;
            array.add(mapObject);
        }
        return array;
    }

    public int getCount() {
        return this.objects.size;
    }

    public int getIndex(MapObject mapObject) {
        return this.objects.indexOf(mapObject, true);
    }

    public int getIndex(String string2) {
        return this.getIndex(this.get(string2));
    }

    @Override
    public Iterator<MapObject> iterator() {
        return this.objects.iterator();
    }

    public void remove(int n) {
        this.objects.removeIndex(n);
    }

    public void remove(MapObject mapObject) {
        this.objects.removeValue(mapObject, true);
    }
}

