/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class RemoteInput
implements Input,
Runnable {
    public static int DEFAULT_PORT = 8190;
    private static final int MAX_TOUCHES = 20;
    private float[] accel = new float[3];
    private float[] compass;
    private boolean connected = false;
    int[] deltaX;
    int[] deltaY;
    private float[] gyrate = new float[3];
    public final String[] ips;
    boolean[] isTouched;
    boolean[] justPressedKeys;
    boolean justTouched = false;
    int keyCount = 0;
    boolean keyJustPressed = false;
    boolean[] keys;
    private RemoteInputListener listener;
    private boolean multiTouch = false;
    private final int port;
    InputProcessor processor = null;
    private float remoteHeight = 0.0f;
    private float remoteWidth = 0.0f;
    private ServerSocket serverSocket;
    int[] touchX;
    int[] touchY;

    public RemoteInput() {
        this(DEFAULT_PORT);
    }

    public RemoteInput(int n) {
        this(n, null);
    }

    public RemoteInput(int n, RemoteInputListener object) {
        this.compass = new float[3];
        this.keys = new boolean[256];
        this.justPressedKeys = new boolean[256];
        this.deltaX = new int[20];
        this.deltaY = new int[20];
        this.touchX = new int[20];
        this.touchY = new int[20];
        this.isTouched = new boolean[20];
        this.listener = object;
        try {
            this.port = n;
            object = new ServerSocket(n);
            this.serverSocket = object;
            object = new Thread(this);
            object.setDaemon(true);
            object.start();
            object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            this.ips = new String[((InetAddress[])object).length];
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                this.ips[i] = object[i].getHostAddress();
            }
            return;
        }
        catch (Exception exception) {
            object = new StringBuilder();
            object.append("Couldn't open listening socket at port '");
            object.append(n);
            object.append("'");
            object = new GdxRuntimeException(object.toString(), exception);
            throw object;
        }
    }

    public RemoteInput(RemoteInputListener remoteInputListener) {
        this(DEFAULT_PORT, remoteInputListener);
    }

    @Override
    public void cancelVibrate() {
    }

    @Override
    public float getAccelerometerX() {
        return this.accel[0];
    }

    @Override
    public float getAccelerometerY() {
        return this.accel[1];
    }

    @Override
    public float getAccelerometerZ() {
        return this.accel[2];
    }

    @Override
    public float getAzimuth() {
        return this.compass[0];
    }

    @Override
    public long getCurrentEventTime() {
        return 0L;
    }

    @Override
    public int getDeltaX() {
        return this.deltaX[0];
    }

    @Override
    public int getDeltaX(int n) {
        return this.deltaX[n];
    }

    @Override
    public int getDeltaY() {
        return this.deltaY[0];
    }

    @Override
    public int getDeltaY(int n) {
        return this.deltaY[n];
    }

    @Override
    public float getGyroscopeX() {
        return this.gyrate[0];
    }

    @Override
    public float getGyroscopeY() {
        return this.gyrate[1];
    }

    @Override
    public float getGyroscopeZ() {
        return this.gyrate[2];
    }

    public String[] getIPs() {
        return this.ips;
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    @Override
    public int getMaxPointers() {
        return 20;
    }

    @Override
    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    @Override
    public float getPitch() {
        return this.compass[1];
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int n) {
        float f = this.isTouched(n) ? 1.0f : 0.0f;
        return f;
    }

    @Override
    public float getRoll() {
        return this.compass[2];
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public void getRotationMatrix(float[] fArray) {
    }

    @Override
    public void getTextInput(Input.TextInputListener textInputListener, String string2, String string3, String string4) {
        Gdx.app.getInput().getTextInput(textInputListener, string2, string3, string4);
    }

    @Override
    public int getX() {
        return this.touchX[0];
    }

    @Override
    public int getX(int n) {
        return this.touchX[n];
    }

    @Override
    public int getY() {
        return this.touchY[0];
    }

    @Override
    public int getY(int n) {
        return this.touchY[n];
    }

    @Override
    public boolean isButtonJustPressed(int n) {
        boolean bl = n == 0 && this.justTouched;
        return bl;
    }

    @Override
    public boolean isButtonPressed(int n) {
        boolean[] blArray;
        if (n != 0) {
            return false;
        }
        for (n = 0; n < (blArray = this.isTouched).length; ++n) {
            if (!blArray[n]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCatchBackKey() {
        return false;
    }

    @Override
    public boolean isCatchKey(int n) {
        return false;
    }

    @Override
    public boolean isCatchMenuKey() {
        return false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isCursorCatched() {
        return false;
    }

    @Override
    public boolean isKeyJustPressed(int n) {
        if (n == -1) {
            return this.keyJustPressed;
        }
        if (n >= 0 && n <= 255) {
            return this.justPressedKeys[n];
        }
        return false;
    }

    @Override
    public boolean isKeyPressed(int n) {
        boolean bl = false;
        if (n == -1) {
            if (this.keyCount > 0) {
                bl = true;
            }
            return bl;
        }
        if (n >= 0 && n <= 255) {
            return this.keys[n];
        }
        return false;
    }

    @Override
    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        if (peripheral == Input.Peripheral.Accelerometer) {
            return true;
        }
        if (peripheral == Input.Peripheral.Compass) {
            return true;
        }
        if (peripheral == Input.Peripheral.MultitouchScreen) {
            return this.multiTouch;
        }
        return false;
    }

    @Override
    public boolean isTouched() {
        return this.isTouched[0];
    }

    @Override
    public boolean isTouched(int n) {
        return this.isTouched[n];
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setCatchBackKey(boolean bl) {
    }

    @Override
    public void setCatchKey(int n, boolean bl) {
    }

    @Override
    public void setCatchMenuKey(boolean bl) {
    }

    @Override
    public void setCursorCatched(boolean bl) {
    }

    @Override
    public void setCursorPosition(int n, int n2) {
    }

    @Override
    public void setInputProcessor(InputProcessor inputProcessor) {
        this.processor = inputProcessor;
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean bl) {
    }

    @Override
    public void vibrate(int n) {
    }

    @Override
    public void vibrate(long[] lArray, int n) {
    }

    class EventTrigger
    implements Runnable {
        KeyEvent keyEvent;
        TouchEvent touchEvent;

        public EventTrigger(TouchEvent touchEvent, KeyEvent keyEvent) {
            this.touchEvent = touchEvent;
            this.keyEvent = keyEvent;
        }

        @Override
        public void run() {
            int n;
            Object object = RemoteInput.this;
            ((RemoteInput)object).justTouched = false;
            if (((RemoteInput)object).keyJustPressed) {
                RemoteInput.this.keyJustPressed = false;
                for (n = 0; n < RemoteInput.this.justPressedKeys.length; ++n) {
                    RemoteInput.this.justPressedKeys[n] = false;
                }
            }
            if (RemoteInput.this.processor != null) {
                object = this.touchEvent;
                if (object != null) {
                    n = ((TouchEvent)object).type;
                    if (n != 0) {
                        if (n != 1) {
                            if (n == 2) {
                                RemoteInput.this.deltaX[this.touchEvent.pointer] = this.touchEvent.x - RemoteInput.this.touchX[this.touchEvent.pointer];
                                RemoteInput.this.deltaY[this.touchEvent.pointer] = this.touchEvent.y - RemoteInput.this.touchY[this.touchEvent.pointer];
                                RemoteInput.this.processor.touchDragged(this.touchEvent.x, this.touchEvent.y, this.touchEvent.pointer);
                            }
                        } else {
                            RemoteInput.this.deltaX[this.touchEvent.pointer] = 0;
                            RemoteInput.this.deltaY[this.touchEvent.pointer] = 0;
                            RemoteInput.this.processor.touchUp(this.touchEvent.x, this.touchEvent.y, this.touchEvent.pointer, 0);
                            RemoteInput.this.isTouched[this.touchEvent.pointer] = false;
                        }
                    } else {
                        RemoteInput.this.deltaX[this.touchEvent.pointer] = 0;
                        RemoteInput.this.deltaY[this.touchEvent.pointer] = 0;
                        RemoteInput.this.processor.touchDown(this.touchEvent.x, this.touchEvent.y, this.touchEvent.pointer, 0);
                        RemoteInput.this.isTouched[this.touchEvent.pointer] = true;
                        RemoteInput.this.justTouched = true;
                    }
                    RemoteInput.this.touchX[this.touchEvent.pointer] = this.touchEvent.x;
                    RemoteInput.this.touchY[this.touchEvent.pointer] = this.touchEvent.y;
                }
                if ((object = this.keyEvent) != null) {
                    n = ((KeyEvent)object).type;
                    if (n != 0) {
                        if (n != 1) {
                            if (n == 2) {
                                RemoteInput.this.processor.keyTyped(this.keyEvent.keyChar);
                            }
                        } else {
                            RemoteInput.this.processor.keyUp(this.keyEvent.keyCode);
                            if (RemoteInput.this.keys[this.keyEvent.keyCode]) {
                                object = RemoteInput.this;
                                --((RemoteInput)object).keyCount;
                                RemoteInput.this.keys[this.keyEvent.keyCode] = false;
                            }
                        }
                    } else {
                        RemoteInput.this.processor.keyDown(this.keyEvent.keyCode);
                        if (!RemoteInput.this.keys[this.keyEvent.keyCode]) {
                            object = RemoteInput.this;
                            ++((RemoteInput)object).keyCount;
                            RemoteInput.this.keys[this.keyEvent.keyCode] = true;
                        }
                        object = RemoteInput.this;
                        ((RemoteInput)object).keyJustPressed = true;
                        ((RemoteInput)object).justPressedKeys[this.keyEvent.keyCode] = true;
                    }
                }
            } else {
                object = this.touchEvent;
                if (object != null) {
                    n = ((TouchEvent)object).type;
                    if (n != 0) {
                        if (n != 1) {
                            if (n == 2) {
                                RemoteInput.this.deltaX[this.touchEvent.pointer] = this.touchEvent.x - RemoteInput.this.touchX[this.touchEvent.pointer];
                                RemoteInput.this.deltaY[this.touchEvent.pointer] = this.touchEvent.y - RemoteInput.this.touchY[this.touchEvent.pointer];
                            }
                        } else {
                            RemoteInput.this.deltaX[this.touchEvent.pointer] = 0;
                            RemoteInput.this.deltaY[this.touchEvent.pointer] = 0;
                            RemoteInput.this.isTouched[this.touchEvent.pointer] = false;
                        }
                    } else {
                        RemoteInput.this.deltaX[this.touchEvent.pointer] = 0;
                        RemoteInput.this.deltaY[this.touchEvent.pointer] = 0;
                        RemoteInput.this.isTouched[this.touchEvent.pointer] = true;
                        RemoteInput.this.justTouched = true;
                    }
                    RemoteInput.this.touchX[this.touchEvent.pointer] = this.touchEvent.x;
                    RemoteInput.this.touchY[this.touchEvent.pointer] = this.touchEvent.y;
                }
                if ((object = this.keyEvent) != null) {
                    if (((KeyEvent)object).type == 0) {
                        if (!RemoteInput.this.keys[this.keyEvent.keyCode]) {
                            object = RemoteInput.this;
                            ++((RemoteInput)object).keyCount;
                            RemoteInput.this.keys[this.keyEvent.keyCode] = true;
                        }
                        object = RemoteInput.this;
                        ((RemoteInput)object).keyJustPressed = true;
                        ((RemoteInput)object).justPressedKeys[this.keyEvent.keyCode] = true;
                    }
                    if (this.keyEvent.type == 1 && RemoteInput.this.keys[this.keyEvent.keyCode]) {
                        object = RemoteInput.this;
                        --((RemoteInput)object).keyCount;
                        RemoteInput.this.keys[this.keyEvent.keyCode] = false;
                    }
                }
            }
        }
    }

    class KeyEvent {
        static final int KEY_DOWN = 0;
        static final int KEY_TYPED = 2;
        static final int KEY_UP = 1;
        char keyChar;
        int keyCode;
        long timeStamp;
        int type;

        KeyEvent() {
        }
    }

    public static interface RemoteInputListener {
        public void onConnected();

        public void onDisconnected();
    }

    class TouchEvent {
        static final int TOUCH_DOWN = 0;
        static final int TOUCH_DRAGGED = 2;
        static final int TOUCH_UP = 1;
        int pointer;
        long timeStamp;
        int type;
        int x;
        int y;

        TouchEvent() {
        }
    }
}

