/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public class GL30Interceptor
extends GLInterceptor
implements GL30 {
    protected final GL30 gl30;

    protected GL30Interceptor(GLProfiler gLProfiler, GL30 gL30) {
        super(gLProfiler);
        this.gl30 = gL30;
    }

    private void check() {
        int n = this.gl30.glGetError();
        while (n != 0) {
            this.glProfiler.getListener().onError(n);
            n = this.gl30.glGetError();
        }
    }

    @Override
    public void glActiveTexture(int n) {
        ++this.calls;
        this.gl30.glActiveTexture(n);
        this.check();
    }

    @Override
    public void glAttachShader(int n, int n2) {
        ++this.calls;
        this.gl30.glAttachShader(n, n2);
        this.check();
    }

    @Override
    public void glBeginQuery(int n, int n2) {
        ++this.calls;
        this.gl30.glBeginQuery(n, n2);
        this.check();
    }

    @Override
    public void glBeginTransformFeedback(int n) {
        ++this.calls;
        this.gl30.glBeginTransformFeedback(n);
        this.check();
    }

    @Override
    public void glBindAttribLocation(int n, int n2, String string2) {
        ++this.calls;
        this.gl30.glBindAttribLocation(n, n2, string2);
        this.check();
    }

    @Override
    public void glBindBuffer(int n, int n2) {
        ++this.calls;
        this.gl30.glBindBuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindBufferBase(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glBindBufferBase(n, n2, n3);
        this.check();
    }

    @Override
    public void glBindBufferRange(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glBindBufferRange(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glBindFramebuffer(int n, int n2) {
        ++this.calls;
        this.gl30.glBindFramebuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindRenderbuffer(int n, int n2) {
        ++this.calls;
        this.gl30.glBindRenderbuffer(n, n2);
        this.check();
    }

    @Override
    public void glBindSampler(int n, int n2) {
        ++this.calls;
        this.gl30.glBindSampler(n, n2);
        this.check();
    }

    @Override
    public void glBindTexture(int n, int n2) {
        ++this.textureBindings;
        ++this.calls;
        this.gl30.glBindTexture(n, n2);
        this.check();
    }

    @Override
    public void glBindTransformFeedback(int n, int n2) {
        ++this.calls;
        this.gl30.glBindTransformFeedback(n, n2);
        this.check();
    }

    @Override
    public void glBindVertexArray(int n) {
        ++this.calls;
        this.gl30.glBindVertexArray(n);
        this.check();
    }

    @Override
    public void glBlendColor(float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl30.glBlendColor(f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glBlendEquation(int n) {
        ++this.calls;
        this.gl30.glBlendEquation(n);
        this.check();
    }

    @Override
    public void glBlendEquationSeparate(int n, int n2) {
        ++this.calls;
        this.gl30.glBlendEquationSeparate(n, n2);
        this.check();
    }

    @Override
    public void glBlendFunc(int n, int n2) {
        ++this.calls;
        this.gl30.glBlendFunc(n, n2);
        this.check();
    }

    @Override
    public void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glBlendFuncSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glBlitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ++this.calls;
        this.gl30.glBlitFramebuffer(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.check();
    }

    @Override
    public void glBufferData(int n, int n2, Buffer buffer, int n3) {
        ++this.calls;
        this.gl30.glBufferData(n, n2, buffer, n3);
        this.check();
    }

    @Override
    public void glBufferSubData(int n, int n2, int n3, Buffer buffer) {
        ++this.calls;
        this.gl30.glBufferSubData(n, n2, n3, buffer);
        this.check();
    }

    @Override
    public int glCheckFramebufferStatus(int n) {
        ++this.calls;
        n = this.gl30.glCheckFramebufferStatus(n);
        this.check();
        return n;
    }

    @Override
    public void glClear(int n) {
        ++this.calls;
        this.gl30.glClear(n);
        this.check();
    }

    @Override
    public void glClearBufferfi(int n, int n2, float f, int n3) {
        ++this.calls;
        this.gl30.glClearBufferfi(n, n2, f, n3);
        this.check();
    }

    @Override
    public void glClearBufferfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glClearBufferfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glClearBufferiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glClearBufferiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glClearBufferuiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glClearBufferuiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glClearColor(float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl30.glClearColor(f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glClearDepthf(float f) {
        ++this.calls;
        this.gl30.glClearDepthf(f);
        this.check();
    }

    @Override
    public void glClearStencil(int n) {
        ++this.calls;
        this.gl30.glClearStencil(n);
        this.check();
    }

    @Override
    public void glColorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ++this.calls;
        this.gl30.glColorMask(bl, bl2, bl3, bl4);
        this.check();
    }

    @Override
    public void glCompileShader(int n) {
        ++this.calls;
        this.gl30.glCompileShader(n);
        this.check();
    }

    @Override
    public void glCompressedTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, Buffer buffer) {
        ++this.calls;
        this.gl30.glCompressedTexImage2D(n, n2, n3, n4, n5, n6, n7, buffer);
        this.check();
    }

    @Override
    public void glCompressedTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl30.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glCopyBufferSubData(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glCopyBufferSubData(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glCopyTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ++this.calls;
        this.gl30.glCopyTexImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.check();
    }

    @Override
    public void glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        ++this.calls;
        this.gl30.glCopyTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8);
        this.check();
    }

    @Override
    public void glCopyTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        ++this.calls;
        this.gl30.glCopyTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9);
        this.check();
    }

    @Override
    public int glCreateProgram() {
        ++this.calls;
        int n = this.gl30.glCreateProgram();
        this.check();
        return n;
    }

    @Override
    public int glCreateShader(int n) {
        ++this.calls;
        n = this.gl30.glCreateShader(n);
        this.check();
        return n;
    }

    @Override
    public void glCullFace(int n) {
        ++this.calls;
        this.gl30.glCullFace(n);
        this.check();
    }

    @Override
    public void glDeleteBuffer(int n) {
        ++this.calls;
        this.gl30.glDeleteBuffer(n);
        this.check();
    }

    @Override
    public void glDeleteBuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteBuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteFramebuffer(int n) {
        ++this.calls;
        this.gl30.glDeleteFramebuffer(n);
        this.check();
    }

    @Override
    public void glDeleteFramebuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteFramebuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteProgram(int n) {
        ++this.calls;
        this.gl30.glDeleteProgram(n);
        this.check();
    }

    @Override
    public void glDeleteQueries(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteQueries(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteQueries(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glDeleteQueries(n, nArray, n2);
        this.check();
    }

    @Override
    public void glDeleteRenderbuffer(int n) {
        ++this.calls;
        this.gl30.glDeleteRenderbuffer(n);
        this.check();
    }

    @Override
    public void glDeleteRenderbuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteRenderbuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteSamplers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteSamplers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteSamplers(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glDeleteSamplers(n, nArray, n2);
        this.check();
    }

    @Override
    public void glDeleteShader(int n) {
        ++this.calls;
        this.gl30.glDeleteShader(n);
        this.check();
    }

    @Override
    public void glDeleteTexture(int n) {
        ++this.calls;
        this.gl30.glDeleteTexture(n);
        this.check();
    }

    @Override
    public void glDeleteTextures(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteTextures(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteTransformFeedbacks(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteTransformFeedbacks(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteTransformFeedbacks(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glDeleteTransformFeedbacks(n, nArray, n2);
        this.check();
    }

    @Override
    public void glDeleteVertexArrays(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glDeleteVertexArrays(n, intBuffer);
        this.check();
    }

    @Override
    public void glDeleteVertexArrays(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glDeleteVertexArrays(n, nArray, n2);
        this.check();
    }

    @Override
    public void glDepthFunc(int n) {
        ++this.calls;
        this.gl30.glDepthFunc(n);
        this.check();
    }

    @Override
    public void glDepthMask(boolean bl) {
        ++this.calls;
        this.gl30.glDepthMask(bl);
        this.check();
    }

    @Override
    public void glDepthRangef(float f, float f2) {
        ++this.calls;
        this.gl30.glDepthRangef(f, f2);
        this.check();
    }

    @Override
    public void glDetachShader(int n, int n2) {
        ++this.calls;
        this.gl30.glDetachShader(n, n2);
        this.check();
    }

    @Override
    public void glDisable(int n) {
        ++this.calls;
        this.gl30.glDisable(n);
        this.check();
    }

    @Override
    public void glDisableVertexAttribArray(int n) {
        ++this.calls;
        this.gl30.glDisableVertexAttribArray(n);
        this.check();
    }

    @Override
    public void glDrawArrays(int n, int n2, int n3) {
        this.vertexCount.put(n3);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawArrays(n, n2, n3);
        this.check();
    }

    @Override
    public void glDrawArraysInstanced(int n, int n2, int n3, int n4) {
        this.vertexCount.put(n3);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawArraysInstanced(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glDrawBuffers(int n, IntBuffer intBuffer) {
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawBuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, int n4) {
        this.vertexCount.put(n2);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawElements(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, Buffer buffer) {
        this.vertexCount.put(n2);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawElements(n, n2, n3, buffer);
        this.check();
    }

    @Override
    public void glDrawElementsInstanced(int n, int n2, int n3, int n4, int n5) {
        this.vertexCount.put(n2);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawElementsInstanced(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, int n6) {
        this.vertexCount.put(n4);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawRangeElements(n, n2, n3, n4, n5, n6);
        this.check();
    }

    @Override
    public void glDrawRangeElements(int n, int n2, int n3, int n4, int n5, Buffer buffer) {
        this.vertexCount.put(n4);
        ++this.drawCalls;
        ++this.calls;
        this.gl30.glDrawRangeElements(n, n2, n3, n4, n5, buffer);
        this.check();
    }

    @Override
    public void glEnable(int n) {
        ++this.calls;
        this.gl30.glEnable(n);
        this.check();
    }

    @Override
    public void glEnableVertexAttribArray(int n) {
        ++this.calls;
        this.gl30.glEnableVertexAttribArray(n);
        this.check();
    }

    @Override
    public void glEndQuery(int n) {
        ++this.calls;
        this.gl30.glEndQuery(n);
        this.check();
    }

    @Override
    public void glEndTransformFeedback() {
        ++this.calls;
        this.gl30.glEndTransformFeedback();
        this.check();
    }

    @Override
    public void glFinish() {
        ++this.calls;
        this.gl30.glFinish();
        this.check();
    }

    @Override
    public void glFlush() {
        ++this.calls;
        this.gl30.glFlush();
        this.check();
    }

    @Override
    public void glFlushMappedBufferRange(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glFlushMappedBufferRange(n, n2, n3);
        this.check();
    }

    @Override
    public void glFramebufferRenderbuffer(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glFramebufferRenderbuffer(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glFramebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glFramebufferTexture2D(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glFramebufferTextureLayer(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glFramebufferTextureLayer(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glFrontFace(int n) {
        ++this.calls;
        this.gl30.glFrontFace(n);
        this.check();
    }

    @Override
    public int glGenBuffer() {
        ++this.calls;
        int n = this.gl30.glGenBuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenBuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenBuffers(n, intBuffer);
        this.check();
    }

    @Override
    public int glGenFramebuffer() {
        ++this.calls;
        int n = this.gl30.glGenFramebuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenFramebuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenFramebuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenQueries(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenQueries(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenQueries(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glGenQueries(n, nArray, n2);
        this.check();
    }

    @Override
    public int glGenRenderbuffer() {
        ++this.calls;
        int n = this.gl30.glGenRenderbuffer();
        this.check();
        return n;
    }

    @Override
    public void glGenRenderbuffers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenRenderbuffers(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenSamplers(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenSamplers(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenSamplers(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glGenSamplers(n, nArray, n2);
        this.check();
    }

    @Override
    public int glGenTexture() {
        ++this.calls;
        int n = this.gl30.glGenTexture();
        this.check();
        return n;
    }

    @Override
    public void glGenTextures(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenTextures(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenTransformFeedbacks(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenTransformFeedbacks(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenTransformFeedbacks(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glGenTransformFeedbacks(n, nArray, n2);
        this.check();
    }

    @Override
    public void glGenVertexArrays(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGenVertexArrays(n, intBuffer);
        this.check();
    }

    @Override
    public void glGenVertexArrays(int n, int[] nArray, int n2) {
        ++this.calls;
        this.gl30.glGenVertexArrays(n, nArray, n2);
        this.check();
    }

    @Override
    public void glGenerateMipmap(int n) {
        ++this.calls;
        this.gl30.glGenerateMipmap(n);
        this.check();
    }

    @Override
    public String glGetActiveAttrib(int n, int n2, IntBuffer object, Buffer buffer) {
        ++this.calls;
        object = this.gl30.glGetActiveAttrib(n, n2, (IntBuffer)object, buffer);
        this.check();
        return object;
    }

    @Override
    public String glGetActiveUniform(int n, int n2, IntBuffer object, Buffer buffer) {
        ++this.calls;
        object = this.gl30.glGetActiveUniform(n, n2, (IntBuffer)object, buffer);
        this.check();
        return object;
    }

    @Override
    public String glGetActiveUniformBlockName(int n, int n2) {
        ++this.calls;
        String string2 = this.gl30.glGetActiveUniformBlockName(n, n2);
        this.check();
        return string2;
    }

    @Override
    public void glGetActiveUniformBlockName(int n, int n2, Buffer buffer, Buffer buffer2) {
        ++this.calls;
        this.gl30.glGetActiveUniformBlockName(n, n2, buffer, buffer2);
        this.check();
    }

    @Override
    public void glGetActiveUniformBlockiv(int n, int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetActiveUniformBlockiv(n, n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glGetActiveUniformsiv(int n, int n2, IntBuffer intBuffer, int n3, IntBuffer intBuffer2) {
        ++this.calls;
        this.gl30.glGetActiveUniformsiv(n, n2, intBuffer, n3, intBuffer2);
        this.check();
    }

    @Override
    public void glGetAttachedShaders(int n, int n2, Buffer buffer, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetAttachedShaders(n, n2, buffer, intBuffer);
        this.check();
    }

    @Override
    public int glGetAttribLocation(int n, String string2) {
        ++this.calls;
        n = this.gl30.glGetAttribLocation(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetBooleanv(int n, Buffer buffer) {
        ++this.calls;
        this.gl30.glGetBooleanv(n, buffer);
        this.check();
    }

    @Override
    public void glGetBufferParameteri64v(int n, int n2, LongBuffer longBuffer) {
        ++this.calls;
        this.gl30.glGetBufferParameteri64v(n, n2, longBuffer);
        this.check();
    }

    @Override
    public void glGetBufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetBufferParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public Buffer glGetBufferPointerv(int n, int n2) {
        ++this.calls;
        Buffer buffer = this.gl30.glGetBufferPointerv(n, n2);
        this.check();
        return buffer;
    }

    @Override
    public int glGetError() {
        ++this.calls;
        return this.gl30.glGetError();
    }

    @Override
    public void glGetFloatv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glGetFloatv(n, floatBuffer);
        this.check();
    }

    @Override
    public int glGetFragDataLocation(int n, String string2) {
        ++this.calls;
        n = this.gl30.glGetFragDataLocation(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetFramebufferAttachmentParameteriv(int n, int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetFramebufferAttachmentParameteriv(n, n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glGetInteger64v(int n, LongBuffer longBuffer) {
        ++this.calls;
        this.gl30.glGetInteger64v(n, longBuffer);
        this.check();
    }

    @Override
    public void glGetIntegerv(int n, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetIntegerv(n, intBuffer);
        this.check();
    }

    @Override
    public String glGetProgramInfoLog(int n) {
        ++this.calls;
        String string2 = this.gl30.glGetProgramInfoLog(n);
        this.check();
        return string2;
    }

    @Override
    public void glGetProgramiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetProgramiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetQueryObjectuiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetQueryObjectuiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetQueryiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetQueryiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetRenderbufferParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetRenderbufferParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetSamplerParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glGetSamplerParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetSamplerParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetSamplerParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public String glGetShaderInfoLog(int n) {
        ++this.calls;
        String string2 = this.gl30.glGetShaderInfoLog(n);
        this.check();
        return string2;
    }

    @Override
    public void glGetShaderPrecisionFormat(int n, int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ++this.calls;
        this.gl30.glGetShaderPrecisionFormat(n, n2, intBuffer, intBuffer2);
        this.check();
    }

    @Override
    public void glGetShaderiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetShaderiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public String glGetString(int n) {
        ++this.calls;
        String string2 = this.gl30.glGetString(n);
        this.check();
        return string2;
    }

    @Override
    public String glGetStringi(int n, int n2) {
        ++this.calls;
        String string2 = this.gl30.glGetStringi(n, n2);
        this.check();
        return string2;
    }

    @Override
    public void glGetTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glGetTexParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetTexParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public int glGetUniformBlockIndex(int n, String string2) {
        ++this.calls;
        n = this.gl30.glGetUniformBlockIndex(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetUniformIndices(int n, String[] stringArray, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetUniformIndices(n, stringArray, intBuffer);
        this.check();
    }

    @Override
    public int glGetUniformLocation(int n, String string2) {
        ++this.calls;
        n = this.gl30.glGetUniformLocation(n, string2);
        this.check();
        return n;
    }

    @Override
    public void glGetUniformfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glGetUniformfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetUniformiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetUniformiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetUniformuiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetUniformuiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribIiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetVertexAttribIiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribIuiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetVertexAttribIuiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribPointerv(int n, int n2, Buffer buffer) {
        ++this.calls;
        this.gl30.glGetVertexAttribPointerv(n, n2, buffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glGetVertexAttribfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glGetVertexAttribiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glGetVertexAttribiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glHint(int n, int n2) {
        ++this.calls;
        this.gl30.glHint(n, n2);
        this.check();
    }

    @Override
    public void glInvalidateFramebuffer(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glInvalidateFramebuffer(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glInvalidateSubFramebuffer(int n, int n2, IntBuffer intBuffer, int n3, int n4, int n5, int n6) {
        ++this.calls;
        this.gl30.glInvalidateSubFramebuffer(n, n2, intBuffer, n3, n4, n5, n6);
        this.check();
    }

    @Override
    public boolean glIsBuffer(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsBuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsEnabled(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsEnabled(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsFramebuffer(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsFramebuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsProgram(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsProgram(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsQuery(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsQuery(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsRenderbuffer(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsRenderbuffer(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsSampler(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsSampler(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsShader(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsShader(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsTexture(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsTexture(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsTransformFeedback(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsTransformFeedback(n);
        this.check();
        return bl;
    }

    @Override
    public boolean glIsVertexArray(int n) {
        ++this.calls;
        boolean bl = this.gl30.glIsVertexArray(n);
        this.check();
        return bl;
    }

    @Override
    public void glLineWidth(float f) {
        ++this.calls;
        this.gl30.glLineWidth(f);
        this.check();
    }

    @Override
    public void glLinkProgram(int n) {
        ++this.calls;
        this.gl30.glLinkProgram(n);
        this.check();
    }

    @Override
    public void glPauseTransformFeedback() {
        ++this.calls;
        this.gl30.glPauseTransformFeedback();
        this.check();
    }

    @Override
    public void glPixelStorei(int n, int n2) {
        ++this.calls;
        this.gl30.glPixelStorei(n, n2);
        this.check();
    }

    @Override
    public void glPolygonOffset(float f, float f2) {
        ++this.calls;
        this.gl30.glPolygonOffset(f, f2);
        this.check();
    }

    @Override
    public void glProgramParameteri(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glProgramParameteri(n, n2, n3);
        this.check();
    }

    @Override
    public void glReadBuffer(int n) {
        ++this.calls;
        this.gl30.glReadBuffer(n);
        this.check();
    }

    @Override
    public void glReadPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        ++this.calls;
        this.gl30.glReadPixels(n, n2, n3, n4, n5, n6, buffer);
        this.check();
    }

    @Override
    public void glReleaseShaderCompiler() {
        ++this.calls;
        this.gl30.glReleaseShaderCompiler();
        this.check();
    }

    @Override
    public void glRenderbufferStorage(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glRenderbufferStorage(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glRenderbufferStorageMultisample(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glRenderbufferStorageMultisample(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glResumeTransformFeedback() {
        ++this.calls;
        this.gl30.glResumeTransformFeedback();
        this.check();
    }

    @Override
    public void glSampleCoverage(float f, boolean bl) {
        ++this.calls;
        this.gl30.glSampleCoverage(f, bl);
        this.check();
    }

    @Override
    public void glSamplerParameterf(int n, int n2, float f) {
        ++this.calls;
        this.gl30.glSamplerParameterf(n, n2, f);
        this.check();
    }

    @Override
    public void glSamplerParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glSamplerParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glSamplerParameteri(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glSamplerParameteri(n, n2, n3);
        this.check();
    }

    @Override
    public void glSamplerParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glSamplerParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glScissor(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glScissor(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glShaderBinary(int n, IntBuffer intBuffer, int n2, Buffer buffer, int n3) {
        ++this.calls;
        this.gl30.glShaderBinary(n, intBuffer, n2, buffer, n3);
        this.check();
    }

    @Override
    public void glShaderSource(int n, String string2) {
        ++this.calls;
        this.gl30.glShaderSource(n, string2);
        this.check();
    }

    @Override
    public void glStencilFunc(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glStencilFunc(n, n2, n3);
        this.check();
    }

    @Override
    public void glStencilFuncSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glStencilFuncSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glStencilMask(int n) {
        ++this.calls;
        this.gl30.glStencilMask(n);
        this.check();
    }

    @Override
    public void glStencilMaskSeparate(int n, int n2) {
        ++this.calls;
        this.gl30.glStencilMaskSeparate(n, n2);
        this.check();
    }

    @Override
    public void glStencilOp(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glStencilOp(n, n2, n3);
        this.check();
    }

    @Override
    public void glStencilOpSeparate(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glStencilOpSeparate(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl30.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        ++this.calls;
        this.gl30.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        this.check();
    }

    @Override
    public void glTexImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Buffer buffer) {
        ++this.calls;
        this.gl30.glTexImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, buffer);
        this.check();
    }

    @Override
    public void glTexParameterf(int n, int n2, float f) {
        ++this.calls;
        this.gl30.glTexParameterf(n, n2, f);
        this.check();
    }

    @Override
    public void glTexParameterfv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glTexParameterfv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glTexParameteri(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glTexParameteri(n, n2, n3);
        this.check();
    }

    @Override
    public void glTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glTexParameteriv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        ++this.calls;
        this.gl30.glTexSubImage2D(n, n2, n3, n4, n5, n6, n7, n8, buffer);
        this.check();
    }

    @Override
    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        ++this.calls;
        this.gl30.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
        this.check();
    }

    @Override
    public void glTexSubImage3D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, Buffer buffer) {
        ++this.calls;
        this.gl30.glTexSubImage3D(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, buffer);
        this.check();
    }

    @Override
    public void glTransformFeedbackVaryings(int n, String[] stringArray, int n2) {
        ++this.calls;
        this.gl30.glTransformFeedbackVaryings(n, stringArray, n2);
        this.check();
    }

    @Override
    public void glUniform1f(int n, float f) {
        ++this.calls;
        this.gl30.glUniform1f(n, f);
        this.check();
    }

    @Override
    public void glUniform1fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniform1fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform1fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniform1fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform1i(int n, int n2) {
        ++this.calls;
        this.gl30.glUniform1i(n, n2);
        this.check();
    }

    @Override
    public void glUniform1iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform1iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform1iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl30.glUniform1iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform1uiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform1uiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform2f(int n, float f, float f2) {
        ++this.calls;
        this.gl30.glUniform2f(n, f, f2);
        this.check();
    }

    @Override
    public void glUniform2fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniform2fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform2fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniform2fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform2i(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glUniform2i(n, n2, n3);
        this.check();
    }

    @Override
    public void glUniform2iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform2iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform2iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl30.glUniform2iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform3f(int n, float f, float f2, float f3) {
        ++this.calls;
        this.gl30.glUniform3f(n, f, f2, f3);
        this.check();
    }

    @Override
    public void glUniform3fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniform3fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform3fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniform3fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform3i(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glUniform3i(n, n2, n3, n4);
        this.check();
    }

    @Override
    public void glUniform3iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform3iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform3iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl30.glUniform3iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform3uiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform3uiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform4f(int n, float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl30.glUniform4f(n, f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glUniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniform4fv(n, n2, floatBuffer);
        this.check();
    }

    @Override
    public void glUniform4fv(int n, int n2, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniform4fv(n, n2, fArray, n3);
        this.check();
    }

    @Override
    public void glUniform4i(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glUniform4i(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glUniform4iv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform4iv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniform4iv(int n, int n2, int[] nArray, int n3) {
        ++this.calls;
        this.gl30.glUniform4iv(n, n2, nArray, n3);
        this.check();
    }

    @Override
    public void glUniform4uiv(int n, int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl30.glUniform4uiv(n, n2, intBuffer);
        this.check();
    }

    @Override
    public void glUniformBlockBinding(int n, int n2, int n3) {
        ++this.calls;
        this.gl30.glUniformBlockBinding(n, n2, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix2fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix2fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniformMatrix2fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix2x3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix2x3fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix2x4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix2x4fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix3fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix3fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniformMatrix3fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix3x2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix3x2fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix3x4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix3x4fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix4fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix4fv(int n, int n2, boolean bl, float[] fArray, int n3) {
        ++this.calls;
        this.gl30.glUniformMatrix4fv(n, n2, bl, fArray, n3);
        this.check();
    }

    @Override
    public void glUniformMatrix4x2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix4x2fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glUniformMatrix4x3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glUniformMatrix4x3fv(n, n2, bl, floatBuffer);
        this.check();
    }

    @Override
    public boolean glUnmapBuffer(int n) {
        ++this.calls;
        boolean bl = this.gl30.glUnmapBuffer(n);
        this.check();
        return bl;
    }

    @Override
    public void glUseProgram(int n) {
        ++this.shaderSwitches;
        ++this.calls;
        this.gl30.glUseProgram(n);
        this.check();
    }

    @Override
    public void glValidateProgram(int n) {
        ++this.calls;
        this.gl30.glValidateProgram(n);
        this.check();
    }

    @Override
    public void glVertexAttrib1f(int n, float f) {
        ++this.calls;
        this.gl30.glVertexAttrib1f(n, f);
        this.check();
    }

    @Override
    public void glVertexAttrib1fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glVertexAttrib1fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib2f(int n, float f, float f2) {
        ++this.calls;
        this.gl30.glVertexAttrib2f(n, f, f2);
        this.check();
    }

    @Override
    public void glVertexAttrib2fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glVertexAttrib2fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib3f(int n, float f, float f2, float f3) {
        ++this.calls;
        this.gl30.glVertexAttrib3f(n, f, f2, f3);
        this.check();
    }

    @Override
    public void glVertexAttrib3fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glVertexAttrib3fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        ++this.calls;
        this.gl30.glVertexAttrib4f(n, f, f2, f3, f4);
        this.check();
    }

    @Override
    public void glVertexAttrib4fv(int n, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl30.glVertexAttrib4fv(n, floatBuffer);
        this.check();
    }

    @Override
    public void glVertexAttribDivisor(int n, int n2) {
        ++this.calls;
        this.gl30.glVertexAttribDivisor(n, n2);
        this.check();
    }

    @Override
    public void glVertexAttribI4i(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glVertexAttribI4i(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribI4ui(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glVertexAttribI4ui(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribIPointer(int n, int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl30.glVertexAttribIPointer(n, n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int n5) {
        ++this.calls;
        this.gl30.glVertexAttribPointer(n, n2, n3, bl, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        ++this.calls;
        this.gl30.glVertexAttribPointer(n, n2, n3, bl, n4, buffer);
        this.check();
    }

    @Override
    public void glViewport(int n, int n2, int n3, int n4) {
        ++this.calls;
        this.gl30.glViewport(n, n2, n3, n4);
        this.check();
    }
}

