/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.glutils.IndexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public class IndexArray
implements IndexData {
    final ShortBuffer buffer;
    final ByteBuffer byteBuffer;
    private final boolean empty;

    public IndexArray(int n) {
        boolean bl = n == 0;
        this.empty = bl;
        if (this.empty) {
            n = 1;
        }
        this.byteBuffer = BufferUtils.newUnsafeByteBuffer(n * 2);
        this.buffer = this.byteBuffer.asShortBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
    }

    @Override
    public void bind() {
    }

    @Override
    public void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.byteBuffer);
    }

    @Override
    public ShortBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public int getNumIndices() {
        int n = this.empty ? 0 : this.buffer.limit();
        return n;
    }

    @Override
    public int getNumMaxIndices() {
        int n = this.empty ? 0 : this.buffer.capacity();
        return n;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void setIndices(ShortBuffer shortBuffer) {
        int n = shortBuffer.position();
        this.buffer.clear();
        this.buffer.limit(shortBuffer.remaining());
        this.buffer.put(shortBuffer);
        this.buffer.flip();
        shortBuffer.position(n);
        this.byteBuffer.position(0);
        this.byteBuffer.limit(this.buffer.limit() << 1);
    }

    @Override
    public void setIndices(short[] sArray, int n, int n2) {
        this.buffer.clear();
        this.buffer.put(sArray, n, n2);
        this.buffer.flip();
        this.byteBuffer.position(0);
        this.byteBuffer.limit(n2 << 1);
    }

    @Override
    public void unbind() {
    }

    @Override
    public void updateIndices(int n, short[] sArray, int n2, int n3) {
        int n4 = this.byteBuffer.position();
        this.byteBuffer.position(n * 2);
        BufferUtils.copy(sArray, n2, (Buffer)this.byteBuffer, n3);
        this.byteBuffer.position(n4);
    }
}

