/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;

public class ImmediateModeRenderer20
implements ImmediateModeRenderer {
    private final int colorOffset;
    private final int maxVertices;
    private final Mesh mesh;
    private final int normalOffset;
    private int numSetTexCoords;
    private final int numTexCoords;
    private int numVertices;
    private boolean ownsShader;
    private int primitiveType;
    private final Matrix4 projModelView = new Matrix4();
    private ShaderProgram shader;
    private final String[] shaderUniformNames;
    private final int texCoordOffset;
    private int vertexIdx;
    private final int vertexSize;
    private final float[] vertices;

    public ImmediateModeRenderer20(int n, boolean bl, boolean bl2, int n2) {
        this(n, bl, bl2, n2, ImmediateModeRenderer20.createDefaultShader(bl, bl2, n2));
        this.ownsShader = true;
    }

    public ImmediateModeRenderer20(int n, boolean bl, boolean bl2, int n2, ShaderProgram object) {
        this.maxVertices = n;
        this.numTexCoords = n2;
        this.shader = object;
        object = this.buildVertexAttributes(bl, bl2, n2);
        int n3 = 0;
        this.mesh = new Mesh(false, n, 0, (VertexAttribute[])object);
        this.vertices = new float[n * (this.mesh.getVertexAttributes().vertexSize / 4)];
        this.vertexSize = this.mesh.getVertexAttributes().vertexSize / 4;
        n = this.mesh.getVertexAttribute(8) != null ? this.mesh.getVertexAttribute((int)8).offset / 4 : 0;
        this.normalOffset = n;
        n = this.mesh.getVertexAttribute(4) != null ? this.mesh.getVertexAttribute((int)4).offset / 4 : 0;
        this.colorOffset = n;
        n = this.mesh.getVertexAttribute(16) != null ? this.mesh.getVertexAttribute((int)16).offset / 4 : 0;
        this.texCoordOffset = n;
        this.shaderUniformNames = new String[n2];
        for (n = n3; n < n2; ++n) {
            String[] stringArray = this.shaderUniformNames;
            object = new StringBuilder();
            ((StringBuilder)object).append("u_sampler");
            ((StringBuilder)object).append(n);
            stringArray[n] = ((StringBuilder)object).toString();
        }
    }

    public ImmediateModeRenderer20(boolean bl, boolean bl2, int n) {
        this(5000, bl, bl2, n, ImmediateModeRenderer20.createDefaultShader(bl, bl2, n));
        this.ownsShader = true;
    }

    private VertexAttribute[] buildVertexAttributes(boolean bl, boolean bl2, int n) {
        VertexAttribute[] vertexAttributeArray;
        Array<VertexAttribute> array = new Array<VertexAttribute>();
        array.add(new VertexAttribute(1, 3, "a_position"));
        if (bl) {
            array.add(new VertexAttribute(8, 3, "a_normal"));
        }
        if (bl2) {
            array.add(new VertexAttribute(4, 4, "a_color"));
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            vertexAttributeArray = new StringBuilder();
            vertexAttributeArray.append("a_texCoord");
            vertexAttributeArray.append(i);
            array.add(new VertexAttribute(16, 2, vertexAttributeArray.toString()));
        }
        vertexAttributeArray = new VertexAttribute[array.size];
        for (n = n2; n < array.size; ++n) {
            vertexAttributeArray[n] = (VertexAttribute)array.get(n);
        }
        return vertexAttributeArray;
    }

    public static ShaderProgram createDefaultShader(boolean bl, boolean bl2, int n) {
        return new ShaderProgram(ImmediateModeRenderer20.createVertexShader(bl, bl2, n), ImmediateModeRenderer20.createFragmentShader(bl, bl2, n));
    }

    private static String createFragmentShader(boolean bl, boolean bl2, int n) {
        CharSequence charSequence;
        int n2;
        CharSequence charSequence2 = "#ifdef GL_ES\nprecision mediump float;\n#endif\n";
        if (bl2) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append("#ifdef GL_ES\nprecision mediump float;\n#endif\n");
            ((StringBuilder)charSequence2).append("varying vec4 v_col;\n");
            charSequence2 = ((StringBuilder)charSequence2).toString();
        }
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("varying vec2 v_tex");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(";\n");
            charSequence2 = ((StringBuilder)charSequence).toString();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)charSequence2);
            ((StringBuilder)charSequence).append("uniform sampler2D u_sampler");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(";\n");
            charSequence2 = ((StringBuilder)charSequence).toString();
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append("void main() {\n   gl_FragColor = ");
        charSequence2 = bl2 ? "v_col" : "vec4(1, 1, 1, 1)";
        ((StringBuilder)charSequence).append((String)charSequence2);
        charSequence = ((StringBuilder)charSequence).toString();
        n2 = n3;
        charSequence2 = charSequence;
        if (n > 0) {
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append((String)charSequence);
            ((StringBuilder)charSequence2).append(" * ");
            charSequence2 = ((StringBuilder)charSequence2).toString();
            n2 = n3;
        }
        while (n2 < n) {
            if (n2 == n - 1) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(" texture2D(u_sampler");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(",  v_tex");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(")");
                charSequence2 = ((StringBuilder)charSequence).toString();
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(" texture2D(u_sampler");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(",  v_tex");
                ((StringBuilder)charSequence).append(n2);
                ((StringBuilder)charSequence).append(") *");
                charSequence2 = ((StringBuilder)charSequence).toString();
            }
            ++n2;
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append((String)charSequence2);
        ((StringBuilder)charSequence).append(";\n}");
        return ((StringBuilder)charSequence).toString();
    }

    private static String createVertexShader(boolean bl, boolean bl2, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("attribute vec4 a_position;\n");
        CharSequence charSequence = "";
        String string2 = bl ? "attribute vec3 a_normal;\n" : "";
        stringBuilder.append(string2);
        string2 = bl2 ? "attribute vec4 a_color;\n" : "";
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("attribute vec2 a_texCoord");
            stringBuilder.append(n2);
            stringBuilder.append(";\n");
            string2 = stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("uniform mat4 u_projModelView;\n");
        string2 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        string2 = bl2 ? "varying vec4 v_col;\n" : "";
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        for (n2 = 0; n2 < n; ++n2) {
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("varying vec2 v_tex");
            stringBuilder.append(n2);
            stringBuilder.append(";\n");
            string2 = stringBuilder.toString();
        }
        stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("void main() {\n   gl_Position = u_projModelView * a_position;\n");
        string2 = charSequence;
        if (bl2) {
            string2 = "   v_col = a_color;\n";
        }
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        for (n2 = n3; n2 < n; ++n2) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("   v_tex");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(" = ");
            ((StringBuilder)charSequence).append("a_texCoord");
            ((StringBuilder)charSequence).append(n2);
            ((StringBuilder)charSequence).append(";\n");
            string2 = ((StringBuilder)charSequence).toString();
        }
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append("   gl_PointSize = 1.0;\n");
        string2 = ((StringBuilder)charSequence).toString();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append("}\n");
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public void begin(Matrix4 matrix4, int n) {
        this.projModelView.set(matrix4);
        this.primitiveType = n;
    }

    @Override
    public void color(float f) {
        this.vertices[this.vertexIdx + this.colorOffset] = f;
    }

    @Override
    public void color(float f, float f2, float f3, float f4) {
        this.vertices[this.vertexIdx + this.colorOffset] = Color.toFloatBits(f, f2, f3, f4);
    }

    @Override
    public void color(Color color2) {
        this.vertices[this.vertexIdx + this.colorOffset] = color2.toFloatBits();
    }

    @Override
    public void dispose() {
        ShaderProgram shaderProgram;
        if (this.ownsShader && (shaderProgram = this.shader) != null) {
            shaderProgram.dispose();
        }
        this.mesh.dispose();
    }

    @Override
    public void end() {
        this.flush();
    }

    @Override
    public void flush() {
        if (this.numVertices == 0) {
            return;
        }
        this.shader.begin();
        this.shader.setUniformMatrix("u_projModelView", this.projModelView);
        for (int i = 0; i < this.numTexCoords; ++i) {
            this.shader.setUniformi(this.shaderUniformNames[i], i);
        }
        this.mesh.setVertices(this.vertices, 0, this.vertexIdx);
        this.mesh.render(this.shader, this.primitiveType);
        this.shader.end();
        this.numSetTexCoords = 0;
        this.vertexIdx = 0;
        this.numVertices = 0;
    }

    @Override
    public int getMaxVertices() {
        return this.maxVertices;
    }

    @Override
    public int getNumVertices() {
        return this.numVertices;
    }

    @Override
    public void normal(float f, float f2, float f3) {
        int n = this.vertexIdx + this.normalOffset;
        float[] fArray = this.vertices;
        fArray[n] = f;
        fArray[n + 1] = f2;
        fArray[n + 2] = f3;
    }

    public void setShader(ShaderProgram shaderProgram) {
        if (this.ownsShader) {
            this.shader.dispose();
        }
        this.shader = shaderProgram;
        this.ownsShader = false;
    }

    @Override
    public void texCoord(float f, float f2) {
        int n = this.vertexIdx + this.texCoordOffset;
        float[] fArray = this.vertices;
        int n2 = this.numSetTexCoords;
        fArray[n + n2] = f;
        fArray[n + n2 + 1] = f2;
        this.numSetTexCoords = n2 + 2;
    }

    @Override
    public void vertex(float f, float f2, float f3) {
        int n = this.vertexIdx;
        float[] fArray = this.vertices;
        fArray[n] = f;
        fArray[n + 1] = f2;
        fArray[n + 2] = f3;
        this.numSetTexCoords = 0;
        this.vertexIdx = n + this.vertexSize;
        ++this.numVertices;
    }
}

