/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils.shapebuilders;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.BaseShapeBuilder;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FlushablePool;

public class RenderableShapeBuilder
extends BaseShapeBuilder {
    private static final int FLOAT_BYTES = 4;
    private static short[] indices;
    private static final Array<Renderable> renderables;
    private static final RenderablePool renderablesPool;
    private static float[] vertices;

    static {
        renderablesPool = new RenderablePool();
        renderables = new Array();
    }

    public static void buildNormals(MeshPartBuilder meshPartBuilder, Renderable renderable, float f, Color color2, Color color3, Color color4) {
        int n;
        int n2;
        Object object = renderable.meshPart.mesh;
        int n3 = ((Mesh)object).getVertexAttribute(1) != null ? ((Mesh)object).getVertexAttribute((int)1).offset / 4 : -1;
        int n4 = ((Mesh)object).getVertexAttribute(8) != null ? ((Mesh)object).getVertexAttribute((int)8).offset / 4 : -1;
        int n5 = ((Mesh)object).getVertexAttribute(128) != null ? ((Mesh)object).getVertexAttribute((int)128).offset / 4 : -1;
        int n6 = ((Mesh)object).getVertexAttribute(256) != null ? ((Mesh)object).getVertexAttribute((int)256).offset / 4 : -1;
        int n7 = ((Mesh)object).getVertexSize() / 4;
        if (((Mesh)object).getNumIndices() > 0) {
            RenderableShapeBuilder.ensureIndicesCapacity(((Mesh)object).getNumIndices());
            ((Mesh)object).getIndices(renderable.meshPart.offset, renderable.meshPart.size, indices, 0);
            n2 = RenderableShapeBuilder.minVerticeInIndices();
            n = RenderableShapeBuilder.maxVerticeInIndices() - n2;
        } else {
            n2 = renderable.meshPart.offset;
            n = renderable.meshPart.size;
        }
        int n8 = n * n7;
        RenderableShapeBuilder.ensureVerticesCapacity(n8);
        ((Mesh)object).getVertices(n2 * n7, n8, vertices, 0);
        while (n2 < n) {
            n8 = n2 * n7;
            object = tmpV0;
            Object object2 = vertices;
            int n9 = n8 + n3;
            ((Vector3)object).set(object2[n9], object2[n9 + 1], object2[n9 + 2]);
            if (n4 != -1) {
                object2 = tmpV1;
                object = vertices;
                n9 = n8 + n4;
                ((Vector3)object2).set((float)object[n9], (float)object[n9 + 1], (float)object[n9 + 2]);
                tmpV2.set(tmpV0).add(tmpV1.scl(f));
            }
            if (n5 != -1) {
                object2 = tmpV3;
                object = vertices;
                n9 = n8 + n5;
                ((Vector3)object2).set((float)object[n9], (float)object[n9 + 1], (float)object[n9 + 2]);
                tmpV4.set(tmpV0).add(tmpV3.scl(f));
            }
            if (n6 != -1) {
                object2 = tmpV5;
                object = vertices;
                ((Vector3)object2).set((float)object[n8 += n6], (float)object[n8 + 1], (float)object[n8 + 2]);
                tmpV6.set(tmpV0).add(tmpV5.scl(f));
            }
            tmpV0.mul(renderable.worldTransform);
            tmpV2.mul(renderable.worldTransform);
            tmpV4.mul(renderable.worldTransform);
            tmpV6.mul(renderable.worldTransform);
            if (n4 != -1) {
                meshPartBuilder.setColor(color2);
                meshPartBuilder.line(tmpV0, tmpV2);
            }
            if (n5 != -1) {
                meshPartBuilder.setColor(color3);
                meshPartBuilder.line(tmpV0, tmpV4);
            }
            if (n6 != -1) {
                meshPartBuilder.setColor(color4);
                meshPartBuilder.line(tmpV0, tmpV6);
            }
            ++n2;
        }
    }

    public static void buildNormals(MeshPartBuilder meshPartBuilder, RenderableProvider renderableProvider, float f) {
        RenderableShapeBuilder.buildNormals(meshPartBuilder, renderableProvider, f, tmpColor0.set(0.0f, 0.0f, 1.0f, 1.0f), tmpColor1.set(1.0f, 0.0f, 0.0f, 1.0f), tmpColor2.set(0.0f, 1.0f, 0.0f, 1.0f));
    }

    public static void buildNormals(MeshPartBuilder meshPartBuilder, RenderableProvider object, float f, Color color2, Color color3, Color color4) {
        object.getRenderables(renderables, renderablesPool);
        object = renderables.iterator();
        while (object.hasNext()) {
            RenderableShapeBuilder.buildNormals(meshPartBuilder, (Renderable)object.next(), f, color2, color3, color4);
        }
        renderablesPool.flush();
        renderables.clear();
    }

    private static void ensureIndicesCapacity(int n) {
        short[] sArray = indices;
        if (sArray == null || sArray.length < n) {
            indices = new short[n];
        }
    }

    private static void ensureVerticesCapacity(int n) {
        float[] fArray = vertices;
        if (fArray == null || fArray.length < n) {
            vertices = new float[n];
        }
    }

    private static short maxVerticeInIndices() {
        short[] sArray;
        short s = Short.MIN_VALUE;
        short s2 = s;
        for (int i = 0; i < (sArray = indices).length; ++i) {
            s = s2;
            if (sArray[i] > s2) {
                s = sArray[i];
            }
            s2 = s;
        }
        return s2;
    }

    private static short minVerticeInIndices() {
        short[] sArray;
        short s = Short.MAX_VALUE;
        short s2 = s;
        for (int i = 0; i < (sArray = indices).length; ++i) {
            s = s2;
            if (sArray[i] < s2) {
                s = sArray[i];
            }
            s2 = s;
        }
        return s2;
    }

    private static class RenderablePool
    extends FlushablePool<Renderable> {
        @Override
        protected Renderable newObject() {
            return new Renderable();
        }

        @Override
        public Renderable obtain() {
            Renderable renderable = (Renderable)super.obtain();
            renderable.environment = null;
            renderable.material = null;
            renderable.meshPart.set("", null, 0, 0, 0);
            renderable.shader = null;
            renderable.userData = null;
            return renderable;
        }
    }
}

