/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.utils.MeshPartBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.ArrowShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.BoxShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.CapsuleShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.ConeShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.CylinderShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.EllipseShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.PatchShapeBuilder;
import com.badlogic.gdx.graphics.g3d.utils.shapebuilders.SphereShapeBuilder;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntIntMap;
import com.badlogic.gdx.utils.ShortArray;

public class MeshBuilder
implements MeshPartBuilder {
    private static IntIntMap indicesMap;
    private static final ShortArray tmpIndices;
    private static final FloatArray tmpVertices;
    private static final Vector3 vTmp;
    private VertexAttributes attributes;
    private int biNorOffset;
    private final BoundingBox bounds;
    private int colOffset;
    private int colSize;
    private final Color color;
    private int cpOffset;
    private boolean hasColor = false;
    private boolean hasUVTransform = false;
    private ShortArray indices;
    private int istart;
    private short lastIndex;
    private int norOffset;
    private final Matrix3 normalTransform;
    private MeshPart part;
    private Array<MeshPart> parts;
    private int posOffset;
    private int posSize;
    private final Matrix4 positionTransform;
    private int primitiveType;
    private int stride;
    private int tangentOffset;
    private final Color tempC1;
    private final Vector3 tmpNormal;
    private float uOffset = 0.0f;
    private float uScale = 1.0f;
    private int uvOffset;
    private float vOffset = 0.0f;
    private float vScale = 1.0f;
    private final MeshPartBuilder.VertexInfo vertTmp1 = new MeshPartBuilder.VertexInfo();
    private final MeshPartBuilder.VertexInfo vertTmp2 = new MeshPartBuilder.VertexInfo();
    private final MeshPartBuilder.VertexInfo vertTmp3 = new MeshPartBuilder.VertexInfo();
    private final MeshPartBuilder.VertexInfo vertTmp4 = new MeshPartBuilder.VertexInfo();
    private float[] vertex;
    private boolean vertexTransformationEnabled = false;
    private FloatArray vertices;
    private int vindex;

    static {
        tmpIndices = new ShortArray();
        tmpVertices = new FloatArray();
        vTmp = new Vector3();
        indicesMap = null;
    }

    public MeshBuilder() {
        this.tempC1 = new Color();
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.parts = new Array();
        this.color = new Color(Color.WHITE);
        this.positionTransform = new Matrix4();
        this.normalTransform = new Matrix3();
        this.bounds = new BoundingBox();
        this.lastIndex = (short)-1;
        this.tmpNormal = new Vector3();
    }

    private final void addVertex(float[] fArray, int n) {
        int n2 = this.vertices.size;
        this.vertices.addAll(fArray, n, this.stride);
        n = this.vindex;
        this.vindex = n + 1;
        this.lastIndex = (short)n;
        if (this.vertexTransformationEnabled) {
            MeshBuilder.transformPosition(this.vertices.items, this.posOffset + n2, this.posSize, this.positionTransform);
            if (this.norOffset >= 0) {
                MeshBuilder.transformNormal(this.vertices.items, this.norOffset + n2, 3, this.normalTransform);
            }
            if (this.biNorOffset >= 0) {
                MeshBuilder.transformNormal(this.vertices.items, this.biNorOffset + n2, 3, this.normalTransform);
            }
            if (this.tangentOffset >= 0) {
                MeshBuilder.transformNormal(this.vertices.items, this.tangentOffset + n2, 3, this.normalTransform);
            }
        }
        float f = this.vertices.items[this.posOffset + n2];
        n = this.posSize;
        float f2 = 0.0f;
        float f3 = n > 1 ? this.vertices.items[this.posOffset + n2 + 1] : 0.0f;
        if (this.posSize > 2) {
            f2 = this.vertices.items[this.posOffset + n2 + 2];
        }
        this.bounds.ext(f, f3, f2);
        if (this.hasColor) {
            if (this.colOffset >= 0) {
                fArray = this.vertices.items;
                n = this.colOffset + n2;
                fArray[n] = fArray[n] * this.color.r;
                fArray = this.vertices.items;
                n = this.colOffset + n2 + 1;
                fArray[n] = fArray[n] * this.color.g;
                fArray = this.vertices.items;
                n = this.colOffset + n2 + 2;
                fArray[n] = fArray[n] * this.color.b;
                if (this.colSize > 3) {
                    fArray = this.vertices.items;
                    n = this.colOffset + n2 + 3;
                    fArray[n] = fArray[n] * this.color.a;
                }
            } else if (this.cpOffset >= 0) {
                Color.abgr8888ToColor(this.tempC1, this.vertices.items[this.cpOffset + n2]);
                this.vertices.items[this.cpOffset + n2] = this.tempC1.mul(this.color).toFloatBits();
            }
        }
        if (this.hasUVTransform && this.uvOffset >= 0) {
            this.vertices.items[this.uvOffset + n2] = this.uOffset + this.uScale * this.vertices.items[this.uvOffset + n2];
            this.vertices.items[this.uvOffset + n2 + 1] = this.vOffset + this.vScale * this.vertices.items[n2 + this.uvOffset + 1];
        }
    }

    public static VertexAttributes createAttributes(long l) {
        Array<VertexAttribute> array = new Array<VertexAttribute>();
        if ((l & 1L) == 1L) {
            array.add(new VertexAttribute(1, 3, "a_position"));
        }
        if ((l & 2L) == 2L) {
            array.add(new VertexAttribute(2, 4, "a_color"));
        }
        if ((l & 4L) == 4L) {
            array.add(new VertexAttribute(4, 4, "a_color"));
        }
        if ((l & 8L) == 8L) {
            array.add(new VertexAttribute(8, 3, "a_normal"));
        }
        if ((l & 0x10L) == 16L) {
            array.add(new VertexAttribute(16, 2, "a_texCoord0"));
        }
        VertexAttribute[] vertexAttributeArray = new VertexAttribute[array.size];
        for (int i = 0; i < vertexAttributeArray.length; ++i) {
            vertexAttributeArray[i] = (VertexAttribute)array.get(i);
        }
        return new VertexAttributes(vertexAttributeArray);
    }

    private void endpart() {
        MeshPart meshPart = this.part;
        if (meshPart != null) {
            this.bounds.getCenter(meshPart.center);
            this.bounds.getDimensions(this.part.halfExtents).scl(0.5f);
            meshPart = this.part;
            meshPart.radius = meshPart.halfExtents.len();
            this.bounds.inf();
            meshPart = this.part;
            meshPart.offset = this.istart;
            meshPart.size = this.indices.size - this.istart;
            this.istart = this.indices.size;
            this.part = null;
        }
    }

    private static final void transformNormal(float[] fArray, int n, int n2, Matrix3 matrix3) {
        if (n2 > 2) {
            Vector3 vector3 = vTmp;
            float f = fArray[n];
            n2 = n + 1;
            float f2 = fArray[n2];
            int n3 = n + 2;
            vector3.set(f, f2, fArray[n3]).mul(matrix3).nor();
            fArray[n] = MeshBuilder.vTmp.x;
            fArray[n2] = MeshBuilder.vTmp.y;
            fArray[n3] = MeshBuilder.vTmp.z;
        } else if (n2 > 1) {
            Vector3 vector3 = vTmp;
            float f = fArray[n];
            n2 = n + 1;
            vector3.set(f, fArray[n2], 0.0f).mul(matrix3).nor();
            fArray[n] = MeshBuilder.vTmp.x;
            fArray[n2] = MeshBuilder.vTmp.y;
        } else {
            fArray[n] = MeshBuilder.vTmp.set((float)fArray[n], (float)0.0f, (float)0.0f).mul((Matrix3)matrix3).nor().x;
        }
    }

    private static final void transformPosition(float[] fArray, int n, int n2, Matrix4 matrix4) {
        if (n2 > 2) {
            Vector3 vector3 = vTmp;
            float f = fArray[n];
            n2 = n + 1;
            float f2 = fArray[n2];
            int n3 = n + 2;
            vector3.set(f, f2, fArray[n3]).mul(matrix4);
            fArray[n] = MeshBuilder.vTmp.x;
            fArray[n2] = MeshBuilder.vTmp.y;
            fArray[n3] = MeshBuilder.vTmp.z;
        } else if (n2 > 1) {
            Vector3 vector3 = vTmp;
            float f = fArray[n];
            n2 = n + 1;
            vector3.set(f, fArray[n2], 0.0f).mul(matrix4);
            fArray[n] = MeshBuilder.vTmp.x;
            fArray[n2] = MeshBuilder.vTmp.y;
        } else {
            fArray[n] = MeshBuilder.vTmp.set((float)fArray[n], (float)0.0f, (float)0.0f).mul((Matrix4)matrix4).x;
        }
    }

    @Override
    public void addMesh(Mesh mesh) {
        this.addMesh(mesh, 0, mesh.getNumIndices());
    }

    @Override
    public void addMesh(Mesh mesh, int n, int n2) {
        if (this.attributes.equals(mesh.getVertexAttributes())) {
            if (n2 <= 0) {
                return;
            }
            int n3 = mesh.getNumVertices() * this.stride;
            tmpVertices.clear();
            tmpVertices.ensureCapacity(n3);
            Object object = tmpVertices;
            ((FloatArray)object).size = n3;
            mesh.getVertices(((FloatArray)object).items);
            tmpIndices.clear();
            tmpIndices.ensureCapacity(n2);
            object = tmpIndices;
            ((ShortArray)object).size = n2;
            mesh.getIndices(n, n2, ((ShortArray)object).items, 0);
            this.addMesh(MeshBuilder.tmpVertices.items, MeshBuilder.tmpIndices.items, 0, n2);
            return;
        }
        throw new GdxRuntimeException("Vertex attributes do not match");
    }

    @Override
    public void addMesh(MeshPart meshPart) {
        if (meshPart.primitiveType == this.primitiveType) {
            this.addMesh(meshPart.mesh, meshPart.offset, meshPart.size);
            return;
        }
        throw new GdxRuntimeException("Primitive type doesn't match");
    }

    @Override
    public void addMesh(float[] fArray, short[] sArray) {
        int n;
        short s = (short)(this.lastIndex + 1);
        this.ensureVertices(fArray.length / this.stride);
        int n2 = 0;
        for (n = 0; n < fArray.length; n += this.stride) {
            this.addVertex(fArray, n);
        }
        this.ensureIndices(sArray.length);
        for (n = n2; n < sArray.length; ++n) {
            this.index((short)(sArray[n] + s));
        }
    }

    @Override
    public void addMesh(float[] fArray, short[] sArray, int n, int n2) {
        IntIntMap intIntMap = indicesMap;
        if (intIntMap == null) {
            indicesMap = new IntIntMap(n2);
        } else {
            intIntMap.clear();
            indicesMap.ensureCapacity(n2);
        }
        this.ensureIndices(n2);
        int n3 = fArray.length / this.stride;
        if (n3 >= n2) {
            n3 = n2;
        }
        this.ensureVertices(n3);
        for (n3 = 0; n3 < n2; ++n3) {
            int n4;
            short s = sArray[n + n3];
            int n5 = n4 = indicesMap.get(s, -1);
            if (n4 < 0) {
                this.addVertex(fArray, this.stride * s);
                intIntMap = indicesMap;
                n5 = this.lastIndex;
                intIntMap.put(s, n5);
            }
            this.index((short)n5);
        }
    }

    @Override
    @Deprecated
    public void arrow(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        ArrowShapeBuilder.build(this, f, f2, f3, f4, f5, f6, f7, f8, n);
    }

    public void begin(long l) {
        this.begin(MeshBuilder.createAttributes(l), -1);
    }

    public void begin(long l, int n) {
        this.begin(MeshBuilder.createAttributes(l), n);
    }

    public void begin(VertexAttributes vertexAttributes) {
        this.begin(vertexAttributes, -1);
    }

    public void begin(VertexAttributes object, int n) {
        if (this.attributes == null) {
            this.attributes = object;
            this.vertices.clear();
            this.indices.clear();
            this.parts.clear();
            int n2 = 0;
            this.vindex = 0;
            int n3 = -1;
            this.lastIndex = (short)-1;
            this.istart = 0;
            this.part = null;
            this.stride = ((VertexAttributes)object).vertexSize / 4;
            Object object2 = this.vertex;
            if (object2 == null || ((float[])object2).length < this.stride) {
                this.vertex = new float[this.stride];
            }
            if ((object2 = (Object)((VertexAttributes)object).findByUsage(1)) != null) {
                this.posOffset = object2.offset / 4;
                this.posSize = object2.numComponents;
                object2 = ((VertexAttributes)object).findByUsage(8);
                int n4 = object2 == null ? -1 : object2.offset / 4;
                this.norOffset = n4;
                object2 = ((VertexAttributes)object).findByUsage(256);
                n4 = object2 == null ? -1 : object2.offset / 4;
                this.biNorOffset = n4;
                object2 = ((VertexAttributes)object).findByUsage(128);
                n4 = object2 == null ? -1 : object2.offset / 4;
                this.tangentOffset = n4;
                object2 = ((VertexAttributes)object).findByUsage(2);
                n4 = object2 == null ? -1 : object2.offset / 4;
                this.colOffset = n4;
                n4 = object2 == null ? n2 : object2.numComponents;
                this.colSize = n4;
                object2 = ((VertexAttributes)object).findByUsage(4);
                n4 = object2 == null ? -1 : object2.offset / 4;
                this.cpOffset = n4;
                object = ((VertexAttributes)object).findByUsage(16);
                n4 = object == null ? n3 : ((VertexAttribute)object).offset / 4;
                this.uvOffset = n4;
                this.setColor(null);
                this.setVertexTransform(null);
                this.setUVRange(null);
                this.primitiveType = n;
                this.bounds.inf();
                return;
            }
            throw new GdxRuntimeException("Cannot build mesh without position attribute");
        }
        throw new RuntimeException("Call end() first");
    }

    @Override
    @Deprecated
    public void box(float f, float f2, float f3) {
        BoxShapeBuilder.build(this, f, f2, f3);
    }

    @Override
    @Deprecated
    public void box(float f, float f2, float f3, float f4, float f5, float f6) {
        BoxShapeBuilder.build(this, f, f2, f3, f4, f5, f6);
    }

    @Override
    @Deprecated
    public void box(MeshPartBuilder.VertexInfo vertexInfo, MeshPartBuilder.VertexInfo vertexInfo2, MeshPartBuilder.VertexInfo vertexInfo3, MeshPartBuilder.VertexInfo vertexInfo4, MeshPartBuilder.VertexInfo vertexInfo5, MeshPartBuilder.VertexInfo vertexInfo6, MeshPartBuilder.VertexInfo vertexInfo7, MeshPartBuilder.VertexInfo vertexInfo8) {
        BoxShapeBuilder.build((MeshPartBuilder)this, vertexInfo, vertexInfo2, vertexInfo3, vertexInfo4, vertexInfo5, vertexInfo6, vertexInfo7, vertexInfo8);
    }

    @Override
    @Deprecated
    public void box(Matrix4 matrix4) {
        BoxShapeBuilder.build((MeshPartBuilder)this, matrix4);
    }

    @Override
    @Deprecated
    public void box(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, Vector3 vector35, Vector3 vector36, Vector3 vector37, Vector3 vector38) {
        BoxShapeBuilder.build((MeshPartBuilder)this, vector3, vector32, vector33, vector34, vector35, vector36, vector37, vector38);
    }

    @Override
    @Deprecated
    public void capsule(float f, float f2, int n) {
        CapsuleShapeBuilder.build(this, f, f2, n);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, float f2, float f3, float f4, float f5, float f6, float f7) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, n, f2, f3, f4, f5, f6, f7);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        EllipseShapeBuilder.build(this, f, n, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        EllipseShapeBuilder.build(this, f, n, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        EllipseShapeBuilder.build(this, f, n, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, Vector3 vector3, Vector3 vector32) {
        EllipseShapeBuilder.build(this, f, n, vector3, vector32);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, Vector3 vector3, Vector3 vector32, float f2, float f3) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, n, vector3, vector32, f2, f3);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, n, vector3, vector32, vector33, vector34);
    }

    @Override
    @Deprecated
    public void circle(float f, int n, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, float f2, float f3) {
        this.circle(f, n, vector3.x, vector3.y, vector3.z, vector32.x, vector32.y, vector32.z, vector33.x, vector33.y, vector33.z, vector34.x, vector34.y, vector34.z, f2, f3);
    }

    public void clear() {
        this.vertices.clear();
        this.indices.clear();
        this.parts.clear();
        this.vindex = 0;
        this.lastIndex = (short)-1;
        this.istart = 0;
        this.part = null;
    }

    @Override
    @Deprecated
    public void cone(float f, float f2, float f3, int n) {
        this.cone(f, f2, f3, n, 0.0f, 360.0f);
    }

    @Override
    @Deprecated
    public void cone(float f, float f2, float f3, int n, float f4, float f5) {
        ConeShapeBuilder.build(this, f, f2, f3, n, f4, f5);
    }

    @Override
    @Deprecated
    public void cylinder(float f, float f2, float f3, int n) {
        CylinderShapeBuilder.build(this, f, f2, f3, n);
    }

    @Override
    @Deprecated
    public void cylinder(float f, float f2, float f3, int n, float f4, float f5) {
        CylinderShapeBuilder.build(this, f, f2, f3, n, f4, f5);
    }

    @Override
    @Deprecated
    public void cylinder(float f, float f2, float f3, int n, float f4, float f5, boolean bl) {
        CylinderShapeBuilder.build(this, f, f2, f3, n, f4, f5, bl);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7, float f8, float f9, float f10) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, f3, f4, n, f5, f6, f7, f8, f9, f10);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        EllipseShapeBuilder.build(this, f, f2, f3, f4, n, f5, f6, f7, f8, f9, f10, f11, f12);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, float f3, float f4, int n, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        EllipseShapeBuilder.build(this, f, f2, f3, f4, n, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, float f3, float f4, int n, Vector3 vector3, Vector3 vector32) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, f3, f4, n, vector3, vector32);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, float f3, float f4, float f5, float f6, float f7, float f8) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, n, f3, f4, f5, f6, f7, f8);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, n, f3, f4, f5, f6, f7, f8, f9, f10);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        EllipseShapeBuilder.build(this, f, f2, n, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        EllipseShapeBuilder.build(this, f, f2, n, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, Vector3 vector3, Vector3 vector32) {
        EllipseShapeBuilder.build(this, f, f2, n, vector3, vector32);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, Vector3 vector3, Vector3 vector32, float f3, float f4) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, n, vector3, vector32, f3, f4);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, n, vector3, vector32, vector33, vector34);
    }

    @Override
    @Deprecated
    public void ellipse(float f, float f2, int n, Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, float f3, float f4) {
        EllipseShapeBuilder.build((MeshPartBuilder)this, f, f2, n, vector3, vector32, vector33, vector34, f3, f4);
    }

    public Mesh end() {
        return this.end(new Mesh(true, this.vertices.size / this.stride, this.indices.size, this.attributes));
    }

    public Mesh end(Mesh object) {
        this.endpart();
        Object object2 = this.attributes;
        if (object2 != null) {
            if (((VertexAttributes)object2).equals(((Mesh)object).getVertexAttributes())) {
                if (((Mesh)object).getMaxVertices() * this.stride >= this.vertices.size) {
                    if (((Mesh)object).getMaxIndices() >= this.indices.size) {
                        ((Mesh)object).setVertices(this.vertices.items, 0, this.vertices.size);
                        ((Mesh)object).setIndices(this.indices.items, 0, this.indices.size);
                        object2 = this.parts.iterator();
                        while (object2.hasNext()) {
                            ((MeshPart)object2.next()).mesh = object;
                        }
                        this.parts.clear();
                        this.attributes = null;
                        this.vertices.clear();
                        this.indices.clear();
                        return object;
                    }
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("Mesh can't hold enough indices: ");
                    ((StringBuilder)object2).append(((Mesh)object).getMaxIndices());
                    ((StringBuilder)object2).append(" < ");
                    ((StringBuilder)object2).append(this.indices.size);
                    throw new GdxRuntimeException(((StringBuilder)object2).toString());
                }
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Mesh can't hold enough vertices: ");
                ((StringBuilder)object2).append(((Mesh)object).getMaxVertices());
                ((StringBuilder)object2).append(" * ");
                ((StringBuilder)object2).append(this.stride);
                ((StringBuilder)object2).append(" < ");
                ((StringBuilder)object2).append(this.vertices.size);
                throw new GdxRuntimeException(((StringBuilder)object2).toString());
            }
            throw new GdxRuntimeException("Mesh attributes don't match");
        }
        object = new GdxRuntimeException("Call begin() first");
        throw object;
    }

    @Override
    public void ensureCapacity(int n, int n2) {
        this.ensureVertices(n);
        this.ensureIndices(n2);
    }

    @Override
    public void ensureIndices(int n) {
        this.indices.ensureCapacity(n);
    }

    @Override
    public void ensureRectangleIndices(int n) {
        int n2 = this.primitiveType;
        if (n2 == 0) {
            this.ensureIndices(n * 4);
        } else if (n2 == 1) {
            this.ensureIndices(n * 8);
        } else {
            this.ensureIndices(n * 6);
        }
    }

    public void ensureRectangles(int n) {
        this.ensureVertices(n * 4);
        this.ensureRectangleIndices(n);
    }

    @Deprecated
    public void ensureRectangles(int n, int n2) {
        this.ensureVertices(n);
        this.ensureRectangleIndices(n2);
    }

    @Override
    public void ensureTriangleIndices(int n) {
        int n2 = this.primitiveType;
        if (n2 == 1) {
            this.ensureIndices(n * 6);
        } else {
            if (n2 != 4 && n2 != 0) {
                throw new GdxRuntimeException("Incorrect primtive type");
            }
            this.ensureIndices(n * 3);
        }
    }

    @Deprecated
    public void ensureTriangles(int n) {
        this.ensureVertices(n * 3);
        this.ensureTriangleIndices(n);
    }

    @Deprecated
    public void ensureTriangles(int n, int n2) {
        this.ensureVertices(n);
        this.ensureTriangleIndices(n2);
    }

    @Override
    public void ensureVertices(int n) {
        this.vertices.ensureCapacity(this.stride * n);
    }

    @Override
    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    public int getFloatsPerVertex() {
        return this.stride;
    }

    public void getIndices(short[] sArray, int n) {
        if (this.attributes != null) {
            if (n >= 0 && n <= sArray.length - this.indices.size) {
                System.arraycopy(this.indices.items, 0, sArray, n, this.indices.size);
                return;
            }
            throw new GdxRuntimeException("Array to small or offset out of range");
        }
        throw new GdxRuntimeException("Must be called in between #begin and #end");
    }

    protected short[] getIndices() {
        return this.indices.items;
    }

    @Override
    public MeshPart getMeshPart() {
        return this.part;
    }

    public int getNumIndices() {
        return this.indices.size;
    }

    public int getNumVertices() {
        return this.vertices.size / this.stride;
    }

    @Override
    public int getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public Matrix4 getVertexTransform(Matrix4 matrix4) {
        return matrix4.set(this.positionTransform);
    }

    public void getVertices(float[] fArray, int n) {
        if (this.attributes != null) {
            if (n >= 0 && n <= fArray.length - this.vertices.size) {
                System.arraycopy(this.vertices.items, 0, fArray, n, this.vertices.size);
                return;
            }
            throw new GdxRuntimeException("Array to small or offset out of range");
        }
        throw new GdxRuntimeException("Must be called in between #begin and #end");
    }

    protected float[] getVertices() {
        return this.vertices.items;
    }

    @Override
    public void index(short s) {
        this.indices.add(s);
    }

    @Override
    public void index(short s, short s2) {
        this.ensureIndices(2);
        this.indices.add(s);
        this.indices.add(s2);
    }

    @Override
    public void index(short s, short s2, short s3) {
        this.ensureIndices(3);
        this.indices.add(s);
        this.indices.add(s2);
        this.indices.add(s3);
    }

    @Override
    public void index(short s, short s2, short s3, short s4) {
        this.ensureIndices(4);
        this.indices.add(s);
        this.indices.add(s2);
        this.indices.add(s3);
        this.indices.add(s4);
    }

    @Override
    public void index(short s, short s2, short s3, short s4, short s5, short s6) {
        this.ensureIndices(6);
        this.indices.add(s);
        this.indices.add(s2);
        this.indices.add(s3);
        this.indices.add(s4);
        this.indices.add(s5);
        this.indices.add(s6);
    }

    @Override
    public void index(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        this.ensureIndices(8);
        this.indices.add(s);
        this.indices.add(s2);
        this.indices.add(s3);
        this.indices.add(s4);
        this.indices.add(s5);
        this.indices.add(s6);
        this.indices.add(s7);
        this.indices.add(s8);
    }

    @Override
    public boolean isVertexTransformationEnabled() {
        return this.vertexTransformationEnabled;
    }

    @Override
    public short lastIndex() {
        return this.lastIndex;
    }

    @Override
    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.line(this.vertTmp1.set(null, null, null, null).setPos(f, f2, f3), this.vertTmp2.set(null, null, null, null).setPos(f4, f5, f6));
    }

    @Override
    public void line(MeshPartBuilder.VertexInfo vertexInfo, MeshPartBuilder.VertexInfo vertexInfo2) {
        this.ensureVertices(2);
        this.line(this.vertex(vertexInfo), this.vertex(vertexInfo2));
    }

    @Override
    public void line(Vector3 vector3, Color color2, Vector3 vector32, Color color3) {
        this.line(this.vertTmp1.set(vector3, null, color2, null), this.vertTmp2.set(vector32, null, color3, null));
    }

    @Override
    public void line(Vector3 vector3, Vector3 vector32) {
        this.line(this.vertTmp1.set(vector3, null, null, null), this.vertTmp2.set(vector32, null, null, null));
    }

    @Override
    public void line(short s, short s2) {
        if (this.primitiveType == 1) {
            this.index(s, s2);
            return;
        }
        throw new GdxRuntimeException("Incorrect primitive type");
    }

    public MeshPart part(String string2, int n) {
        return this.part(string2, n, new MeshPart());
    }

    public MeshPart part(String string2, int n, MeshPart meshPart) {
        if (this.attributes != null) {
            this.endpart();
            meshPart = this.part = meshPart;
            meshPart.id = string2;
            meshPart.primitiveType = n;
            this.primitiveType = n;
            this.parts.add(meshPart);
            this.setColor(null);
            this.setVertexTransform(null);
            this.setUVRange(null);
            return this.part;
        }
        throw new RuntimeException("Call begin() first");
    }

    @Override
    @Deprecated
    public void patch(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, int n, int n2) {
        PatchShapeBuilder.build(this, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, n, n2);
    }

    @Override
    @Deprecated
    public void patch(MeshPartBuilder.VertexInfo vertexInfo, MeshPartBuilder.VertexInfo vertexInfo2, MeshPartBuilder.VertexInfo vertexInfo3, MeshPartBuilder.VertexInfo vertexInfo4, int n, int n2) {
        PatchShapeBuilder.build(this, vertexInfo, vertexInfo2, vertexInfo3, vertexInfo4, n, n2);
    }

    @Override
    @Deprecated
    public void patch(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, Vector3 vector35, int n, int n2) {
        PatchShapeBuilder.build(this, vector3, vector32, vector33, vector34, vector35, n, n2);
    }

    @Override
    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15) {
        this.rect(this.vertTmp1.set(null, null, null, null).setPos(f, f2, f3).setNor(f13, f14, f15).setUV(0.0f, 1.0f), this.vertTmp2.set(null, null, null, null).setPos(f4, f5, f6).setNor(f13, f14, f15).setUV(1.0f, 1.0f), this.vertTmp3.set(null, null, null, null).setPos(f7, f8, f9).setNor(f13, f14, f15).setUV(1.0f, 0.0f), this.vertTmp4.set(null, null, null, null).setPos(f10, f11, f12).setNor(f13, f14, f15).setUV(0.0f, 0.0f));
    }

    @Override
    public void rect(MeshPartBuilder.VertexInfo vertexInfo, MeshPartBuilder.VertexInfo vertexInfo2, MeshPartBuilder.VertexInfo vertexInfo3, MeshPartBuilder.VertexInfo vertexInfo4) {
        this.ensureVertices(4);
        this.rect(this.vertex(vertexInfo), this.vertex(vertexInfo2), this.vertex(vertexInfo3), this.vertex(vertexInfo4));
    }

    @Override
    public void rect(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, Vector3 vector35) {
        this.rect(this.vertTmp1.set(vector3, vector35, null, null).setUV(0.0f, 1.0f), this.vertTmp2.set(vector32, vector35, null, null).setUV(1.0f, 1.0f), this.vertTmp3.set(vector33, vector35, null, null).setUV(1.0f, 0.0f), this.vertTmp4.set(vector34, vector35, null, null).setUV(0.0f, 0.0f));
    }

    @Override
    public void rect(short s, short s2, short s3, short s4) {
        block5: {
            block3: {
                int n;
                block4: {
                    block2: {
                        n = this.primitiveType;
                        if (n != 4) break block2;
                        this.index(s, s2, s3, s3, s4, s);
                        break block3;
                    }
                    if (n != 1) break block4;
                    this.index(s, s2, s2, s3, s3, s4, s4, s);
                    break block3;
                }
                if (n != 0) break block5;
                this.index(s, s2, s3, s4);
            }
            return;
        }
        throw new GdxRuntimeException("Incorrect primitive type");
    }

    @Override
    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
        this.hasColor = this.color.equals(Color.WHITE) ^ true;
    }

    @Override
    public void setColor(Color color2) {
        Color color3 = this.color;
        boolean bl = color2 != null;
        this.hasColor = bl;
        if (!bl) {
            color2 = Color.WHITE;
        }
        color3.set(color2);
    }

    @Override
    public void setUVRange(float f, float f2, float f3, float f4) {
        this.uOffset = f;
        this.vOffset = f2;
        this.uScale = f3 - f;
        this.vScale = f4 - f2;
        boolean bl = !(MathUtils.isZero(f) && MathUtils.isZero(f2) && MathUtils.isEqual(f3, 1.0f) && MathUtils.isEqual(f4, 1.0f));
        this.hasUVTransform = bl;
    }

    @Override
    public void setUVRange(TextureRegion textureRegion) {
        boolean bl = textureRegion != null;
        this.hasUVTransform = bl;
        if (!bl) {
            this.vOffset = 0.0f;
            this.uOffset = 0.0f;
            this.vScale = 1.0f;
            this.uScale = 1.0f;
        } else {
            this.setUVRange(textureRegion.getU(), textureRegion.getV(), textureRegion.getU2(), textureRegion.getV2());
        }
    }

    @Override
    public void setVertexTransform(Matrix4 matrix4) {
        boolean bl = matrix4 != null;
        this.vertexTransformationEnabled = bl;
        if (this.vertexTransformationEnabled) {
            this.positionTransform.set(matrix4);
            this.normalTransform.set(matrix4).inv().transpose();
        } else {
            this.positionTransform.idt();
            this.normalTransform.idt();
        }
    }

    @Override
    public void setVertexTransformationEnabled(boolean bl) {
        this.vertexTransformationEnabled = bl;
    }

    @Override
    @Deprecated
    public void sphere(float f, float f2, float f3, int n, int n2) {
        SphereShapeBuilder.build(this, f, f2, f3, n, n2);
    }

    @Override
    @Deprecated
    public void sphere(float f, float f2, float f3, int n, int n2, float f4, float f5, float f6, float f7) {
        SphereShapeBuilder.build(this, f, f2, f3, n, n2, f4, f5, f6, f7);
    }

    @Override
    @Deprecated
    public void sphere(Matrix4 matrix4, float f, float f2, float f3, int n, int n2) {
        SphereShapeBuilder.build(this, matrix4, f, f2, f3, n, n2);
    }

    @Override
    @Deprecated
    public void sphere(Matrix4 matrix4, float f, float f2, float f3, int n, int n2, float f4, float f5, float f6, float f7) {
        SphereShapeBuilder.build(this, matrix4, f, f2, f3, n, n2, f4, f5, f6, f7);
    }

    @Override
    public void triangle(MeshPartBuilder.VertexInfo vertexInfo, MeshPartBuilder.VertexInfo vertexInfo2, MeshPartBuilder.VertexInfo vertexInfo3) {
        this.ensureVertices(3);
        this.triangle(this.vertex(vertexInfo), this.vertex(vertexInfo2), this.vertex(vertexInfo3));
    }

    @Override
    public void triangle(Vector3 vector3, Color color2, Vector3 vector32, Color color3, Vector3 vector33, Color color4) {
        this.triangle(this.vertTmp1.set(vector3, null, color2, null), this.vertTmp2.set(vector32, null, color3, null), this.vertTmp3.set(vector33, null, color4, null));
    }

    @Override
    public void triangle(Vector3 vector3, Vector3 vector32, Vector3 vector33) {
        this.triangle(this.vertTmp1.set(vector3, null, null, null), this.vertTmp2.set(vector32, null, null, null), this.vertTmp3.set(vector33, null, null, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void triangle(short s, short s2, short s3) {
        int n = this.primitiveType;
        if (n != 4 && n != 0) {
            if (n != 1) throw new GdxRuntimeException("Incorrect primitive type");
            this.index(s, s2, s2, s3, s3, s);
            return;
        } else {
            this.index(s, s2, s3);
        }
    }

    @Override
    public short vertex(MeshPartBuilder.VertexInfo vertexInfo) {
        boolean bl = vertexInfo.hasPosition;
        Vector2 vector2 = null;
        Vector3 vector3 = bl ? vertexInfo.position : null;
        Vector3 vector32 = vertexInfo.hasNormal ? vertexInfo.normal : null;
        Color color2 = vertexInfo.hasColor ? vertexInfo.color : null;
        if (vertexInfo.hasUV) {
            vector2 = vertexInfo.uv;
        }
        return this.vertex(vector3, vector32, color2, vector2);
    }

    @Override
    public short vertex(Vector3 object, Vector3 vector3, Color color2, Vector2 vector2) {
        if (this.vindex <= Short.MAX_VALUE) {
            int n;
            this.vertex[this.posOffset] = ((Vector3)object).x;
            if (this.posSize > 1) {
                this.vertex[this.posOffset + 1] = ((Vector3)object).y;
            }
            if (this.posSize > 2) {
                this.vertex[this.posOffset + 2] = ((Vector3)object).z;
            }
            if (this.norOffset >= 0) {
                Vector3 vector32 = vector3;
                if (vector3 == null) {
                    vector32 = this.tmpNormal.set((Vector3)object).nor();
                }
                this.vertex[this.norOffset] = vector32.x;
                this.vertex[this.norOffset + 1] = vector32.y;
                this.vertex[this.norOffset + 2] = vector32.z;
            }
            if (this.colOffset >= 0) {
                object = color2;
                if (color2 == null) {
                    object = Color.WHITE;
                }
                this.vertex[this.colOffset] = ((Color)object).r;
                this.vertex[this.colOffset + 1] = ((Color)object).g;
                this.vertex[this.colOffset + 2] = ((Color)object).b;
                if (this.colSize > 3) {
                    this.vertex[this.colOffset + 3] = ((Color)object).a;
                }
            } else if (this.cpOffset > 0) {
                object = color2;
                if (color2 == null) {
                    object = Color.WHITE;
                }
                this.vertex[this.cpOffset] = ((Color)object).toFloatBits();
            }
            if (vector2 != null && (n = this.uvOffset) >= 0) {
                this.vertex[n] = vector2.x;
                this.vertex[this.uvOffset + 1] = vector2.y;
            }
            this.addVertex(this.vertex, 0);
            return this.lastIndex;
        }
        throw new GdxRuntimeException("Too many vertices used");
    }

    @Override
    public short vertex(float ... fArray) {
        int n = fArray.length;
        int n2 = this.stride;
        for (int i = 0; i <= n - n2; i += this.stride) {
            this.addVertex(fArray, i);
        }
        return this.lastIndex;
    }
}

