/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;

public abstract class BaseShader
implements Shader {
    private final IntIntMap attributes;
    public Camera camera;
    private Attributes combinedAttributes;
    public RenderContext context;
    private Mesh currentMesh;
    private final IntArray globalUniforms;
    private final IntArray localUniforms;
    private int[] locations;
    public ShaderProgram program;
    private final Array<Setter> setters;
    private final IntArray tempArray;
    private final Array<String> uniforms = new Array();
    private final Array<Validator> validators = new Array();

    public BaseShader() {
        this.setters = new Array();
        this.globalUniforms = new IntArray();
        this.localUniforms = new IntArray();
        this.attributes = new IntIntMap();
        this.tempArray = new IntArray();
        this.combinedAttributes = new Attributes();
    }

    private final int[] getAttributeLocations(VertexAttributes vertexAttributes) {
        this.tempArray.clear();
        int n = vertexAttributes.size();
        for (int i = 0; i < n; ++i) {
            this.tempArray.add(this.attributes.get(vertexAttributes.get(i).getKey(), -1));
        }
        this.tempArray.shrink();
        return this.tempArray.items;
    }

    @Override
    public void begin(Camera array, RenderContext renderContext) {
        this.camera = array;
        this.context = renderContext;
        this.program.begin();
        this.currentMesh = null;
        for (int i = 0; i < this.globalUniforms.size; ++i) {
            array = this.setters;
            int n = this.globalUniforms.get(i);
            if (array.get(n) == null) continue;
            this.setters.get(n).set(this, n, null, null);
        }
    }

    @Override
    public void dispose() {
        this.program = null;
        this.uniforms.clear();
        this.validators.clear();
        this.setters.clear();
        this.localUniforms.clear();
        this.globalUniforms.clear();
        this.locations = null;
    }

    @Override
    public void end() {
        Mesh mesh = this.currentMesh;
        if (mesh != null) {
            mesh.unbind(this.program, this.tempArray.items);
            this.currentMesh = null;
        }
        this.program.end();
    }

    public String getUniformAlias(int n) {
        return this.uniforms.get(n);
    }

    public int getUniformID(String string2) {
        int n = this.uniforms.size;
        for (int i = 0; i < n; ++i) {
            if (!this.uniforms.get(i).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public final boolean has(int n) {
        int[] nArray;
        boolean bl = n >= 0 && n < (nArray = this.locations).length && nArray[n] >= 0;
        return bl;
    }

    public void init(ShaderProgram object, Renderable object2) {
        if (this.locations == null) {
            if (((ShaderProgram)object).isCompiled()) {
                Object object3;
                int n;
                this.program = object;
                int n2 = this.uniforms.size;
                this.locations = new int[n2];
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    String string2 = this.uniforms.get(n);
                    object3 = this.validators.get(n);
                    Setter setter = this.setters.get(n);
                    if (object3 != null && !object3.validate(this, n, (Renderable)object2)) {
                        this.locations[n] = -1;
                    } else {
                        this.locations[n] = ((ShaderProgram)object).fetchUniformLocation(string2, false);
                        if (this.locations[n] >= 0 && setter != null) {
                            if (setter.isGlobal(this, n)) {
                                this.globalUniforms.add(n);
                            } else {
                                this.localUniforms.add(n);
                            }
                        }
                    }
                    if (this.locations[n] >= 0) continue;
                    this.validators.set(n, null);
                    this.setters.set(n, null);
                }
                if (object2 != null) {
                    object2 = ((Renderable)object2).meshPart.mesh.getVertexAttributes();
                    n2 = ((VertexAttributes)object2).size();
                    for (n = n3; n < n2; ++n) {
                        object3 = ((VertexAttributes)object2).get(n);
                        n3 = ((ShaderProgram)object).getAttributeLocation(((VertexAttribute)object3).alias);
                        if (n3 < 0) continue;
                        this.attributes.put(((VertexAttribute)object3).getKey(), n3);
                    }
                }
                return;
            }
            throw new GdxRuntimeException(((ShaderProgram)object).getLog());
        }
        object = new GdxRuntimeException("Already initialized");
        throw object;
    }

    public final int loc(int n) {
        int[] nArray;
        n = n >= 0 && n < (nArray = this.locations).length ? nArray[n] : -1;
        return n;
    }

    public int register(Uniform uniform) {
        return this.register(uniform, null);
    }

    public int register(Uniform uniform, Setter setter) {
        return this.register(uniform.alias, uniform, setter);
    }

    public int register(String string2) {
        return this.register(string2, null, null);
    }

    public int register(String string2, Setter setter) {
        return this.register(string2, null, setter);
    }

    public int register(String string2, Validator validator) {
        return this.register(string2, validator, null);
    }

    public int register(String string2, Validator validator, Setter setter) {
        if (this.locations == null) {
            int n = this.getUniformID(string2);
            if (n >= 0) {
                this.validators.set(n, validator);
                this.setters.set(n, setter);
                return n;
            }
            this.uniforms.add(string2);
            this.validators.add(validator);
            this.setters.add(setter);
            return this.uniforms.size - 1;
        }
        throw new GdxRuntimeException("Cannot register an uniform after initialization");
    }

    @Override
    public void render(Renderable renderable) {
        if (renderable.worldTransform.det3x3() == 0.0f) {
            return;
        }
        this.combinedAttributes.clear();
        if (renderable.environment != null) {
            this.combinedAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            this.combinedAttributes.set(renderable.material);
        }
        this.render(renderable, this.combinedAttributes);
    }

    public void render(Renderable renderable, Attributes object) {
        for (int i = 0; i < this.localUniforms.size; ++i) {
            Array<Setter> array = this.setters;
            int n = this.localUniforms.get(i);
            if (array.get(n) == null) continue;
            this.setters.get(n).set(this, n, renderable, (Attributes)object);
        }
        if (this.currentMesh != renderable.meshPart.mesh) {
            object = this.currentMesh;
            if (object != null) {
                ((Mesh)object).unbind(this.program, this.tempArray.items);
            }
            this.currentMesh = renderable.meshPart.mesh;
            this.currentMesh.bind(this.program, this.getAttributeLocations(renderable.meshPart.mesh.getVertexAttributes()));
        }
        renderable.meshPart.render(this.program, false);
    }

    public final boolean set(int n, float f) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], f);
        return true;
    }

    public final boolean set(int n, float f, float f2) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], f, f2);
        return true;
    }

    public final boolean set(int n, float f, float f2, float f3) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], f, f2, f3);
        return true;
    }

    public final boolean set(int n, float f, float f2, float f3, float f4) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], f, f2, f3, f4);
        return true;
    }

    public final boolean set(int n, int n2) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], n2);
        return true;
    }

    public final boolean set(int n, int n2, int n3) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], n2, n3);
        return true;
    }

    public final boolean set(int n, int n2, int n3, int n4) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], n2, n3, n4);
        return true;
    }

    public final boolean set(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], n2, n3, n4, n5);
        return true;
    }

    public final boolean set(int n, Color color2) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], color2);
        return true;
    }

    public final boolean set(int n, GLTexture gLTexture) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], this.context.textureBinder.bind(gLTexture));
        return true;
    }

    public final boolean set(int n, TextureDescriptor textureDescriptor) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformi(nArray[n], this.context.textureBinder.bind(textureDescriptor));
        return true;
    }

    public final boolean set(int n, Matrix3 matrix3) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformMatrix(nArray[n], matrix3);
        return true;
    }

    public final boolean set(int n, Matrix4 matrix4) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformMatrix(nArray[n], matrix4);
        return true;
    }

    public final boolean set(int n, Vector2 vector2) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], vector2);
        return true;
    }

    public final boolean set(int n, Vector3 vector3) {
        int[] nArray = this.locations;
        if (nArray[n] < 0) {
            return false;
        }
        this.program.setUniformf(nArray[n], vector3);
        return true;
    }

    public static abstract class GlobalSetter
    implements Setter {
        @Override
        public boolean isGlobal(BaseShader baseShader, int n) {
            return true;
        }
    }

    public static abstract class LocalSetter
    implements Setter {
        @Override
        public boolean isGlobal(BaseShader baseShader, int n) {
            return false;
        }
    }

    public static interface Setter {
        public boolean isGlobal(BaseShader var1, int var2);

        public void set(BaseShader var1, int var2, Renderable var3, Attributes var4);
    }

    public static class Uniform
    implements Validator {
        public final String alias;
        public final long environmentMask;
        public final long materialMask;
        public final long overallMask;

        public Uniform(String string2) {
            this(string2, 0L, 0L);
        }

        public Uniform(String string2, long l) {
            this(string2, 0L, 0L, l);
        }

        public Uniform(String string2, long l, long l2) {
            this(string2, l, l2, 0L);
        }

        public Uniform(String string2, long l, long l2, long l3) {
            this.alias = string2;
            this.materialMask = l;
            this.environmentMask = l2;
            this.overallMask = l3;
        }

        @Override
        public boolean validate(BaseShader baseShader, int n, Renderable renderable) {
            long l = 0L;
            long l2 = renderable != null && renderable.material != null ? renderable.material.getMask() : 0L;
            long l3 = l;
            if (renderable != null) {
                l3 = l;
                if (renderable.environment != null) {
                    l3 = renderable.environment.getMask();
                }
            }
            boolean bl = (l2 & (l = this.materialMask)) == l && (l3 & (l = this.environmentMask)) == l && ((l3 | l2) & (l = this.overallMask)) == l;
            return bl;
        }
    }

    public static interface Validator {
        public boolean validate(BaseShader var1, int var2, Renderable var3);
    }
}

