/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.influencers.SimpleInfluencer;

public class ScaleInfluencer
extends SimpleInfluencer {
    public ScaleInfluencer() {
        this.valueChannelDescriptor = ParticleChannels.Scale;
    }

    public ScaleInfluencer(ScaleInfluencer scaleInfluencer) {
        super(scaleInfluencer);
    }

    @Override
    public void activateParticles(int n, int n2) {
        if (this.value.isRelative()) {
            int n3 = this.valueChannel.strideSize * n;
            int n4 = n * this.interpolationChannel.strideSize;
            int n5 = this.valueChannel.strideSize;
            n = n3;
            while (n < n2 * n5 + n3) {
                float f = this.value.newLowValue() * this.controller.scale.x;
                float f2 = this.value.newHighValue() * this.controller.scale.x;
                this.interpolationChannel.data[n4 + 0] = f;
                this.interpolationChannel.data[n4 + 1] = f2;
                this.valueChannel.data[n] = f + f2 * this.value.getScale(0.0f);
                n += this.valueChannel.strideSize;
                n4 += this.interpolationChannel.strideSize;
            }
        } else {
            int n6 = this.valueChannel.strideSize * n;
            int n7 = n * this.interpolationChannel.strideSize;
            int n8 = this.valueChannel.strideSize;
            n = n6;
            while (n < n2 * n8 + n6) {
                float f = this.value.newLowValue() * this.controller.scale.x;
                float f3 = this.value.newHighValue() * this.controller.scale.x - f;
                this.interpolationChannel.data[n7 + 0] = f;
                this.interpolationChannel.data[n7 + 1] = f3;
                this.valueChannel.data[n] = f + f3 * this.value.getScale(0.0f);
                n += this.valueChannel.strideSize;
                n7 += this.interpolationChannel.strideSize;
            }
        }
    }

    @Override
    public ParticleControllerComponent copy() {
        return new ScaleInfluencer(this);
    }
}

