/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.emitters.Emitter;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.graphics.g3d.particles.renderers.ParticleControllerRenderer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.reflect.ClassReflection;
import java.util.Iterator;

public class ParticleController
implements ResourceData.Configurable,
Json.Serializable {
    protected static final float DEFAULT_TIME_STEP = 0.016666668f;
    protected BoundingBox boundingBox;
    public float deltaTime;
    public float deltaTimeSqr;
    public Emitter emitter;
    public Array<Influencer> influencers;
    public String name;
    public ParticleChannels particleChannels;
    public ParallelArray particles;
    public ParticleControllerRenderer<?, ?> renderer;
    public Vector3 scale;
    public Matrix4 transform = new Matrix4();

    public ParticleController() {
        this.scale = new Vector3(1.0f, 1.0f, 1.0f);
        this.influencers = new Array(true, 3, Influencer.class);
        this.setTimeStep(0.016666668f);
    }

    public ParticleController(String string2, Emitter emitter, ParticleControllerRenderer<?, ?> particleControllerRenderer, Influencer ... influencerArray) {
        this();
        this.name = string2;
        this.emitter = emitter;
        this.renderer = particleControllerRenderer;
        this.particleChannels = new ParticleChannels();
        this.influencers = new Array<Influencer>(influencerArray);
    }

    private <K extends Influencer> int findIndex(Class<K> clazz) {
        for (int i = 0; i < this.influencers.size; ++i) {
            if (!ClassReflection.isAssignableFrom(clazz, this.influencers.get(i).getClass())) continue;
            return i;
        }
        return -1;
    }

    private void setTimeStep(float f) {
        f = this.deltaTime = f;
        this.deltaTimeSqr = f * f;
    }

    public void activateParticles(int n, int n2) {
        this.emitter.activateParticles(n, n2);
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().activateParticles(n, n2);
        }
    }

    protected void allocateChannels(int n) {
        this.particles = new ParallelArray(n);
        this.emitter.allocateChannels();
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().allocateChannels();
        }
        this.renderer.allocateChannels();
    }

    protected void bind() {
        this.emitter.set(this);
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().set(this);
        }
        this.renderer.set(this);
    }

    protected void calculateBoundingBox() {
        this.boundingBox.clr();
        ParallelArray.FloatChannel floatChannel = (ParallelArray.FloatChannel)this.particles.getChannel(ParticleChannels.Position);
        int n = floatChannel.strideSize;
        int n2 = this.particles.size;
        for (int i = 0; i < n * n2; i += floatChannel.strideSize) {
            this.boundingBox.ext(floatChannel.data[i + 0], floatChannel.data[i + 1], floatChannel.data[i + 2]);
        }
    }

    public ParticleController copy() {
        Emitter emitter = (Emitter)this.emitter.copy();
        Influencer[] influencerArray = new Influencer[this.influencers.size];
        Iterator<Influencer> iterator = this.influencers.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            influencerArray[n] = (Influencer)iterator.next().copy();
            ++n;
        }
        return new ParticleController(new String(this.name), emitter, (ParticleControllerRenderer)this.renderer.copy(), influencerArray);
    }

    public void dispose() {
        this.emitter.dispose();
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().dispose();
        }
    }

    public void draw() {
        if (this.particles.size > 0) {
            this.renderer.update();
        }
    }

    public void end() {
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().end();
        }
        this.emitter.end();
    }

    public <K extends Influencer> K findInfluencer(Class<K> object) {
        int n = this.findIndex((Class<K>)object);
        object = n > -1 ? this.influencers.get(n) : null;
        return (K)object;
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox();
        }
        this.calculateBoundingBox();
        return this.boundingBox;
    }

    public void getTransform(Matrix4 matrix4) {
        matrix4.set(this.transform);
    }

    public void init() {
        this.bind();
        if (this.particles != null) {
            this.end();
            this.particleChannels.resetIds();
        }
        this.allocateChannels(this.emitter.maxParticleCount);
        this.emitter.init();
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().init();
        }
        this.renderer.init();
    }

    public boolean isComplete() {
        return this.emitter.isComplete();
    }

    public void killParticles(int n, int n2) {
        this.emitter.killParticles(n, n2);
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().killParticles(n, n2);
        }
    }

    public void load(AssetManager assetManager, ResourceData resourceData) {
        this.emitter.load(assetManager, resourceData);
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().load(assetManager, resourceData);
        }
        this.renderer.load(assetManager, resourceData);
    }

    public void mul(Matrix4 matrix4) {
        this.transform.mul(matrix4);
        this.transform.getScale(this.scale);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.name = json.readValue("name", String.class, jsonValue);
        this.emitter = json.readValue("emitter", Emitter.class, jsonValue);
        this.influencers.addAll((Array)((Object)json.readValue("influencers", Array.class, Influencer.class, jsonValue)));
        this.renderer = json.readValue("renderer", ParticleControllerRenderer.class, jsonValue);
    }

    public <K extends Influencer> void removeInfluencer(Class<K> clazz) {
        int n = this.findIndex(clazz);
        if (n > -1) {
            this.influencers.removeIndex(n);
        }
    }

    public <K extends Influencer> boolean replaceInfluencer(Class<K> clazz, K k) {
        int n = this.findIndex(clazz);
        if (n > -1) {
            this.influencers.insert(n, k);
            this.influencers.removeIndex(n + 1);
            return true;
        }
        return false;
    }

    public void reset() {
        this.end();
        this.start();
    }

    public void rotate(Quaternion quaternion) {
        this.transform.rotate(quaternion);
    }

    public void rotate(Vector3 vector3, float f) {
        this.transform.rotate(vector3, f);
    }

    public void save(AssetManager assetManager, ResourceData resourceData) {
        this.emitter.save(assetManager, resourceData);
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().save(assetManager, resourceData);
        }
        this.renderer.save(assetManager, resourceData);
    }

    public void scale(float f, float f2, float f3) {
        this.transform.scale(f, f2, f3);
        this.transform.getScale(this.scale);
    }

    public void scale(Vector3 vector3) {
        this.scale(vector3.x, vector3.y, vector3.z);
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.transform.set(f, f2, f3, f4, f5, f6, f7, f8, f8, f8);
        this.scale.set(f8, f8, f8);
    }

    public void setTransform(Matrix4 matrix4) {
        this.transform.set(matrix4);
        matrix4.getScale(this.scale);
    }

    public void setTranslation(Vector3 vector3) {
        this.transform.setTranslation(vector3);
    }

    public void start() {
        this.emitter.start();
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().start();
        }
    }

    public void translate(Vector3 vector3) {
        this.transform.translate(vector3);
    }

    public void update() {
        this.update(Gdx.graphics.getDeltaTime());
    }

    public void update(float f) {
        this.setTimeStep(f);
        this.emitter.update();
        Iterator<Influencer> iterator = this.influencers.iterator();
        while (iterator.hasNext()) {
            iterator.next().update();
        }
    }

    @Override
    public void write(Json json) {
        json.writeValue("name", this.name);
        json.writeValue("emitter", this.emitter, Emitter.class);
        json.writeValue("influencers", this.influencers, Array.class, Influencer.class);
        json.writeValue("renderer", this.renderer, ParticleControllerRenderer.class);
    }
}

