/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectSet;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Iterator;

public class TextureAtlas
implements Disposable {
    static final Comparator<TextureAtlasData.Region> indexComparator;
    static final String[] tuple;
    private final Array<AtlasRegion> regions;
    private final ObjectSet<Texture> textures = new ObjectSet(4);

    static {
        tuple = new String[4];
        indexComparator = new Comparator<TextureAtlasData.Region>(){

            @Override
            public int compare(TextureAtlasData.Region region, TextureAtlasData.Region region2) {
                int n;
                int n2;
                int n3 = n2 = region.index;
                if (n2 == -1) {
                    n3 = Integer.MAX_VALUE;
                }
                n2 = n = region2.index;
                if (n == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                return n3 - n2;
            }
        };
    }

    public TextureAtlas() {
        this.regions = new Array();
    }

    public TextureAtlas(FileHandle fileHandle) {
        this(fileHandle, fileHandle.parent());
    }

    public TextureAtlas(FileHandle fileHandle, FileHandle fileHandle2) {
        this(fileHandle, fileHandle2, false);
    }

    public TextureAtlas(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        this(new TextureAtlasData(fileHandle, fileHandle2, bl));
    }

    public TextureAtlas(FileHandle fileHandle, boolean bl) {
        this(fileHandle, fileHandle.parent(), bl);
    }

    public TextureAtlas(TextureAtlasData textureAtlasData) {
        this.regions = new Array();
        if (textureAtlasData != null) {
            this.load(textureAtlasData);
        }
    }

    public TextureAtlas(String string2) {
        this(Gdx.files.internal(string2));
    }

    /*
     * WARNING - void declaration
     */
    private void load(TextureAtlasData object) {
        ObjectMap<TextureAtlasData.Page, void> objectMap = new ObjectMap<TextureAtlasData.Page, void>();
        for (TextureAtlasData.Page page : ((TextureAtlasData)((Object)object)).pages) {
            void object2;
            if (page.texture == null) {
                Texture texture = new Texture(page.textureFile, page.format, page.useMipMaps);
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            } else {
                Texture texture = page.texture;
                texture.setFilter(page.minFilter, page.magFilter);
                texture.setWrap(page.uWrap, page.vWrap);
            }
            this.textures.add((Texture)object2);
            objectMap.put(page, object2);
        }
        for (TextureAtlasData.Region region : ((TextureAtlasData)((Object)object)).regions) {
            int n = region.width;
            int n2 = region.height;
            Object object3 = (Texture)objectMap.get(region.page);
            int n3 = region.left;
            int n4 = region.top;
            int n5 = region.rotate ? n2 : n;
            if (!region.rotate) {
                n = n2;
            }
            object3 = new AtlasRegion((Texture)object3, n3, n4, n5, n);
            ((AtlasRegion)object3).index = region.index;
            ((AtlasRegion)object3).name = region.name;
            ((AtlasRegion)object3).offsetX = region.offsetX;
            ((AtlasRegion)object3).offsetY = region.offsetY;
            ((AtlasRegion)object3).originalHeight = region.originalHeight;
            ((AtlasRegion)object3).originalWidth = region.originalWidth;
            ((AtlasRegion)object3).rotate = region.rotate;
            ((AtlasRegion)object3).degrees = region.degrees;
            ((AtlasRegion)object3).splits = region.splits;
            ((AtlasRegion)object3).pads = region.pads;
            if (region.flip) {
                ((AtlasRegion)object3).flip(false, true);
            }
            this.regions.add((AtlasRegion)object3);
        }
    }

    private Sprite newSprite(AtlasRegion atlasRegion) {
        if (atlasRegion.packedWidth == atlasRegion.originalWidth && atlasRegion.packedHeight == atlasRegion.originalHeight) {
            if (atlasRegion.rotate) {
                Sprite sprite = new Sprite(atlasRegion);
                sprite.setBounds(0.0f, 0.0f, atlasRegion.getRegionHeight(), atlasRegion.getRegionWidth());
                sprite.rotate90(true);
                return sprite;
            }
            return new Sprite(atlasRegion);
        }
        return new AtlasSprite(atlasRegion);
    }

    static int readTuple(BufferedReader object) throws IOException {
        int n = ((String)(object = ((BufferedReader)object).readLine())).indexOf(58);
        if (n != -1) {
            int n2;
            int n3 = n + 1;
            for (n = 0; n < 3 && (n2 = ((String)object).indexOf(44, n3)) != -1; ++n) {
                TextureAtlas.tuple[n] = ((String)object).substring(n3, n2).trim();
                n3 = n2 + 1;
            }
            TextureAtlas.tuple[n] = ((String)object).substring(n3).trim();
            return n + 1;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid line: ");
        stringBuilder.append((String)object);
        object = new GdxRuntimeException(stringBuilder.toString());
        throw object;
    }

    static String readValue(BufferedReader object) throws IOException {
        int n = ((String)(object = ((BufferedReader)object).readLine())).indexOf(58);
        if (n != -1) {
            return ((String)object).substring(n + 1).trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid line: ");
        stringBuilder.append((String)object);
        throw new GdxRuntimeException(stringBuilder.toString());
    }

    public AtlasRegion addRegion(String string2, Texture object, int n, int n2, int n3, int n4) {
        this.textures.add((Texture)object);
        object = new AtlasRegion((Texture)object, n, n2, n3, n4);
        ((AtlasRegion)object).name = string2;
        ((AtlasRegion)object).index = -1;
        this.regions.add((AtlasRegion)object);
        return object;
    }

    public AtlasRegion addRegion(String string2, TextureRegion textureRegion) {
        this.textures.add(textureRegion.texture);
        textureRegion = new AtlasRegion(textureRegion);
        ((AtlasRegion)textureRegion).name = string2;
        ((AtlasRegion)textureRegion).index = -1;
        this.regions.add((AtlasRegion)textureRegion);
        return textureRegion;
    }

    public NinePatch createPatch(String object) {
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            Object object2 = this.regions.get(i);
            if (!((AtlasRegion)object2).name.equals(object)) continue;
            int[] nArray = ((AtlasRegion)object2).splits;
            if (nArray != null) {
                object = new NinePatch((TextureRegion)object2, nArray[0], nArray[1], nArray[2], nArray[3]);
                if (((AtlasRegion)object2).pads != null) {
                    ((NinePatch)object).setPadding(((AtlasRegion)object2).pads[0], ((AtlasRegion)object2).pads[1], ((AtlasRegion)object2).pads[2], ((AtlasRegion)object2).pads[3]);
                }
                return object;
            }
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Region does not have ninepatch splits: ");
            ((StringBuilder)object2).append((String)object);
            throw new IllegalArgumentException(((StringBuilder)object2).toString());
        }
        return null;
    }

    public Sprite createSprite(String string2) {
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            if (!this.regions.get((int)i).name.equals(string2)) continue;
            return this.newSprite(this.regions.get(i));
        }
        return null;
    }

    public Sprite createSprite(String string2, int n) {
        int n2 = this.regions.size;
        for (int i = 0; i < n2; ++i) {
            AtlasRegion atlasRegion = this.regions.get(i);
            if (!atlasRegion.name.equals(string2) || atlasRegion.index != n) {
                continue;
            }
            return this.newSprite(this.regions.get(i));
        }
        return null;
    }

    public Array<Sprite> createSprites() {
        Array<Sprite> array = new Array<Sprite>(true, this.regions.size, Sprite.class);
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            array.add(this.newSprite(this.regions.get(i)));
        }
        return array;
    }

    public Array<Sprite> createSprites(String string2) {
        Array<Sprite> array = new Array<Sprite>(Sprite.class);
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            AtlasRegion atlasRegion = this.regions.get(i);
            if (!atlasRegion.name.equals(string2)) continue;
            array.add(this.newSprite(atlasRegion));
        }
        return array;
    }

    @Override
    public void dispose() {
        Iterator iterator = this.textures.iterator();
        while (iterator.hasNext()) {
            ((Texture)iterator.next()).dispose();
        }
        this.textures.clear(0);
    }

    public AtlasRegion findRegion(String string2) {
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            if (!this.regions.get((int)i).name.equals(string2)) continue;
            return this.regions.get(i);
        }
        return null;
    }

    public AtlasRegion findRegion(String string2, int n) {
        int n2 = this.regions.size;
        for (int i = 0; i < n2; ++i) {
            AtlasRegion atlasRegion = this.regions.get(i);
            if (!atlasRegion.name.equals(string2) || atlasRegion.index != n) {
                continue;
            }
            return atlasRegion;
        }
        return null;
    }

    public Array<AtlasRegion> findRegions(String string2) {
        Array<AtlasRegion> array = new Array<AtlasRegion>(AtlasRegion.class);
        int n = this.regions.size;
        for (int i = 0; i < n; ++i) {
            AtlasRegion atlasRegion = this.regions.get(i);
            if (!atlasRegion.name.equals(string2)) continue;
            array.add(new AtlasRegion(atlasRegion));
        }
        return array;
    }

    public Array<AtlasRegion> getRegions() {
        return this.regions;
    }

    public ObjectSet<Texture> getTextures() {
        return this.textures;
    }

    public static class AtlasRegion
    extends TextureRegion {
        public int degrees;
        public int index;
        public String name;
        public float offsetX;
        public float offsetY;
        public int originalHeight;
        public int originalWidth;
        public int packedHeight;
        public int packedWidth;
        public int[] pads;
        public boolean rotate;
        public int[] splits;

        public AtlasRegion(Texture texture, int n, int n2, int n3, int n4) {
            super(texture, n, n2, n3, n4);
            this.originalWidth = n3;
            this.originalHeight = n4;
            this.packedWidth = n3;
            this.packedHeight = n4;
        }

        public AtlasRegion(AtlasRegion atlasRegion) {
            this.setRegion(atlasRegion);
            this.index = atlasRegion.index;
            this.name = atlasRegion.name;
            this.offsetX = atlasRegion.offsetX;
            this.offsetY = atlasRegion.offsetY;
            this.packedWidth = atlasRegion.packedWidth;
            this.packedHeight = atlasRegion.packedHeight;
            this.originalWidth = atlasRegion.originalWidth;
            this.originalHeight = atlasRegion.originalHeight;
            this.rotate = atlasRegion.rotate;
            this.degrees = atlasRegion.degrees;
            this.splits = atlasRegion.splits;
        }

        public AtlasRegion(TextureRegion textureRegion) {
            this.setRegion(textureRegion);
            this.packedWidth = textureRegion.getRegionWidth();
            this.packedHeight = textureRegion.getRegionHeight();
            this.originalWidth = this.packedWidth;
            this.originalHeight = this.packedHeight;
        }

        @Override
        public void flip(boolean bl, boolean bl2) {
            super.flip(bl, bl2);
            if (bl) {
                this.offsetX = (float)this.originalWidth - this.offsetX - this.getRotatedPackedWidth();
            }
            if (bl2) {
                this.offsetY = (float)this.originalHeight - this.offsetY - this.getRotatedPackedHeight();
            }
        }

        public float getRotatedPackedHeight() {
            int n = this.rotate ? this.packedWidth : this.packedHeight;
            return n;
        }

        public float getRotatedPackedWidth() {
            int n = this.rotate ? this.packedHeight : this.packedWidth;
            return n;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class AtlasSprite
    extends Sprite {
        float originalOffsetX;
        float originalOffsetY;
        final AtlasRegion region;

        public AtlasSprite(AtlasRegion atlasRegion) {
            this.region = new AtlasRegion(atlasRegion);
            this.originalOffsetX = atlasRegion.offsetX;
            this.originalOffsetY = atlasRegion.offsetY;
            this.setRegion(atlasRegion);
            this.setOrigin((float)atlasRegion.originalWidth / 2.0f, (float)atlasRegion.originalHeight / 2.0f);
            int n = atlasRegion.getRegionWidth();
            int n2 = atlasRegion.getRegionHeight();
            if (atlasRegion.rotate) {
                super.rotate90(true);
                super.setBounds(atlasRegion.offsetX, atlasRegion.offsetY, n2, n);
            } else {
                super.setBounds(atlasRegion.offsetX, atlasRegion.offsetY, n, n2);
            }
            this.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public AtlasSprite(AtlasSprite atlasSprite) {
            this.region = atlasSprite.region;
            this.originalOffsetX = atlasSprite.originalOffsetX;
            this.originalOffsetY = atlasSprite.originalOffsetY;
            this.set(atlasSprite);
        }

        @Override
        public void flip(boolean bl, boolean bl2) {
            if (this.region.rotate) {
                super.flip(bl2, bl);
            } else {
                super.flip(bl, bl2);
            }
            float f = this.getOriginX();
            float f2 = this.getOriginY();
            float f3 = this.region.offsetX;
            float f4 = this.region.offsetY;
            float f5 = this.getWidthRatio();
            float f6 = this.getHeightRatio();
            AtlasRegion atlasRegion = this.region;
            atlasRegion.offsetX = this.originalOffsetX;
            atlasRegion.offsetY = this.originalOffsetY;
            atlasRegion.flip(bl, bl2);
            this.originalOffsetX = this.region.offsetX;
            this.originalOffsetY = this.region.offsetY;
            atlasRegion = this.region;
            atlasRegion.offsetX *= f5;
            atlasRegion = this.region;
            atlasRegion.offsetY *= f6;
            this.translate(this.region.offsetX - f3, this.region.offsetY - f4);
            this.setOrigin(f, f2);
        }

        public AtlasRegion getAtlasRegion() {
            return this.region;
        }

        @Override
        public float getHeight() {
            return super.getHeight() / this.region.getRotatedPackedHeight() * (float)this.region.originalHeight;
        }

        public float getHeightRatio() {
            return super.getHeight() / this.region.getRotatedPackedHeight();
        }

        @Override
        public float getOriginX() {
            return super.getOriginX() + this.region.offsetX;
        }

        @Override
        public float getOriginY() {
            return super.getOriginY() + this.region.offsetY;
        }

        @Override
        public float getWidth() {
            return super.getWidth() / this.region.getRotatedPackedWidth() * (float)this.region.originalWidth;
        }

        public float getWidthRatio() {
            return super.getWidth() / this.region.getRotatedPackedWidth();
        }

        @Override
        public float getX() {
            return super.getX() - this.region.offsetX;
        }

        @Override
        public float getY() {
            return super.getY() - this.region.offsetY;
        }

        @Override
        public void rotate90(boolean bl) {
            super.rotate90(bl);
            float f = this.getOriginX();
            float f2 = this.getOriginY();
            float f3 = this.region.offsetX;
            float f4 = this.region.offsetY;
            float f5 = this.getWidthRatio();
            float f6 = this.getHeightRatio();
            if (bl) {
                AtlasRegion atlasRegion = this.region;
                atlasRegion.offsetX = f4;
                atlasRegion.offsetY = (float)atlasRegion.originalHeight * f6 - f3 - (float)this.region.packedWidth * f5;
            } else {
                AtlasRegion atlasRegion = this.region;
                atlasRegion.offsetX = (float)atlasRegion.originalWidth * f5 - f4 - (float)this.region.packedHeight * f6;
                this.region.offsetY = f3;
            }
            this.translate(this.region.offsetX - f3, this.region.offsetY - f4);
            this.setOrigin(f, f2);
        }

        @Override
        public void setBounds(float f, float f2, float f3, float f4) {
            AtlasRegion atlasRegion = this.region;
            atlasRegion.offsetX = this.originalOffsetX * (f3 /= (float)this.region.originalWidth);
            atlasRegion.offsetY = this.originalOffsetY * (f4 /= (float)this.region.originalHeight);
            int n = atlasRegion.rotate ? this.region.packedHeight : this.region.packedWidth;
            int n2 = this.region.rotate ? this.region.packedWidth : this.region.packedHeight;
            super.setBounds(f + this.region.offsetX, f2 + this.region.offsetY, (float)n * f3, (float)n2 * f4);
        }

        @Override
        public void setOrigin(float f, float f2) {
            super.setOrigin(f - this.region.offsetX, f2 - this.region.offsetY);
        }

        @Override
        public void setOriginCenter() {
            super.setOrigin(this.width / 2.0f - this.region.offsetX, this.height / 2.0f - this.region.offsetY);
        }

        @Override
        public void setPosition(float f, float f2) {
            super.setPosition(f + this.region.offsetX, f2 + this.region.offsetY);
        }

        @Override
        public void setSize(float f, float f2) {
            this.setBounds(this.getX(), this.getY(), f, f2);
        }

        @Override
        public void setX(float f) {
            super.setX(f + this.region.offsetX);
        }

        @Override
        public void setY(float f) {
            super.setY(f + this.region.offsetY);
        }

        public String toString() {
            return this.region.toString();
        }
    }

    public static class TextureAtlasData {
        final Array<Page> pages;
        final Array<Region> regions;

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TextureAtlasData(FileHandle fileHandle, FileHandle object, boolean bl) {
            Throwable throwable222222;
            BufferedReader bufferedReader;
            block19: {
                Object object2;
                this.pages = new Array();
                this.regions = new Array();
                bufferedReader = new BufferedReader(new InputStreamReader(fileHandle.read()), 64);
                block5: while (true) {
                    object2 = null;
                    while (true) {
                        Object object3;
                        Object object4;
                        block18: {
                            object4 = bufferedReader.readLine();
                            if (object4 != null) break block18;
                            StreamUtils.closeQuietly(bufferedReader);
                            this.regions.sort(indexComparator);
                            return;
                        }
                        if (object4.trim().length() == 0) continue block5;
                        if (object2 == null) {
                            float f;
                            float f2;
                            FileHandle fileHandle2 = ((FileHandle)object).child((String)object4);
                            if (TextureAtlas.readTuple(bufferedReader) == 2) {
                                f2 = Integer.parseInt(tuple[0]);
                                f = Integer.parseInt(tuple[1]);
                                TextureAtlas.readTuple(bufferedReader);
                            } else {
                                f2 = 0.0f;
                                f = 0.0f;
                            }
                            Pixmap.Format format = Pixmap.Format.valueOf(tuple[0]);
                            TextureAtlas.readTuple(bufferedReader);
                            Texture.TextureFilter textureFilter = Texture.TextureFilter.valueOf(tuple[0]);
                            Texture.TextureFilter textureFilter2 = Texture.TextureFilter.valueOf(tuple[1]);
                            object3 = TextureAtlas.readValue(bufferedReader);
                            object2 = Texture.TextureWrap.ClampToEdge;
                            object4 = Texture.TextureWrap.ClampToEdge;
                            if (((String)object3).equals("x")) {
                                object2 = Texture.TextureWrap.Repeat;
                            } else if (((String)object3).equals("y")) {
                                object4 = Texture.TextureWrap.Repeat;
                            } else if (((String)object3).equals("xy")) {
                                object2 = Texture.TextureWrap.Repeat;
                                object4 = Texture.TextureWrap.Repeat;
                            }
                            object3 = new Page(fileHandle2, f2, f, textureFilter.isMipMap(), format, textureFilter, textureFilter2, (Texture.TextureWrap)((Object)object2), (Texture.TextureWrap)((Object)object4));
                            this.pages.add((Page)object3);
                            object2 = object3;
                            continue;
                        }
                        object3 = TextureAtlas.readValue(bufferedReader);
                        int n = ((String)object3).equalsIgnoreCase("true") ? 90 : (((String)object3).equalsIgnoreCase("false") ? 0 : Integer.valueOf((String)object3));
                        TextureAtlas.readTuple(bufferedReader);
                        int n2 = Integer.parseInt(tuple[0]);
                        int n3 = Integer.parseInt(tuple[1]);
                        TextureAtlas.readTuple(bufferedReader);
                        int n4 = Integer.parseInt(tuple[0]);
                        int n5 = Integer.parseInt(tuple[1]);
                        object3 = new Region();
                        ((Region)object3).page = object2;
                        ((Region)object3).left = n2;
                        ((Region)object3).top = n3;
                        ((Region)object3).width = n4;
                        ((Region)object3).height = n5;
                        ((Region)object3).name = object4;
                        boolean bl2 = n == 90;
                        ((Region)object3).rotate = bl2;
                        ((Region)object3).degrees = n;
                        if (TextureAtlas.readTuple(bufferedReader) == 4) {
                            ((Region)object3).splits = new int[]{Integer.parseInt(tuple[0]), Integer.parseInt(tuple[1]), Integer.parseInt(tuple[2]), Integer.parseInt(tuple[3])};
                            if (TextureAtlas.readTuple(bufferedReader) == 4) {
                                ((Region)object3).pads = new int[]{Integer.parseInt(tuple[0]), Integer.parseInt(tuple[1]), Integer.parseInt(tuple[2]), Integer.parseInt(tuple[3])};
                                TextureAtlas.readTuple(bufferedReader);
                            }
                        }
                        ((Region)object3).originalWidth = Integer.parseInt(tuple[0]);
                        ((Region)object3).originalHeight = Integer.parseInt(tuple[1]);
                        TextureAtlas.readTuple(bufferedReader);
                        ((Region)object3).offsetX = Integer.parseInt(tuple[0]);
                        ((Region)object3).offsetY = Integer.parseInt(tuple[1]);
                        ((Region)object3).index = Integer.parseInt(TextureAtlas.readValue(bufferedReader));
                        if (bl) {
                            ((Region)object3).flip = true;
                        }
                        this.regions.add((Region)object3);
                        continue;
                        break;
                    }
                    break;
                }
                catch (Throwable throwable222222) {
                    break block19;
                }
                catch (Exception exception) {
                    object2 = new StringBuilder();
                    object2.append("Error reading pack file: ");
                    object2.append(fileHandle);
                    object = new GdxRuntimeException(object2.toString(), exception);
                    throw object;
                }
            }
            StreamUtils.closeQuietly(bufferedReader);
            throw throwable222222;
        }

        public Array<Page> getPages() {
            return this.pages;
        }

        public Array<Region> getRegions() {
            return this.regions;
        }

        public static class Page {
            public final Pixmap.Format format;
            public final float height;
            public final Texture.TextureFilter magFilter;
            public final Texture.TextureFilter minFilter;
            public Texture texture;
            public final FileHandle textureFile;
            public final Texture.TextureWrap uWrap;
            public final boolean useMipMaps;
            public final Texture.TextureWrap vWrap;
            public final float width;

            public Page(FileHandle fileHandle, float f, float f2, boolean bl, Pixmap.Format format, Texture.TextureFilter textureFilter, Texture.TextureFilter textureFilter2, Texture.TextureWrap textureWrap, Texture.TextureWrap textureWrap2) {
                this.width = f;
                this.height = f2;
                this.textureFile = fileHandle;
                this.useMipMaps = bl;
                this.format = format;
                this.minFilter = textureFilter;
                this.magFilter = textureFilter2;
                this.uWrap = textureWrap;
                this.vWrap = textureWrap2;
            }
        }

        public static class Region {
            public int degrees;
            public boolean flip;
            public int height;
            public int index;
            public int left;
            public String name;
            public float offsetX;
            public float offsetY;
            public int originalHeight;
            public int originalWidth;
            public int[] pads;
            public Page page;
            public boolean rotate;
            public int[] splits;
            public int top;
            public int width;
        }
    }
}

