/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.PolygonSpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ShortArray;

public class RepeatablePolygonSprite {
    private Color color;
    private int cols;
    private float density;
    private boolean dirty = true;
    private float gridHeight;
    private float gridWidth;
    private Array<short[]> indices;
    private Vector2 offset;
    private Array<float[]> parts = new Array();
    private TextureRegion region;
    private int rows;
    private Array<float[]> vertices = new Array();
    public float x = 0.0f;
    public float y = 0.0f;

    public RepeatablePolygonSprite() {
        this.indices = new Array();
        this.color = Color.WHITE;
        this.offset = new Vector2();
    }

    private void buildVertices() {
        this.vertices.clear();
        for (int i = 0; i < this.parts.size; ++i) {
            float[] fArray = this.parts.get(i);
            if (fArray == null) continue;
            float[] fArray2 = new float[fArray.length * 5 / 2];
            int n = this.rows;
            int n2 = i / n;
            int n3 = i % n;
            n = 0;
            int n4 = 0;
            while (n < fArray.length) {
                int n5 = n4 + 1;
                fArray2[n4] = fArray[n] + this.offset.x + this.x;
                int n6 = n5 + 1;
                n4 = n + 1;
                fArray2[n5] = fArray[n4] + this.offset.y + this.y;
                n5 = n6 + 1;
                fArray2[n6] = this.color.toFloatBits();
                float f = fArray[n];
                float f2 = this.gridWidth;
                f = f % f2 / f2;
                float f3 = fArray[n4];
                float f4 = this.gridHeight;
                f3 = f3 % f4 / f4;
                if (fArray[n] == (float)n2 * f2) {
                    f = 0.0f;
                }
                float f5 = fArray[n];
                float f6 = n2 + 1;
                float f7 = this.gridWidth;
                f4 = 1.0f;
                f2 = f;
                if (f5 == f6 * f7) {
                    f2 = 1.0f;
                }
                f = fArray[n4] == (float)n3 * this.gridHeight ? 0.0f : f3;
                if (fArray[n4] == (float)(n3 + 1) * this.gridHeight) {
                    f = f4;
                }
                float f8 = this.region.getU();
                f3 = this.region.getU2();
                f5 = this.region.getU();
                f4 = this.region.getV();
                f7 = this.region.getV2();
                f6 = this.region.getV();
                n4 = n5 + 1;
                fArray2[n5] = f8 + (f3 - f5) * f2;
                fArray2[n4] = f4 + (f7 - f6) * f;
                n += 2;
                ++n4;
            }
            this.vertices.add(fArray2);
        }
        this.dirty = false;
    }

    private float[] offset(float[] fArray) {
        int n;
        Vector2 vector2 = this.offset;
        int n2 = 0;
        vector2.set(fArray[0], fArray[1]);
        int n3 = 0;
        while (true) {
            float f;
            if (n3 >= fArray.length - 1) break;
            if (this.offset.x > fArray[n3]) {
                this.offset.x = fArray[n3];
            }
            if ((f = this.offset.y) > fArray[n = n3 + 1]) {
                this.offset.y = fArray[n];
            }
            n3 += 2;
        }
        for (n = n2; n < fArray.length; n += 2) {
            fArray[n] = fArray[n] - this.offset.x;
            n3 = n + 1;
            fArray[n3] = fArray[n3] - this.offset.y;
        }
        return fArray;
    }

    private float[] snapToGrid(float[] fArray) {
        for (int i = 0; i < fArray.length; i += 2) {
            float f = fArray[i] / this.gridWidth % 1.0f;
            int n = i + 1;
            float f2 = fArray[n] / this.gridHeight % 1.0f;
            if (f > 0.99f || f < 0.01f) {
                f = this.gridWidth;
                fArray[i] = f * (float)Math.round(fArray[i] / f);
            }
            if (!(f2 > 0.99f) && !(f2 < 0.01f)) continue;
            f2 = this.gridHeight;
            fArray[n] = f2 * (float)Math.round(fArray[n] / f2);
        }
        return fArray;
    }

    public void draw(PolygonSpriteBatch polygonSpriteBatch) {
        if (this.dirty) {
            this.buildVertices();
        }
        for (int i = 0; i < this.vertices.size; ++i) {
            polygonSpriteBatch.draw(this.region.getTexture(), this.vertices.get(i), 0, this.vertices.get(i).length, this.indices.get(i), 0, this.indices.get(i).length);
        }
    }

    public void setColor(Color color2) {
        this.color = color2;
        this.dirty = true;
    }

    public void setPolygon(TextureRegion textureRegion, float[] fArray) {
        this.setPolygon(textureRegion, fArray, -1.0f);
    }

    public void setPolygon(TextureRegion object, float[] object2, float f) {
        this.region = object;
        Polygon polygon = new Polygon(this.offset((float[])object2));
        Polygon polygon2 = new Polygon();
        object2 = new Polygon();
        EarClippingTriangulator earClippingTriangulator = new EarClippingTriangulator();
        Rectangle rectangle = polygon.getBoundingRectangle();
        if (f == -1.0f) {
            f = rectangle.getWidth() / (float)((TextureRegion)object).getRegionWidth();
        }
        float f2 = (float)((TextureRegion)object).getRegionHeight() / (float)((TextureRegion)object).getRegionWidth();
        this.cols = (int)Math.ceil(f);
        this.gridWidth = rectangle.getWidth() / f;
        this.gridHeight = f2 * this.gridWidth;
        this.rows = (int)Math.ceil(rectangle.getHeight() / this.gridHeight);
        for (int i = 0; i < this.cols; ++i) {
            int n = 0;
            while (n < this.rows) {
                f = i;
                float f3 = this.gridWidth;
                float f4 = n;
                f2 = this.gridHeight;
                float f5 = ++n;
                float f6 = i + 1;
                polygon2.setVertices(new float[]{f * f3, f4 * f2, f * f3, f5 * f2, f6 * f3, f5 * f2, f6 * f3, f4 * f2});
                Intersector.intersectPolygons(polygon, polygon2, (Polygon)object2);
                object = ((Polygon)object2).getVertices();
                if (((Object)object).length > 0) {
                    this.parts.add(this.snapToGrid((float[])object));
                    object = earClippingTriangulator.computeTriangles((float[])object);
                    this.indices.add(((ShortArray)object).toArray());
                    continue;
                }
                this.parts.add(null);
            }
        }
        this.buildVertices();
    }

    public void setPosition(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.dirty = true;
    }
}

