/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class DistanceFieldFont
extends BitmapFont {
    private float distanceFieldSmoothing;

    public DistanceFieldFont(FileHandle fileHandle) {
        super(fileHandle);
    }

    public DistanceFieldFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        super(fileHandle, fileHandle2, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl, boolean bl2) {
        super(fileHandle, fileHandle2, bl, bl2);
    }

    public DistanceFieldFont(FileHandle fileHandle, TextureRegion textureRegion) {
        super(fileHandle, textureRegion);
    }

    public DistanceFieldFont(FileHandle fileHandle, TextureRegion textureRegion, boolean bl) {
        super(fileHandle, textureRegion, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, boolean bl) {
        super(fileHandle, bl);
    }

    public DistanceFieldFont(BitmapFont.BitmapFontData bitmapFontData, TextureRegion textureRegion, boolean bl) {
        super(bitmapFontData, textureRegion, bl);
    }

    public DistanceFieldFont(BitmapFont.BitmapFontData bitmapFontData, Array<TextureRegion> array, boolean bl) {
        super(bitmapFontData, array, bl);
    }

    public static ShaderProgram createDistanceFieldShader() {
        ShaderProgram shaderProgram = new ShaderProgram("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n", "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tfloat distance = texture2D(u_texture, v_texCoords).a;\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, distance);\n\t\tgl_FragColor = vec4(v_color.rgb, alpha * v_color.a);\n\t} else {\n\t\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n\t}\n}\n");
        if (shaderProgram.isCompiled()) {
            return shaderProgram;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error compiling distance field shader: ");
        stringBuilder.append(shaderProgram.getLog());
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public float getDistanceFieldSmoothing() {
        return this.distanceFieldSmoothing;
    }

    @Override
    protected void load(BitmapFont.BitmapFontData object) {
        super.load((BitmapFont.BitmapFontData)object);
        object = this.getRegions().iterator();
        while (object.hasNext()) {
            ((TextureRegion)object.next()).getTexture().setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        }
    }

    @Override
    public BitmapFontCache newFontCache() {
        return new DistanceFieldFontCache(this, this.integer);
    }

    public void setDistanceFieldSmoothing(float f) {
        this.distanceFieldSmoothing = f;
    }

    private static class DistanceFieldFontCache
    extends BitmapFontCache {
        public DistanceFieldFontCache(DistanceFieldFont distanceFieldFont) {
            super(distanceFieldFont, distanceFieldFont.usesIntegerPositions());
        }

        public DistanceFieldFontCache(DistanceFieldFont distanceFieldFont, boolean bl) {
            super(distanceFieldFont, bl);
        }

        private float getSmoothingFactor() {
            DistanceFieldFont distanceFieldFont = (DistanceFieldFont)super.getFont();
            return distanceFieldFont.getDistanceFieldSmoothing() * distanceFieldFont.getScaleX();
        }

        private void setSmoothingUniform(Batch batch, float f) {
            batch.flush();
            batch.getShader().setUniformf("u_smoothing", f);
        }

        @Override
        public void draw(Batch batch) {
            this.setSmoothingUniform(batch, this.getSmoothingFactor());
            super.draw(batch);
            this.setSmoothingUniform(batch, 0.0f);
        }

        @Override
        public void draw(Batch batch, int n, int n2) {
            this.setSmoothingUniform(batch, this.getSmoothingFactor());
            super.draw(batch, n, n2);
            this.setSmoothingUniform(batch, 0.0f);
        }
    }
}

