/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.ByteArray;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class PixmapIO {
    public static Pixmap readCIM(FileHandle fileHandle) {
        return CIM.read(fileHandle);
    }

    public static void writeCIM(FileHandle fileHandle, Pixmap pixmap) {
        CIM.write(fileHandle, pixmap);
    }

    public static void writePNG(FileHandle fileHandle, Pixmap pixmap) {
        PixmapIO.writePNG(fileHandle, pixmap, -1, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writePNG(FileHandle fileHandle, Pixmap object, int n, boolean bl) {
        PNG pNG;
        try {
            pNG = new PNG((int)((float)(((Pixmap)object).getWidth() * ((Pixmap)object).getHeight()) * 1.5f));
        }
        catch (IOException iOException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Error writing PNG: ");
            ((StringBuilder)object).append(fileHandle);
            throw new GdxRuntimeException(((StringBuilder)object).toString(), iOException);
        }
        try {
            pNG.setFlipY(bl);
            pNG.setCompression(n);
            pNG.write(fileHandle, (Pixmap)object);
            return;
        }
        finally {
            pNG.dispose();
        }
    }

    private static class CIM {
        private static final int BUFFER_SIZE = 32000;
        private static final byte[] readBuffer;
        private static final byte[] writeBuffer;

        static {
            writeBuffer = new byte[32000];
            readBuffer = new byte[32000];
        }

        private CIM() {
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public static Pixmap read(FileHandle fileHandle) {
            void var0_3;
            FilterInputStream filterInputStream;
            block15: {
                Object object = new BufferedInputStream(fileHandle.read());
                filterInputStream = new InflaterInputStream((InputStream)object);
                DataInputStream dataInputStream = new DataInputStream(filterInputStream);
                filterInputStream = dataInputStream;
                int n = dataInputStream.readInt();
                filterInputStream = dataInputStream;
                int n2 = dataInputStream.readInt();
                filterInputStream = dataInputStream;
                Object object2 = Pixmap.Format.fromGdx2DPixmapFormat(dataInputStream.readInt());
                filterInputStream = dataInputStream;
                filterInputStream = dataInputStream;
                object = new Pixmap(n, n2, (Pixmap.Format)((Object)object2));
                filterInputStream = dataInputStream;
                Object object3 = ((Pixmap)object).getPixels();
                filterInputStream = dataInputStream;
                ((ByteBuffer)object3).position(0);
                filterInputStream = dataInputStream;
                ((ByteBuffer)object3).limit(((Buffer)object3).capacity());
                filterInputStream = dataInputStream;
                object2 = readBuffer;
                filterInputStream = dataInputStream;
                // MONITORENTER : object2
                while ((n2 = dataInputStream.read(readBuffer)) > 0) {
                    ((ByteBuffer)object3).put(readBuffer, 0, n2);
                }
                // MONITOREXIT : object2
                filterInputStream = dataInputStream;
                ((ByteBuffer)object3).position(0);
                filterInputStream = dataInputStream;
                ((ByteBuffer)object3).limit(((Buffer)object3).capacity());
                StreamUtils.closeQuietly(dataInputStream);
                return object;
                {
                    catch (Throwable throwable) {}
                    filterInputStream = dataInputStream;
                    try {
                        void var3_10;
                        block14: {
                            try {
                                throw throwable;
                            }
                            catch (Exception exception) {
                                break block14;
                            }
                            catch (Throwable throwable) {
                                filterInputStream = null;
                                break block15;
                            }
                            catch (Exception exception) {
                                dataInputStream = null;
                            }
                        }
                        filterInputStream = dataInputStream;
                        filterInputStream = dataInputStream;
                        filterInputStream = dataInputStream;
                        object2 = new StringBuilder();
                        filterInputStream = dataInputStream;
                        object2.append("Couldn't read Pixmap from file '");
                        filterInputStream = dataInputStream;
                        object2.append(fileHandle);
                        filterInputStream = dataInputStream;
                        object2.append("'");
                        filterInputStream = dataInputStream;
                        object3 = new GdxRuntimeException(object2.toString(), (Throwable)var3_10);
                        filterInputStream = dataInputStream;
                        throw object3;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            StreamUtils.closeQuietly(filterInputStream);
            throw var0_3;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void write(FileHandle fileHandle, Pixmap object) {
            void var0_3;
            Object object2;
            block14: {
                Object object3;
                Object object4;
                StringBuilder stringBuilder;
                block15: {
                    int n;
                    int n2;
                    stringBuilder = null;
                    object3 = object4 = null;
                    try {
                        object3 = object4;
                        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(fileHandle.write(false));
                        object3 = object4;
                        object3 = object4;
                        object2 = new DataOutputStream(deflaterOutputStream);
                    }
                    catch (Throwable throwable) {
                        object2 = object3;
                        break block14;
                    }
                    catch (Exception exception) {
                        object = stringBuilder;
                        break block15;
                    }
                    try {
                        ((DataOutputStream)object2).writeInt(((Pixmap)object).getWidth());
                        ((DataOutputStream)object2).writeInt(((Pixmap)object).getHeight());
                        ((DataOutputStream)object2).writeInt(Pixmap.Format.toGdx2DPixmapFormat(((Pixmap)object).getFormat()));
                        object3 = ((Pixmap)object).getPixels();
                        ((ByteBuffer)object3).position(0);
                        ((ByteBuffer)object3).limit(((Buffer)object3).capacity());
                        n2 = ((Buffer)object3).capacity() % 32000;
                        n = ((Buffer)object3).capacity() / 32000;
                        object = writeBuffer;
                        synchronized (object) {
                        }
                    }
                    catch (Throwable throwable) {
                        break block14;
                    }
                    catch (Exception exception) {
                        object = object2;
                        object2 = exception;
                        break block15;
                    }
                    {
                        for (int i = 0; i < n; ++i) {
                            ((ByteBuffer)object3).get(writeBuffer);
                            ((FilterOutputStream)object2).write(writeBuffer);
                        }
                        ((ByteBuffer)object3).get(writeBuffer, 0, n2);
                        ((DataOutputStream)object2).write(writeBuffer, 0, n2);
                    }
                    {
                        ((ByteBuffer)object3).position(0);
                        ((ByteBuffer)object3).limit(((Buffer)object3).capacity());
                    }
                    StreamUtils.closeQuietly((Closeable)object2);
                    return;
                }
                object3 = object;
                {
                    object3 = object;
                    object3 = object;
                    stringBuilder = new StringBuilder();
                    object3 = object;
                    stringBuilder.append("Couldn't write Pixmap to file '");
                    object3 = object;
                    stringBuilder.append(fileHandle);
                    object3 = object;
                    stringBuilder.append("'");
                    object3 = object;
                    object4 = new GdxRuntimeException(stringBuilder.toString(), (Throwable)object2);
                    object3 = object;
                    throw object4;
                }
            }
            StreamUtils.closeQuietly((Closeable)object2);
            throw var0_3;
        }
    }

    public static class PNG
    implements Disposable {
        private static final byte COLOR_ARGB = 6;
        private static final byte COMPRESSION_DEFLATE = 0;
        private static final byte FILTER_NONE = 0;
        private static final int IDAT = 1229209940;
        private static final int IEND = 1229278788;
        private static final int IHDR = 1229472850;
        private static final byte INTERLACE_NONE = 0;
        private static final byte PAETH = 4;
        private static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        private final ChunkBuffer buffer;
        private ByteArray curLineBytes;
        private final Deflater deflater;
        private boolean flipY = true;
        private int lastLineLen;
        private ByteArray lineOutBytes;
        private ByteArray prevLineBytes;

        public PNG() {
            this(16384);
        }

        public PNG(int n) {
            this.buffer = new ChunkBuffer(n);
            this.deflater = new Deflater();
        }

        @Override
        public void dispose() {
            this.deflater.end();
        }

        public void setCompression(int n) {
            this.deflater.setLevel(n);
        }

        public void setFlipY(boolean bl) {
            this.flipY = bl;
        }

        public void write(FileHandle object, Pixmap pixmap) throws IOException {
            object = ((FileHandle)object).write(false);
            try {
                this.write((OutputStream)object, pixmap);
                return;
            }
            finally {
                StreamUtils.closeQuietly((Closeable)object);
            }
        }

        public void write(OutputStream outputStream, Pixmap pixmap) throws IOException {
            int n;
            int n2;
            byte[] byArray;
            Object object;
            Object object2;
            byte[] byArray2;
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)this.buffer, this.deflater);
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.write(SIGNATURE);
            this.buffer.writeInt(1229472850);
            this.buffer.writeInt(pixmap.getWidth());
            this.buffer.writeInt(pixmap.getHeight());
            this.buffer.writeByte(8);
            this.buffer.writeByte(6);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.writeByte(0);
            this.buffer.endChunk(dataOutputStream);
            this.buffer.writeInt(1229209940);
            this.deflater.reset();
            int n3 = pixmap.getWidth() * 4;
            Object object3 = this.lineOutBytes;
            if (object3 == null) {
                object3 = new ByteArray(n3);
                this.lineOutBytes = object3;
                byArray2 = ((ByteArray)object3).items;
                object3 = new ByteArray(n3);
                this.curLineBytes = object3;
                object3 = ((ByteArray)object3).items;
                object2 = new ByteArray(n3);
                this.prevLineBytes = object2;
                object2 = object2.items;
            } else {
                object = ((ByteArray)object3).ensureCapacity(n3);
                byArray = this.curLineBytes.ensureCapacity(n3);
                byte[] byArray3 = this.prevLineBytes.ensureCapacity(n3);
                n2 = this.lastLineLen;
                n = 0;
                while (true) {
                    byArray2 = object;
                    object3 = byArray;
                    object2 = byArray3;
                    if (n >= n2) break;
                    byArray3[n] = (byte)0;
                    ++n;
                }
            }
            this.lastLineLen = n3;
            object = pixmap.getPixels();
            int n4 = ((Buffer)object).position();
            n = pixmap.getFormat() == Pixmap.Format.RGBA8888 ? 1 : 0;
            int n5 = pixmap.getHeight();
            n2 = 0;
            while (true) {
                int n6;
                int n7;
                int n8;
                int n9;
                byArray = object2;
                if (n2 >= n5) break;
                int n10 = this.flipY ? n5 - n2 - 1 : n2;
                if (n != 0) {
                    ((ByteBuffer)object).position(n10 * n3);
                    ((ByteBuffer)object).get((byte[])object3, 0, n3);
                } else {
                    n9 = 0;
                    n8 = 0;
                    n7 = n;
                    while (true) {
                        n = n7;
                        if (n9 >= pixmap.getWidth()) break;
                        n6 = pixmap.getPixel(n9, n10);
                        n = n8 + 1;
                        object3[n8] = (byte)(n6 >> 24 & 0xFF);
                        n8 = n + 1;
                        object3[n] = (byte)(n6 >> 16 & 0xFF);
                        n = n8 + 1;
                        object3[n8] = (byte)(n6 >> 8 & 0xFF);
                        object3[n] = (byte)(n6 & 0xFF);
                        ++n9;
                        n8 = n + 1;
                    }
                }
                byArray2[0] = (byte)(object3[0] - byArray[0]);
                byArray2[1] = (byte)(object3[1] - byArray[1]);
                byArray2[2] = (byte)(object3[2] - byArray[2]);
                byArray2[3] = (byte)(object3[3] - byArray[3]);
                n7 = 4;
                n10 = n5;
                for (n5 = n7; n5 < n3; ++n5) {
                    n7 = n5 - 4;
                    n6 = object3[n7] & 0xFF;
                    int n11 = byArray[n5] & 0xFF;
                    int n12 = byArray[n7] & 0xFF;
                    int n13 = n6 + n11 - n12;
                    n7 = n9 = n13 - n6;
                    if (n9 < 0) {
                        n7 = -n9;
                    }
                    n9 = n8 = n13 - n11;
                    if (n8 < 0) {
                        n9 = -n8;
                    }
                    n8 = n13 -= n12;
                    if (n13 < 0) {
                        n8 = -n13;
                    }
                    n7 = n7 <= n9 && n7 <= n8 ? n6 : (n9 <= n8 ? n11 : n12);
                    byArray2[n5] = (byte)(object3[n5] - n7);
                }
                deflaterOutputStream.write(4);
                deflaterOutputStream.write(byArray2, 0, n3);
                ++n2;
                object2 = object3;
                object3 = byArray;
                n5 = n10;
            }
            ((ByteBuffer)object).position(n4);
            deflaterOutputStream.finish();
            this.buffer.endChunk(dataOutputStream);
            this.buffer.writeInt(1229278788);
            this.buffer.endChunk(dataOutputStream);
            outputStream.flush();
        }

        static class ChunkBuffer
        extends DataOutputStream {
            final ByteArrayOutputStream buffer;
            final CRC32 crc;

            ChunkBuffer(int n) {
                this(new ByteArrayOutputStream(n), new CRC32());
            }

            private ChunkBuffer(ByteArrayOutputStream byteArrayOutputStream, CRC32 cRC32) {
                super(new CheckedOutputStream(byteArrayOutputStream, cRC32));
                this.buffer = byteArrayOutputStream;
                this.crc = cRC32;
            }

            public void endChunk(DataOutputStream dataOutputStream) throws IOException {
                this.flush();
                dataOutputStream.writeInt(this.buffer.size() - 4);
                this.buffer.writeTo(dataOutputStream);
                dataOutputStream.writeInt((int)this.crc.getValue());
                this.buffer.reset();
                this.crc.reset();
            }
        }
    }
}

