/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.content.res.AssetFileDescriptor;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.android.AndroidFileHandle;
import com.badlogic.gdx.backends.android.AndroidFiles;
import com.badlogic.gdx.backends.android.ZipResourceFile;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;

public class AndroidZipFileHandle
extends AndroidFileHandle {
    private ZipResourceFile expansionFile;
    private long fdLength;
    private boolean hasAssetFd;
    private String path;

    public AndroidZipFileHandle(File file, Files.FileType fileType) {
        super(null, file, fileType);
        this.initialize();
    }

    public AndroidZipFileHandle(String string2) {
        super(null, string2, Files.FileType.Internal);
        this.initialize();
    }

    private String getPath() {
        return this.path;
    }

    private void initialize() {
        this.path = this.file.getPath().replace('\\', '/');
        this.expansionFile = ((AndroidFiles)Gdx.files).getExpansionFile();
        Object object = this.expansionFile.getAssetFileDescriptor(this.getPath());
        if (object != null) {
            this.hasAssetFd = true;
            this.fdLength = object.getLength();
            try {
                object.close();
            }
            catch (IOException iOException) {}
        } else {
            this.hasAssetFd = false;
        }
        if (this.isDirectory()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(this.path);
            ((StringBuilder)object).append("/");
            this.path = ((StringBuilder)object).toString();
        }
    }

    @Override
    public FileHandle child(String string2) {
        if (this.file.getPath().length() == 0) {
            return new AndroidZipFileHandle(new File(string2), this.type);
        }
        return new AndroidZipFileHandle(new File(this.file, string2), this.type);
    }

    @Override
    public boolean exists() {
        boolean bl = this.hasAssetFd || this.expansionFile.getEntriesAt(this.getPath()).length != 0;
        return bl;
    }

    @Override
    public AssetFileDescriptor getAssetFileDescriptor() throws IOException {
        return this.expansionFile.getAssetFileDescriptor(this.getPath());
    }

    @Override
    public boolean isDirectory() {
        return this.hasAssetFd ^ true;
    }

    @Override
    public long length() {
        long l = this.hasAssetFd ? this.fdLength : 0L;
        return l;
    }

    @Override
    public FileHandle[] list() {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] fileHandleArray = new FileHandle[zipEntryROArray.length - 1];
        int n = zipEntryROArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (zipEntryROArray[i].mFileName.length() == this.getPath().length()) continue;
            fileHandleArray[n2] = new AndroidZipFileHandle(zipEntryROArray[i].mFileName);
            ++n2;
        }
        return fileHandleArray;
    }

    @Override
    public FileHandle[] list(FileFilter fileHandleArray) {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] fileHandleArray2 = new FileHandle[zipEntryROArray.length - 1];
        int n = zipEntryROArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            AndroidZipFileHandle androidZipFileHandle;
            if (zipEntryROArray[i].mFileName.length() == this.getPath().length() || !fileHandleArray.accept(((FileHandle)(androidZipFileHandle = new AndroidZipFileHandle(zipEntryROArray[i].mFileName))).file())) continue;
            fileHandleArray2[n2] = androidZipFileHandle;
            ++n2;
        }
        if (n2 < fileHandleArray2.length) {
            fileHandleArray = new FileHandle[n2];
            System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
        } else {
            fileHandleArray = fileHandleArray2;
        }
        return fileHandleArray;
    }

    @Override
    public FileHandle[] list(FilenameFilter fileHandleArray) {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] fileHandleArray2 = new FileHandle[zipEntryROArray.length - 1];
        int n = zipEntryROArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2;
            if (zipEntryROArray[i].mFileName.length() == this.getPath().length() || !fileHandleArray.accept(this.file, string2 = zipEntryROArray[i].mFileName)) continue;
            fileHandleArray2[n2] = new AndroidZipFileHandle(string2);
            ++n2;
        }
        if (n2 < fileHandleArray2.length) {
            fileHandleArray = new FileHandle[n2];
            System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
        } else {
            fileHandleArray = fileHandleArray2;
        }
        return fileHandleArray;
    }

    @Override
    public FileHandle[] list(String fileHandleArray) {
        ZipResourceFile.ZipEntryRO[] zipEntryROArray = this.expansionFile.getEntriesAt(this.getPath());
        FileHandle[] fileHandleArray2 = new FileHandle[zipEntryROArray.length - 1];
        int n = zipEntryROArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2;
            if (zipEntryROArray[i].mFileName.length() == this.getPath().length() || !(string2 = zipEntryROArray[i].mFileName).endsWith((String)fileHandleArray)) continue;
            fileHandleArray2[n2] = new AndroidZipFileHandle(string2);
            ++n2;
        }
        if (n2 < fileHandleArray2.length) {
            fileHandleArray = new FileHandle[n2];
            System.arraycopy(fileHandleArray2, 0, fileHandleArray, 0, n2);
        } else {
            fileHandleArray = fileHandleArray2;
        }
        return fileHandleArray;
    }

    @Override
    public FileHandle parent() {
        File file;
        File file2 = file = this.file.getParentFile();
        if (file == null) {
            file2 = new File("");
        }
        return new AndroidZipFileHandle(file2.getPath());
    }

    @Override
    public InputStream read() {
        try {
            InputStream inputStream = this.expansionFile.getInputStream(this.getPath());
            return inputStream;
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Error reading file: ");
            stringBuilder.append(this.file);
            stringBuilder.append(" (ZipResourceFile)");
            throw new GdxRuntimeException(stringBuilder.toString(), iOException);
        }
    }

    @Override
    public FileHandle sibling(String string2) {
        if (this.file.getPath().length() != 0) {
            return Gdx.files.getFileHandle(new File(this.file.getParent(), string2).getPath(), this.type);
        }
        throw new GdxRuntimeException("Cannot get the sibling of the root.");
    }
}

