/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.TimeUtils;

public class InputEventQueue
implements InputProcessor {
    private static final int KEY_DOWN = 0;
    private static final int KEY_TYPED = 2;
    private static final int KEY_UP = 1;
    private static final int MOUSE_MOVED = 6;
    private static final int SCROLLED = 7;
    private static final int SKIP = -1;
    private static final int TOUCH_DOWN = 3;
    private static final int TOUCH_DRAGGED = 5;
    private static final int TOUCH_UP = 4;
    private long currentEventTime;
    private final IntArray processingQueue;
    private InputProcessor processor;
    private final IntArray queue = new IntArray();

    public InputEventQueue() {
        this.processingQueue = new IntArray();
    }

    public InputEventQueue(InputProcessor inputProcessor) {
        this.processingQueue = new IntArray();
        this.processor = inputProcessor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int next(int n, int n2) {
        synchronized (this) {
            Object object;
            block14: {
                object = this.queue.items;
                int n3 = this.queue.size;
                block12: while (n2 < n3) {
                    int n4 = object[n2];
                    if (n4 == n) {
                        return n2;
                    }
                    n2 += 3;
                    switch (n4) {
                        default: {
                            object = new RuntimeException;
                            break block14;
                        }
                        case 6: {
                            n2 += 2;
                            continue block12;
                        }
                        case 5: {
                            n2 += 3;
                            continue block12;
                        }
                        case 3: 
                        case 4: {
                            n2 += 4;
                            continue block12;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 7: {
                            ++n2;
                            continue block12;
                        }
                        case -1: {
                            n2 += object[n2];
                            continue block12;
                        }
                    }
                }
                return -1;
            }
            object();
            throw object;
        }
    }

    private void queueTime() {
        long l = TimeUtils.nanoTime();
        this.queue.add((int)(l >> 32));
        this.queue.add((int)l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void drain() {
        int n;
        int n2;
        InputProcessor inputProcessor;
        int[] nArray;
        synchronized (this) {
            if (this.processor == null) {
                this.queue.clear();
                return;
            }
            this.processingQueue.addAll(this.queue);
            this.queue.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            nArray = this.processingQueue.items;
            inputProcessor = this.processor;
            n2 = 0;
            n = this.processingQueue.size;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        block15: while (true) {
            if (n2 >= n) {
                this.processingQueue.clear();
                return;
            }
            int n3 = n2 + 1;
            n2 = nArray[n2];
            int n4 = n3 + 1;
            long l = nArray[n3];
            n3 = n4 + 1;
            this.currentEventTime = l << 32 | (long)nArray[n4] & 0xFFFFFFFFL;
            switch (n2) {
                default: {
                    throw new RuntimeException();
                }
                case 7: {
                    n2 = n3 + 1;
                    inputProcessor.scrolled(nArray[n3]);
                    continue block15;
                }
                case 6: {
                    n2 = n3 + 1;
                    inputProcessor.mouseMoved(nArray[n3], nArray[n2]);
                    ++n2;
                    continue block15;
                }
                case 5: {
                    n2 = n3 + 1;
                    n3 = nArray[n3];
                    n4 = n2 + 1;
                    inputProcessor.touchDragged(n3, nArray[n2], nArray[n4]);
                    n2 = n4 + 1;
                    continue block15;
                }
                case 4: {
                    n4 = n3 + 1;
                    n3 = nArray[n3];
                    n2 = n4 + 1;
                    n4 = nArray[n4];
                    int n5 = n2 + 1;
                    int n6 = nArray[n2];
                    n2 = n5 + 1;
                    inputProcessor.touchUp(n3, n4, n6, nArray[n5]);
                    continue block15;
                }
                case 3: {
                    n4 = n3 + 1;
                    n3 = nArray[n3];
                    n2 = n4 + 1;
                    n4 = nArray[n4];
                    int n5 = n2 + 1;
                    int n6 = nArray[n2];
                    n2 = n5 + 1;
                    inputProcessor.touchDown(n3, n4, n6, nArray[n5]);
                    continue block15;
                }
                case 2: {
                    n2 = n3 + 1;
                    inputProcessor.keyTyped((char)nArray[n3]);
                    continue block15;
                }
                case 1: {
                    n2 = n3 + 1;
                    inputProcessor.keyUp(nArray[n3]);
                    continue block15;
                }
                case 0: {
                    n2 = n3 + 1;
                    inputProcessor.keyDown(nArray[n3]);
                    continue block15;
                }
                case -1: 
            }
            n2 = n3 + nArray[n3];
        }
    }

    public long getCurrentEventTime() {
        return this.currentEventTime;
    }

    public InputProcessor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean keyDown(int n) {
        synchronized (this) {
            this.queue.add(0);
            this.queueTime();
            this.queue.add(n);
            return false;
        }
    }

    @Override
    public boolean keyTyped(char c) {
        synchronized (this) {
            this.queue.add(2);
            this.queueTime();
            this.queue.add(c);
            return false;
        }
    }

    @Override
    public boolean keyUp(int n) {
        synchronized (this) {
            this.queue.add(1);
            this.queueTime();
            this.queue.add(n);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mouseMoved(int n, int n2) {
        synchronized (this) {
            int n3 = this.next(6, 0);
            while (true) {
                if (n3 < 0) {
                    this.queue.add(6);
                    this.queueTime();
                    this.queue.add(n);
                    this.queue.add(n2);
                    return false;
                }
                this.queue.set(n3, -1);
                this.queue.set(n3 + 3, 2);
                n3 = this.next(6, n3 + 5);
            }
        }
    }

    @Override
    public boolean scrolled(int n) {
        synchronized (this) {
            this.queue.add(7);
            this.queueTime();
            this.queue.add(n);
            return false;
        }
    }

    public void setProcessor(InputProcessor inputProcessor) {
        this.processor = inputProcessor;
    }

    @Override
    public boolean touchDown(int n, int n2, int n3, int n4) {
        synchronized (this) {
            this.queue.add(3);
            this.queueTime();
            this.queue.add(n);
            this.queue.add(n2);
            this.queue.add(n3);
            this.queue.add(n4);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean touchDragged(int n, int n2, int n3) {
        synchronized (this) {
            int n4 = this.next(5, 0);
            while (true) {
                if (n4 < 0) {
                    this.queue.add(5);
                    this.queueTime();
                    this.queue.add(n);
                    this.queue.add(n2);
                    this.queue.add(n3);
                    return false;
                }
                if (this.queue.get(n4 + 5) == n3) {
                    this.queue.set(n4, -1);
                    this.queue.set(n4 + 3, 3);
                }
                n4 = this.next(5, n4 + 6);
            }
        }
    }

    @Override
    public boolean touchUp(int n, int n2, int n3, int n4) {
        synchronized (this) {
            this.queue.add(4);
            this.queueTime();
            this.queue.add(n);
            this.queue.add(n2);
            this.queue.add(n3);
            this.queue.add(n4);
            return false;
        }
    }
}

